/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.geometric;

import com.kingbase.geometric.KBpoint;
import com.kingbase.util.KBobject;
import com.kingbase.util.KBtokenizer;
import com.kingbase.util.KSQLException;
import java.io.Serializable;
import java.sql.SQLException;

public class KBcircle
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint center;
    double radius;

    public KBcircle(double x, double y, double r) {
        this(new KBpoint(x, y), r);
    }

    public KBcircle(KBpoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public KBcircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public KBcircle() {
        this.setType("circle");
    }

    public void setValue(String s) throws SQLException {
        KBtokenizer t = new KBtokenizer(KBtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw new KSQLException("kingbase.geo.circle", (Object)s);
        }
        try {
            this.center = new KBpoint(t.getToken(0));
            this.radius = Double.valueOf(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new KSQLException("kingbase.geo.circle", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof KBcircle) {
            KBcircle p = (KBcircle)obj;
            return p.center.equals(this.center) && p.radius == this.radius;
        }
        return false;
    }

    public Object clone() {
        return new KBcircle((KBpoint)this.center.clone(), this.radius);
    }

    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

