/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc1;

import com.kingbase.Driver;
import com.kingbase.KBNotification;
import com.kingbase.core.BaseConnection;
import com.kingbase.core.BaseResultSet;
import com.kingbase.core.BaseStatement;
import com.kingbase.core.Encoding;
import com.kingbase.core.KB_Stream;
import com.kingbase.core.QueryExecutor;
import com.kingbase.core.StartupPacket;
import com.kingbase.fastpath.Fastpath;
import com.kingbase.jdbc1.AbstractJdbc1Statement;
import com.kingbase.jdbc3.AbstractJdbc3Statement;
import com.kingbase.largeobject.LargeObjectManager;
import com.kingbase.util.KBTypeInfo;
import com.kingbase.util.KBobject;
import com.kingbase.util.KSQLException;
import com.kingbase.util.MD5Digest;
import com.kingbase.util.UnixCrypt;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AbstractJdbc1Connection
implements BaseConnection {
    private KB_Stream KB_Stream;
    protected String SYS_HOST;
    protected int SYS_PORT;
    protected String SYS_USER;
    protected String SYS_DATABASE;
    protected boolean SYS_STATUS;
    protected boolean useSSL;
    protected boolean enableSavepoint = false;
    protected boolean escapeProcessing;
    protected boolean useServerPrepare = true;
    protected boolean isSavePrepared = false;
    protected boolean isSaveResultSet = false;
    protected String clientEncoding = "GBK";
    protected int pid;
    protected int ckey;
    private Vector m_notifications;
    private Encoding encoding = Encoding.defaultEncoding();
    private String dbVersionNumber;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor = null;
    private int KBProtocolVersionMajor = 2;
    private int KBProtocolVersionMinor = 0;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static Hashtable sqlTypeCache = new Hashtable();
    private static Hashtable sysTypeCache = new Hashtable();
    private static Hashtable typeOidCache = new Hashtable();
    public SQLWarning firstWarning = null;
    private int isolationLevel = 2;
    public Vector stmts = new Vector(0, 1);
    public Vector allocIds = new Vector(0, 1);
    private boolean isTransactionBegin = false;
    public boolean isClientCursor = false;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    private Hashtable objectTypes = new Hashtable();
    private static final int maxStmts = 1000;
    protected DatabaseMetaData metadata;
    private int databaseMajorVersion = 0;
    private int databaseMinorVersion = 0;
    private int patch = 0;
    private static final String[][] defaultObjectTypes = new String[][]{{"box", "com.kingbase.geometric.SYSbox"}, {"circle", "com.kingbase.geometric.SYScircle"}, {"line", "com.kingbase.geometric.SYSline"}, {"lseg", "com.kingbase.geometric.SYSlseg"}, {"path", "com.kingbase.geometric.SYSpath"}, {"point", "com.kingbase.geometric.SYSpoint"}, {"polygon", "com.kingbase.geometric.SYSpolygon"}, {"money", "com.kingbase.util.SYSmoney"}};
    private static final String[] jdbc1Types = new String[]{"INT2", "INT4", "OID", "INT8", "MONEY", "NUMERIC", "FLOAT4", "FLOAT8", "BPCHAR", "CHAR", "CHAR2", "CHAR4", "CHAR8", "CHAR16", "VARCHAR", "TEXT", "NAME", "FILENAME", "BYTEA", "BOOL", "DATE", "TIME", "ABSTIME", "TIMESTAMP", "TIMESTAMPTZ", "BIT", "BIT VARYING", "VARBIT", "TINYINT", "BOOL", "BLOB", "BLOB", "CLOB", "CLOB", "BYTEA", "FLOAT4", "FLOAT4"};
    private static final int[] jdbc1Typei = new int[]{5, 4, 4, -5, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -2, 4, 91, 92, 93, 93, 93, -7, -7, -7, -6, 16, 2004, -4, 2005, -1, -3, 3, 6};
    private static final int[] Protocols;
    private int protocolIndex = 0;
    private int currentVersion = Protocols[0];

    public KB_Stream getKBStream() {
        return this.KB_Stream;
    }

    public int getKBProtocolVersionMajor() {
        return this.KBProtocolVersionMajor;
    }

    public int getKBProtocolVersionMinor() {
        return this.KBProtocolVersionMinor;
    }

    public int getKBProtocolVersion() {
        return (this.KBProtocolVersionMajor * 100 + this.KBProtocolVersionMinor) * 100;
    }

    public abstract Statement createStatement() throws SQLException;

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public void openConnection(String host, int port, Properties info, String database, String url, Driver d) throws SQLException {
        String escape;
        this.firstWarning = null;
        if (info.getProperty("user") == null) {
            throw new KSQLException("kingbase.con.user");
        }
        this.this_driver = d;
        this.this_url = url;
        this.SYS_DATABASE = database;
        this.SYS_USER = info.getProperty("user");
        String password = info.getProperty("password", "");
        if (password == null || password.equals("")) {
            password = info.getProperty("pwd", "");
        }
        this.escapeProcessing = (escape = info.getProperty("EscapeProcessing")) == null || !escape.equalsIgnoreCase("false");
        String cancelPst = info.getProperty("UseServerPrepare");
        this.useServerPrepare = cancelPst == null || !cancelPst.equalsIgnoreCase("false");
        String isSavePre = info.getProperty("SavePreparedStatement");
        this.isSavePrepared = isSavePre != null && isSavePre.equalsIgnoreCase("true");
        String isSaveResult = info.getProperty("UseResultSetCache");
        this.isSaveResultSet = isSaveResult != null && isSaveResult.equalsIgnoreCase("true");
        String cursorType = info.getProperty("ClientCursor");
        this.isClientCursor = cursorType == null || !cursorType.equalsIgnoreCase("false");
        String temp = info.getProperty("ClientEncoding");
        if (temp != null && !temp.equalsIgnoreCase("GBK")) {
            this.clientEncoding = temp;
        }
        this.SYS_PORT = port;
        this.SYS_HOST = host;
        this.SYS_STATUS = this.CONNECTION_BAD;
        this.useSSL = info.getProperty("ssl") != null && Driver.sslEnabled();
        String strLogFile = info.getProperty("logFile", null);
        if (strLogFile != null) {
            Driver.isDebug = true;
            File file = new File(strLogFile);
            try {
                Driver.logStream = new PrintWriter(new FileWriter(file, true));
            }
            catch (Exception e) {
                throw new SQLException("Log file : " + strLogFile + " is not existed");
            }
        }
        try {
            this.KB_Stream = new KB_Stream(host, port);
        }
        catch (ConnectException cex) {
            throw new KSQLException("kingbase.con.refused");
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.con.failed");
        }
        this.openConnectionPV3(host, port, info, database, url, d, password);
    }

    private static final int getProtocol(int max, int n) {
        return (max & 0xFF) << 16 | n & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    private void parseErrorMessage(String p_host, int p_port, Properties p_info, String p_database, String p_url, Driver p_d, String p_password) throws SQLException, IOException {
        int ch;
        StringBuffer errorMessage = new StringBuffer();
        String sqlState = null;
        String strErrDesc = null;
        int iUpperLimitVersion = 0;
        int l_elen = this.KB_Stream.ReceiveIntegerR(4);
        if (l_elen > 30000) {
            try {
                try {
                    this.KB_Stream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.KB_Stream = new KB_Stream(p_host, p_port);
                this.currentVersion = Protocols[2];
            }
            catch (ConnectException cex) {
                throw new KSQLException("kingbase.con.refused");
            }
            catch (IOException e) {
                throw new KSQLException("kingbase.con.failed", e);
            }
            this.openConnectionPV2(p_host, p_port, p_info, p_database, p_url, p_d, p_password);
            return;
        }
        l_elen -= 4;
        while ((ch = this.KB_Stream.ReceiveChar()) != 0 && l_elen > 0) {
            void cex;
            String s = this.KB_Stream.ReceiveString(this.getEncoding());
            l_elen = s != null && s.length() > 0 ? l_elen - 1 - s.length() : --l_elen;
            if (cex == 77) {
                errorMessage.append(s);
                continue;
            }
            if (cex != 67) continue;
            sqlState = s;
        }
        strErrDesc = errorMessage.toString();
        if (sqlState != null && strErrDesc != null && sqlState.equals("08K99") && strErrDesc.length() > 0 && Protocols[this.protocolIndex] > AbstractJdbc1Connection.getProtocol(2, 0)) {
            int indexOfColon = strErrDesc.indexOf(":");
            int indexOfQuotate = strErrDesc.indexOf(".");
            int indexOfto = strErrDesc.indexOf("to");
            String strLowLimitMaxVersion = strErrDesc.substring(indexOfColon + 2, indexOfQuotate);
            String strLowLimitMinVersion = strErrDesc.substring(indexOfQuotate + 1, indexOfto);
            strErrDesc = strErrDesc.substring(indexOfto + 3);
            indexOfQuotate = strErrDesc.indexOf(".");
            int indexOfComma = strErrDesc.indexOf(",");
            String strUpperLimitMaxVersion = strErrDesc.substring(0, indexOfQuotate);
            String strUpperLimitMinVersion = strErrDesc.substring(indexOfQuotate + 1, indexOfComma);
            iUpperLimitVersion = AbstractJdbc1Connection.getProtocol(Integer.parseInt(strUpperLimitMaxVersion), Integer.parseInt(strUpperLimitMinVersion));
            try {
                try {
                    this.KB_Stream.close();
                    this.KB_Stream = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.KB_Stream = new KB_Stream(p_host, p_port);
            }
            catch (ConnectException cex) {
                throw new KSQLException("kingbase.con.refused");
            }
            catch (IOException e) {
                throw new KSQLException("kingbase.con.failed", e);
            }
            if (iUpperLimitVersion <= Protocols[0] && iUpperLimitVersion >= Protocols[Protocols.length - 1]) {
                int i = 0;
                while (i < Protocols.length) {
                    if (iUpperLimitVersion < Protocols[i] && iUpperLimitVersion >= Protocols[i + 1]) {
                        this.currentVersion = Protocols[i + 1];
                        this.openConnectionPV3(p_host, p_port, p_info, p_database, p_url, p_d, p_password);
                    }
                    ++i;
                }
            } else {
                if (this.protocolIndex >= Protocols.length) {
                    return;
                }
                this.currentVersion = Protocols[++this.protocolIndex];
                if (this.protocolIndex <= 1) {
                    this.openConnectionPV3(p_host, p_port, p_info, p_database, p_url, p_d, p_password);
                } else if (this.protocolIndex == 2) {
                    this.openConnectionPV2(p_host, p_port, p_info, p_database, p_url, p_d, p_password);
                }
            }
        } else {
            throw new KSQLException("kingbase.con.authfail", (Object)strErrDesc);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void openConnectionPV3(String p_host, int p_port, Properties p_info, String p_database, String p_url, Driver p_d, String p_password) throws SQLException {
        int beresp;
        this.KBProtocolVersionMinor = this.currentVersion << 16 >> 16 & 0xFF;
        this.KBProtocolVersionMajor = this.currentVersion >> 16 & 0xFF;
        try {
            if (this.useSSL) {
                if (Driver.isDebug) {
                    Driver.debug("Asking server if it supports ssl");
                }
                this.KB_Stream.SendInteger(8, 4);
                this.KB_Stream.SendInteger(80877103, 4);
                this.KB_Stream.flush();
                beresp = this.KB_Stream.ReceiveChar();
                if (Driver.isDebug) {
                    Driver.debug("Server response was (S=Yes,N=No): " + (char)beresp);
                }
                switch (beresp) {
                    case 69: {
                        throw new KSQLException("kingbase.con.misc", (Object)this.KB_Stream.ReceiveString(this.encoding));
                    }
                    case 78: {
                        throw new KSQLException("kingbase.con.sslnotsupported");
                    }
                    case 83: {
                        if (Driver.isDebug) {
                            Driver.debug("server does support ssl");
                        }
                        Driver.makeSSL(this.KB_Stream);
                        break;
                    }
                    default: {
                        throw new KSQLException("kingbase.con.sslfail");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.con.failed", e);
        }
        try {
            new StartupPacket(this.KBProtocolVersionMajor, this.KBProtocolVersionMinor, this.SYS_USER, p_database).writeTo(this.KB_Stream);
            this.KB_Stream.flush();
            int areq = -1;
            do {
                int beresp2 = this.KB_Stream.ReceiveChar();
                String salt = null;
                byte[] md5Salt = new byte[4];
                block8 : switch (beresp2) {
                    case 69: {
                        this.parseErrorMessage(p_host, p_port, p_info, p_database, p_url, p_d, p_password);
                        return;
                    }
                    case 82: {
                        int l_msgLen = this.KB_Stream.ReceiveIntegerR(4);
                        areq = this.KB_Stream.ReceiveIntegerR(4);
                        if (areq == 4) {
                            byte[] rst = new byte[]{(byte)this.KB_Stream.ReceiveChar(), (byte)this.KB_Stream.ReceiveChar()};
                            salt = new String(rst, 0, 2);
                            if (Driver.isDebug) {
                                Driver.debug("Crypt salt=" + salt);
                            }
                        }
                        if (areq == 5) {
                            md5Salt[0] = (byte)this.KB_Stream.ReceiveChar();
                            md5Salt[1] = (byte)this.KB_Stream.ReceiveChar();
                            md5Salt[2] = (byte)this.KB_Stream.ReceiveChar();
                            md5Salt[3] = (byte)this.KB_Stream.ReceiveChar();
                            salt = new String(md5Salt, 0, 4);
                            if (Driver.isDebug) {
                                Driver.debug("MD5 salt=" + salt);
                            }
                        }
                        switch (areq) {
                            case 0: {
                                break block8;
                            }
                            case 1: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: KRB4");
                                }
                                throw new KSQLException("kingbase.con.kerb4");
                            }
                            case 2: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: KRB5");
                                }
                                throw new KSQLException("kingbase.con.kerb5");
                            }
                            case 6: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: SCM");
                                }
                                throw new KSQLException("kingbase.con.scm");
                            }
                            case 3: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: PASSWORD");
                                }
                                this.KB_Stream.SendChar(112);
                                this.KB_Stream.SendInteger(5 + p_password.length(), 4);
                                this.KB_Stream.Send(p_password.getBytes());
                                this.KB_Stream.SendChar(0);
                                this.KB_Stream.flush();
                                break block8;
                            }
                            case 4: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: CRYPT");
                                }
                                String crypted = UnixCrypt.crypt(salt, p_password);
                                this.KB_Stream.SendChar(112);
                                this.KB_Stream.SendInteger(5 + crypted.length(), 4);
                                this.KB_Stream.Send(crypted.getBytes());
                                this.KB_Stream.SendChar(0);
                                this.KB_Stream.flush();
                                break block8;
                            }
                            case 5: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: MD5");
                                }
                                byte[] digest = MD5Digest.encode(this.SYS_USER, p_password, md5Salt);
                                this.KB_Stream.SendChar(112);
                                this.KB_Stream.SendInteger(5 + digest.length, 4);
                                this.KB_Stream.Send(digest);
                                this.KB_Stream.SendChar(0);
                                this.KB_Stream.flush();
                                break block8;
                            }
                        }
                        throw new KSQLException("kingbase.con.auth", new Integer(areq));
                    }
                    default: {
                        throw new KSQLException("kingbase.con.authfail");
                    }
                }
            } while (areq != 0);
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.con.failed", e);
        }
        block32: do {
            beresp = this.KB_Stream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    break;
                }
                case 75: {
                    int l_msgLen = this.KB_Stream.ReceiveIntegerR(4);
                    if (l_msgLen != 12) {
                        throw new KSQLException("kingbase.con.setup");
                    }
                    this.pid = this.KB_Stream.ReceiveIntegerR(4);
                    this.ckey = this.KB_Stream.ReceiveIntegerR(4);
                    break;
                }
                case 69: {
                    int ch;
                    StringBuffer errorMessage = null;
                    String sqlState = null;
                    if (errorMessage == null) {
                        errorMessage = new StringBuffer();
                    }
                    int l_elen = this.KB_Stream.ReceiveIntegerR(4);
                    l_elen -= 4;
                    while ((ch = this.KB_Stream.ReceiveChar()) != 0 && l_elen > 0) {
                        void crypted;
                        String s = this.KB_Stream.ReceiveString(this.encoding);
                        l_elen = s != null && s.length() > 0 ? l_elen - 1 - s.length() : --l_elen;
                        if (crypted == 77) {
                            errorMessage.append(s);
                            continue;
                        }
                        if (crypted != 67) continue;
                        sqlState = s;
                    }
                    try {
                        this.KB_Stream.close();
                        this.KB_Stream = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new KSQLException("kingbase.con.backend", (Object)(errorMessage == null ? "" : errorMessage.toString()));
                }
                case 78: {
                    int l_nlen = this.KB_Stream.ReceiveIntegerR(4);
                    this.addWarning(this.encoding.decode(this.KB_Stream.Receive(l_nlen - 4)));
                    break;
                }
                case 83: {
                    int l_len = this.KB_Stream.ReceiveIntegerR(4);
                    String l_pStatus = this.encoding.decode(this.KB_Stream.Receive(l_len - 4));
                    if (!Driver.isDebug) continue block32;
                    Driver.debug("ParameterStatus=" + l_pStatus);
                    break;
                }
                default: {
                    if (Driver.isDebug) {
                        Driver.debug("invalid state=" + (char)beresp);
                    }
                    throw new KSQLException("kingbase.con.setup");
                }
            }
        } while (beresp != 90);
        if (this.KB_Stream.ReceiveIntegerR(4) != 5) {
            throw new KSQLException("kingbase.con.setup");
        }
        char l_tStatus = (char)this.KB_Stream.ReceiveChar();
        String encodingQuery = "case when sys_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end";
        BaseResultSet resultSet = this.execSQL("set datestyle to 'ISO'; select version(), case when sys_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end;");
        if (!resultSet.next()) {
            throw new KSQLException("kingbase.con.failed", (Object)"failed getting backend encoding");
        }
        String version = resultSet.getString(1);
        this.dbVersionNumber = AbstractJdbc1Connection.extractVersionNumber(version);
        String[] temp = this.dbVersionNumber.split("\\.");
        this.databaseMajorVersion = Integer.parseInt(temp[0]);
        this.databaseMinorVersion = Integer.parseInt(temp[1]);
        this.patch = Integer.parseInt(temp[2]);
        if (this.databaseMajorVersion == 4 && this.databaseMinorVersion == 1 && this.patch == 0) {
            KBTypeInfo.getAllTypeInfo()[6].setLiteralPrefix("'");
        }
        String dbEncoding = resultSet.getString(2);
        resultSet.close();
        this.encoding = Encoding.getEncoding("GBK", p_info.getProperty("charSet"));
        String setClientEncoding = "set client_encoding = '" + this.clientEncoding + "'";
        BaseResultSet acRset = this.execSQL(setClientEncoding);
        this.encoding = Encoding.getEncoding(this.clientEncoding, null);
        BaseResultSet rsSP = this.execSQL("show enable_savepoint;");
        if (!rsSP.next()) {
            throw new KSQLException("kingbase.con.failed", (Object)"failed getting backend enable_savepoint");
        }
        String savepoint = rsSP.getString(1);
        if (savepoint.equalsIgnoreCase("on")) {
            this.setEnableSavepoint(true);
        } else if (savepoint.equalsIgnoreCase("off")) {
            this.setEnableSavepoint(false);
        }
        rsSP.close();
        this.initObjectTypes();
        this.SYS_STATUS = this.CONNECTION_OK;
        if (Driver.isDebug) {
            Driver.debug("Using Protocol Version " + this.KBProtocolVersionMajor + "." + this.KBProtocolVersionMinor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void openConnectionPV2(String host, int port, Properties info, String database, String url, Driver d, String password) throws SQLException {
        String s;
        String sqlState;
        int beresp;
        this.KBProtocolVersionMinor = this.currentVersion << 16 >> 16 & 0xFF;
        this.KBProtocolVersionMajor = this.currentVersion >> 16 & 0xFF;
        try {
            if (this.useSSL) {
                if (Driver.isDebug) {
                    Driver.debug("Asking server if it supports ssl");
                }
                this.KB_Stream.SendInteger(8, 4);
                this.KB_Stream.SendInteger(80877103, 4);
                this.KB_Stream.flush();
                beresp = this.KB_Stream.ReceiveChar();
                if (Driver.isDebug) {
                    Driver.debug("Server response was (S=Yes,N=No): " + (char)beresp);
                }
                switch (beresp) {
                    case 69: {
                        throw new KSQLException("kingbase.con.misc", (Object)this.KB_Stream.ReceiveString(this.encoding));
                    }
                    case 78: {
                        throw new KSQLException("kingbase.con.sslnotsupported");
                    }
                    case 83: {
                        if (Driver.isDebug) {
                            Driver.debug("server does support ssl");
                        }
                        Driver.makeSSL(this.KB_Stream);
                        break;
                    }
                    default: {
                        throw new KSQLException("kingbase.con.sslfail");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.con.failed", e);
        }
        try {
            new StartupPacket(this.KBProtocolVersionMajor, this.KBProtocolVersionMinor, this.SYS_USER, database).writeTo(this.KB_Stream);
            this.KB_Stream.flush();
            int areq = -1;
            do {
                int beresp2 = this.KB_Stream.ReceiveChar();
                String salt = null;
                byte[] md5Salt = new byte[4];
                block9 : switch (beresp2) {
                    case 69: {
                        throw new KSQLException("kingbase.con.misc", (Object)this.KB_Stream.ReceiveString(this.encoding));
                    }
                    case 82: {
                        areq = this.KB_Stream.ReceiveIntegerR(4);
                        if (areq == 4) {
                            byte[] rst = new byte[]{(byte)this.KB_Stream.ReceiveChar(), (byte)this.KB_Stream.ReceiveChar()};
                            salt = new String(rst, 0, 2);
                            if (Driver.isDebug) {
                                Driver.debug("Crypt salt=" + salt);
                            }
                        }
                        if (areq == 5) {
                            md5Salt[0] = (byte)this.KB_Stream.ReceiveChar();
                            md5Salt[1] = (byte)this.KB_Stream.ReceiveChar();
                            md5Salt[2] = (byte)this.KB_Stream.ReceiveChar();
                            md5Salt[3] = (byte)this.KB_Stream.ReceiveChar();
                            salt = new String(md5Salt, 0, 4);
                            if (Driver.isDebug) {
                                Driver.debug("MD5 salt=" + salt);
                            }
                        }
                        switch (areq) {
                            case 0: {
                                break block9;
                            }
                            case 1: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: KRB4");
                                }
                                throw new KSQLException("kingbase.con.kerb4");
                            }
                            case 2: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: KRB5");
                                }
                                throw new KSQLException("kingbase.con.kerb5");
                            }
                            case 3: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: PASSWORD");
                                }
                                this.KB_Stream.SendInteger(5 + password.length(), 4);
                                this.KB_Stream.Send(password.getBytes());
                                this.KB_Stream.SendInteger(0, 1);
                                this.KB_Stream.flush();
                                break block9;
                            }
                            case 4: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: CRYPT");
                                }
                                String crypted = UnixCrypt.crypt(salt, password);
                                this.KB_Stream.SendInteger(5 + crypted.length(), 4);
                                this.KB_Stream.Send(crypted.getBytes());
                                this.KB_Stream.SendInteger(0, 1);
                                this.KB_Stream.flush();
                                break block9;
                            }
                            case 5: {
                                if (Driver.isDebug) {
                                    Driver.debug("Kingbase: MD5");
                                }
                                byte[] digest = MD5Digest.encode(this.SYS_USER, password, md5Salt);
                                this.KB_Stream.SendInteger(5 + digest.length, 4);
                                this.KB_Stream.Send(digest);
                                this.KB_Stream.SendInteger(0, 1);
                                this.KB_Stream.flush();
                                break block9;
                            }
                        }
                        throw new KSQLException("kingbase.con.auth", new Integer(areq));
                    }
                    default: {
                        throw new KSQLException("kingbase.con.authfail");
                    }
                }
            } while (areq != 0);
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.con.failed", e);
        }
        do {
            beresp = this.KB_Stream.ReceiveChar();
            switch (beresp) {
                case 75: {
                    this.pid = this.KB_Stream.ReceiveIntegerR(4);
                    this.ckey = this.KB_Stream.ReceiveIntegerR(4);
                    break;
                }
                case 69: {
                    int ch;
                    StringBuffer errorMessage = null;
                    sqlState = null;
                    if (errorMessage == null) {
                        errorMessage = new StringBuffer();
                    }
                    int l_elen = this.KB_Stream.ReceiveIntegerR(4);
                    l_elen -= 4;
                    while ((ch = this.KB_Stream.ReceiveChar()) != 0 && l_elen > 0) {
                        void crypted;
                        s = this.KB_Stream.ReceiveString(this.encoding);
                        l_elen = s != null && s.length() > 0 ? l_elen - 1 - s.length() : --l_elen;
                        if (crypted == 77) {
                            errorMessage.append(s);
                            continue;
                        }
                        if (crypted != 67) continue;
                        sqlState = s;
                    }
                    try {
                        this.KB_Stream.close();
                        this.KB_Stream = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new KSQLException("kingbase.con.backend", (Object)(errorMessage == null ? "" : errorMessage.toString()));
                }
                case 78: {
                    this.addWarning(this.KB_Stream.ReceiveString(this.encoding));
                    break;
                }
                default: {
                    throw new KSQLException("kingbase.con.setup");
                }
            }
        } while (beresp == 78);
        do {
            beresp = this.KB_Stream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    break;
                }
                case 78: {
                    this.addWarning(this.KB_Stream.ReceiveString(this.encoding));
                    break;
                }
                case 69: {
                    int ch;
                    StringBuffer errorMessage = null;
                    sqlState = null;
                    if (errorMessage == null) {
                        errorMessage = new StringBuffer();
                    }
                    int l_elen = this.KB_Stream.ReceiveIntegerR(4);
                    l_elen -= 4;
                    while ((ch = this.KB_Stream.ReceiveChar()) != 0 && l_elen > 0) {
                        s = this.KB_Stream.ReceiveString(this.encoding);
                        l_elen = s != null && s.length() > 0 ? l_elen - 1 - s.length() : --l_elen;
                        if (ch == 77) {
                            errorMessage.append(s);
                            continue;
                        }
                        if (ch != 67) continue;
                        sqlState = s;
                    }
                    try {
                        this.KB_Stream.close();
                        this.KB_Stream = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new KSQLException("kingbase.con.backend", (Object)(errorMessage == null ? "" : errorMessage.toString()));
                }
                default: {
                    throw new KSQLException("kingbase.con.setup");
                }
            }
        } while (beresp == 78);
        String encodingQuery = "case when sys_encoding_to_char(1) = 'SQL_ASCII' then 'GBK' else getdatabaseencoding() end";
        BaseResultSet resultSet = this.execSQL("set datestyle to 'ISO'; select version(), case when sys_encoding_to_char(1) = 'SQL_ASCII' then 'GBK' else getdatabaseencoding() end;");
        if (!resultSet.next()) {
            throw new KSQLException("kingbase.con.failed", (Object)"failed getting backend encoding");
        }
        String version = resultSet.getString(1);
        this.dbVersionNumber = AbstractJdbc1Connection.extractVersionNumber(version);
        this.databaseMajorVersion = Integer.parseInt(this.dbVersionNumber.substring(0, 1));
        this.databaseMinorVersion = Integer.parseInt(this.dbVersionNumber.substring(2, 3));
        String dbEncoding = resultSet.getString(2);
        this.encoding = Encoding.getEncoding(dbEncoding, info.getProperty("charSet"));
        BaseResultSet acRset = this.execSQL(" show autocommit");
        if (!acRset.next()) {
            throw new KSQLException("kingbase.con.failed2");
        }
        if (acRset.getString(1).equals("off")) {
            this.execSQL("set autocommit = on; commit;");
        }
        this.initObjectTypes();
        this.SYS_STATUS = this.CONNECTION_OK;
        if (Driver.isDebug) {
            Driver.debug("Using Protocol Version " + this.KBProtocolVersionMajor + "." + this.KBProtocolVersionMinor);
        }
    }

    public Driver getDriver() {
        return this.this_driver;
    }

    public void addWarning(String msg) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning("[KingbaseES Server]" + msg, "01000"));
        } else {
            this.firstWarning = new SQLWarning("[KingbaseES Server]" + msg, "01000");
        }
    }

    public BaseResultSet execSQL(String s) throws SQLException {
        Object[] nullarr = new Object[]{};
        BaseStatement stat = this.createBaseStatement();
        return QueryExecutor.execute(new String[]{s}, nullarr, stat);
    }

    public void setCursorName(String cursor) throws SQLException {
        this.cursor = cursor;
    }

    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getURL() throws SQLException {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        return this.SYS_USER;
    }

    public Encoding getEncoding() throws SQLException {
        return this.encoding;
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this, this.KB_Stream);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    public Object getObject(String type, String value) throws SQLException {
        try {
            Object o = this.objectTypes.get(type);
            if (o != null && o instanceof String) {
                KBobject obj = null;
                obj = (KBobject)Class.forName((String)o).newInstance();
                obj.setType(type);
                obj.setValue(value);
                return obj;
            }
        }
        catch (SQLException sx) {
            sx.fillInStackTrace();
            throw sx;
        }
        catch (Exception ex) {
            throw new KSQLException("kingbase.con.creobj", (Object)type, (Object)ex);
        }
        return null;
    }

    public void addDataType(String type, String name) {
        this.objectTypes.put(type, name);
    }

    private void initObjectTypes() {
        int i = 0;
        while (i < defaultObjectTypes.length) {
            this.objectTypes.put(defaultObjectTypes[i][0], defaultObjectTypes[i][1]);
            ++i;
        }
    }

    public void close() throws SQLException {
        int size = this.stmts.size();
        int i = 0;
        while (i < size) {
            ((Statement)this.stmts.elementAt(0)).close();
            ++i;
        }
        if (this.objectTypes != null) {
            this.objectTypes.clear();
            this.objectTypes = null;
        }
        if (this.getDatabaseMajorVersion() >= 4) {
            this.closePV3();
        } else {
            this.closePV2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePV3() throws SQLException {
        if (this.KB_Stream != null) {
            try {
                try {
                    this.KB_Stream.SendChar(88);
                    this.KB_Stream.SendInteger(4, 4);
                    this.KB_Stream.flush();
                    this.KB_Stream.close();
                }
                catch (IOException e) {
                    Object var3_2 = null;
                    this.KB_Stream = null;
                }
                Object var3_1 = null;
                this.KB_Stream = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.KB_Stream = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePV2() throws SQLException {
        if (this.KB_Stream != null) {
            try {
                try {
                    this.KB_Stream.SendChar(88);
                    this.KB_Stream.flush();
                    this.KB_Stream.close();
                }
                catch (IOException e) {
                    Object var3_2 = null;
                    this.KB_Stream = null;
                }
                Object var3_1 = null;
                this.KB_Stream = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.KB_Stream = null;
                throw throwable;
            }
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.getDatabaseMajorVersion() >= 4) {
            this.setAutoCommitV4(autoCommit);
        } else {
            this.setAutoCommitV3(autoCommit);
        }
    }

    public void setAutoCommitV4(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (this.getIsBegin()) {
            Boolean b = new Boolean(autoCommit);
            String s = Boolean.toString(autoCommit);
            this.execSQL("commit;");
        }
        this.autoCommit = autoCommit;
    }

    public void setAutoCommitV3(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        int i = 0;
        while (i < this.stmts.size()) {
            if (((AbstractJdbc3Statement)this.stmts.elementAt(i)).getResultSetHoldability() == 2 && ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result != null) {
                ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result.close();
            }
            ++i;
        }
        if (autoCommit) {
            this.execSQL("select 1; commit; set autocommit = on;");
        } else {
            this.execSQL("set autocommit = off; " + this.getIsolationLevelSQL());
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        if (this.getDatabaseMajorVersion() >= 4) {
            this.commitSV4();
        } else {
            this.commitSV3();
        }
    }

    private void commitSV3() throws SQLException {
        int i = 0;
        while (i < this.stmts.size()) {
            if (((AbstractJdbc3Statement)this.stmts.elementAt(i)).getResultSetHoldability() == 2 && ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result != null) {
                ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result.close();
            }
            ++i;
        }
        this.execSQL("commit; " + this.getIsolationLevelSQL());
    }

    private void commitSV4() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        this.execSQL("commit;begin;" + this.getIsolationLevelSQL());
    }

    public void rollback() throws SQLException {
        if (this.getDatabaseMajorVersion() >= 4) {
            this.rollbackSV4();
        } else {
            this.rollbackSV3();
        }
    }

    private void rollbackSV3() throws SQLException {
        int i = 0;
        while (i < this.stmts.size()) {
            if (((AbstractJdbc3Statement)this.stmts.elementAt(i)).getResultSetHoldability() == 2 && ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result != null) {
                ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result.close();
            }
            ++i;
        }
        if (this.autoCommit) {
            return;
        }
        this.execSQL("rollback; " + this.getIsolationLevelSQL());
    }

    private void rollbackSV4() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.getIsBegin()) {
            this.execSQL("rollback;");
        }
    }

    public int getTransactionIsolation() throws SQLException {
        String sql = "show transaction isolation level";
        String level = null;
        BaseResultSet rs = this.execSQL(sql);
        if (rs.next()) {
            level = rs.getString(1);
        }
        rs.close();
        if (level != null) {
            if ((level = level.toUpperCase()).indexOf("READ COMMITTED") != -1) {
                return 2;
            }
            if (level.indexOf("READ UNCOMMITTED") != -1) {
                return 1;
            }
            if (level.indexOf("REPEATABLE READ") != -1) {
                return 4;
            }
            if (level.indexOf("SERIALIZABLE") != -1) {
                return 8;
            }
        }
        return 2;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.isolationLevel = level;
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL ";
        switch (this.isolationLevel) {
            case 2: {
                isolationLevelSQL = isolationLevelSQL + "READ COMMITTED";
                break;
            }
            case 8: {
                isolationLevelSQL = isolationLevelSQL + "SERIALIZABLE";
                break;
            }
            default: {
                throw new KSQLException("kingbase.con.isolevel");
            }
        }
        this.execSQL(isolationLevelSQL);
    }

    protected String getIsolationLevelSQL() throws SQLException {
        StringBuffer sb = new StringBuffer("SET TRANSACTION ISOLATION LEVEL");
        switch (this.isolationLevel) {
            case 2: {
                sb.append(" READ COMMITTED");
                break;
            }
            case 8: {
                sb.append(" SERIALIZABLE");
                break;
            }
            default: {
                throw new KSQLException("kingbase.con.isolevel", new Integer(this.isolationLevel));
            }
        }
        return sb.toString();
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.SYS_DATABASE;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static String extractVersionNumber(String fullVersionString) {
        StringTokenizer versionParts = new StringTokenizer(fullVersionString);
        versionParts.nextToken();
        return versionParts.nextToken();
    }

    private static int integerPart(String dirtyString) {
        int start = 0;
        while (start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start))) {
            ++start;
        }
        int end = start;
        while (end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end))) {
            ++end;
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    public int getSQLType(int oid) throws SQLException {
        Integer iOid;
        Integer sqlType = (Integer)sqlTypeCache.get(new Integer(oid));
        String sysType = (String)sysTypeCache.get(new Integer(oid));
        if (sqlType == null && sysType != null) {
            iOid = new Integer(oid);
            sqlType = new Integer(this.getSQLType(sysType));
            sqlTypeCache.put(iOid, sqlType);
            sysTypeCache.put(iOid, sysType);
        }
        if (sqlType == null) {
            if (oid == 0) {
                sysType = "opaque";
            } else {
                String sql = "SELECT typname FROM sys_catalog.sys_type WHERE oid = " + oid;
                BaseResultSet result = this.execSQL(sql);
                if (result.getColumnCount() != 1 || result.getTupleCount() != 1) {
                    throw new KSQLException("kingbase.unexpected");
                }
                result.next();
                sysType = result.getString(1);
                if (sysType.equalsIgnoreCase("unknown")) {
                    sysType = "TEXT";
                }
                result.close();
            }
            iOid = new Integer(oid);
            sqlType = new Integer(this.getSQLType(sysType));
            sqlTypeCache.put(iOid, sqlType);
            sysTypeCache.put(iOid, sysType);
        }
        return sqlType;
    }

    public int getPGType(String typeName) throws SQLException {
        int oid = -1;
        if (typeName != null) {
            Integer oidValue = (Integer)typeOidCache.get(typeName);
            if (oidValue != null) {
                oid = oidValue;
            } else {
                String sql = "SELECT oid FROM sys_catalog.sys_type WHERE typname='" + typeName + "'";
                BaseResultSet result = this.execSQL(sql);
                if (result.getColumnCount() != 1 || result.getTupleCount() != 1) {
                    throw new KSQLException("kingbase.unexpected");
                }
                result.next();
                oid = Integer.parseInt(result.getString(1));
                typeOidCache.put(typeName, new Integer(oid));
                result.close();
            }
        }
        return oid;
    }

    public String getPGType(int oid) throws SQLException {
        String sysType = (String)sysTypeCache.get(new Integer(oid));
        if (sysType == null) {
            this.getSQLType(oid);
            sysType = (String)sysTypeCache.get(new Integer(oid));
        }
        return sysType;
    }

    protected String getPGTypeFromSQLType(int type) {
        String PGType = "";
        int i = 0;
        while (i < jdbc1Typei.length) {
            if (type == jdbc1Typei[i]) {
                PGType = jdbc1Types[i];
                break;
            }
            ++i;
        }
        return PGType;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogWriter() == null) {
            DriverManager.setLogWriter(new PrintWriter(System.out));
        }
    }

    public boolean isClosed() throws SQLException {
        return this.KB_Stream == null;
    }

    public int getSQLType(String sysTypeName) {
        int sqlType = 1111;
        int i = 0;
        while (i < jdbc1Types.length) {
            if (sysTypeName.equalsIgnoreCase(jdbc1Types[i])) {
                sqlType = jdbc1Typei[i];
                break;
            }
            ++i;
        }
        return sqlType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancelQuery() throws SQLException {
        KB_Stream cancelStream = null;
        try {
            cancelStream = new KB_Stream(this.SYS_HOST, this.SYS_PORT);
        }
        catch (ConnectException cex) {
            throw new KSQLException("kingbase.con.refused");
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.con.failed", e);
        }
        try {
            try {
                cancelStream.SendInteger(16, 4);
                cancelStream.SendInteger(80877102, 4);
                cancelStream.SendInteger(this.pid, 4);
                cancelStream.SendInteger(this.ckey, 4);
                cancelStream.flush();
            }
            catch (IOException e) {
                throw new KSQLException("kingbase.con.failed", e);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (cancelStream == null) throw throwable;
                cancelStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (cancelStream == null) return;
        cancelStream.close();
        return;
    }

    public void addNotification(KBNotification p_notification) {
        if (this.m_notifications == null) {
            this.m_notifications = new Vector();
        }
        this.m_notifications.addElement(p_notification);
    }

    public KBNotification[] getNotifications() {
        Object[] l_return = null;
        if (this.m_notifications != null) {
            l_return = new KBNotification[this.m_notifications.size()];
            this.m_notifications.copyInto(l_return);
        }
        this.m_notifications = null;
        return l_return;
    }

    protected int allocId() throws SQLException {
        int i = 0;
        while (i < 1000) {
            Integer m = new Integer(i);
            if (!this.allocIds.contains(m)) {
                this.allocIds.add(m);
                return i;
            }
            ++i;
        }
        throw new KSQLException("kingbase.con.toomanystmts");
    }

    private void checkAutoCommit() throws SQLException {
        if (this.autoCommit) {
            throw new KSQLException("kingbase.con.autoCommit");
        }
    }

    protected void releaseResource() throws SQLException {
        int i = 0;
        while (i < this.stmts.size()) {
            AbstractJdbc1Statement st = (AbstractJdbc1Statement)this.stmts.elementAt(i);
            st.result = null;
            st.close();
            ++i;
        }
    }

    public void setEscape(boolean escape) {
        this.escapeProcessing = escape;
    }

    public boolean getEscape() {
        return this.escapeProcessing;
    }

    public boolean getIsUseServerPrepare() {
        return this.useServerPrepare;
    }

    public boolean getIsSavePrepareStatement() {
        return this.isSavePrepared;
    }

    public void setIsBegin(boolean isBegin) {
        this.isTransactionBegin = isBegin;
    }

    public boolean getIsBegin() {
        return this.isTransactionBegin;
    }

    public boolean getIsClientCursor() {
        return this.isClientCursor;
    }

    public void setClientCursor(boolean isClientCursor) {
        this.isClientCursor = isClientCursor;
    }

    public void removeStatement(BaseStatement statement) {
        this.stmts.remove(statement);
    }

    public boolean isStatementClosed(BaseStatement statement) {
        return !this.stmts.contains(statement);
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public int getDatabaseVersion() {
        return (this.databaseMajorVersion * 100 + this.databaseMinorVersion) * 100 + this.patch;
    }

    public void setEnableSavepoint(boolean savepoint) {
        this.enableSavepoint = savepoint;
    }

    public boolean getEnableSavepoint() {
        return this.enableSavepoint;
    }

    static {
        KBTypeInfo[] typeInfo = KBTypeInfo.getAllTypeInfo();
        int i = 0;
        while (i < typeInfo.length) {
            sysTypeCache.put(new Integer(typeInfo[i].getTypeOid()), typeInfo[i].getTypeName());
            sqlTypeCache.put(new Integer(typeInfo[i].getTypeOid()), new Integer(typeInfo[i].getDataType()));
            ++i;
        }
        sysTypeCache.put(new Integer(19), "NAME");
        sqlTypeCache.put(new Integer(19), new Integer(12));
        sysTypeCache.put(new Integer(701), "DOUBLE");
        sqlTypeCache.put(new Integer(701), new Integer(8));
        sysTypeCache.put(new Integer(1700), "NUMERIC");
        sqlTypeCache.put(new Integer(1700), new Integer(2));
        Protocols = new int[]{AbstractJdbc1Connection.getProtocol(3, 1), AbstractJdbc1Connection.getProtocol(3, 0), AbstractJdbc1Connection.getProtocol(2, 0), AbstractJdbc1Connection.getProtocol(1, 0)};
    }
}

