/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc1;

import com.kingbase.core.Field;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.util.KBTypeInfo;
import com.kingbase.util.KSQLException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public abstract class AbstractJdbc1ResultSetMetaData {
    protected Vector rows;
    protected Field[] fields;
    private boolean isOidAdded;
    private ResultSet resultSet;

    public AbstractJdbc1ResultSetMetaData(Vector rows, Field[] fields, boolean isOidAdded, ResultSet rs) {
        this.rows = rows;
        this.fields = fields;
        this.isOidAdded = isOidAdded;
        this.resultSet = rs;
    }

    public int getColumnCount() throws SQLException {
        if (this.isOidAdded) {
            return this.fields.length - 1;
        }
        return this.fields.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkIndex(column);
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkIndex(column);
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case -6: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return true;
    }

    public boolean isSearchable(int column) throws SQLException {
        this.checkIndex(column);
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case 1111: {
                return true;
            }
        }
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        this.checkIndex(column);
        String type_name = this.getField(column).getPGType();
        return type_name.equalsIgnoreCase("cash") || type_name.equalsIgnoreCase("money");
    }

    public int isNullable(int column) throws SQLException {
        this.checkIndex(column);
        return 2;
    }

    public boolean isSigned(int column) throws SQLException {
        this.checkIndex(column);
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case -6: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkIndex(column);
        Field f = this.getField(column);
        String type_name = f.getPGType();
        int sql_type = f.getSQLType();
        int typmod = f.getMod();
        if (type_name.equalsIgnoreCase("int2") || type_name.equalsIgnoreCase("SMALLINT")) {
            return 6;
        }
        if (type_name.equalsIgnoreCase("int4") || type_name.equalsIgnoreCase("oid") || type_name.equalsIgnoreCase("INTEGER") || type_name.equalsIgnoreCase("INT")) {
            return 11;
        }
        if (type_name.equalsIgnoreCase("int8") || type_name.equalsIgnoreCase("BIGINT")) {
            return 20;
        }
        if (type_name.equalsIgnoreCase("money")) {
            return 12;
        }
        if (type_name.equalsIgnoreCase("float4") || type_name.equalsIgnoreCase("REAL")) {
            return 11;
        }
        if (type_name.equalsIgnoreCase("float8") || type_name.equalsIgnoreCase("DOUBLE")) {
            return 20;
        }
        if (type_name.equalsIgnoreCase("bool") || type_name.equalsIgnoreCase("BOOLEAN")) {
            return 1;
        }
        if (type_name.equalsIgnoreCase("date")) {
            return 14;
        }
        if (type_name.equalsIgnoreCase("time")) {
            return 8;
        }
        if (type_name.equalsIgnoreCase("timestamp")) {
            return 22;
        }
        typmod -= 4;
        if (type_name.equalsIgnoreCase("bpchar") || type_name.equalsIgnoreCase("varchar") || type_name.equalsIgnoreCase("CHAR")) {
            return typmod;
        }
        if (type_name.equalsIgnoreCase("numeric")) {
            return (typmod >> 16 & 0xFFFF) + 1 + (typmod & 0xFFFF);
        }
        return f.getLength();
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws SQLException {
        this.checkIndex(column);
        Field f = this.getField(column);
        if (f != null) {
            return f.getName();
        }
        return "FIELD" + column;
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        if (((AbstractJdbc1Connection)((Object)this.resultSet.getStatement().getConnection())).getDatabaseVersion() >= 40100) {
            return this.getPrecisionSV4(column);
        }
        return this.getPrecisionSV3(column);
    }

    private int getPrecisionSV4(int column) throws SQLException {
        this.checkIndex(column);
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field f = this.getField(column);
                if (f != null) {
                    return (0xFFFF0000 & f.getMod()) >> 16;
                }
                return 0;
            }
        }
        return 0;
    }

    private int getPrecisionSV3(int column) throws SQLException {
        this.checkIndex(column);
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field f = this.getField(column);
                if (f != null && f.getMod() == -1) {
                    return 38;
                }
                if (f != null) {
                    return (0xFFFF0000 & f.getMod()) >> 16;
                }
                return 0;
            }
        }
        return 0;
    }

    public int getScale(int column) throws SQLException {
        if (((AbstractJdbc1Connection)((Object)this.resultSet.getStatement().getConnection())).getDatabaseVersion() >= 40100) {
            return this.getScaleSV4(column);
        }
        return this.getScaleSV3(column);
    }

    private int getScaleSV4(int column) throws SQLException {
        this.checkIndex(column);
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case -6: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field f = this.getField(column);
                if (f != null) {
                    return (0xFFFF & f.getMod()) - 4;
                }
                return 0;
            }
        }
        return 0;
    }

    private int getScaleSV3(int column) throws SQLException {
        this.checkIndex(column);
        int sql_type = this.getField(column).getSQLType();
        switch (sql_type) {
            case 5: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field f = this.getField(column);
                if (f != null && f.getMod() == -1) {
                    return 8;
                }
                if (f != null) {
                    return (0xFFFF & f.getMod()) - 4;
                }
                return 0;
            }
        }
        return 0;
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        this.checkIndex(column);
        return this.getField(column).getSQLType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.checkIndex(column);
        return KBTypeInfo.getDatabaseTypeName(this.getField(column).getOID(), this.getField(column).getMod(), this.resultSet.getStatement().getConnection(), this.getField(column).getPGType());
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.checkIndex(column);
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkIndex(column);
        return false;
    }

    protected Field getField(int columnIndex) throws SQLException {
        return this.fields[columnIndex - 1];
    }

    protected void checkIndex(int col) throws SQLException {
        if (col < 1 || col > this.getColumnCount()) {
            throw new KSQLException("kingbase.res.colrange");
        }
    }

    private String getColumnName1(int column) throws SQLException {
        Field f = this.getField(column);
        if (f != null) {
            return f.getName();
        }
        return "field" + column;
    }
}

