/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc2;

import com.kingbase.KBConnection;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.largeobject.LargeObject;
import com.kingbase.largeobject.LargeObjectManager;
import com.kingbase.util.KSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public abstract class AbstractJdbc2Blob {
    protected int oid;
    protected LargeObject lo;
    private AbstractJdbc1Connection connection = null;
    protected boolean isOpened = false;
    protected LargeObjectManager largeObjectManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractJdbc2Blob(KBConnection conn, int oid) throws SQLException {
        this.oid = oid;
        KBConnection kBConnection = conn;
        synchronized (kBConnection) {
            LargeObjectManager lom;
            this.largeObjectManager = lom = conn.getLargeObjectAPI();
        }
        this.connection = (AbstractJdbc1Connection)conn;
    }

    public long length() throws SQLException {
        this.checkState();
        return this.lo.size();
    }

    public InputStream getBinaryStream() throws SQLException {
        this.checkState();
        this.lo.seek(0);
        return this.lo.getInputStream();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkState();
        this.lo.seek((int)pos - 1, 0);
        return this.lo.read(length);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        this.checkState();
        return this.lo.position(pattern, start - 1L) + 1L;
    }

    public long position(Blob pattern, long start) throws SQLException {
        this.checkState();
        if (pattern instanceof AbstractJdbc2Blob) {
            return this.lo.position(((AbstractJdbc2Blob)((Object)pattern)).lo, start - 1L) + 1L;
        }
        long position = -1L;
        try {
            LargeObject tempLargeObject = this.createTempLargeObject(pattern);
            position = this.lo.position(tempLargeObject, start - 1L) + 1L;
            this.deleteTempLargeObject(tempLargeObject);
        }
        catch (Exception e) {
            throw new KSQLException("kingbase.unusual");
        }
        return position;
    }

    public void close() {
        try {
            if (this.lo != null) {
                this.lo.close();
                this.isOpened = false;
                this.lo = null;
            }
        }
        catch (Exception e) {}
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private LargeObject createTempLargeObject(Blob blob) throws SQLException {
        LargeObject lob = null;
        InputStream l_inStream = blob.getBinaryStream();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        lob = lom.openLargeObject(oid);
        OutputStream los = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            int bytesRemaining = (int)blob.length();
            int numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            while (numRead != -1 && bytesRemaining > 0) {
                bytesRemaining -= numRead;
                if (numRead == buf.length) {
                    los.write(buf);
                } else {
                    los.write(buf, 0, numRead);
                }
                numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            }
        }
        catch (IOException se) {
            throw new SQLException();
        }
        return lob;
    }

    private void deleteTempLargeObject(LargeObject lob) throws SQLException {
        try {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            lom.delete(lob.getOID());
        }
        catch (Exception e) {
            throw new SQLException("delete temp large object exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() throws SQLException {
        if (!this.isOpened) {
            AbstractJdbc1Connection abstractJdbc1Connection = this.connection;
            synchronized (abstractJdbc1Connection) {
                if (this.connection.getAutoCommit() && !this.connection.getIsBegin()) {
                    this.connection.execSQL("begin;");
                }
                this.lo = this.largeObjectManager.openLargeObject(this.oid);
                this.isOpened = true;
            }
        }
    }
}

