/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc2;

import com.kingbase.Driver;
import com.kingbase.core.BaseStatement;
import com.kingbase.core.Field;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.jdbc1.AbstractJdbc1ResultSet;
import com.kingbase.jdbc1.AbstractJdbc1Statement;
import com.kingbase.jdbc2.AbstractJdbc2Statement;
import com.kingbase.jdbc2.Array;
import com.kingbase.util.KBStringTokenizer;
import com.kingbase.util.KSQLException;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public abstract class AbstractJdbc2ResultSet
extends AbstractJdbc1ResultSet {
    protected boolean updateable;
    protected boolean doingUpdates;
    protected boolean onInsertRow;
    protected Hashtable updateValues;
    private boolean usingOID;
    private Vector primaryKeys;
    private int numKeys;
    private boolean singleTable;
    protected String tableName;
    protected PreparedStatement updateStatement;
    protected PreparedStatement insertStatement;
    protected PreparedStatement deleteStatement;
    private PreparedStatement selectStatement;
    protected int beginPos;
    protected int fetchDirect;
    protected int fetchSize;
    private AbstractJdbc2ResultSet rs;

    public AbstractJdbc2ResultSet(BaseStatement statement, Field[] fields, Vector tuples, String status, int updateCount, long insertOID, boolean binaryCursor) {
        block3: {
            super(statement, fields, tuples, status, updateCount, insertOID, binaryCursor);
            this.updateable = false;
            this.doingUpdates = false;
            this.onInsertRow = false;
            this.updateValues = new Hashtable();
            this.usingOID = false;
            this.numKeys = 0;
            this.singleTable = false;
            this.tableName = null;
            this.updateStatement = null;
            this.insertStatement = null;
            this.deleteStatement = null;
            this.selectStatement = null;
            this.fetchSize = 100;
            this.rs = null;
            if (statement == null) break block3;
            try {
                this.fetchDirect = ((AbstractJdbc2Statement)statement).getFetchDirection();
                this.fetchSize = ((AbstractJdbc2Statement)statement).getFetchSize();
                if (((AbstractJdbc2Statement)statement).getResultSetType() == 1003) {
                    this.beginPos = 1;
                    break block3;
                }
                this.beginPos = 0;
            }
            catch (SQLException e) {}
        }
    }

    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    public URL getURL(String columnName) throws SQLException {
        return null;
    }

    public Object getObject(int columnIndex) throws SQLException {
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: {
                return this.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Short(this.getShort(columnIndex));
            }
            case 4: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: {
                return this.getBigDecimal(columnIndex, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
        }
        String type = field.getPGType();
        if (type.equalsIgnoreCase("unknown")) {
            return this.getString(columnIndex);
        }
        if (type.equals("refcursor")) {
            String cursorName = this.getString(columnIndex);
            return this.statement.createRefCursorResultSet(cursorName);
        }
        return this.connection.getObject(field.getPGType(), this.getString(columnIndex));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean absolute(int index) throws SQLException {
        int internalIndex;
        if (index == 0) {
            this.beforeFirst();
            return false;
        }
        this.checkForPosition();
        if (this.isServerSideScroll() && this.statement.getCursorName() != null) {
            if (index < 0) {
                if (this.connection.getDatabaseVersion() >= 40102) {
                    if (!this.fetchRowForScroll("absolute", index)) return false;
                    index = this.rs.getFetchPosition();
                    int interval = (index - this.beginPos) / this.fetchSize * this.fetchSize;
                    if (interval > 0) {
                        this.beginPos += interval;
                    } else {
                        this.beginPos += interval - this.fetchSize;
                        if (this.beginPos < 0) {
                            this.beginPos = 0;
                        }
                    }
                    this.fetchRowForScroll("absolute", this.beginPos);
                    this.fetchRows(this.beginPos);
                    if (this.rs.rows.size() == this.fetchSize) {
                        this.current_row = index - (this.beginPos - this.fetchSize) - 1;
                        return this.getThisRow();
                    }
                    this.current_row = index - (this.beginPos - this.rs.rows.size()) - 1;
                    return this.getThisRow();
                }
                int temp = this.beginPos;
                this.last();
                index = this.beginPos + 1 + index;
                this.beginPos = temp;
                if (index <= 0) {
                    this.fetchRowForScroll("absolute", 0);
                    this.current_row = 0;
                    return this.getThisRow();
                }
            }
            if (this.beginPos - --index > 0 && this.beginPos - index <= this.fetchSize) {
                if (this.rs.rows.size() == this.fetchSize) {
                    this.current_row = index - (this.beginPos - this.fetchSize);
                    return this.getThisRow();
                }
                this.current_row = index - (this.beginPos - this.rs.rows.size());
                return this.getThisRow();
            }
            int interval = (index - this.beginPos) / this.fetchSize * this.fetchSize;
            if (interval > 0) {
                this.beginPos += interval;
            } else if (interval < 0) {
                this.beginPos += interval - this.fetchSize;
                if (this.beginPos < 0) {
                    this.beginPos = 0;
                }
            }
            this.fetchRowForScroll("absolute", this.beginPos);
            this.fetchRows(this.beginPos);
            if (this.rs.rows.size() == this.fetchSize) {
                this.current_row = index - (this.beginPos - this.fetchSize);
                return this.getThisRow();
            }
            this.current_row = index - (this.beginPos - this.rs.rows.size());
            return this.getThisRow();
        }
        if (index == 0) {
            throw new SQLException("Cannot move to index of 0");
        }
        int rows_size = this.rows.size();
        if (index < 0) {
            if (index < -rows_size) {
                this.beforeFirst();
                return false;
            }
            internalIndex = rows_size + index;
        } else {
            if (index > rows_size) {
                this.afterLast();
                return false;
            }
            internalIndex = index - 1;
        }
        this.current_row = internalIndex;
        this.this_row = (byte[][])this.rows.elementAt(internalIndex);
        this.rowBuffer = null;
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public void afterLast() throws SQLException {
        this.checkForPosition();
        if (this.isServerSideScroll() && this.statement.getCursorName() != null) {
            while (this.fetchRowForScroll("next")) {
                ++this.beginPos;
            }
        } else {
            int rows_size = this.rows.size();
            if (rows_size > 0) {
                this.current_row = rows_size;
            }
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkForPosition();
        if (this.isServerSideScroll() && this.statement.getCursorName() != null) {
            this.fetchRowForScroll("first");
            this.fetchRowForScroll("prior");
            this.beginPos = 0;
        } else if (this.rows.size() > 0) {
            this.current_row = -1;
        }
    }

    public boolean first() throws SQLException {
        this.checkForPosition();
        if (this.beginPos != 0 || this.rows.size() == 0) {
            this.moveRowForScroll("first");
            this.moveRowForScroll("prior");
            this.beginPos = 0;
            this.fetchRows(this.beginPos);
            this.current_row = 0;
            this.onInsertRow = false;
            return this.getThisRow();
        }
        this.current_row = 0;
        return this.getThisRow();
    }

    public java.sql.Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public java.sql.Array getArray(int i) throws SQLException {
        this.checkResultSet(i);
        boolean bl = this.wasNullFlag = this.this_row[i - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (i < 1 || i > this.fields.length) {
            throw new KSQLException("kingbase.res.colrange");
        }
        return new Array(this.connection, i, this.fields[i - 1], this);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, -1);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    public abstract Blob getBlob(int var1) throws SQLException;

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public abstract Clob getClob(int var1) throws SQLException;

    public int getConcurrency() throws SQLException {
        if (this.statement == null) {
            return 1007;
        }
        return this.statement.getResultSetConcurrency();
    }

    public Date getDate(int i, Calendar cal) throws SQLException {
        if (cal != null) {
            Date d = this.getDate(i);
            cal.setTime(d);
            String str = cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5);
            return Date.valueOf(str);
        }
        return this.getDate(i);
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        if (cal != null) {
            Time t = this.getTime(i);
            cal.setTime(t);
            String str = cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
            return Time.valueOf(str);
        }
        return this.getTime(i);
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        if (cal != null) {
            Timestamp t = this.getTimestamp(i);
            cal.setTime(t);
            String str = cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5) + " " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
            return Timestamp.valueOf(str);
        }
        return this.getTimestamp(i);
    }

    public Date getDate(String c, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(c), cal);
    }

    public Time getTime(String c, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(c), cal);
    }

    public Timestamp getTimestamp(String c, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(c), cal);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.rows.size();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    public Ref getRef(int i) throws SQLException {
        throw new KSQLException("kingbase.psqlnotimp");
    }

    public int getRow() throws SQLException {
        if (this.statement.getCursorName() == null) {
            int rows_size = this.rows.size();
            if (this.current_row < 0 || this.current_row >= rows_size) {
                return 0;
            }
            return this.current_row + 1;
        }
        return this.beginPos;
    }

    public Statement getStatement() throws SQLException {
        return (Statement)((Object)this.statement);
    }

    public int getType() throws SQLException {
        return ((AbstractJdbc2Statement)this.statement).getResultSetType();
    }

    public boolean isAfterLast() throws SQLException {
        if (this.statement.getCursorName() != null) {
            if (((AbstractJdbc2Statement)this.statement).getResultSetType() == 1003) {
                int rows_size = 0;
                if (this.rows != null) {
                    rows_size = this.rows.size();
                }
                return this.current_row >= rows_size && rows_size >= 0;
            }
            return this.rows.size() == 0 && this.beginPos > 0;
        }
        int rows_size = this.rows.size();
        return this.current_row >= rows_size && rows_size > 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.statement.getCursorName() != null) {
            if (((AbstractJdbc2Statement)this.statement).getResultSetType() == 1003) {
                return this.current_row < 0 && this.rows.size() > 0;
            }
            if (this.beginPos == 0 && this.fetchRowForScroll("next")) {
                this.fetchRowForScroll("prior");
                return true;
            }
            return false;
        }
        return this.current_row < 0 && this.rows.size() > 0;
    }

    public boolean isFirst() throws SQLException {
        if (this.statement.getCursorName() != null) {
            if (((AbstractJdbc2Statement)this.statement).getResultSetType() == 1003) {
                return this.beginPos + this.current_row == 1 && this.rows.size() >= 0;
            }
            return this.beginPos == 1;
        }
        return this.current_row == 0 && this.rows.size() >= 0;
    }

    public boolean isLast() throws SQLException {
        if (this.statement.getCursorName() != null) {
            if (((AbstractJdbc2Statement)this.statement).getResultSetType() == 1003) {
                throw new KSQLException("kingbase.res.typeforwardonly");
            }
            if (this.beginPos > 0 & this.rows.size() > 0 & !this.fetchRowForScroll("next")) {
                this.fetchRowForScroll("prior");
                return true;
            }
            this.fetchRowForScroll("prior");
            return false;
        }
        int rows_size = this.rows.size();
        return this.current_row == rows_size - 1 && rows_size > 0;
    }

    public boolean next() throws SQLException {
        if (this.onInsertRow) {
            throw new KSQLException("kingbase.res.cursoronInsertRow");
        }
        if (this.rows == null) {
            throw new KSQLException("kingbase.res.closed");
        }
        if (this.statement == null || this.statement.getCursorName() == null) {
            if (++this.current_row >= this.rows.size()) {
                return false;
            }
            this.this_row = (byte[][])this.rows.elementAt(this.current_row);
            this.rowBuffer = null;
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
            return true;
        }
        if (this.exists(this.beginPos + this.current_row + 1)) {
            ++this.current_row;
            this.this_row = (byte[][])this.rows.elementAt(this.current_row);
            this.rowBuffer = null;
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
            return true;
        }
        if (this.fetchRows(this.beginPos)) {
            if (this.isServerSideScroll() && this.isAfterLast()) {
                return false;
            }
            this.current_row = 0;
            return this.getThisRow();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean last() throws SQLException {
        block4: {
            this.checkForPosition();
            curName = this.statement.getCursorName();
            if (!this.isServerSideScroll() || this.statement.getCursorName() == null) break block4;
            if (this.connection.getDatabaseVersion() < 40102) ** GOTO lbl15
            if (this.fetchRowForScroll("last")) {
                this.beginPos = this.rs.getFetchPosition();
                this.fetchRows(this.beginPos, 1001);
                this.fetchRows(this.beginPos);
                this.current_row = this.rows.size() - 1;
                return this.getThisRow();
            }
            return false;
lbl-1000:
            // 1 sources

            {
                ++this.beginPos;
lbl15:
                // 2 sources

                ** while (this.fetchRowForScroll((String)"next"))
            }
lbl16:
            // 1 sources

            this.fetchRowForScroll("prior");
            if (this.beginPos == 0) {
                return false;
            }
            this.current_row = 0;
            return this.getThisRow();
        }
        rows_size = this.rows.size();
        if (rows_size <= 0) {
            return false;
        }
        this.current_row = rows_size - 1;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = null;
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public boolean previous() throws SQLException {
        this.checkForPosition();
        if (this.exists(this.beginPos + this.current_row - 1)) {
            if (--this.current_row < 0) {
                if (this.current_row < -1) {
                    this.current_row = -1;
                }
                return false;
            }
            this.this_row = (byte[][])this.rows.elementAt(this.current_row);
            this.rowBuffer = null;
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
            return true;
        }
        if (this.rs.rows.size() == 1) {
            this.fetchRows(this.beginPos, 1001);
            this.fetchRows(this.beginPos);
            this.current_row = this.rows.size() - 2;
            return this.getThisRow();
        }
        this.fetchRows(this.beginPos, 1001);
        if (this.isServerSideScroll() && this.isBeforeFirst()) {
            return false;
        }
        this.fetchRows(this.beginPos, 1001);
        this.fetchRows(this.beginPos);
        this.current_row = this.rows.size() - 1;
        return this.getThisRow();
    }

    public boolean relative(int index) throws SQLException {
        if (index == 0) {
            return !this.isBeforeFirst() && !this.isAfterLast();
        }
        if (this.isServerSideScroll()) {
            this.checkForPosition();
            int absoluteRow = this.beginPos == 0 ? this.current_row + index : this.current_row + index + this.beginPos - this.fetchSize;
            if (absoluteRow < this.beginPos && absoluteRow >= this.beginPos - this.fetchSize) {
                this.current_row = this.rs.rows.size() == this.fetchSize ? absoluteRow - (this.beginPos - this.fetchSize) : absoluteRow - (this.beginPos - this.rs.rows.size());
                return this.getThisRow();
            }
            int interval = (absoluteRow - this.beginPos) / this.fetchSize * this.fetchSize;
            if (interval > 0) {
                this.beginPos += interval;
            } else if (interval < 0) {
                this.beginPos += interval - this.fetchSize;
                if (this.beginPos < 0) {
                    this.beginPos = 0;
                }
            }
            this.fetchRowForScroll("absolute", this.beginPos);
            this.fetchRows(this.beginPos);
            this.current_row = this.rs.rows.size() == this.fetchSize ? absoluteRow - (this.beginPos - this.fetchSize) : absoluteRow - (this.beginPos - this.rs.rows.size());
            return this.getThisRow();
        }
        return this.absolute(this.current_row + 1 + index);
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (((AbstractJdbc2Statement)this.statement).getResultSetType() == 1003 && direction != 1000) {
            throw new KSQLException("kingbase.res.typeforwardonly");
        }
        if (direction == 1000 || direction == 1001) {
            this.fetchDirect = direction;
        } else if (direction != 1002) {
            throw new KSQLException("kingbase.stat.Illegalconstant");
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows > 0) {
            this.fetchSize = rows;
        } else if (rows < 0) {
            throw new KSQLException("kingbase.stat.illegalpara");
        }
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer();
        }
    }

    public synchronized void deleteRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new KSQLException("kingbase.updateable.notupdateable");
        }
        if (this.onInsertRow) {
            throw new KSQLException("kingbase.updateable.oninsertrow");
        }
        if (this.rows.size() == 0) {
            throw new KSQLException("kingbase.updateable.emptydelete");
        }
        if (this.isBeforeFirst()) {
            throw new KSQLException("kingbase.updateable.beforestartdelete");
        }
        if (this.isAfterLast()) {
            throw new KSQLException("kingbase.updateable.afterlastdelete");
        }
        int numKeys = this.primaryKeys.size();
        if (this.deleteStatement == null) {
            StringBuffer deleteSQL = new StringBuffer("DELETE FROM ").append(this.tableName).append(" where ");
            int i = 0;
            while (i < numKeys) {
                deleteSQL.append(((PrimaryKey)this.primaryKeys.get((int)i)).name).append(" = ? ");
                if (i < numKeys - 1) {
                    deleteSQL.append(" and ");
                }
                ++i;
            }
            this.deleteStatement = ((Connection)((Object)this.connection)).prepareStatement(deleteSQL.toString());
        }
        this.deleteStatement.clearParameters();
        int i = 0;
        while (i < numKeys) {
            this.deleteStatement.setObject(i + 1, ((PrimaryKey)this.primaryKeys.get(i)).getValue());
            ++i;
        }
        this.deleteStatement.executeUpdate();
        this.deleteStatement.close();
        this.deleteStatement = null;
        this.rows.removeElementAt(this.current_row);
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new KSQLException("kingbase.updateable.notupdateable");
        }
        if (!this.onInsertRow) {
            throw new KSQLException("kingbase.updateable.notoninsertrow");
        }
        StringBuffer insertSQL = new StringBuffer("INSERT INTO ").append(this.tableName).append(" (");
        StringBuffer paramSQL = new StringBuffer(") values (");
        Enumeration columnNames = this.updateValues.keys();
        int numColumns = this.updateValues.size();
        int i = 0;
        while (columnNames.hasMoreElements()) {
            Field fd = (Field)columnNames.nextElement();
            String columnName = fd.getRealColName();
            insertSQL.append("\"");
            insertSQL.append(columnName);
            insertSQL.append("\"");
            if (i < numColumns - 1) {
                insertSQL.append(", ");
                paramSQL.append("?,");
            } else {
                paramSQL.append("?)");
            }
            ++i;
        }
        insertSQL.append(paramSQL.toString());
        this.insertStatement = ((Connection)((Object)this.connection)).prepareStatement(insertSQL.toString());
        Enumeration keys = this.updateValues.keys();
        int i2 = 1;
        while (keys.hasMoreElements()) {
            Field key = (Field)keys.nextElement();
            Object o = this.updateValues.get(key);
            if (o instanceof NullObject) {
                this.insertStatement.setNull(i2, ((NullObject)o).type);
            } else {
                this.insertStatement.setObject(i2, o, key.getSQLType());
                if (key.getSQLType() == 2004 || key.getSQLType() == 2005) {
                    this.updateValues.put(key, new Integer(((BaseStatement)((Object)this.insertStatement)).getUpdatedOrInsertedLargeObjOID()).toString());
                }
            }
            ++i2;
        }
        this.insertStatement.executeUpdate();
        if (this.usingOID) {
            long insertedOID = ((AbstractJdbc2Statement)((Object)this.insertStatement)).getLastOID();
            this.updateValues.put("oid", new Long(insertedOID));
        }
        this.updateRowBuffer();
        this.rows.addElement(this.rowBuffer);
        this.this_row = this.rowBuffer;
        this.onInsertRow = false;
        this.clearRowBuffer();
        this.insertStatement.close();
        this.insertStatement = null;
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        if (!this.updateable) {
            throw new KSQLException("kingbase.updateable.notupdateable");
        }
        if (this.current_row < 0) {
            this.this_row = null;
            this.rowBuffer = null;
        } else {
            this.this_row = (byte[][])this.rows.elementAt(this.current_row);
            this.rowBuffer = null;
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new KSQLException("kingbase.updateable.notupdateable");
        }
        if (this.insertStatement != null) {
            this.insertStatement = null;
        }
        this.clearRowBuffer();
        this.onInsertRow = true;
        this.doingUpdates = false;
    }

    private synchronized void clearRowBuffer() throws SQLException {
        this.rowBuffer = null;
        this.rowBuffer = new byte[this.fields.length][];
        this.updateValues.clear();
    }

    public boolean rowDeleted() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowUpdated() throws SQLException {
        throw Driver.notImplemented();
    }

    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        byte[] theData = null;
        try {
            x.read(theData, 0, length);
        }
        catch (NullPointerException ex) {
            throw new KSQLException("kingbase.updateable.inputstream");
        }
        catch (IOException ie) {
            throw new KSQLException("kingbase.updateable.ioerror");
        }
        this.updateValue(columnIndex, theData);
    }

    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        byte[] theData = null;
        try {
            x.read(theData, 0, length);
        }
        catch (NullPointerException ex) {
            throw new KSQLException("kingbase.updateable.inputstream");
        }
        catch (IOException ie) {
            throw new KSQLException("kingbase.updateable.ioerror");
        }
        this.updateValue(columnIndex, theData);
    }

    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("updating boolean " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Boolean(x));
    }

    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateValue(columnIndex, new Byte(x));
    }

    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        char[] theData = null;
        try {
            x.read(theData, 0, length);
        }
        catch (NullPointerException ex) {
            throw new KSQLException("kingbase.updateable.inputstream");
        }
        catch (IOException ie) {
            throw new KSQLException("kingbase.updateable.ioerror");
        }
        this.updateValue(columnIndex, theData);
    }

    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("updating double " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Double(x));
    }

    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("updating float " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Float(x));
    }

    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("updating int " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Integer(x));
    }

    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("updating long " + this.fields[columnIndex - 1].getName() + "=" + x);
        }
        this.updateValue(columnIndex, new Long(x));
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.updateValue(columnIndex, new NullObject(this.fields[columnIndex - 1].getSQLType()));
    }

    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("updating object " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (!this.isUpdateable()) {
            throw new KSQLException("kingbase.updateable.notupdateable");
        }
        this.updateObject(columnIndex, x);
    }

    public void refreshRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new KSQLException("kingbase.updateable.notupdateable");
        }
        try {
            StringBuffer selectSQL = new StringBuffer("select ");
            int numColumns = java.lang.reflect.Array.getLength(this.fields);
            int i = 0;
            while (i < numColumns) {
                selectSQL.append(this.fields[i].getRealColName());
                if (i < numColumns - 1) {
                    selectSQL.append(", ");
                }
                ++i;
            }
            selectSQL.append(" from ").append(this.tableName).append(" where ");
            int numKeys = this.primaryKeys.size();
            int i2 = 0;
            while (i2 < numKeys) {
                PrimaryKey primaryKey = (PrimaryKey)this.primaryKeys.get(i2);
                selectSQL.append(primaryKey.name).append("= ?");
                if (i2 < numKeys - 1) {
                    selectSQL.append(" and ");
                }
                ++i2;
            }
            if (Driver.isDebug) {
                Driver.debug("selecting " + selectSQL.toString());
            }
            this.selectStatement = ((Connection)((Object)this.connection)).prepareStatement(selectSQL.toString());
            int j = 0;
            int i3 = 1;
            while (j < numKeys) {
                this.selectStatement.setObject(i3, ((PrimaryKey)this.primaryKeys.get(j)).getValue());
                ++j;
                ++i3;
            }
            AbstractJdbc2ResultSet rs = (AbstractJdbc2ResultSet)((Object)this.selectStatement.executeQuery());
            if (rs.next()) {
                this.rowBuffer = rs.rowBuffer;
            }
            System.arraycopy(rs.this_row, 0, this.this_row, 0, this.this_row.length);
            this.rows.setElementAt(this.this_row, this.current_row);
            if (Driver.isDebug) {
                Driver.debug("done updates");
            }
            rs.close();
            this.selectStatement.close();
            this.selectStatement = null;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            if (Driver.isDebug) {
                Driver.debug(e.getClass().getName() + e);
            }
            throw new KSQLException(e.getMessage());
        }
    }

    public synchronized void updateRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new KSQLException("kingbase.updateable.notupdateable");
        }
        if (this.doingUpdates) {
            try {
                try {
                    StringBuffer updateSQL = new StringBuffer("UPDATE " + this.tableName + " SET  ");
                    int numColumns = this.updateValues.size();
                    Enumeration columns = this.updateValues.keys();
                    ArrayList<Field> arrCols = new ArrayList<Field>();
                    int i = 0;
                    while (columns.hasMoreElements()) {
                        Field column = (Field)columns.nextElement();
                        arrCols.add(column);
                        updateSQL.append("\"");
                        updateSQL.append(column.getRealColName());
                        updateSQL.append("\" = ?");
                        if (i < numColumns - 1) {
                            updateSQL.append(", ");
                        }
                        ++i;
                    }
                    updateSQL.append(" WHERE ");
                    int numKeys = this.primaryKeys.size();
                    int i2 = 0;
                    while (i2 < numKeys) {
                        PrimaryKey primaryKey = (PrimaryKey)this.primaryKeys.get(i2);
                        updateSQL.append("\"");
                        updateSQL.append(primaryKey.name);
                        updateSQL.append("\" = ?");
                        if (i2 < numKeys - 1) {
                            updateSQL.append(" and ");
                        }
                        ++i2;
                    }
                    if (Driver.isDebug) {
                        Driver.debug("updating " + updateSQL.toString());
                    }
                    this.updateStatement = ((Connection)((Object)this.connection)).prepareStatement(updateSQL.toString());
                    int i3 = 0;
                    Iterator iterator = this.updateValues.values().iterator();
                    while (iterator.hasNext()) {
                        Object o = iterator.next();
                        if (o instanceof NullObject) {
                            this.updateStatement.setNull(i3 + 1, ((NullObject)o).type);
                        } else {
                            this.updateStatement.setObject(i3 + 1, o, ((Field)arrCols.get(i3)).getSQLType());
                            if (((Field)arrCols.get(i3)).getSQLType() == 2004 || ((Field)arrCols.get(i3)).getSQLType() == 2005) {
                                this.updateValues.put(arrCols.get(i3), new Integer(((BaseStatement)((Object)this.updateStatement)).getUpdatedOrInsertedLargeObjOID()).toString());
                            }
                        }
                        ++i3;
                    }
                    int j = 0;
                    while (j < numKeys) {
                        this.updateStatement.setObject(i3 + 1, ((PrimaryKey)this.primaryKeys.get(j)).getValue());
                        ++j;
                        ++i3;
                    }
                    this.updateStatement.executeUpdate();
                    this.updateStatement.close();
                    this.updateStatement = null;
                    this.updateRowBuffer();
                    if (Driver.isDebug) {
                        Driver.debug("copying data");
                    }
                    System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
                    this.rows.setElementAt(this.rowBuffer, this.current_row);
                    if (Driver.isDebug) {
                        Driver.debug("done updates");
                    }
                    this.updateValues.clear();
                    this.doingUpdates = false;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (Driver.isDebug) {
                        Driver.debug(e.getClass().getName() + e);
                    }
                    throw new SQLException(e.getMessage());
                }
                Object var12_16 = null;
                this.updateValues.clear();
                this.doingUpdates = false;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                this.updateValues.clear();
                this.doingUpdates = false;
                throw throwable;
            }
        }
    }

    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("in update Short " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, new Short(x));
    }

    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("in update String " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("in update Time " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("updating Timestamp " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    boolean isUpdateable() throws SQLException {
        if (this.statement.getResultSetConcurrency() != 1008) {
            throw new KSQLException("kingbase.updateable.notupdateable");
        }
        if (this.updateable) {
            return true;
        }
        if (Driver.isDebug) {
            Driver.debug("checking if rs is updateable");
        }
        this.parseQuery();
        if (!this.singleTable) {
            if (Driver.isDebug) {
                Driver.debug("not a single table");
            }
            return false;
        }
        if (Driver.isDebug) {
            Driver.debug("getting primary keys");
        }
        this.primaryKeys = new Vector();
        this.usingOID = false;
        int oidIndex = 0;
        try {
            oidIndex = this.findColumn("OID");
        }
        catch (SQLException l_se) {
            // empty catch block
        }
        int i = 0;
        if (oidIndex > 0) {
            ++i;
            this.primaryKeys.add(new PrimaryKey(oidIndex, "OID"));
            this.usingOID = true;
        } else {
            String[] s = AbstractJdbc2ResultSet.quotelessTableName(this.tableName);
            String quotelessTableName = s[0];
            String quotelessSchemaName = s[1];
            ResultSet rs = ((Connection)((Object)this.connection)).getMetaData().getPrimaryKeys("", quotelessSchemaName, quotelessTableName);
            while (rs.next()) {
                String columnName = rs.getString(4);
                int index = this.findColumn(columnName);
                if (index > 0) {
                    this.primaryKeys.add(new PrimaryKey(index, columnName));
                }
                ++i;
            }
            rs.close();
        }
        this.numKeys = this.primaryKeys.size();
        if (Driver.isDebug) {
            Driver.debug("no of keys=" + i);
        }
        if (i < 1) {
            throw new KSQLException("kingbase.res.noprimarykeys");
        }
        boolean bl = this.updateable = this.primaryKeys.size() > 0;
        if (Driver.isDebug) {
            Driver.debug("checking primary key " + this.updateable);
        }
        return this.updateable;
    }

    private static String[] quotelessTableName(String fullname) {
        StringBuffer buf = new StringBuffer(fullname);
        String[] parts = new String[]{null, ""};
        StringBuffer acc = new StringBuffer();
        boolean betweenQuotes = false;
        int i = 0;
        while (i < buf.length()) {
            char c = buf.charAt(i);
            switch (c) {
                case '\"': {
                    if (i < buf.length() - 1 && buf.charAt(i + 1) == '\"') {
                        ++i;
                        acc.append(c);
                        break;
                    }
                    betweenQuotes = !betweenQuotes;
                    break;
                }
                case '.': {
                    if (betweenQuotes) {
                        acc.append(c);
                        break;
                    }
                    parts[1] = acc.toString();
                    acc = new StringBuffer();
                    break;
                }
                default: {
                    acc.append(betweenQuotes ? c : Character.toUpperCase(c));
                }
            }
            ++i;
        }
        parts[0] = acc.toString();
        return parts;
    }

    private void dealColumnAliasMap(String sql) {
        if (this.fields != null && this.fields.length > 0 && sql != null && sql.length() > 0) {
            int i = 0;
            while (i < this.fields.length) {
                this.fields[i].setRealColName(this.fields[i].getName());
                ++i;
            }
        } else {
            return;
        }
        KBStringTokenizer st = new KBStringTokenizer(sql, " \r\t\n,.");
        String previousToken = null;
        block1: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("as")) {
                token = st.nextToken();
                int i = 0;
                while (i < this.fields.length) {
                    String alias = this.fields[i].getName();
                    String alias1 = "\"" + alias + "\"";
                    if (alias.equals(token) || alias1.equals(token)) {
                        this.fields[i].setRealColName(previousToken);
                        continue block1;
                    }
                    ++i;
                }
                continue;
            }
            if (token.startsWith("\"")) {
                token = token.substring(1, token.length());
            }
            if (token.endsWith("\"")) {
                token = token.substring(0, token.length() - 1);
            }
            previousToken = token;
        }
    }

    private void parseQuery() {
        String[] l_sqlFragments = ((AbstractJdbc2Statement)this.statement).getSqlFragments();
        String l_sql = l_sqlFragments[0];
        this.dealColumnAliasMap(l_sql);
        KBStringTokenizer st = new KBStringTokenizer(l_sql, " \r\t\n");
        boolean tableFound = false;
        boolean tablesChecked = false;
        String name = "";
        this.singleTable = true;
        while (!tableFound && !tablesChecked && st.hasMoreTokens()) {
            name = st.nextToken();
            if (!tableFound) {
                if (!name.toLowerCase().equals("from")) continue;
                String tmpTbNm = st.nextToken();
                if (tmpTbNm.startsWith("\"")) {
                    int tmpPos = l_sql.indexOf(name) + name.length();
                    String tmpSql = l_sql.substring(tmpPos + 1, l_sql.length());
                    tmpPos = tmpSql.indexOf(tmpTbNm);
                    tmpSql = tmpSql.substring(tmpPos + 1, tmpSql.length());
                    boolean inQuote = true;
                    StringBuffer tableNameBuf = new StringBuffer();
                    tableNameBuf.append('\"');
                    int i = 0;
                    while (i < tmpSql.length()) {
                        char ch = tmpSql.charAt(i);
                        if (ch == '\"' && i + 1 < tmpSql.length() && tmpSql.charAt(i + 1) == '\"') {
                            tableNameBuf.append(ch);
                            tableNameBuf.append(ch);
                            ++i;
                        } else {
                            if (ch == '\"' && i + 1 < tmpSql.length() && tmpSql.charAt(i + 1) != '\"') {
                                inQuote = !inQuote;
                            }
                            tableNameBuf.append(ch);
                            if (!inQuote) {
                                ++i;
                                while (i < tmpSql.length() && (ch = tmpSql.charAt(i)) == ' ') {
                                    ++i;
                                }
                                if (ch != '.') break;
                                tableNameBuf.append(ch);
                                ++i;
                                while (i < tmpSql.length() && (ch = tmpSql.charAt(i)) == ' ') {
                                    ++i;
                                }
                                if (ch == ' ') break;
                                if (ch == '\"') {
                                    tableNameBuf.append(ch);
                                    inQuote = true;
                                }
                            }
                        }
                        ++i;
                    }
                    this.tableName = tableNameBuf.toString();
                } else {
                    this.tableName = tmpTbNm;
                }
                if (this.tableName.endsWith(";")) {
                    this.tableName = this.tableName.substring(0, this.tableName.length() - 1);
                }
                tableFound = true;
                continue;
            }
            tablesChecked = true;
            boolean bl = this.singleTable = !name.equalsIgnoreCase(",");
        }
    }

    private void updateRowBuffer() throws SQLException {
        Enumeration columns = this.updateValues.keys();
        while (columns.hasMoreElements()) {
            Object key = columns.nextElement();
            String columnName = null;
            if (key instanceof Field) {
                Field fd = (Field)key;
                columnName = fd.getName();
            } else if (key instanceof String) {
                columnName = key.toString();
            }
            int columnIndex = this.findColumn(columnName) - 1;
            Object valueObject = this.updateValues.get(key);
            if (valueObject instanceof NullObject) {
                this.rowBuffer[columnIndex] = null;
                continue;
            }
            if (columnName.equals("oid")) {
                this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(valueObject));
                continue;
            }
            switch (this.connection.getSQLType(this.fields[columnIndex].getPGType())) {
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 16: 
                case 91: 
                case 92: 
                case 93: 
                case 2004: 
                case 2005: {
                    this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(valueObject));
                }
                case 0: {
                    break;
                }
                case 1111: {
                    this.rowBuffer[columnIndex] = this.connection.getEncoding().encode(String.valueOf(valueObject));
                    break;
                }
                default: {
                    this.rowBuffer[columnIndex] = (byte[])valueObject;
                }
            }
        }
    }

    public void setStatement(BaseStatement statement) {
        this.statement = statement;
    }

    protected void updateValue(int columnIndex, Object value) throws SQLException {
        if (!this.isUpdateable()) {
            throw new KSQLException("kingbase.updateable.notupdateable");
        }
        if (this.fields.length <= columnIndex) {
            throw new KSQLException("kingbase.res.colrange");
        }
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (value == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateValues.put(this.fields[columnIndex - 1], value);
            if (value instanceof Blob || value instanceof Clob) {
                this.connection.produceLargeObject(value);
            }
        }
    }

    private void checkForPosition() throws SQLException {
        if (this.onInsertRow) {
            throw new KSQLException("kingbase.res.cursoronInsertRow");
        }
        if (this.rows == null) {
            throw new KSQLException("kingbase.res.closed");
        }
        if (((AbstractJdbc2Statement)this.statement).getResultSetType() == 1003) {
            throw new KSQLException("kingbase.res.typeforwardonly");
        }
        this.clearWarnings();
    }

    protected boolean exists(int index) {
        return index >= this.beginPos && index < this.beginPos + this.rows.size();
    }

    protected boolean fetchRows(int index) throws SQLException {
        return this.fetchRows(index, 1000);
    }

    protected boolean fetchRows(int index, int direc) throws SQLException {
        if (this.statement == null) {
            throw new KSQLException("kingbase.res.needstmt");
        }
        if (((AbstractJdbc1Statement)this.statement).getCursorName() == null) {
            return false;
        }
        if (direc != 1001) {
            this.rs = (AbstractJdbc2ResultSet)((AbstractJdbc1Connection)this.connection).execSQL("fetch forward " + this.fetchSize + " in " + ((AbstractJdbc1Statement)this.statement).getCursorName());
            this.beginPos = index + this.rs.rows.size();
        } else {
            this.rs = (AbstractJdbc2ResultSet)((AbstractJdbc1Connection)this.connection).execSQL("fetch backward " + this.fetchSize + " in " + ((AbstractJdbc1Statement)this.statement).getCursorName());
            this.beginPos = index - this.fetchSize;
            if (this.beginPos < 0) {
                this.beginPos = 0;
            }
        }
        this.rows = this.rs.rows;
        return this.rows.size() != 0;
    }

    protected boolean fetchRowForScroll(String option) throws SQLException {
        if (this.statement == null) {
            throw new KSQLException("kingbase.res.needstmt");
        }
        if (((AbstractJdbc1Statement)this.statement).getCursorName() == null) {
            return false;
        }
        this.rs = (AbstractJdbc2ResultSet)((AbstractJdbc1Connection)this.connection).execSQL("fetch " + option + " in " + ((AbstractJdbc1Statement)this.statement).getCursorName());
        this.rows = this.rs.rows;
        return this.rows.size() != 0;
    }

    protected boolean fetchRowForScroll(String option, int count) throws SQLException {
        if (this.statement == null) {
            throw new KSQLException("kingbase.res.needstmt");
        }
        if (((AbstractJdbc1Statement)this.statement).getCursorName() == null) {
            return false;
        }
        this.rs = (AbstractJdbc2ResultSet)((AbstractJdbc1Connection)this.connection).execSQL("fetch " + option + " " + count + " in " + ((AbstractJdbc1Statement)this.statement).getCursorName());
        this.rows = this.rs.rows;
        return this.rows.size() != 0;
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.fields[columnIndex - 1].getSQLType() == 2004 || this.fields[columnIndex - 1].getSQLType() == 2005) {
            Blob bl = this.getBlob(columnIndex);
            return bl.getBinaryStream();
        }
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        byte[] b = this.getBytes(columnIndex);
        if (b != null) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.fields[columnIndex - 1].getSQLType() == 2004 || this.fields[columnIndex - 1].getSQLType() == 2005) {
            Blob bl = this.getBlob(columnIndex);
            return bl.getBinaryStream();
        }
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new KSQLException("kingbase.unusual");
        }
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.fields[columnIndex - 1].getSQLType() == 2004 || this.fields[columnIndex - 1].getSQLType() == 2005) {
            Blob bl = this.getBlob(columnIndex);
            return bl.getBinaryStream();
        }
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new KSQLException("kingbase.unusual");
        }
    }

    public Reader getCharacterStream(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.fields[i - 1].getSQLType() == 2004 || this.fields[i - 1].getSQLType() == 2005) {
            Blob bl = this.getBlob(i);
            return new InputStreamReader(bl.getBinaryStream());
        }
        boolean bl = this.wasNullFlag = this.this_row[i - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return new CharArrayReader(this.getString(i).toCharArray());
    }

    boolean isServerSideScroll() throws SQLException {
        boolean isClientSide = this.statement.getKBConnection().getIsClientCursor();
        return !isClientSide && ((AbstractJdbc2Statement)this.statement).getResultSetType() != 1003;
    }

    protected boolean getThisRow() throws SQLException {
        if (this.isServerSideScroll()) {
            if (this.rs == null) {
                return false;
            }
            if (this.rs.rows.size() == 0) {
                this.this_row = null;
                return false;
            }
        }
        if (this.current_row >= this.rows.size()) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = null;
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    protected boolean moveRowForScroll(String option) throws SQLException {
        if (this.statement == null) {
            throw new KSQLException("kingbase.res.needstmt");
        }
        if (((AbstractJdbc1Statement)this.statement).getCursorName() == null) {
            return false;
        }
        ((AbstractJdbc1Connection)this.connection).execSQL("move " + option + " in " + ((AbstractJdbc1Statement)this.statement).getCursorName());
        return true;
    }

    class NullObject {
        int type;

        public NullObject(int typ) {
            this.type = typ;
        }
    }

    private class PrimaryKey {
        int index;
        String name;

        PrimaryKey(int index, String name) {
            this.index = index;
            this.name = name;
        }

        Object getValue() throws SQLException {
            AbstractJdbc2ResultSet.this.checkResultSet(this.index);
            return AbstractJdbc2ResultSet.this.getObject(this.index);
        }
    }
}

