/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc3;

import com.kingbase.Driver;
import com.kingbase.core.BaseStatement;
import com.kingbase.core.Field;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.jdbc1.AbstractJdbc1Statement;
import com.kingbase.jdbc2.AbstractJdbc2ResultSet;
import com.kingbase.jdbc3.AbstractJdbc3Statement;
import com.kingbase.jdbc3.Jdbc3Blob;
import com.kingbase.jdbc3.Jdbc3Clob;
import com.kingbase.jdbc3.Jdbc3Statement;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Vector;

public abstract class AbstractJdbc3ResultSet
extends AbstractJdbc2ResultSet {
    protected ArrayList largeObjectList = null;
    protected BitSet largeObjectBit = null;

    public AbstractJdbc3ResultSet(BaseStatement statement, Field[] fields, Vector tuples, String status, int updateCount, long insertOID, boolean binaryCursor) {
        super(statement, fields, tuples, status, updateCount, insertOID, binaryCursor);
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw Driver.notImplemented();
    }

    public URL getURL(String columnName) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("in update String " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        if (((AbstractJdbc1Connection)this.connection).getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        if (Driver.isDebug) {
            Driver.debug("in update String " + this.fields[columnIndex - 1].getName() + " = " + x);
        }
        this.updateValue(columnIndex, x);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        if (((AbstractJdbc1Connection)this.connection).getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        this.updateClob(this.findColumn(columnName), x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw Driver.notImplemented();
    }

    public Object getObject(int columnIndex) throws SQLException {
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: 
            case 16: {
                return this.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
            }
            case -6: {
                return new Byte(this.getByte(columnIndex));
            }
            case 5: {
                return new Short(this.getShort(columnIndex));
            }
            case 4: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: {
                return this.getBigDecimal(columnIndex, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
        }
        String type = field.getPGType();
        if (type != null && type.trim().startsWith("INTERVAL")) {
            return this.getString(columnIndex);
        }
        if (type.equalsIgnoreCase("unknown")) {
            return this.getString(columnIndex);
        }
        return this.connection.getObject(field.getPGType(), this.getString(columnIndex));
    }

    protected Object getLargeObjectFromList(int columnIndex, int largeObjectType) throws SQLException {
        if (this.largeObjectBit == null || this.largeObjectList == null || this.largeObjectList.size() == 0) {
            int columnNum = this.getMetaData().getColumnCount();
            this.largeObjectBit = new BitSet(columnNum + 1);
            this.largeObjectList = new ArrayList(columnNum + 1);
            int i = 0;
            while (i <= columnNum) {
                this.largeObjectList.add(null);
                ++i;
            }
        }
        if (this.largeObjectBit.get(columnIndex)) {
            return this.largeObjectList.get(columnIndex);
        }
        Object obj = null;
        if (largeObjectType == 2004) {
            obj = new Jdbc3Blob(this.connection, this.getInt(columnIndex));
            this.connection.produceLargeObject((Blob)obj);
        } else {
            obj = new Jdbc3Clob(this.connection, this.getInt(columnIndex));
            this.connection.produceLargeObject((Clob)obj);
        }
        this.largeObjectList.add(columnIndex, obj);
        this.largeObjectBit.set(columnIndex);
        return obj;
    }

    protected void closeBlobAndClob() {
        try {
            if (this.largeObjectList != null && this.largeObjectList.size() > 0) {
                this.largeObjectList.clear();
                this.largeObjectBit.clear();
                this.largeObjectList = null;
                this.largeObjectBit = null;
            }
        }
        catch (Exception e) {}
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return super.getAsciiStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return super.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return super.getUnicodeStream(columnIndex);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return super.getCharacterStream(columnIndex);
    }

    protected void releaseSource() {
        this.closeBlobAndClob();
    }

    public boolean next() throws SQLException {
        this.releaseSource();
        return super.next();
    }

    public void close() throws SQLException {
        if (((AbstractJdbc1Connection)this.connection).getDatabaseVersion() >= 40100) {
            this.closeSV4();
        } else {
            this.closeSV3();
        }
    }

    private void closeSV4() throws SQLException {
        this.releaseSource();
        super.close();
    }

    private void closeSV3() throws SQLException {
        if (this.rows != null) {
            this.rows = null;
            this.this_row = null;
            if (this.statement != null) {
                ((AbstractJdbc1Statement)this.statement).result = null;
                if (((AbstractJdbc3Statement)this.statement).isDelare) {
                    ((AbstractJdbc1Connection)this.connection).execSQL("close " + ((Jdbc3Statement)this.statement).getCursorName());
                    ((AbstractJdbc3Statement)this.statement).isDelare = false;
                }
            }
        }
    }

    public synchronized void updateRow() throws SQLException {
        super.updateRow();
        this.releaseSource();
    }

    public synchronized void insertRow() throws SQLException {
        this.releaseSource();
        super.insertRow();
    }

    public boolean first() throws SQLException {
        this.releaseSource();
        return super.first();
    }

    public void beforeFirst() throws SQLException {
        this.releaseSource();
        super.beforeFirst();
    }

    public boolean previous() throws SQLException {
        this.releaseSource();
        return super.previous();
    }

    public boolean last() throws SQLException {
        this.releaseSource();
        return super.last();
    }

    public void afterLast() throws SQLException {
        this.releaseSource();
        super.afterLast();
    }

    public boolean relative(int rows) throws SQLException {
        this.releaseSource();
        return super.relative(rows);
    }

    public boolean absolute(int index) throws SQLException {
        this.releaseSource();
        return super.absolute(index);
    }

    public void setFetchPosition(int beginPos) {
        this.fetchPosition = beginPos;
    }

    public int getFetchPosition() {
        return this.fetchPosition;
    }
}

