/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.largeobject;

import com.kingbase.largeobject.CharLargeObject;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class ClobOutputStream
extends OutputStream {
    private CharLargeObject lo;
    private byte[] buffer;
    private int bsize;
    private int bpos;

    public ClobOutputStream(CharLargeObject lo) {
        this(lo, 1024);
    }

    public ClobOutputStream(CharLargeObject lo, int bsize) {
        this.lo = lo;
        this.bsize = bsize;
        this.buffer = new byte[bsize];
        this.bpos = 0;
    }

    public void write(int b) throws IOException {
        try {
            if (this.bpos >= this.bsize) {
                if (this.lo == null || this.lo.closed) {
                    throw new IOException("The OutputStream has been closed");
                }
                this.lo.write(this.buffer);
                this.bpos = 0;
            }
            this.buffer[this.bpos++] = (byte)b;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        try {
            if (this.bpos > 0) {
                this.flush();
            }
            if (buf == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len + off > buf.length || len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.lo == null || this.lo.closed) {
                throw new IOException("The OutputStream has been closed");
            }
            if (off == 0 && len == buf.length) {
                this.lo.write(buf);
            } else {
                this.lo.write(buf, off, len);
            }
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void flush() throws IOException {
        try {
            if (this.bpos > 0) {
                if (this.lo == null || this.lo.closed) {
                    throw new IOException("The OutputStream has been closed");
                }
                this.lo.write(this.buffer, 0, this.bpos);
            }
            this.bpos = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
            this.lo.close();
            this.lo = null;
            this.buffer = null;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }
}

