/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.largeobject;

import com.kingbase.largeobject.CharLargeObject;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class ClobReader
extends Reader {
    private CharLargeObject lo;
    private String cbuffer;
    private int cpos;
    private int bsize;
    private int mpos = 0;
    private String encoding;

    public ClobReader(CharLargeObject lo, String encoding) {
        this(lo, 4096, encoding);
    }

    public ClobReader(CharLargeObject lo, int bsize, String encoding) {
        this.lo = lo;
        this.cbuffer = null;
        this.cpos = 0;
        this.bsize = bsize;
        this.encoding = encoding;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            if (cbuf == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len + off > cbuf.length || len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int i = 0;
            while (i < len) {
                char ch;
                if (this.cbuffer == null || this.cpos >= this.cbuffer.length()) {
                    if (this.lo == null || this.lo.closed) {
                        throw new IOException("The Reader has been closed");
                    }
                    this.cbuffer = new String(this.lo.read(this.bsize), this.encoding);
                    this.cpos = 0;
                }
                if (this.cbuffer == null || this.cbuffer.length() == 0) {
                    if (i == 0) {
                        return -1;
                    }
                    return i;
                }
                cbuf[off + i] = ch = this.cbuffer.charAt(this.cpos);
                ++this.cpos;
                ++i;
            }
            return len;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void close() throws IOException {
        try {
            this.lo.close();
            this.lo = null;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public synchronized void mark(int readlimit) {
        try {
            if (this.lo == null || this.lo.closed) {
                return;
            }
            this.mpos = this.lo.tell();
        }
        catch (SQLException se) {}
    }

    public synchronized void reset() throws IOException {
        try {
            if (this.lo == null || this.lo.closed) {
                throw new IOException("The Reader has been closed");
            }
            this.lo.seek(this.mpos);
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public boolean markSupported() {
        return true;
    }
}

