/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.largeobject;

import com.kingbase.fastpath.Fastpath;
import com.kingbase.fastpath.FastpathArg;
import com.kingbase.largeobject.AbstractLargeObject;
import com.kingbase.largeobject.BlobInputStream;
import com.kingbase.largeobject.BlobOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

public class LargeObject
extends AbstractLargeObject {
    private BlobOutputStream os;

    protected LargeObject(Fastpath fp, int oid, int mode) throws SQLException {
        super(fp, oid, mode);
    }

    protected void finalize() throws SQLException, Throwable {
        super.finalize();
    }

    public void close() throws SQLException {
        if (!this.closed && this.fd != -1) {
            if (this.os != null) {
                try {
                    try {
                        this.os.flush();
                    }
                    catch (IOException ioe) {
                        throw new SQLException(ioe.getMessage());
                    }
                    Object var3_1 = null;
                    this.os = null;
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    this.os = null;
                    throw throwable;
                }
            }
            FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd)};
            this.fp.fastpath("LO_CLOSE", false, args);
            this.closed = true;
            this.fd = -1;
        }
    }

    public byte[] read(int len) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(len)};
        return this.fp.getData("LOREAD", args);
    }

    public int read(byte[] buf, int off, int len) throws SQLException {
        byte[] b = this.read(len);
        if (b.length < len) {
            len = b.length;
        }
        System.arraycopy(b, 0, buf, off, len);
        return len;
    }

    public Object write(byte[] buf) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(buf)};
        return this.fp.fastpath("LOWRITE", true, args);
    }

    public Object write(byte[] buf, int off, int len) throws SQLException {
        if (buf == null || buf.length == 0 || buf.length <= off) {
            return "0".getBytes();
        }
        if (len > buf.length - off) {
            len = buf.length - off;
        }
        byte[] data = new byte[len];
        System.arraycopy(buf, off, data, 0, len);
        int sumLength = len;
        while (sumLength > 0) {
            Integer length = (Integer)this.write(data);
            sumLength -= length.intValue();
        }
        return Integer.toString(len).getBytes();
    }

    public void seek(int pos, int ref) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(pos), new FastpathArg(ref)};
        this.fp.fastpath("LO_LSEEK", false, args);
    }

    public void seek(int pos) throws SQLException {
        this.seek(pos, 0);
    }

    public int size() throws SQLException {
        int cp = this.tell();
        this.seek(0, 2);
        int sz = this.tell();
        this.seek(cp, 0);
        return sz;
    }

    public int tell() throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fp.getInteger("LO_TELL", args);
    }

    public InputStream getInputStream() throws SQLException {
        return new BlobInputStream(this, 4096);
    }

    public OutputStream getOutputStream() throws SQLException {
        if (this.os == null) {
            this.os = new BlobOutputStream(this, 4096);
        }
        return this.os;
    }

    public long position(byte[] buf, long start) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(buf), new FastpathArg((int)start)};
        return this.fp.getInteger("LO_POSITION", args);
    }

    public long position(LargeObject pattern, long start) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(pattern.fd), new FastpathArg((int)start)};
        return this.fp.getInteger("LO_POSITIONLOB", args);
    }

    public void truncate(long len) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg((int)len)};
        this.fp.fastpath("LO_TRUNCATE", false, args);
    }
}

