/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.util;

import com.kingbase.core.BaseStatement;
import com.kingbase.core.Field;
import com.kingbase.jdbc3.Jdbc3ResultSet;
import com.kingbase.util.Params;
import com.kingbase.util.ResultSetCache;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class CachedResultSet {
    static final int NOT_CACHED = -1;
    static final int IS_FIXED = 0;
    private static Object NullObject = new Nullable(){};
    private static final int sqlNumberFixed = 10;
    private static final int sqlNumberNotFixed = 10;
    private static final int NumberOfNotFixedSQLParams = 2000;
    private static final int NumberOfFixedSQLParams = 50;
    private static int nextIndexOfFixed = 0;
    private static int nextIndexOfNotFixed = 0;
    private static ResultSetCache[] fixedSQLCache = new ResultSetCache[10];
    private static ResultSetCache[] notFixedSQLCache = new ResultSetCache[10];

    private static int getCacheState(String sql) {
        if (sql != null && sql.length() > 0) {
            int remarkBegin = sql.toUpperCase().indexOf("/*CACHE");
            if (remarkBegin < 0) {
                return -1;
            }
            int remarkEnd = sql.substring(remarkBegin).toUpperCase().indexOf("*/");
            if (remarkEnd < 0) {
                return -1;
            }
            String flag = sql.substring(remarkBegin + "/*CACHE".length(), remarkEnd += remarkBegin);
            try {
                if (flag == null) {
                    return -1;
                }
                int state = Integer.parseInt(flag.trim());
                if (state < 0) {
                    return -1;
                }
                return state;
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addResultSetCached(Statement stmt, String sql, Object[] params, Field[] fields, Vector tuples, boolean binaryCursor) throws SQLException {
        Object object = NullObject;
        synchronized (object) {
            int cacheState = CachedResultSet.getCacheState(sql);
            ResultSetCache[] sqlCache = null;
            int index = -1;
            boolean isFixed = false;
            if (cacheState == -1) {
                return;
            }
            if (cacheState == 0) {
                sqlCache = fixedSQLCache;
                isFixed = true;
            } else {
                sqlCache = notFixedSQLCache;
            }
            Params key = new Params(params);
            int i = 0;
            while (i < sqlCache.length) {
                if (sqlCache[i].sql != null && sqlCache[i].sql.equals(sql)) {
                    if (sqlCache[i].cachedRSs.get(key) != null) {
                        return;
                    }
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                if (isFixed) {
                    index = nextIndexOfFixed++ % 10;
                    if (nextIndexOfFixed >= 10) {
                        nextIndexOfFixed = 0;
                    }
                } else {
                    index = nextIndexOfNotFixed++ % 10;
                    if (nextIndexOfNotFixed >= 10) {
                        nextIndexOfNotFixed = 0;
                    }
                }
                if (sqlCache[index].sql != null && sqlCache[index].sql.equals(sql)) {
                    sqlCache[index].cachedRSs.clear();
                }
            }
            bufferItem item = new bufferItem(stmt, sql, params, fields, tuples, binaryCursor);
            sqlCache[index].sql = sql;
            sqlCache[index].cachedRSs.put(key, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ResultSet getResultSet(String sql, Object[] params, Statement stmt) {
        Object object = NullObject;
        synchronized (object) {
            Date currentDate = Calendar.getInstance().getTime();
            Jdbc3ResultSet result = null;
            boolean isFixedCol = false;
            int cacheState = CachedResultSet.getCacheState(sql);
            ResultSetCache[] sqlCache = null;
            int index = -1;
            if (cacheState == -1) {
                return null;
            }
            if (cacheState == 0) {
                isFixedCol = true;
                sqlCache = fixedSQLCache;
            } else {
                sqlCache = notFixedSQLCache;
            }
            int i = 0;
            while (i < sqlCache.length) {
                if (sqlCache[i].sql != null && sqlCache[i].sql.equals(sql)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                return null;
            }
            ResultSetCache cacheItem = sqlCache[index];
            Params key = new Params(params);
            bufferItem item = (bufferItem)cacheItem.cachedRSs.get(key);
            if (item != null) {
                if (!isFixedCol && (currentDate.getTime() - item.createDate.getTime()) / 1000L > (long)item.secondOfInterval) {
                    cacheItem.cachedRSs.remove(key);
                } else {
                    result = new Jdbc3ResultSet((BaseStatement)((Object)stmt), item.fields, CachedResultSet.createBuffer(item.rows), "", 0, 0L, item.binaryCursor);
                }
            }
            return result;
        }
    }

    private static synchronized Vector createBuffer(Vector tuples) {
        Vector<byte[][]> rows = new Vector<byte[][]>();
        if (tuples != null && tuples.size() > 0) {
            Iterator it = tuples.iterator();
            while (it.hasNext()) {
                byte[][] originalRow = (byte[][])it.next();
                if (originalRow == null) continue;
                byte[][] rowBuffer = new byte[originalRow.length][];
                int i = 0;
                while (i < originalRow.length) {
                    if (originalRow[i] != null) {
                        rowBuffer[i] = new byte[originalRow[i].length];
                        System.arraycopy(originalRow[i], 0, rowBuffer[i], 0, originalRow[i].length);
                    }
                    ++i;
                }
                rows.add(rowBuffer);
            }
        }
        return rows;
    }

    static {
        int i = 0;
        while (i < 10) {
            CachedResultSet.fixedSQLCache[i] = new ResultSetCache(50);
            ++i;
        }
        int i2 = 0;
        while (i2 < 10) {
            CachedResultSet.notFixedSQLCache[i2] = new ResultSetCache(2000);
            ++i2;
        }
    }

    private static interface Nullable {
    }

    private static class bufferItem {
        private String sql = null;
        private Object[] m_binds = new Object[0];
        private Vector rows;
        private Field[] fields;
        private Statement stmt;
        private boolean binaryCursor = false;
        private int secondOfInterval = 0;
        private Date createDate = Calendar.getInstance().getTime();

        public bufferItem(Statement statement, String s, Object[] params, Field[] f, Vector tuples, boolean binaryCursor) {
            int i;
            this.sql = s;
            if (params != null && params.length > 0) {
                this.m_binds = new Object[params.length];
                i = 0;
                while (i < params.length) {
                    this.m_binds[i] = new String(params[i].toString());
                    ++i;
                }
            }
            this.rows = CachedResultSet.createBuffer(tuples);
            if (f != null) {
                this.fields = new Field[f.length];
                i = 0;
                while (i < f.length) {
                    this.fields[i] = (Field)f[i].Clone();
                    ++i;
                }
            }
            this.stmt = statement;
            this.binaryCursor = binaryCursor;
            if (CachedResultSet.getCacheState(this.sql) > 0) {
                this.secondOfInterval = this.getSecondNumFromSQL(this.sql);
            }
        }

        private int getSecondNumFromSQL(String sql) {
            int remarkBegin = sql.toUpperCase().indexOf("/*CACHE");
            int remarkEnd = sql.substring(remarkBegin).toUpperCase().indexOf("*/") + remarkBegin;
            return Integer.parseInt(sql.substring(remarkBegin + "/*CACHE".length(), remarkEnd).trim());
        }
    }
}

