/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.util;

import com.kingbase.jdbc1.AbstractJdbc1Connection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class KBTypeInfo {
    private int TYPE_OID;
    private String TYPE_NAME;
    private int DATA_TYPE;
    private int COLUMN_SIZE;
    private String LITERAL_PREFIX;
    private String LITERAL_SUFFIX;
    private String CREATE_PARAMS;
    private int NULLABLE;
    private boolean CASE_SENSITIVE;
    private int SEARCHABLE;
    private boolean UNSIGNED_ATTRIBUTE;
    private boolean FIXED_PREC_SCALE;
    private boolean AUTO_INCREMENT;
    private String LOCAL_TYPE_NAME;
    private int MINIMUM_SCALE;
    private int MAXIMUM_SCALE;
    private int SQL_DATA_TYPE;
    private int SQL_DATATIME_SUB;
    private int NUM_PREC_RADIX;
    private static final int intervalOID = 1186;
    private static KBTypeInfo[] allTypeInfo = null;

    public static KBTypeInfo[] getAllTypeInfo() {
        return allTypeInfo;
    }

    public static int getSQLDataType(int oid) {
        int sqlType = Integer.MAX_VALUE;
        int i = 0;
        while (i < allTypeInfo.length) {
            if (oid == KBTypeInfo.allTypeInfo[i].TYPE_OID) {
                sqlType = KBTypeInfo.allTypeInfo[i].DATA_TYPE;
                break;
            }
            ++i;
        }
        return sqlType;
    }

    public static String getDatabaseTypeName(int oid, int mod, Connection con, String originalType) throws SQLException {
        String typeName = null;
        if (oid != 1186) {
            int i = 0;
            while (i < allTypeInfo.length) {
                if (oid == KBTypeInfo.allTypeInfo[i].TYPE_OID) {
                    typeName = KBTypeInfo.allTypeInfo[i].TYPE_NAME;
                    break;
                }
                ++i;
            }
        } else if (((AbstractJdbc1Connection)((Object)con)).getDatabaseVersion() >= 40100) {
            if (mod <= 0) {
                typeName = "INTERVAL";
            } else {
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery("select sys_interval_type(" + mod + ")");
                if (rs.next()) {
                    typeName = "INTERVAL " + rs.getString(1);
                }
                if (rs != null) {
                    rs.close();
                }
                st.close();
            }
        }
        if (typeName == null) {
            typeName = originalType;
        }
        return typeName;
    }

    public KBTypeInfo(int TYPE_OID, String TYPE_NAME, int DATA_TYPE, int COLUMN_SIZE, String LITERAL_PREFIX, String LITERAL_SUFFIX, String CREATE_PARAMS, int NULLABLE, boolean CASE_SENSITIVE, int SEARCHABLE, boolean UNSIGNED_ATTRIBUTE, boolean FIXED_PREC_SCALE, boolean AUTO_INCREMENT, String LOCAL_TYPE_NAME, int MINIMUM_SCALE, int MAXIMUM_SCALE, int SQL_DATA_TYPE, int SQL_DATATIME_SUB, int NUM_PREC_RADIX) {
        this.TYPE_OID = TYPE_OID;
        this.TYPE_NAME = TYPE_NAME;
        this.DATA_TYPE = DATA_TYPE;
        this.COLUMN_SIZE = COLUMN_SIZE;
        this.LITERAL_PREFIX = LITERAL_PREFIX;
        this.LITERAL_SUFFIX = LITERAL_SUFFIX;
        this.CREATE_PARAMS = CREATE_PARAMS;
        this.NULLABLE = NULLABLE;
        this.CASE_SENSITIVE = CASE_SENSITIVE;
        this.SEARCHABLE = SEARCHABLE;
        this.UNSIGNED_ATTRIBUTE = UNSIGNED_ATTRIBUTE;
        this.FIXED_PREC_SCALE = FIXED_PREC_SCALE;
        this.AUTO_INCREMENT = AUTO_INCREMENT;
        this.LOCAL_TYPE_NAME = LOCAL_TYPE_NAME;
        this.MINIMUM_SCALE = MINIMUM_SCALE;
        this.MAXIMUM_SCALE = MAXIMUM_SCALE;
        this.SQL_DATA_TYPE = SQL_DATA_TYPE;
        this.SQL_DATATIME_SUB = SQL_DATATIME_SUB;
        this.NUM_PREC_RADIX = NUM_PREC_RADIX;
    }

    public int getTypeOid() {
        return this.TYPE_OID;
    }

    public String getTypeName() {
        return this.TYPE_NAME;
    }

    public int getDataType() {
        return this.DATA_TYPE;
    }

    public int getPrecision() {
        return this.COLUMN_SIZE;
    }

    public String getLiteralPrefix() {
        return this.LITERAL_PREFIX;
    }

    public String getLiteralSuffix() {
        return this.LITERAL_SUFFIX;
    }

    public String getCreateParams() {
        return this.CREATE_PARAMS;
    }

    public int getNullable() {
        return this.NULLABLE;
    }

    public boolean getCaseSensitive() {
        return this.CASE_SENSITIVE;
    }

    public int getSearchable() {
        return this.SEARCHABLE;
    }

    public boolean getUnsignedAttribute() {
        return this.UNSIGNED_ATTRIBUTE;
    }

    public boolean getFixedPrecScale() {
        return this.FIXED_PREC_SCALE;
    }

    public boolean getAutoIncrement() {
        return this.AUTO_INCREMENT;
    }

    public String getLocalTypeName() {
        return this.LOCAL_TYPE_NAME;
    }

    public int getMinimumScale() {
        return this.MINIMUM_SCALE;
    }

    public int getMaximumScale() {
        return this.MAXIMUM_SCALE;
    }

    public int getSqlDataType() {
        return this.SQL_DATA_TYPE;
    }

    public int getSqlDatatimeSub() {
        return this.SQL_DATATIME_SUB;
    }

    public int getNumPrecRadix() {
        return this.NUM_PREC_RADIX;
    }

    public void setLiteralPrefix(String literalPrefix) {
        this.LITERAL_PREFIX = literalPrefix;
    }

    static {
        allTypeInfo = new KBTypeInfo[31];
        KBTypeInfo.allTypeInfo[0] = new KBTypeInfo(16, "BOOLEAN", 16, 1, null, null, null, 1, false, 2, false, false, false, "BOOLEAN", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[1] = new KBTypeInfo(17, "BYTEA", -3, 65536, "X'", "'", null, 1, false, 2, false, false, false, "BYTEA", 0, 0, -1, -1, 2);
        KBTypeInfo.allTypeInfo[2] = new KBTypeInfo(20, "BIGINT", -5, 19, null, null, null, 1, false, 2, true, false, false, "BIGINT", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[3] = new KBTypeInfo(21, "SMALLINT", 5, 5, null, null, null, 1, false, 2, true, false, false, "SMALLINT", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[4] = new KBTypeInfo(23, "INTEGER", 4, 10, null, null, null, 1, false, 2, true, false, false, "INTEGER", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[5] = new KBTypeInfo(25, "TEXT", -1, 65536, "'", "'", null, 1, false, 3, false, false, false, "TEXT", 0, 0, -1, -1, 2);
        KBTypeInfo.allTypeInfo[6] = new KBTypeInfo(90, "BLOB", 2004, Integer.MAX_VALUE, "X'", "'", null, 1, false, 0, false, false, false, "BLOB", 0, 0, -1, -1, 2);
        KBTypeInfo.allTypeInfo[7] = new KBTypeInfo(91, "CLOB", 2005, Integer.MAX_VALUE, "'", "'", null, 1, false, 0, false, false, false, "CLOB", 0, 0, -1, -1, 2);
        KBTypeInfo.allTypeInfo[8] = new KBTypeInfo(700, "REAL", 7, 7, null, null, null, 1, false, 2, true, false, false, "REAL", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[9] = new KBTypeInfo(701, "DOUBLE", 8, 15, null, null, null, 1, false, 2, true, false, false, "DOUBLE", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[10] = new KBTypeInfo(1042, "CHAR", 1, 8000, "'", "'", "length", 1, true, 3, false, false, false, "CHAR", 0, 0, -1, -1, 2);
        KBTypeInfo.allTypeInfo[11] = new KBTypeInfo(1043, "VARCHAR", 12, 8000, "'", "'", "max length", 1, true, 3, false, false, false, "VARCHAR", 0, 0, -1, -1, 2);
        KBTypeInfo.allTypeInfo[12] = new KBTypeInfo(1082, "DATE", 91, 10, "'", "'", null, 1, false, 2, false, false, false, "DATE", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[13] = new KBTypeInfo(1083, "TIME", 92, 6, "'", "'", "scale", 1, false, 2, false, false, false, "TIME", 0, 6, -1, -1, 10);
        KBTypeInfo.allTypeInfo[14] = new KBTypeInfo(1114, "TIMESTAMP", 93, 6, "'", "'", "scale", 1, false, 2, false, false, false, "TIMESTAMP", 0, 6, -1, -1, 10);
        KBTypeInfo.allTypeInfo[15] = new KBTypeInfo(1184, "TIMESTAMP WITH TIME ZONE", 93, 6, "'", "'", "scale", 1, false, 2, false, false, false, "TIMESTAMP WITH TIME ZONE", 0, 6, -1, -1, 10);
        KBTypeInfo.allTypeInfo[16] = new KBTypeInfo(1186, "INTERVAL YEAR", 1111, 9, "'", "'", "precision", 1, false, 2, false, false, false, "INTERVAL YEAR", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[17] = new KBTypeInfo(1186, "INTERVAL MONTH", 1111, 9, "'", "'", "precision", 1, false, 2, false, false, false, "INTERVAL MONTH", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[18] = new KBTypeInfo(1186, "INTERVAL DAY", 1111, 9, "'", "'", "precision", 1, false, 2, false, false, false, "INTERVAL DAY", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[19] = new KBTypeInfo(1186, "INTERVAL HOUR", 1111, 9, "'", "'", "precision", 1, false, 2, false, false, false, "INTERVAL HOUR", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[20] = new KBTypeInfo(1186, "INTERVAL MINUTE", 1111, 9, "'", "'", "precision", 1, false, 2, false, false, false, "INTERVAL MINUTE", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[21] = new KBTypeInfo(1186, "INTERVAL SECOND", 1111, 9, "'", "'", "precision,scale", 1, false, 2, false, false, false, "INTERVAL SECOND", 0, 6, -1, -1, 10);
        KBTypeInfo.allTypeInfo[22] = new KBTypeInfo(1186, "INTERVAL YEAR TO MONTH", 1111, 9, "'", "'", "precision", 1, false, 2, false, false, false, "INTERVAL YEAR TO MONTH", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[23] = new KBTypeInfo(1186, "INTERVAL DAY TO SECOND", 1111, 9, "'", "'", "precision,scale", 1, false, 2, false, false, false, "INTERVAL DAY TO SECOND", 0, 6, -1, -1, 10);
        KBTypeInfo.allTypeInfo[24] = new KBTypeInfo(1266, "TIME WITH TIME ZONE", 92, 6, "'", "'", "scale", 1, false, 2, false, false, false, "TIME WITH TIME ZONE", 0, 6, -1, -1, 10);
        KBTypeInfo.allTypeInfo[25] = new KBTypeInfo(1560, "BIT", -7, 64000, "B'", "'", "length", 1, false, 2, false, false, false, "BIT", 0, 0, -1, -1, 2);
        KBTypeInfo.allTypeInfo[26] = new KBTypeInfo(1562, "BIT VARYING", -7, 64000, "B'", "'", "max length", 1, false, 2, false, false, false, "BIT VARYING", 0, 0, -1, -1, 2);
        KBTypeInfo.allTypeInfo[27] = new KBTypeInfo(1700, "NUMERIC", 2, 38, null, null, "precision,scale", 1, false, 2, false, false, false, "NUMERIC", 0, 38, -1, -1, 10);
        KBTypeInfo.allTypeInfo[28] = new KBTypeInfo(8098, "TINYINT", -6, 3, null, null, null, 1, false, 2, false, false, false, "TINYINT", 0, 0, -1, -1, 10);
        KBTypeInfo.allTypeInfo[29] = new KBTypeInfo(701, "FLOAT", 6, 53, null, null, "precision", 1, false, 2, true, false, false, "FLOAT", 0, 53, -1, -1, 2);
        KBTypeInfo.allTypeInfo[30] = new KBTypeInfo(1700, "DECIMAL", 3, 38, null, null, "precision,scale", 1, false, 2, false, false, false, "DECIMAL", 0, 38, -1, -1, 10);
    }
}

