/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.util;

import com.kingbase.Driver;
import com.kingbase.util.MessageTranslator;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Locale;

public class KSQLException
extends SQLException {
    private String message;
    private String sqlState;
    private int errCode;
    private Locale nativeLoc = Locale.getDefault();

    public KSQLException(String error) {
        this.translate(error, null);
        if (Driver.isDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public KSQLException(String error, Object[] args) {
        this.translate(error, args);
        if (Driver.isDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public KSQLException(String error, Object arg) {
        Object[] argv = new Object[]{arg};
        this.translate(error, argv);
        if (Driver.isDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public KSQLException(String error, Exception ex) {
        Object[] argv = new Object[1];
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            pw.println("Exception: " + ex.toString() + "\nStack Trace:\n");
            ex.printStackTrace(pw);
            pw.println("End of Stack Trace");
            pw.flush();
            argv[0] = baos.toString();
            pw.close();
            baos.close();
        }
        catch (Exception ioe) {
            argv[0] = ex.toString() + "\nIO Error on stack trace generation! " + ioe.toString();
        }
        this.translate(error, argv);
        if (Driver.isDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public KSQLException(String error, Object arg1, Object arg2) {
        Object[] argv = new Object[]{arg1, arg2};
        this.translate(error, argv);
        if (Driver.isDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    private void translate(String error, Object[] args) {
        this.message = MessageTranslator.translate(error, args);
        if (this.nativeLoc.equals(new Locale("zh", "CN")) || this.nativeLoc.getLanguage().equals("en")) {
            this.sqlState = this.message.substring(1, 6);
            this.errCode = 0;
            this.message = this.message.substring(7);
        } else {
            this.sqlState = null;
            this.errCode = 0;
        }
        this.message = "[KingbaseES JDBC Driver]" + this.message;
    }

    public String getLocalizedMessage() {
        return this.message;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.message;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    public String getSQLState() {
        return this.sqlState;
    }
}

