package com.reconciliation.recfj.enums;

/**
 * 对账表枚举类
 * @author 史连宁
 */
public enum RecTable {
    SD_MS_DFS("table34904", "SD_MS_DFS", "稻飞虱模式报表", "1"),
    SD_MS_ZJYM("table34903", "SD_MS_ZJYM", "纵卷叶螟模式报表", "1"),
    SD_MS_MCDCYC("table34905", "SD_MS_MCDCYC", "螟虫各代调查及下代预测模式报表", "1"),
    SD_MS_YHPKQSW("table34909", "SD_MS_YHPKQSW", "孕穗-破口期稻瘟病发生情况和穗瘟发生预测模式报表", "1"),
    SD_MS_WKB("table34902", "SD_MS_WKB", "水稻纹枯病模式报表", "1"),
    FJ_DSZBB_SDBCZBB4("table34906", "FJ_DSZBB_SDBCZBB4", "中稻及一季晚稻主要病虫周报表一", "2"),
    FJ_DSZBB_SDBCZBB3("table34907", "FJ_DSZBB_SDBCZBB3", "中稻及一季晚稻主要病虫周报表二", "2"),
    FJ_DSZBB_SDBCZBB6("table34901", "FJ_DSZBB_SDBCZBB6", "双季晚稻主要病虫周报表一", "2"),
    FJ_DSZBB_SDBCZBB5("table34911", "FJ_DSZBB_SDBCZBB5", "双季晚稻主要病虫周报表二", "2"),
    FJ_DSZBB_SDBCZBBE("table34908", "FJ_DSZBB_SDBCZBBE", "双季早稻主要病虫周报表一", "2"),
    FJ_DSZBB_SDBCZBBY("table34910", "FJ_DSZBB_SDBCZBBY", "双季早稻主要病虫周报表二", "2");

    private final String hjTable;
    private final String sysTable;
    private final String tableName;
    private final String sqlType;

    /**
     * 对账表枚举类
     * @param hjTable 汇聚平台表名
     * @param sysTable 系统表名
     * @param tableName 表中文名
     * @param sqlType sql处理类型
     */
    RecTable(String hjTable, String sysTable, String tableName, String sqlType) {
      this.hjTable = hjTable;
      this.tableName = tableName;
      this.sqlType = sqlType;
      this.sysTable = sysTable;
    }

    public String getHjTable() {
        return hjTable;
    }

    public String getSysTable() {
        return sysTable;
    }

    public String getTableName() {
        return tableName;
    }

    public String getSqlType() {
        return sqlType;
    }

    public static RecTable parse(String str) throws EnumConstantNotPresentException {
        for (RecTable rec : RecTable.values()) {
            if (rec.hjTable.equals(str) || rec.sysTable.equals(str)) {
                return rec;
            }
        }
        throw new EnumConstantNotPresentException(RecTable.class, str);
    }
}
