package com.reconciliation.recfj.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.reconciliation.recfj.entity.RecExcel;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 对账mapper
 * @author 史连宁
 */
@Mapper
public interface RecMapper extends BaseMapper<RecExcel> {

    @Select("<script>" +
            " select count(*) value, max(tbrq) latestUpdateDate from ${table} t " +
            "</script>")
    List<RecExcel> getRecAll1(String table);

    @Select("<script>" +
            " select count(*) value, max(t.tbrq) latestUpdateDate from ${table} t, ${table}_D d where t.recordid=d.recordid" +
            "</script>")
    List<RecExcel> getRecAll2(String table);

    @Select("select count(*) value, tbrq from (select TO_CHAR(t.tbrq,'yyyy-MM') tbrq from ${table} t)a group by tbrq ")
    List<RecExcel> getRecMon1(String table);

    @Select("select count(*) value, tbrq from (select TO_CHAR(t.tbrq,'yyyy-MM') tbrq from ${table} t,${table}_D d where t.recordid=d.recordid)a group by tbrq")
    List<RecExcel> getRecMon2(String table);

    @Select("select count(*) value, tbrq from (select TO_CHAR(t.tbrq,'yyyy-MM-dd') tbrq from ${table} t where t.tbrq>= to_char(now() - interval '30' day,'yyyy-MM-dd') and t.tbrq < to_char(now(),'yyyy-MM-dd'))a group by tbrq")
    List<RecExcel> getRecDay1(String table);

    @Select("select count(*) value, tbrq from (select TO_CHAR(t.tbrq,'yyyy-MM-dd') tbrq from ${table} t,${table}_D d where t.recordid=d.recordid and t.tbrq>= to_char(now() - interval '30' day,'yyyy-MM-dd') and t.tbrq < to_char(now(),'yyyy-MM-dd'))a group by tbrq")
    List<RecExcel> getRecDay2(String table);
}
