package com.reconciliation.recfj.service;

import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author : Fengmao
 * @date : 2024-11-14
 **/
@Service
public class SendWebService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${api.wsdl}")
    private String wsdl;
    @Value("${api.userid}")
    private String userid;
    @Value("${api.password}")
    private String password;
    @Value("${api.catalogId}")
    private String catalogId;

    /**
     * testwebservice接口测试方法
     *
     * @param userName  用户名
     * @param passWord  密码
     * @param catalogId 目录id
     * @param xmlStr    xml格式参数
     * @param wsdl      接口wsdl
     */
    public static void testWebService(String userName, String passWord, String catalogId, String xmlStr, String wsdl) {
        try {
            JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
            //wsdl 为实际接口地址
            org.apache.cxf.endpoint.Client client = dcf.createClient(wsdl);
            //LoginByAccount 为用户身份验证接口方法名称，userName为用户名，passWord为密码
            Object[] guidObjects = client.invoke("LoginByAccount", userName, passWord);
            System.out.println("获取guid：" + guidObjects[0].toString());
            //pushXml 为政务数据推送接口方法名称，参数个数按照接口定义进行传参，返回一个Object数组
            Object[] objects = client.invoke("pushXml", guidObjects[0].toString(), catalogId, xmlStr);
            //输出调用结果，Object数组第一条数据为返回结果
            System.out.println("调用结果:" + objects[0].toString());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    public boolean pushXmlData(String xmlStr) {
        this.logger.debug("推送的wsdl:" + wsdl);
        boolean flag = false;

        try {
            this.logger.info("推送数据---开始");
            JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
            //wsdl 为实际接口地址
            org.apache.cxf.endpoint.Client client = dcf.createClient(wsdl);
            //LoginByAccount 为用户身份验证接口方法名称，userName为用户名，passWord为密码
            Object[] guidObjects = client.invoke("LoginByAccount", userid, password);
            logger.info("获取guid：" + guidObjects[0].toString());
            //pushXml 为政务数据推送接口方法名称，参数个数按照接口定义进行传参，返回一个Object数组
            Object[] objects = client.invoke("pushXml", guidObjects[0].toString(), catalogId, xmlStr);
            //输出调用结果，Object数组第一条数据为返回结果
            logger.info("调用结果:" + objects[0].toString());
            String pushXmlResult = objects[0].toString();
            this.logger.info("调用结果:" + pushXmlResult);
        } catch (Exception e) {
            this.logger.info("推送数据---出错", e);
            return flag;
        }
        this.logger.info("推送数据---结束");
        return true;
    }

}
