/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.fastpath;

import com.kingbase.core.KB_Stream;
import java.io.IOException;

public class FastpathArg {
    public boolean type;
    public int value;
    public byte[] bytes;

    public FastpathArg(int value) {
        this.type = true;
        this.value = value;
    }

    public FastpathArg(byte[] bytes) {
        this.type = false;
        this.bytes = bytes;
    }

    public FastpathArg(byte[] buf, int off, int len) {
        this.type = false;
        this.bytes = new byte[len];
        System.arraycopy(buf, off, this.bytes, 0, len);
    }

    public FastpathArg(String s) {
        this(s.getBytes());
    }

    protected void send(KB_Stream s) throws IOException {
        if (this.type) {
            s.SendInteger(4, 4);
            s.SendInteger(this.value, 4);
        } else {
            s.SendInteger(this.bytes.length, 4);
            s.Send(this.bytes);
        }
    }

    protected int sendSize() {
        if (this.type) {
            return 8;
        }
        return 4 + this.bytes.length;
    }
}

