/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.geometric;

import com.kingbase.geometric.KBpoint;
import com.kingbase.util.KBobject;
import com.kingbase.util.KBtokenizer;
import com.kingbase.util.KSQLException;
import java.io.Serializable;
import java.sql.SQLException;

public class KBpath
extends KBobject
implements Serializable,
Cloneable {
    public boolean open;
    public KBpoint[] points;

    public KBpath(KBpoint[] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public KBpath() {
        this.setType("path");
    }

    public KBpath(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public void setValue(String s) throws SQLException {
        if (s.startsWith("[") && s.endsWith("]")) {
            this.open = true;
            s = KBtokenizer.removeBox(s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            this.open = false;
            s = KBtokenizer.removePara(s);
        } else {
            throw new KSQLException("kingbase.geo.path");
        }
        KBtokenizer t = new KBtokenizer(s, ',');
        int npoints = t.getSize();
        this.points = new KBpoint[npoints];
        int p = 0;
        while (p < npoints) {
            this.points[p] = new KBpoint(t.getToken(p));
            ++p;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof KBpath) {
            KBpath p = (KBpath)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            if (p.open != this.open) {
                return false;
            }
            int i = 0;
            while (i < this.points.length) {
                if (!this.points[i].equals(p.points[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        KBpoint[] ary = new KBpoint[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            ary[i] = (KBpoint)this.points[i].clone();
            ++i;
        }
        return new KBpath(ary, this.open);
    }

    public String getValue() {
        StringBuffer b = new StringBuffer(this.open ? "[" : "(");
        int p = 0;
        while (p < this.points.length) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
            ++p;
        }
        b.append(this.open ? "]" : ")");
        return b.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

