/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc1;

import com.kingbase.Driver;
import com.kingbase.core.BaseConnection;
import com.kingbase.core.BaseResultSet;
import com.kingbase.core.BaseStatement;
import com.kingbase.core.Field;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.jdbc1.AbstractJdbc1ResultSet;
import com.kingbase.jdbc1.Parameter;
import com.kingbase.jdbc1.ParameterMetaData;
import com.kingbase.largeobject.CharLargeObject;
import com.kingbase.largeobject.LargeObject;
import com.kingbase.largeobject.LargeObjectManager;
import com.kingbase.util.KBbytea;
import com.kingbase.util.KSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AbstractJdbc1Statement
implements BaseStatement {
    protected AbstractJdbc1Connection connection;
    protected SQLWarning warnings = null;
    protected int maxrows = 0;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled;
    public BaseResultSet result = null;
    public boolean addoid = false;
    protected int maxFieldSize = 0;
    protected int resultsettype = 1003;
    protected int concurrency = 1007;
    protected int fetchSize = 100;
    protected int fetchDirection = 1000;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private static final short ESC_FUNCTION = 4;
    private static final short ESC_OUTJOIN = 5;
    protected StringBuffer sbuf = new StringBuffer(32);
    protected String[] m_sqlFragments;
    protected String[] m_origSqlFragments;
    protected String[] m_executeSqlFragments;
    protected Object[] m_binds = new Object[0];
    protected String[] m_bindTypes = new String[0];
    protected String m_statementName = null;
    protected boolean m_useServerPrepare = false;
    protected String m_cursorName = null;
    private static final String JDBC_SYNTAX = "{[? =] call <some_function> ([? [,?]*]) }";
    private static final String RESULT_ALIAS = "result";
    private String originalSql = "";
    protected boolean isFunction = false;
    protected int functionReturnType;
    protected int testReturn;
    protected boolean returnTypeSet;
    protected BaseResultSet callResult;
    public boolean isProcedure = false;
    public String proname = null;
    public String proname1 = null;
    public String schname = null;
    protected Parameter[] parameters = null;
    protected ParameterMetaData pmd = null;
    protected String insertTableName;
    protected String insertSchemaName;
    protected static final String SYS_TEXT = "text";
    private static final String SYS_INTEGER = "integer";
    private static final String SYS_INT2 = "int2";
    private static final String SYS_INT8 = "int8";
    private static final String SYS_NUMERIC = "numeric";
    private static final String SYS_FLOAT = "float";
    private static final String SYS_DOUBLE = "float8";
    private static final String SYS_BOOLEAN = "boolean";
    private static final String SYS_DATE = "date";
    private static final String SYS_TIME = "timetz";
    protected static final String SYS_TIMESTAMPTZ = "timestamptz";
    private static final String SYS_BYTEA = "bytea";
    private static final String SYS_BIT = "BIT";
    private static final String SYS_VARBIT = "BIT VARYING";
    private static final String SYS_BLOB = "BLOB";
    private static final String SYS_CLOB = "CLOB";
    protected int UpdatedOrInsertedLargeObjOID = -1;
    public boolean isEscape = true;

    public AbstractJdbc1Statement(AbstractJdbc1Connection connection, String p_sql) throws SQLException {
        this.connection = connection;
        this.replaceProcessingEnabled = connection.getEscape();
        this.parseSqlStmt(p_sql);
        this.pmd = this.getParameterMetaData1();
        this.parameters = this.pmd.getParameter();
        if (this.isFunction) {
            this.pmd.setParpos();
        }
        if (this.isProcedure) {
            this.prem_sqlFragment();
            this.pmd.setParpos();
            if (this.m_sqlFragments.length > 1) {
                int m = 0;
                while (m < this.m_sqlFragments.length) {
                    if (m != 0 && m != this.m_sqlFragments.length - 1) {
                        if (!this.m_sqlFragments[m].trim().endsWith(",")) {
                            this.m_sqlFragments[m] = this.m_sqlFragments[m] + ",";
                        }
                        if (!this.m_sqlFragments[m].trim().startsWith(",")) {
                            this.m_sqlFragments[m] = "," + this.m_sqlFragments[m];
                        }
                    } else if (m == 0 && !this.m_sqlFragments[m].endsWith("(") && !this.m_sqlFragments[m].trim().equals(",")) {
                        this.m_sqlFragments[m] = this.m_sqlFragments[m] + ",";
                    }
                    if (!(m != this.m_sqlFragments.length - 1 || this.m_sqlFragments[m].trim().equals(",") || this.m_sqlFragments[m].trim().equals(")") || this.m_sqlFragments[m].startsWith(","))) {
                        this.m_sqlFragments[m] = "," + this.m_sqlFragments[m];
                    }
                    ++m;
                }
            }
        }
    }

    public abstract BaseResultSet createResultSet(Field[] var1, Vector var2, String var3, int var4, long var5, boolean var7) throws SQLException;

    public AbstractJdbc1Statement(BaseConnection connection) {
        this.connection = (AbstractJdbc1Connection)connection;
        this.replaceProcessingEnabled = connection.getEscape();
    }

    public BaseConnection getKBConnection() {
        return this.connection;
    }

    public String getStatementName() {
        return this.m_statementName;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String p_sql) throws SQLException {
        if (this.connection == null) {
            throw new KSQLException("kingbase.stmt.noconnection");
        }
        this.insertTableName = this.extractTableName(p_sql);
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        if (this.m_statementName != null) {
            try {
                this.connection.execSQL("DEALLOCATE " + this.m_statementName);
            }
            catch (Exception e) {
            }
            finally {
                this.m_statementName = null;
                this.m_origSqlFragments = null;
                this.m_executeSqlFragments = null;
            }
        }
        return this.executeQuery();
    }

    public ResultSet executeQuery() throws SQLException {
        this.execute();
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)((Object)this.result.getNext());
        }
        if (this.result == null) {
            throw new KSQLException("kingbase.stat.noresult");
        }
        return (ResultSet)((Object)this.result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String p_sql) throws SQLException {
        if (this.connection == null) {
            throw new KSQLException("kingbase.stmt.noconnection");
        }
        this.insertTableName = this.extractTableName(p_sql);
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        if (this.m_statementName != null) {
            try {
                this.connection.execSQL("DEALLOCATE " + this.m_statementName);
            }
            catch (Exception e) {
            }
            finally {
                this.m_statementName = null;
                this.m_origSqlFragments = null;
                this.m_executeSqlFragments = null;
            }
        }
        return this.executeUpdate();
    }

    public int executeUpdate() throws SQLException {
        this.execute();
        if (this.isProcedure) {
            return 0;
        }
        if (this.result.reallyResultSet()) {
            throw new KSQLException("kingbase.stat.result");
        }
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String p_sql) throws SQLException {
        if (this.connection == null) {
            throw new KSQLException("kingbase.stmt.noconnection");
        }
        this.insertTableName = this.extractTableName(p_sql);
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        if (this.m_statementName != null) {
            try {
                this.connection.execSQL("DEALLOCATE " + this.m_statementName);
            }
            catch (Exception e) {
            }
            finally {
                this.m_statementName = null;
                this.m_origSqlFragments = null;
                this.m_executeSqlFragments = null;
                if (this instanceof PreparedStatement) {
                    this.m_useServerPrepare = false;
                }
            }
        }
        return this.execute();
    }

    public boolean execute() throws SQLException {
        throw Driver.notImplemented();
    }

    public void setCursorName(String name) throws SQLException {
        this.m_cursorName = name;
    }

    public Connection getConnection() throws SQLException {
        return (Connection)((Object)this.connection);
    }

    public String getCursorName() {
        return this.m_cursorName;
    }

    public int getUpdateCount() throws SQLException {
        if (this.result == null) {
            return -1;
        }
        if (this.isFunction) {
            return 1;
        }
        if (this.result.reallyResultSet()) {
            return -1;
        }
        return this.result.getResultCount();
    }

    public boolean getMoreResults() throws SQLException {
        if (this.connection.getDatabaseVersion() >= 40100) {
            return this.getMoreResultsV4();
        }
        return this.getMoreResultsV3();
    }

    public boolean getMoreResultsV4() throws SQLException {
        this.result.close();
        this.result = (BaseResultSet)((Object)this.result.getNext());
        return this.result != null && this.result.reallyResultSet();
    }

    public boolean getMoreResultsV3() throws SQLException {
        this.result = (BaseResultSet)((Object)((AbstractJdbc1ResultSet)this.result).getNext());
        return this.result != null && ((AbstractJdbc1ResultSet)this.result).reallyResultSet();
    }

    public String getResultStatusString() {
        if (this.result == null) {
            return null;
        }
        return this.result.getStatusString();
    }

    public int getMaxRows() throws SQLException {
        return this.maxrows;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("maxrows munst be more then zero");
        }
        this.maxrows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.replaceProcessingEnabled = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("timeout munst be more then zero");
        }
        this.timeout = seconds;
    }

    public void addWarning(String msg) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new SQLWarning("[KingbaseES Server]" + msg, "01000"));
        } else {
            this.warnings = new SQLWarning("[KingbaseES Server]" + msg, "01000");
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max == 0) {
            this.maxFieldSize = 0;
            return;
        }
        if (max <= 0) {
            throw new KSQLException("kingbase.stat.maxfieldsize");
        }
        this.maxFieldSize = max;
    }

    public void clearWarnings() throws SQLException {
        if (this.warnings != null) {
            this.warnings = null;
        }
    }

    public void cancel() throws SQLException {
        throw new KSQLException("kingbase.unimplemented");
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.result != null && ((AbstractJdbc1ResultSet)this.result).reallyResultSet()) {
            return (ResultSet)((Object)this.result);
        }
        return null;
    }

    public void close() throws SQLException {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            rs.close();
        }
        if (this.m_useServerPrepare && this.m_statementName != null) {
            try {
                this.connection.execSQL("DEALLOCATE " + this.m_statementName);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_statementName = null;
        }
        this.result = null;
        this.connection.removeStatement(this);
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        super.finalize();
    }

    public int getInsertedOID() throws SQLException {
        if (this.result == null) {
            return 0;
        }
        return (int)this.result.getLastOID();
    }

    public long getLastOID() throws SQLException {
        if (this.result == null) {
            return 0L;
        }
        return this.result.getLastOID();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        String l_sysType;
        switch (sqlType) {
            case 4: {
                l_sysType = SYS_INTEGER;
                break;
            }
            case -6: 
            case 5: {
                l_sysType = SYS_INT2;
                break;
            }
            case -5: {
                l_sysType = SYS_INT8;
                break;
            }
            case 6: 
            case 7: {
                l_sysType = SYS_FLOAT;
                break;
            }
            case 8: {
                l_sysType = SYS_DOUBLE;
                break;
            }
            case 2: 
            case 3: {
                l_sysType = SYS_NUMERIC;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                l_sysType = SYS_TEXT;
                break;
            }
            case 91: {
                l_sysType = SYS_DATE;
                break;
            }
            case 92: {
                l_sysType = SYS_TIME;
                break;
            }
            case 93: {
                l_sysType = SYS_TIMESTAMPTZ;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                l_sysType = SYS_BYTEA;
                break;
            }
            case 2004: {
                l_sysType = SYS_BLOB;
                break;
            }
            case 2005: {
                l_sysType = SYS_CLOB;
                break;
            }
            case 1111: {
                l_sysType = SYS_TEXT;
                break;
            }
            default: {
                l_sysType = SYS_TEXT;
            }
        }
        this.bind(parameterIndex, "null", l_sysType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.bind(parameterIndex, x ? "'1'" : "'0'", SYS_BOOLEAN);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.bind(parameterIndex, Integer.toString(x), SYS_INT2);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.bind(parameterIndex, Integer.toString(x), SYS_INT2);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.bind(parameterIndex, Integer.toString(x), SYS_INTEGER);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.bind(parameterIndex, Long.toString(x), SYS_INT8);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.bind(parameterIndex, new Double(x), SYS_FLOAT);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.bind(parameterIndex, new Double(x), SYS_DOUBLE);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bind(parameterIndex, x.toString(), SYS_NUMERIC);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setString(parameterIndex, x, SYS_TEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int parameterIndex, String x, String type) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                if (type == SYS_BYTEA && this.connection.getDatabaseVersion() >= 40100) {
                    this.bind(parameterIndex, x, type);
                } else {
                    this.sbuf.setLength(0);
                    this.sbuf.ensureCapacity(2 + x.length() + x.length() / 10);
                    this.sbuf.append('\'');
                    if (this.connection.getDatabaseVersion() >= 40100) {
                        this.escapeStringSV4(x, this.sbuf);
                    } else {
                        this.escapeStringSV3(x, this.sbuf);
                    }
                    this.sbuf.append('\'');
                    this.bind(parameterIndex, this.sbuf.toString(), type);
                }
            }
        }
    }

    private void escapeStringSV3(String p_input, StringBuffer p_output) {
        int i = 0;
        while (i < p_input.length()) {
            char c = p_input.charAt(i);
            switch (c) {
                case '\'': 
                case '\\': {
                    p_output.append('\\');
                    p_output.append(c);
                    break;
                }
                case '\u0000': {
                    throw new IllegalArgumentException("\\0 not allowed");
                }
                default: {
                    p_output.append(c);
                }
            }
            ++i;
        }
    }

    private void escapeStringSV4(String p_input, StringBuffer p_output) {
        int i = 0;
        while (i < p_input.length()) {
            char c = p_input.charAt(i);
            switch (c) {
                case '\\': {
                    p_output.append(c);
                    break;
                }
                case '\'': {
                    p_output.append('\'');
                    p_output.append(c);
                    break;
                }
                case '\u0000': {
                    throw new IllegalArgumentException("\\0 not allowed");
                }
                default: {
                    p_output.append(c);
                }
            }
            ++i;
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (null == x) {
            this.setNull(parameterIndex, -3);
        } else {
            int parameterType = this.pmd.getParameter()[parameterIndex - 1].parSQLType;
            this.setString(parameterIndex, KBbytea.toSYSString(x, this.connection, parameterType), SYS_BYTEA);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (null == x) {
            this.setNull(parameterIndex, 91);
        } else {
            this.bind(parameterIndex, "'" + x.toString() + "'", SYS_DATE);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (null == x) {
            this.setNull(parameterIndex, 92);
        } else {
            this.bind(parameterIndex, "'" + x.toString() + "'", SYS_TIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (null == x) {
            this.setNull(parameterIndex, 93);
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.ensureCapacity(32);
                this.sbuf.append("'");
                Calendar cal = Calendar.getInstance();
                cal.setTime(x);
                int l_year = cal.get(1);
                this.sbuf.append(l_year);
                this.sbuf.append('-');
                int l_month = cal.get(2) + 1;
                if (l_month < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_month);
                this.sbuf.append('-');
                int l_day = cal.get(5);
                if (l_day < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_day);
                this.sbuf.append(' ');
                int l_hours = cal.get(11);
                if (l_hours < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_hours);
                this.sbuf.append(':');
                int l_minutes = cal.get(12);
                if (l_minutes < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_minutes);
                this.sbuf.append(':');
                int l_seconds = cal.get(13);
                if (l_seconds < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_seconds);
                char[] l_decimal = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
                char[] l_nanos = Integer.toString(x.getNanos()).toCharArray();
                System.arraycopy(l_nanos, 0, l_decimal, l_decimal.length - l_nanos.length, l_nanos.length);
                this.sbuf.append('.');
                this.sbuf.append(l_decimal, 0, 6);
                int l_offset = cal.get(15);
                int l_houros = l_offset / 3600000;
                if (l_houros >= 0) {
                    this.sbuf.append('+');
                } else {
                    this.sbuf.append('-');
                }
                if (l_houros > -10 && l_houros < 10) {
                    this.sbuf.append('0');
                }
                if (l_houros >= 0) {
                    this.sbuf.append(l_houros);
                } else {
                    this.sbuf.append(-l_houros);
                }
                int l_minos = (l_offset - l_houros * 3600000) / 60000;
                if (l_minos < 0) {
                    l_minos = -l_minos;
                }
                if (l_minos != 0) {
                    this.sbuf.append(":");
                    if (l_minos < 10) {
                        this.sbuf.append('0');
                    }
                    this.sbuf.append(l_minos);
                }
                this.sbuf.append("'");
                this.bind(parameterIndex, this.sbuf.toString(), SYS_TIMESTAMPTZ);
            }
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.connection.getAutoCommit()) {
            this.connection.execSQL("begin");
        }
        try {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            CharLargeObject lob = lom.openCharLargeObject(oid);
            OutputStream os = lob.getOutputStream();
            int c = x.read();
            int p = 0;
            while (c > -1 && p < length) {
                os.write(c);
                c = x.read();
                ++p;
            }
            os.close();
            this.setInt(parameterIndex, oid);
            if (this.connection.getAutoCommit()) {
                this.connection.execSQL("end;");
            }
        }
        catch (Exception se) {
            if (!this.connection.getAutoCommit()) {
                this.connection.execSQL("rollback;");
            }
            throw new SQLException(se.getMessage());
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean flag = false;
        if (!this.connection.getIsBegin()) {
            this.connection.execSQL("begin");
        }
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        LargeObject lob = lom.openLargeObject(oid);
        this.connection.produceLargeObject();
        try {
            flag = true;
            OutputStream los = lob.getOutputStream();
            int c = x.read();
            int p = 0;
            while (c > -1 && p < length) {
                los.write(c);
                c = x.read();
                ++p;
            }
            los.close();
            this.connection.consumeLargeObject();
            flag = false;
            if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                this.connection.execSQL("commit");
            }
        }
        catch (IOException se) {
            if (flag) {
                this.connection.consumeLargeObject();
            }
            if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                this.connection.execSQL("rollback");
            }
            throw new KSQLException("kingbase.unusual");
        }
        this.setInt(parameterIndex, oid);
        this.UpdatedOrInsertedLargeObjOID = oid;
    }

    public void clearParameters() throws SQLException {
        int i = 0;
        while (i < this.m_binds.length) {
            this.m_binds[i] = null;
            this.m_bindTypes[i] = null;
            ++i;
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 4: {
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? "1" : "0", SYS_INTEGER);
                    break;
                }
                if (x instanceof Float) {
                    String s = new Integer(((Float)x).intValue()).toString();
                    this.bind(parameterIndex, s, SYS_INTEGER);
                    break;
                }
                if (x instanceof Double) {
                    String s = new Integer(((Double)x).intValue()).toString();
                    this.bind(parameterIndex, s, SYS_INTEGER);
                    break;
                }
                this.bind(parameterIndex, x.toString(), SYS_INTEGER);
                break;
            }
            case -6: 
            case 5: {
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? "1" : "0", SYS_INT2);
                    break;
                }
                if (x instanceof Float) {
                    String s = new Integer(((Float)x).shortValue()).toString();
                    this.bind(parameterIndex, s, SYS_INT2);
                    break;
                }
                if (x instanceof Double) {
                    String s = new Integer(((Double)x).shortValue()).toString();
                    this.bind(parameterIndex, s, SYS_INT2);
                    break;
                }
                this.bind(parameterIndex, x.toString(), SYS_INT2);
                break;
            }
            case -5: {
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? "1" : "0", SYS_INT8);
                    break;
                }
                if (x instanceof Double) {
                    String s = new Long(((Double)x).longValue()).toString();
                    this.bind(parameterIndex, s, SYS_INT8);
                    break;
                }
                if (x instanceof Float) {
                    String s = new Long(((Float)x).longValue()).toString();
                    this.bind(parameterIndex, s, SYS_INT8);
                    break;
                }
                this.bind(parameterIndex, x.toString(), SYS_INT8);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                if (x instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x != false ? "1" : "0", SYS_BOOLEAN);
                    break;
                }
                if (x instanceof Integer || x instanceof Long || x instanceof Double || x instanceof Short || x instanceof Number || x instanceof Float) {
                    this.bind(parameterIndex, x.toString(), SYS_NUMERIC);
                    break;
                }
                this.bind(parameterIndex, new BigDecimal(x.toString()).toString(), SYS_NUMERIC);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, x.toString());
                break;
            }
            case 91: {
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                    break;
                }
                if (x == null) {
                    this.setNull(parameterIndex, 91);
                    break;
                }
                this.bind(parameterIndex, "'" + x.toString() + "'", SYS_DATE);
                break;
            }
            case 92: {
                if (x instanceof Time) {
                    this.setTime(parameterIndex, (Time)x);
                    break;
                }
                if (x == null) {
                    this.setNull(parameterIndex, 92);
                    break;
                }
                this.bind(parameterIndex, "'" + x.toString() + "'", SYS_TIME);
                break;
            }
            case 93: {
                if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                    break;
                }
                if (x == null) {
                    this.setNull(parameterIndex, 93);
                    break;
                }
                this.bind(parameterIndex, "'" + x.toString() + "'", SYS_TIMESTAMPTZ);
                break;
            }
            case -7: {
                if (this.connection.getDatabaseVersion() >= 40100) {
                    if (x instanceof Boolean) {
                        this.setBoolean(parameterIndex, (Boolean)x);
                        break;
                    }
                    this.bind(parameterIndex, '\'' + x.toString() + '\'', SYS_VARBIT);
                    break;
                }
                this.bind(parameterIndex, '\'' + x.toString() + '\'', SYS_VARBIT);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, x);
                break;
            }
            case 16: {
                this.setBoolean(parameterIndex, (Boolean)x);
                break;
            }
            case 1111: {
                this.setString(parameterIndex, x.toString());
                break;
            }
            case 2004: {
                this.setBlob(parameterIndex, (Blob)x);
                break;
            }
            case 2005: {
                this.setClob(parameterIndex, (Clob)x);
                break;
            }
            default: {
                throw new KSQLException("kingbase.prep.type");
            }
        }
    }

    public abstract void setBlob(int var1, Blob var2) throws SQLException;

    public abstract void setClob(int var1, Clob var2) throws SQLException;

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 1111);
            return;
        }
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof char[]) {
            this.setString(parameterIndex, new String((char[])x), SYS_TEXT);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x, Integer.MAX_VALUE);
        } else if (x instanceof Reader) {
            ((PreparedStatement)((Object)this)).setCharacterStream(parameterIndex, (Reader)x, Integer.MAX_VALUE);
        } else {
            this.setString(parameterIndex, x.toString(), SYS_TEXT);
        }
    }

    public boolean wasNull() throws SQLException {
        return this.callResult == null;
    }

    public String getString(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 12, "String");
            return (String)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return null;
        }
        return (String)this.parameters[in].parValue;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, -7, "Boolean");
            if (this.callResult == null) {
                return false;
            }
            return (Boolean)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return false;
        }
        return (Boolean)this.parameters[in].parValue;
    }

    public byte getByte(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, -6, "Byte");
            if (this.callResult == null) {
                return 0;
            }
            return (byte)((Integer)this.callResult.getObject(parameterIndex)).intValue();
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return 0;
        }
        if (this.parameters[in].parValue instanceof Double) {
            return (byte)((Double)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof Float) {
            return (byte)((Float)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof Long) {
            return (byte)((Long)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof Integer) {
            return (byte)((Integer)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof BigDecimal) {
            return (byte)((BigDecimal)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof Short) {
            return (byte)((Short)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof Boolean) {
            return (byte)((Boolean)this.parameters[in].parValue != false ? 1 : 0);
        }
        return (byte)Integer.parseInt(this.parameters[in].parValue.toString());
    }

    public short getShort(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 5, "Short");
            if (this.callResult == null) {
                return 0;
            }
            return (Short)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return 0;
        }
        if (this.parameters[in].parValue instanceof Double) {
            return ((Double)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof Float) {
            return ((Float)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof Long) {
            return ((Long)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof Integer) {
            return ((Integer)this.parameters[in].parValue).shortValue();
        }
        if (this.parameters[in].parValue instanceof BigDecimal) {
            return ((BigDecimal)this.parameters[in].parValue).shortValue();
        }
        return (Short)this.parameters[in].parValue;
    }

    public int getInt(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 4, "Int");
            if (this.callResult == null) {
                return 0;
            }
            return (Integer)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return 0;
        }
        if (this.parameters[in].parValue instanceof Double) {
            return ((Double)this.parameters[in].parValue).intValue();
        }
        if (this.parameters[in].parValue instanceof Float) {
            return ((Float)this.parameters[in].parValue).intValue();
        }
        if (this.parameters[in].parValue instanceof Long) {
            return ((Long)this.parameters[in].parValue).intValue();
        }
        if (this.parameters[in].parValue instanceof Short) {
            return ((Short)this.parameters[in].parValue).intValue();
        }
        if (this.parameters[in].parValue instanceof BigDecimal) {
            return ((BigDecimal)this.parameters[in].parValue).intValue();
        }
        return (Integer)this.parameters[in].parValue;
    }

    public long getLong(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, -5, "Long");
            if (this.callResult == null) {
                return 0L;
            }
            return (Long)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return 0L;
        }
        if (this.parameters[in].parValue instanceof Double) {
            return ((Double)this.parameters[in].parValue).longValue();
        }
        if (this.parameters[in].parValue instanceof Float) {
            return ((Float)this.parameters[in].parValue).longValue();
        }
        if (this.parameters[in].parValue instanceof Short) {
            return ((Short)this.parameters[in].parValue).longValue();
        }
        if (this.parameters[in].parValue instanceof Integer) {
            return ((Integer)this.parameters[in].parValue).longValue();
        }
        if (this.parameters[in].parValue instanceof BigDecimal) {
            return ((BigDecimal)this.parameters[in].parValue).longValue();
        }
        return (Long)this.parameters[in].parValue;
    }

    public float getFloat(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 7, "Float");
            if (this.callResult == null) {
                return 0.0f;
            }
            return ((Float)this.callResult.getObject(parameterIndex)).floatValue();
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return 0.0f;
        }
        if (this.parameters[in].parValue instanceof Double) {
            return ((Double)this.parameters[in].parValue).floatValue();
        }
        if (this.parameters[in].parValue instanceof Long) {
            return ((Long)this.parameters[in].parValue).floatValue();
        }
        if (this.parameters[in].parValue instanceof Short) {
            return ((Short)this.parameters[in].parValue).floatValue();
        }
        if (this.parameters[in].parValue instanceof Integer) {
            return ((Integer)this.parameters[in].parValue).floatValue();
        }
        if (this.parameters[in].parValue instanceof BigDecimal) {
            return ((BigDecimal)this.parameters[in].parValue).floatValue();
        }
        return ((Float)this.parameters[in].parValue).floatValue();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 8, "Double");
            if (this.callResult == null) {
                return 0.0;
            }
            return (Double)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return 0.0;
        }
        if (this.parameters[in].parValue instanceof Float) {
            return ((Float)this.parameters[in].parValue).doubleValue();
        }
        if (this.parameters[in].parValue instanceof Long) {
            return ((Long)this.parameters[in].parValue).doubleValue();
        }
        if (this.parameters[in].parValue instanceof Short) {
            return ((Short)this.parameters[in].parValue).doubleValue();
        }
        if (this.parameters[in].parValue instanceof Integer) {
            return ((Integer)this.parameters[in].parValue).doubleValue();
        }
        if (this.parameters[in].parValue instanceof BigDecimal) {
            return ((BigDecimal)this.parameters[in].parValue).doubleValue();
        }
        return (Double)this.parameters[in].parValue;
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 2, "BigDecimal");
            return (BigDecimal)this.callResult.getObject(parameterIndex);
        }
        return (BigDecimal)this.parameters[this.checkIndex((int)parameterIndex)].parValue;
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 2, "BigDecimal");
            return (BigDecimal)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue instanceof Float) {
            return BigDecimal.valueOf(((Float)this.parameters[in].parValue).longValue(), scale);
        }
        if (this.parameters[in].parValue instanceof Long) {
            return BigDecimal.valueOf((Long)this.parameters[in].parValue, scale);
        }
        if (this.parameters[in].parValue instanceof Short) {
            return BigDecimal.valueOf(((Short)this.parameters[in].parValue).longValue(), scale);
        }
        if (this.parameters[in].parValue instanceof Integer) {
            return BigDecimal.valueOf(((Integer)this.parameters[in].parValue).longValue(), scale);
        }
        return (BigDecimal)this.parameters[this.checkIndex((int)parameterIndex)].parValue;
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, -3, -2, "Bytes");
            return (byte[])this.callResult.getObject(parameterIndex);
        }
        return (byte[])this.parameters[this.checkIndex((int)parameterIndex)].parValue;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 91, "Date");
            return (Date)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return null;
        }
        return (Date)this.parameters[in].parValue;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 92, "Time");
            return (Time)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return null;
        }
        return (Time)this.parameters[in].parValue;
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 93, "Timestamp");
            return (Timestamp)this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return null;
        }
        return (Timestamp)this.parameters[in].parValue;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex);
            return this.callResult.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue == null) {
            return null;
        }
        return this.parameters[in].parValue;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.m_sqlFragments == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            this.sbuf.setLength(0);
            int i = 0;
            while (i < this.m_binds.length) {
                this.sbuf.append(this.m_sqlFragments[i]);
                if (this.m_binds[i] == null) {
                    this.sbuf.append('?');
                } else {
                    this.sbuf.append(this.m_binds[i]);
                }
                ++i;
            }
            this.sbuf.append(this.m_sqlFragments[this.m_binds.length]);
            return this.sbuf.toString();
        }
    }

    protected void bind(int paramIndex, Object s, String type) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.m_binds.length) {
            throw new KSQLException("kingbase.prep.range");
        }
        if (paramIndex == 1 && this.isFunction && this.isEscape) {
            throw new KSQLException("kingbase.call.funcover");
        }
        this.checksetp(paramIndex);
        this.m_binds[paramIndex - 1] = s;
        this.m_bindTypes[paramIndex - 1] = type;
    }

    private String modifyJdbcCall(String p_sql) throws SQLException {
        if (!p_sql.trim().startsWith("{")) {
            this.isEscape = false;
            String l_sql = p_sql.trim().toLowerCase();
            if (l_sql.startsWith("call")) {
                this.isProcedure = true;
                this.proname = l_sql.substring(l_sql.indexOf("call") + 5, l_sql.indexOf("("));
                this.proname = this.proname.trim();
                int proi = this.proname.indexOf(".");
                if (proi > 0) {
                    this.schname = this.proname.substring(0, proi);
                    this.proname1 = this.proname.substring(proi + 1);
                    if (this.schname.startsWith("\"")) {
                        this.proname = this.schname;
                        this.schname = this.schname.substring(1, this.schname.length() - 1);
                    } else {
                        this.proname = this.schname;
                        this.schname = this.schname.toUpperCase();
                    }
                    if (this.proname1.startsWith("\"")) {
                        this.proname = this.proname + "." + this.proname1;
                        this.proname1 = this.proname1.substring(1, this.proname1.length() - 1);
                    } else {
                        this.proname = this.proname + "." + this.proname1;
                        this.proname1 = this.proname1.toUpperCase();
                    }
                } else {
                    this.proname1 = this.proname.startsWith("\"") ? this.proname.substring(1, this.proname.length() - 1) : this.proname.toUpperCase();
                }
            } else {
                this.isFunction = true;
            }
            return p_sql;
        }
        this.originalSql = p_sql;
        String l_sql = p_sql;
        int index = l_sql.indexOf("=");
        boolean isValid = true;
        if (index > -1) {
            this.isFunction = true;
            isValid = l_sql.indexOf("?") < index;
        } else {
            this.isProcedure = true;
        }
        l_sql = l_sql.trim();
        if (l_sql.startsWith("{") && l_sql.endsWith("}")) {
            l_sql = l_sql.substring(1, l_sql.length() - 1);
        } else {
            isValid = false;
        }
        index = l_sql.indexOf("call");
        if (index == -1 || !isValid) {
            throw new KSQLException("kingbase.call.malformed");
        }
        l_sql = l_sql.replace('{', ' ');
        l_sql = l_sql.replace('}', ' ');
        l_sql = l_sql.replace(';', ' ');
        l_sql = l_sql.substring(index);
        this.proname = l_sql.substring(l_sql.indexOf("call") + 5, l_sql.indexOf("("));
        this.proname = this.proname.trim();
        int proi = this.proname.indexOf(".");
        if (proi > 0) {
            this.schname = this.proname.substring(0, proi);
            this.proname1 = this.proname.substring(proi + 1);
            if (this.schname.startsWith("\"")) {
                this.proname = this.schname;
                this.schname = this.schname.substring(1, this.schname.length() - 1);
            } else {
                this.proname = this.schname;
                this.schname = this.schname.toUpperCase();
            }
            if (this.proname1.startsWith("\"")) {
                this.proname = this.proname + "." + this.proname1;
                this.proname1 = this.proname1.substring(1, this.proname1.length() - 1);
            } else {
                this.proname = this.proname + "." + this.proname1;
                this.proname1 = this.proname1.toUpperCase();
            }
        } else {
            this.proname1 = this.proname.startsWith("\"") ? this.proname.substring(1, this.proname.length() - 1) : this.proname.toUpperCase();
        }
        if (this.isFunction) {
            l_sql = "?" + l_sql;
        }
        return l_sql;
    }

    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn && type2 != this.testReturn) {
            throw new KSQLException("kingbase.call.wrongget", new Object[]{"java.sql.Types=" + this.testReturn, getName, "java.sql.Types=" + type1});
        }
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn) {
            throw new KSQLException("kingbase.call.wrongget");
        }
    }

    protected int checkIndex(int parameterIndex) throws SQLException {
        if (!this.isFunction && !this.isProcedure) {
            throw new KSQLException("kingbase.call.noreturntype");
        }
        if (this.isFunction && parameterIndex != 1 && !this.isEscape) {
            throw new KSQLException("kingbase.call.noinout");
        }
        if (this.isProcedure || this.isFunction) {
            if (parameterIndex > this.parameters.length || parameterIndex < 1) {
                throw new KSQLException("kingbase.call.outindex");
            }
            int index = this.pmd.getParIndex(parameterIndex);
            if (this.parameters[index].parIOType == 1) {
                throw new KSQLException("kingbase.call.inouttype");
            }
            return index;
        }
        return -1;
    }

    protected int checkIndex1(int parameterIndex) throws SQLException {
        if (!this.isFunction && !this.isProcedure) {
            throw new KSQLException("kingbase.call.noreturntype");
        }
        if (this.isProcedure || this.isFunction) {
            if (parameterIndex > this.parameters.length || parameterIndex < 1) {
                throw new KSQLException("kingbase.call.outindex");
            }
            int index = this.pmd.getParIndex(parameterIndex);
            return index;
        }
        return -1;
    }

    protected int checksetp(int parameterIndex) throws SQLException {
        if (this.isProcedure || this.isFunction) {
            int index = this.pmd.getParIndex(parameterIndex);
            if (this.parameters[index].parIOType != 1 && !this.isEscape) {
                throw new KSQLException("kingbase.call.inouttype");
            }
            return index;
        }
        return parameterIndex;
    }

    public void setUseServerPrepare(boolean flag) throws SQLException {
        if (this.m_useServerPrepare != flag && !flag && this.m_statementName != null) {
            try {
                this.connection.execSQL("DEALLOCATE " + this.m_statementName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.m_statementName = null;
        this.m_useServerPrepare = flag;
    }

    public boolean isUseServerPrepare() {
        return this.m_useServerPrepare;
    }

    private Date dateFromString(String s) throws SQLException {
        int timezone = 0;
        long millis = 0L;
        long localoffset = 0L;
        int timezoneLocation = s.indexOf(43) == -1 ? s.lastIndexOf("-") : s.indexOf(43);
        try {
            timezone = timezoneLocation > 7 ? timezoneLocation : s.length();
            millis = Date.valueOf(s.substring(0, timezone)).getTime();
        }
        catch (Exception e) {
            throw new KSQLException("kingbase.format.baddate", (Object)s, "yyyy-MM-dd[-tz]");
        }
        timezone = 0;
        if (timezoneLocation > 7 && timezoneLocation + 3 == s.length()) {
            timezone = Integer.parseInt(s.substring(timezoneLocation + 1, s.length()));
            localoffset = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(millis))) {
                localoffset += 3600000L;
            }
            if (s.charAt(timezoneLocation) == '+') {
                timezone *= -1;
            }
        }
        millis = millis + (long)(timezone * 60 * 60 * 1000) + localoffset;
        return new Date(millis);
    }

    private Time timeFromString(String s) throws SQLException {
        int timezone = 0;
        long millis = 0L;
        long localoffset = 0L;
        int timezoneLocation = s.indexOf(43) == -1 ? s.lastIndexOf("-") : s.indexOf(43);
        try {
            timezone = timezoneLocation == -1 ? s.length() : timezoneLocation;
            millis = Time.valueOf(s.substring(0, timezone)).getTime();
        }
        catch (Exception e) {
            throw new KSQLException("kingbase.format.badtime", (Object)s, "HH:mm:ss[-tz]");
        }
        timezone = 0;
        if (timezoneLocation != -1 && timezoneLocation + 3 == s.length()) {
            timezone = Integer.parseInt(s.substring(timezoneLocation + 1, s.length()));
            localoffset = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(millis))) {
                localoffset += 3600000L;
            }
            if (s.charAt(timezoneLocation) == '+') {
                timezone *= -1;
            }
        }
        millis = millis + (long)(timezone * 60 * 60 * 1000) + localoffset;
        return new Time(millis);
    }

    private Timestamp timestampFromString(String s) throws SQLException {
        int timezone = 0;
        long millis = 0L;
        long localoffset = 0L;
        int nanosVal = 0;
        int timezoneLocation = s.indexOf(43) == -1 ? s.lastIndexOf("-") : s.indexOf(43);
        int nanospos = s.indexOf(".");
        try {
            timezone = nanospos != -1 ? nanospos : (timezoneLocation > 8 ? timezoneLocation : s.length());
            millis = Timestamp.valueOf(s.substring(0, timezone)).getTime();
        }
        catch (Exception e) {
            throw new KSQLException("kingbase.format.badtimestamp", (Object)s, "yyyy-MM-dd HH:mm:ss[.xxxxxx][-tz]");
        }
        timezone = 0;
        if (nanospos != -1) {
            int tmploc = timezoneLocation > 8 ? timezoneLocation : s.length();
            nanosVal = Integer.parseInt(s.substring(nanospos + 1, tmploc));
            int diff = 8 - (tmploc - 1 - (nanospos + 1));
            int i = 0;
            while (i < diff) {
                nanosVal *= 10;
                ++i;
            }
        }
        if (timezoneLocation > 8 && timezoneLocation + 3 == s.length()) {
            timezone = Integer.parseInt(s.substring(timezoneLocation + 1, s.length()));
            localoffset = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(millis))) {
                localoffset += 3600000L;
            }
            if (s.charAt(timezoneLocation) == '+') {
                timezone *= -1;
            }
        }
        millis = millis + (long)(timezone * 60 * 60 * 1000) + localoffset;
        Timestamp tmpts = new Timestamp(millis);
        tmpts.setNanos(nanosVal);
        return tmpts;
    }

    protected String functconvert(String sql) {
        int pi;
        int i = sql.indexOf("(");
        String str1 = sql.substring(0, i);
        if ((str1 = str1.trim()).equalsIgnoreCase("log")) {
            sql = "ln" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("log10")) {
            sql = "log" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("ceiling")) {
            sql = "ceil" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("round") && (pi = this.fun11(sql.substring(i + 1)).length) > 2) {
            String[] strpa = new String[pi];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "round(cast(" + strpa[0] + " as  numeric)," + strpa[1] + strpa[2];
            return sql;
        }
        if (str1.equalsIgnoreCase("rand")) {
            sql = "random()*SetSeed" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("lcase")) {
            sql = "lower" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("ucase")) {
            sql = "upper" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("power")) {
            sql = "pow" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("truncate")) {
            pi = this.fun11(sql.substring(i + 1)).length;
            if (pi > 2) {
                String[] strpa = new String[pi];
                strpa = this.fun11(sql.substring(i + 1));
                sql = "trunc(cast(" + strpa[0] + " as  numeric)," + strpa[1] + strpa[2];
                return sql;
            }
            sql = "trunc" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("char")) {
            sql = "chr(cast(" + sql.substring(sql.indexOf("(") + 1, sql.indexOf(")")) + " as int))" + sql.substring(sql.indexOf(")") + 1);
            return sql;
        }
        if (str1.equalsIgnoreCase("length")) {
            sql = "char_length" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("insert")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "textcat(textcat(substr(" + strpa[0] + ",1," + (Integer.parseInt(strpa[1]) - 1) + ")," + strpa[3] + ")," + "substr(" + strpa[0] + "," + (Integer.parseInt(strpa[1]) + Integer.parseInt(strpa[2])) + ")" + strpa[4];
            return sql;
        }
        if (str1.equalsIgnoreCase("left")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "substr(" + strpa[0] + ",1," + strpa[1] + strpa[2];
            return sql;
        }
        if (str1.equalsIgnoreCase("right")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "substr(" + strpa[0] + ",char_length(" + strpa[0] + ")+1-" + strpa[1] + strpa[2];
            return sql;
        }
        if (str1.equalsIgnoreCase("space")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "repeat(' '," + strpa[0] + strpa[1];
            return sql;
        }
        if (str1.equalsIgnoreCase("locate")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            if (strpa.length == 3) {
                sql = "strpos(" + strpa[1] + "," + strpa[0] + strpa[2];
                return sql;
            }
            sql = "strpos(substr(" + strpa[1] + "," + strpa[2] + ")," + strpa[0] + strpa[3];
            return sql;
        }
        if (str1.equalsIgnoreCase("concat")) {
            sql = "textcat" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("CURDATE")) {
            sql = "current_date" + sql.substring(i + 2);
            return sql;
        }
        if (str1.equalsIgnoreCase("CURTIME")) {
            sql = "current_time" + sql.substring(i + 2);
            return sql;
        }
        if (str1.equalsIgnoreCase("dayname")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "to_char(" + this.timefun(strpa[0]) + strpa[0] + ",'day'" + strpa[1];
            return sql;
        }
        if (str1.equalsIgnoreCase("dayofmonth")) {
            if (this.connection.getDatabaseVersion() >= 40100) {
                sql = "datepart('day'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
                return sql;
            }
            sql = "date_part('day'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
            return sql;
        }
        if (str1.equalsIgnoreCase("dayofweek")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "cast(to_char(" + this.timefun(strpa[0]) + strpa[0] + ",'D') as int" + strpa[1];
            return sql;
        }
        if (str1.equalsIgnoreCase("dayofyear")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "cast(to_char(" + this.timefun(strpa[0]) + strpa[0] + ",'DDD') as int" + strpa[1];
            return sql;
        }
        if (str1.equalsIgnoreCase("hour")) {
            if (this.connection.getDatabaseVersion() >= 40100) {
                sql = "datepart('hour'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
                return sql;
            }
            sql = "date_part('hour'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
            return sql;
        }
        if (str1.equalsIgnoreCase("minute")) {
            if (this.connection.getDatabaseVersion() >= 40100) {
                sql = "datepart('minute'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
                return sql;
            }
            sql = "date_part('minute'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
            return sql;
        }
        if (str1.equalsIgnoreCase("second")) {
            if (this.connection.getDatabaseVersion() >= 40100) {
                sql = "datepart('second'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
                return sql;
            }
            sql = "date_part('second'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
            return sql;
        }
        if (str1.equalsIgnoreCase("month")) {
            if (this.connection.getDatabaseVersion() >= 40100) {
                sql = "datepart('month'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
                return sql;
            }
            sql = "date_part('month'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
            return sql;
        }
        if (str1.equalsIgnoreCase("monthname")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "to_char(" + this.timefun(strpa[0]) + strpa[0] + ",'mon'" + strpa[1];
            return sql;
        }
        if (str1.equalsIgnoreCase("quarter")) {
            if (this.connection.getDatabaseVersion() >= 40100) {
                sql = "datepart('quarter'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
                return sql;
            }
            sql = "date_part('quarter'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
            return sql;
        }
        if (str1.equalsIgnoreCase("year")) {
            if (this.connection.getDatabaseVersion() >= 40100) {
                sql = "datepart('year'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
                return sql;
            }
            sql = "date_part('year'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
            return sql;
        }
        if (str1.equalsIgnoreCase("week")) {
            if (this.connection.getDatabaseVersion() >= 40100) {
                sql = "datepart('week'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
                return sql;
            }
            sql = "date_part('week'," + this.timefun(sql.substring(i + 1)) + sql.substring(i + 1);
            return sql;
        }
        if (str1.equalsIgnoreCase("database")) {
            sql = "current_database" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("user")) {
            sql = "current_user" + sql.substring(i + 2);
            return sql;
        }
        if (str1.equalsIgnoreCase("ifnull")) {
            sql = "isnull" + sql.substring(i);
            return sql;
        }
        if (str1.equalsIgnoreCase("convert")) {
            String[] strpa = new String[this.fun11(sql.substring(i + 1)).length];
            strpa = this.fun11(sql.substring(i + 1));
            sql = "cast(" + strpa[0] + " as " + strpa[1] + strpa[2];
            return sql;
        }
        return sql;
    }

    private String timefun(String str) {
        if (str.startsWith("'")) {
            return "timestamp ";
        }
        return "";
    }

    private String[] fun11(String sql) {
        boolean inQuotes = false;
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        Vector<String> strv = new Vector<String>();
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (c == '\'') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == ',' && !inQuotes) {
                strv.addElement(buf.toString());
                buf.setLength(0);
            } else {
                if (c == ')' && !inQuotes) {
                    strv.addElement(buf.toString());
                    buf.setLength(0);
                    strv.addElement(sql.substring(i));
                    break;
                }
                buf.append(c);
            }
            ++i;
        }
        String[] stra = new String[strv.size()];
        int i2 = 0;
        while (i2 < stra.length) {
            stra[i2] = (String)strv.elementAt(i2);
            ++i2;
        }
        return stra;
    }

    private String[] parDatch(String sql) {
        Vector<String> v = new Vector<String>();
        boolean inQuotes = false;
        int lastParmEnd = 0;
        if (sql.startsWith(",")) {
            sql = sql.substring(1);
        }
        if (sql.endsWith(",")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (c == '\'') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == ',' && !inQuotes) {
                v.addElement(sql.substring(lastParmEnd, i));
                lastParmEnd = i + 1;
            }
            ++i;
        }
        v.addElement(sql.substring(lastParmEnd, sql.length()));
        String[] p_sqlFragments = new String[v.size()];
        i = 0;
        while (i < p_sqlFragments.length) {
            p_sqlFragments[i] = (String)v.elementAt(i);
            ++i;
        }
        return p_sqlFragments;
    }

    private void prem_sqlFragment() {
        if (this instanceof CallableStatement && this.m_sqlFragments.length == 1 && (this.parameters == null || this.parameters.length == 0)) {
            this.m_sqlFragments[0] = "call    " + this.proname + "()";
            return;
        }
        int pn = -1;
        String sql = new String();
        int i = 0;
        while (i < this.m_sqlFragments.length) {
            int j = 0;
            this.m_sqlFragments[i] = this.m_sqlFragments[i].trim();
            if (this.m_sqlFragments[i].equals(",") || this.m_sqlFragments[i].equals(")") || this.m_sqlFragments[i].endsWith("(")) {
                if (this.m_sqlFragments[i].equals(",") || this.m_sqlFragments[i].endsWith("(")) {
                    ++pn;
                }
                if (this.m_sqlFragments[i].endsWith("(")) {
                    this.m_sqlFragments[0] = "call    " + this.proname + "(";
                }
            } else {
                sql = this.m_sqlFragments[i];
                if (i == 0) {
                    sql = sql.substring(sql.lastIndexOf("(") + 1);
                }
                sql = sql.trim();
                String[] p_frag = this.parDatch(sql);
                j = 0;
                while (j < p_frag.length) {
                    ++pn;
                    if (i == 0) {
                        if (j == 0) {
                            this.m_sqlFragments[0] = "call    " + this.proname + "(" + this.parameters[pn].parSYSTypeName + " " + p_frag[j];
                        } else {
                            this.m_sqlFragments[i] = this.m_sqlFragments[i] + "," + this.parameters[pn].parSYSTypeName + " " + p_frag[j];
                        }
                        this.parameters[pn].isquestion = false;
                    } else {
                        this.m_sqlFragments[i] = i != 0 && j == 0 ? this.parameters[pn].parSYSTypeName + " " + p_frag[j] : this.m_sqlFragments[i] + "," + this.parameters[pn].parSYSTypeName + " " + p_frag[j];
                        this.parameters[pn].isquestion = false;
                    }
                    ++j;
                }
                ++pn;
            }
            ++i;
        }
    }

    protected int nameToIndex(String colName) throws SQLException {
        int i = 0;
        while (i < this.parameters.length) {
            if (this.parameters[i].colName.equalsIgnoreCase(colName)) {
                return this.parameters[i].parpos;
            }
            ++i;
        }
        throw new KSQLException("kingbase.call.colnameerr");
    }

    public ParameterMetaData getParameterMetaData1() throws SQLException {
        return new ParameterMetaData(this.m_binds.length, this);
    }

    protected String compile1(String sql) {
        boolean inQuotes = false;
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (c == '\'') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == ' ' && !inQuotes) {
                while (i + 1 < sql.length() && sql.charAt(i + 1) == ' ') {
                    ++i;
                }
            }
            buf.append((int)c);
            ++i;
        }
        return sql;
    }

    protected void parseSqlStmt(String p_sql) throws SQLException {
        String l_sql = this.compile1(p_sql);
        this.insertTableName = this.extractTableName(l_sql);
        l_sql = this.replaceProcessing(l_sql);
        if (this instanceof CallableStatement) {
            l_sql = this.modifyJdbcCall(l_sql);
        }
        Vector<String> v = new Vector<String>();
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        int lastParmEnd = 0;
        int i = 0;
        while (i < l_sql.length()) {
            char c = l_sql.charAt(i);
            if (c == '\"' && !inSingleQuotes) {
                inDoubleQuotes = !inDoubleQuotes;
            } else if (c == '\'' && !inDoubleQuotes) {
                inSingleQuotes = !inSingleQuotes;
            } else if (c == '?' && !inSingleQuotes && !inDoubleQuotes) {
                v.addElement(l_sql.substring(lastParmEnd, i));
                lastParmEnd = i + 1;
            }
            ++i;
        }
        v.addElement(l_sql.substring(lastParmEnd, l_sql.length()));
        this.m_sqlFragments = new String[v.size()];
        this.m_binds = new Object[v.size() - 1];
        this.m_bindTypes = new String[v.size() - 1];
        i = 0;
        while (i < this.m_sqlFragments.length) {
            this.m_sqlFragments[i] = (String)v.elementAt(i);
            ++i;
        }
    }

    private String extractTableName(String sql) {
        String secToken;
        String fstToken;
        String tableName = null;
        String sql_insert = sql.trim();
        StringTokenizer tokens = new StringTokenizer(sql_insert);
        if (tokens.hasMoreTokens() && !(fstToken = tokens.nextToken()).equalsIgnoreCase("insert")) {
            return null;
        }
        if (tokens.hasMoreTokens() && !(secToken = tokens.nextToken()).equalsIgnoreCase("into")) {
            return null;
        }
        if (tokens.hasMoreTokens()) {
            String thdToken = tokens.nextToken();
            if (thdToken.startsWith("\"")) {
                tableName = thdToken;
            } else {
                int pos = thdToken.indexOf(".");
                if (pos > 0) {
                    this.insertSchemaName = thdToken.substring(0, pos);
                    tableName = thdToken.substring(pos + 1, thdToken.length());
                } else {
                    tableName = thdToken;
                }
            }
        }
        if (tableName.indexOf("(") > 0) {
            int position = tableName.indexOf("(");
            tableName = tableName.substring(0, position);
        }
        return tableName;
    }

    protected String replaceProcessing(String p_sql) {
        if (this.replaceProcessingEnabled) {
            StringBuffer newsql = new StringBuffer(p_sql.length());
            int state = 0;
            int i = -1;
            int len = p_sql.length();
            while (++i < len) {
                char c = p_sql.charAt(i);
                switch (state) {
                    case 0: {
                        if (c == '\'') {
                            state = 1;
                        } else if (c == '{' && i + 1 < len) {
                            char next = Character.toLowerCase(p_sql.charAt(i + 1));
                            if (next == 'd') {
                                state = 3;
                                ++i;
                                break;
                            }
                            if (next == 't') {
                                state = 3;
                                i += i + 2 < len && p_sql.charAt(i + 2) == 's' ? 2 : 1;
                                break;
                            }
                            if (next == 'f') {
                                state = 4;
                                p_sql = p_sql.substring(0, (i += 2) + 1) + " " + this.functconvert(p_sql.substring(i + 1));
                                len = p_sql.length();
                                break;
                            }
                            if (next == 'o') {
                                state = 4;
                                i += 2;
                                break;
                            }
                        }
                        newsql.append(c);
                        break;
                    }
                    case 1: {
                        if (c == '\'') {
                            state = 0;
                        } else if (c == '\\') {
                            state = 2;
                        }
                        newsql.append(c);
                        break;
                    }
                    case 2: {
                        state = 1;
                        newsql.append(c);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (c == '}') {
                            state = 0;
                            break;
                        }
                        newsql.append(c);
                    }
                }
            }
            return newsql.toString();
        }
        return p_sql;
    }

    public Parameter[] getParameter() {
        return this.parameters;
    }
}

