/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc1;

import com.kingbase.jdbc1.AbstractJdbc1DatabaseMetaData;
import com.kingbase.jdbc1.AbstractJdbc1Statement;
import com.kingbase.jdbc1.Parameter;
import com.kingbase.util.KSQLException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class ParameterMetaData {
    public Parameter[] parameters;
    public int parcount;
    public AbstractJdbc1Statement statement;

    public ParameterMetaData(int paracount, AbstractJdbc1Statement stmt) throws SQLException {
        this.parcount = paracount;
        this.statement = stmt;
        if (stmt instanceof CallableStatement && (stmt.isProcedure || stmt.isFunction && stmt.isEscape)) {
            ResultSet rs = ((AbstractJdbc1DatabaseMetaData)((Object)stmt.getConnection().getMetaData())).getProcedureColumns("", stmt.schname, stmt.proname1, null);
            Vector<Parameter> pv = new Vector<Parameter>();
            while (rs.next()) {
                Parameter par = new Parameter();
                par.parIOType = rs.getShort(5);
                par.parSQLType = rs.getShort(6);
                par.parSYSTypeName = rs.getString(7);
                par.colName = rs.getString(4);
                par.nullable = rs.getInt(12);
                par.parPrecision = rs.getInt(8);
                par.parScale = rs.getInt(10);
                pv.addElement(par);
            }
            int i = 0;
            this.parameters = new Parameter[pv.size()];
            while (i < pv.size()) {
                this.parameters[i] = (Parameter)pv.elementAt(i);
                ++i;
            }
        } else {
            this.parameters = new Parameter[paracount];
            int i = 0;
            while (i < paracount) {
                this.parameters[i] = new Parameter();
                this.parameters[i].parIOType = 1;
                this.parameters[i].isregist = false;
                ++i;
            }
        }
    }

    public void getPreparedPara() {
        block4: {
            if (!(this.statement instanceof PreparedStatement) || this.statement.m_sqlFragments.length <= 1 || this.statement instanceof CallableStatement) break block4;
            String gTName = this.extractGeneralTableName(this.statement.m_sqlFragments);
            GeneralTableName gName = new GeneralTableName(gTName);
            String tName = gName.getTableName();
            String sName = gName.getSchemaName();
            Vector pFields = this.extractParaFields(this.statement.m_sqlFragments);
            this.parameters = new Parameter[pFields.size()];
            try {
                ResultSet rs = null;
                int i = 0;
                while (i < pFields.size()) {
                    rs = this.statement.getConnection().getMetaData().getColumns(null, sName, tName, pFields.get(i).toString());
                    if (rs.next()) {
                        Parameter par = new Parameter();
                        par.parIOType = 1;
                        par.parSQLType = rs.getShort(5);
                        par.parSYSTypeName = rs.getString(6);
                        par.colName = rs.getString(4);
                        par.nullable = rs.getInt(11);
                        par.parPrecision = rs.getInt(7);
                        par.parScale = rs.getInt(9);
                        this.parameters[i] = par;
                    }
                    ++i;
                }
            }
            catch (Exception e) {}
        }
    }

    public Parameter[] getParameter() throws SQLException {
        return this.parameters;
    }

    public int getParameterCount() throws SQLException {
        return this.parcount;
    }

    public int getParameterCount1() throws SQLException {
        return this.parameters.length;
    }

    public int getParIndex(int param) throws SQLException {
        if (param > this.getParameterCount1()) {
            throw new KSQLException("kingbase.call.parindex");
        }
        if (param <= this.parcount && this.statement instanceof CallableStatement) {
            int i = 0;
            while (i < this.getParameterCount1()) {
                if (this.parameters[i].parpos == param) break;
                ++i;
            }
            return i;
        }
        return param - 1;
    }

    public void setParpos() {
        int userParameterCount = 0;
        int i = 0;
        while (i < this.parameters.length) {
            if (this.parameters[i].isquestion) {
                this.parameters[i].parpos = ++userParameterCount;
            }
            ++i;
        }
    }

    public int isNullable(int param) throws SQLException {
        if (param > this.getParameterCount()) {
            throw new KSQLException("kingbase.par.colIndex");
        }
        return this.parameters[this.getParIndex((int)param)].nullable;
    }

    public boolean isSigned(int param) throws SQLException {
        if (param > this.getParameterCount()) {
            throw new KSQLException("kingbase.par.colIndex");
        }
        switch (this.parameters[this.getParIndex((int)param)].parSQLType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getPrecision(int param) throws SQLException {
        if (param > this.getParameterCount()) {
            throw new KSQLException("kingbase.par.colIndex");
        }
        return this.parameters[this.getParIndex((int)param)].parPrecision;
    }

    public int getScale(int param) throws SQLException {
        if (param > this.getParameterCount()) {
            throw new KSQLException("kingbase.par.colIndex");
        }
        return this.parameters[this.getParIndex((int)param)].parScale;
    }

    public int getParameterType(int param) throws SQLException {
        if (param > this.getParameterCount()) {
            throw new KSQLException("kingbase.par.colIndex");
        }
        return this.parameters[this.getParIndex((int)param)].parSQLType;
    }

    public String getTypeName11(int param) throws SQLException {
        return this.parameters[param].parSYSTypeName;
    }

    public String getTypeName(int param) throws SQLException {
        if (param > this.getParameterCount()) {
            throw new KSQLException("kingbase.par.colIndex");
        }
        return this.parameters[this.getParIndex((int)param)].parSYSTypeName;
    }

    public String getParameterTypeName(int param) throws SQLException {
        if (param > this.getParameterCount()) {
            throw new KSQLException("kingbase.par.colIndex");
        }
        String tName = this.parameters[this.getParIndex((int)param)].parSYSTypeName;
        return tName;
    }

    public String getParameterClassName(int param) throws SQLException {
        if (param > this.getParameterCount()) {
            throw new KSQLException("kingbase.par.colIndex");
        }
        switch (this.parameters[this.getParIndex((int)param)].parSQLType) {
            case -1: 
            case 1: 
            case 12: {
                return "String";
            }
            case 2: {
                return "java.math.BigDeccimal";
            }
            case -7: 
            case 4: {
                return "Integer";
            }
            case -5: {
                return "Long";
            }
            case 7: {
                return "Float";
            }
            case 8: {
                return "Double";
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case 2003: {
                return "java.sql.Array";
            }
            case 2002: {
                return "java.sql.Struct";
            }
            case 2006: {
                return "java.sql.Ref";
            }
            case 2000: {
                return "Java class";
            }
        }
        return "";
    }

    public int getParameterMode(int param) throws SQLException {
        if (param > this.getParameterCount()) {
            throw new KSQLException("kingbase.par.colIndex");
        }
        return this.parameters[this.getParIndex((int)param)].parIOType;
    }

    protected ParameterMetaData(int parcount, Parameter[] parameters, AbstractJdbc1Statement stmt) {
        this.parcount = parcount;
        this.parameters = parameters;
        this.statement = stmt;
    }

    private String extractGeneralTableName(String[] fragments) {
        String[] frags = new String[fragments.length];
        String tableName = null;
        System.arraycopy(fragments, 0, frags, 0, fragments.length);
        String firstFrag = frags[0].toLowerCase().trim();
        if (firstFrag.startsWith("select")) {
            String frag = null;
            int i = 0;
            while (i < frags.length) {
                frag = frags[i].toLowerCase().trim();
                if (frag.indexOf("from") >= 0) {
                    tableName = this.extractToken(frags[i], "from");
                    return tableName;
                }
                ++i;
            }
        } else {
            if (firstFrag.startsWith("insert")) {
                int pos_into = firstFrag.indexOf("into");
                String subStr = frags[0].substring(pos_into + 4, firstFrag.length());
                if (subStr != null) {
                    subStr = subStr.trim();
                }
                StringBuffer buf = new StringBuffer();
                boolean isNameBegin = false;
                boolean inQuote = false;
                int i = 0;
                while (i < subStr.length()) {
                    char ch = subStr.charAt(i);
                    if (ch == ' ') break;
                    isNameBegin = true;
                    if (ch == '\"') {
                        inQuote = !inQuote;
                    } else {
                        if (ch == ' ' || ch == '(' && isNameBegin && !inQuote) break;
                        buf.append(ch);
                    }
                    ++i;
                }
                return buf.toString();
            }
            if (firstFrag.startsWith("update")) {
                tableName = this.extractToken(frags[0], "update");
                return tableName;
            }
        }
        return tableName;
    }

    private String extractToken(String src, String preToken) {
        String[] splits = src.split(" ");
        String result = null;
        int j = 0;
        while (j < splits.length) {
            if (splits[j].equalsIgnoreCase(preToken)) {
                ++j;
                while (splits[j].equals(" ") || splits[j].equals("")) {
                    ++j;
                }
                result = splits[j];
                break;
            }
            ++j;
        }
        return result;
    }

    private Vector extractParaFields(String[] fragments) {
        Vector<String> result;
        block15: {
            String firstFrag;
            String[] frags;
            block16: {
                block14: {
                    result = new Vector<String>();
                    frags = new String[fragments.length];
                    System.arraycopy(fragments, 0, frags, 0, fragments.length);
                    firstFrag = frags[0].toLowerCase().trim();
                    if (!firstFrag.startsWith("select")) break block14;
                    int i = 0;
                    while (i < frags.length) {
                        if (frags[i].indexOf("=") >= 0) {
                            result.add(this.extractFieldName(frags[i]).trim());
                        }
                        ++i;
                    }
                    break block15;
                }
                if (!firstFrag.startsWith("insert")) break block16;
                boolean isAllFields = false;
                String fdFrag = frags[0].substring(0, firstFrag.indexOf("values"));
                int firstP = fdFrag.indexOf("(");
                int secondP = fdFrag.indexOf(")");
                boolean bl = isAllFields = firstP < 0 || secondP < 0;
                if (isAllFields) {
                    int[] paraPos = this.extractParaPositions(frags);
                    String gTName = this.extractGeneralTableName(fragments);
                    GeneralTableName gName = new GeneralTableName(gTName);
                    String tName = gName.getTableName();
                    String sName = gName.getSchemaName();
                    try {
                        ResultSet rs = this.statement.getConnection().getMetaData().getColumns(null, sName, tName, "%");
                        int count = 0;
                        while (rs.next()) {
                            int i = 0;
                            while (i < paraPos.length) {
                                if (paraPos[i] == count) {
                                    result.add(rs.getString(4));
                                }
                                ++i;
                            }
                            ++count;
                        }
                    }
                    catch (Exception e) {
                        return result;
                    }
                } else {
                    String[] fields = frags[0].substring(firstP + 1, secondP).split(",");
                    int[] paraPos = this.extractParaPositions(frags);
                    String[] pFields = new String[paraPos.length];
                    String fName = null;
                    int i = 0;
                    while (i < paraPos.length) {
                        fName = fields[paraPos[i]];
                        if (!fName.startsWith("\"")) {
                            fName = fName.toUpperCase();
                        } else {
                            fName = fName.trim();
                            fName = fName.substring(1, fName.length() - 1);
                        }
                        result.add(fName.trim());
                        ++i;
                    }
                }
                break block15;
            }
            if (!firstFrag.startsWith("update")) break block15;
            int i = 0;
            while (i < frags.length) {
                if (frags[i].indexOf("=") >= 0) {
                    result.add(this.extractFieldName(frags[i]).trim());
                }
                ++i;
            }
        }
        return result;
    }

    private int[] extractParaPositions(String[] fragments) {
        int[] positions = null;
        String[] frags = new String[fragments.length];
        System.arraycopy(fragments, 0, frags, 0, fragments.length);
        Vector<Integer> vPos = new Vector<Integer>();
        int i = 0;
        String frag = null;
        int fCounter = 0;
        while (i < frags.length) {
            frag = frags[i].toLowerCase();
            int value_pos = frag.indexOf("values");
            if (value_pos >= 0) {
                String subF = frag.substring(value_pos + 6, frag.length());
                fCounter += this.calComma(subF);
                ++i;
                break;
            }
            ++i;
        }
        while (i < frags.length) {
            if (frags[i].startsWith(",") || frags[i].startsWith(")")) {
                vPos.add(new Integer(fCounter));
            }
            fCounter += this.calComma(frags[i]);
            ++i;
        }
        positions = new int[vPos.size()];
        int k = 0;
        while (k < vPos.size()) {
            positions[k] = Integer.parseInt(vPos.get(k).toString());
            ++k;
        }
        return positions;
    }

    private int calComma(String frag) {
        int result = 0;
        boolean inQuote = false;
        int i = 0;
        while (i < frag.length()) {
            char ch = frag.charAt(i);
            if (ch == '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if (ch == ',' && !inQuote) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private String extractFieldName(String frag) {
        String result = null;
        String fFrag = frag;
        String[] splits = fFrag.substring(0, fFrag.indexOf("=")).split(" ");
        result = splits[splits.length - 1];
        boolean inQuote = false;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < result.length()) {
            char ch = result.charAt(i);
            if (ch == '\"') {
                boolean bl = inQuote = !inQuote;
            }
            if (ch != ',' && !inQuote) {
                buf.append(ch);
            }
            ++i;
        }
        result = buf.toString();
        if (!result.startsWith("\"")) {
            result = result.toUpperCase();
        } else {
            result = result.trim();
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    class GeneralTableName {
        String generalTableName;
        String tableName;
        String schemaName;

        GeneralTableName(String name) {
            this.generalTableName = name;
            if (this.generalTableName.startsWith("\"")) {
                this.tableName = this.generalTableName;
            } else {
                int pos = this.generalTableName.indexOf(".");
                if (pos > 0) {
                    this.schemaName = this.generalTableName.substring(0, pos).toUpperCase();
                    this.tableName = this.generalTableName.substring(pos + 1, this.generalTableName.length()).toUpperCase();
                } else {
                    this.tableName = this.generalTableName.toUpperCase();
                }
            }
        }

        String getTableName() {
            return this.tableName;
        }

        String getSchemaName() {
            return this.schemaName;
        }
    }
}

