/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc2;

import com.kingbase.KBConnection;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.largeobject.CharLargeObject;
import com.kingbase.largeobject.ClobInputStream;
import com.kingbase.largeobject.ClobReader;
import com.kingbase.largeobject.ClobWriter;
import com.kingbase.largeobject.LargeObjectManager;
import com.kingbase.util.KSQLException;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class AbstractJdbc2Clob {
    protected int oid;
    protected CharLargeObject lo;
    protected AbstractJdbc1Connection conn;
    protected boolean isOpened = false;
    protected LargeObjectManager largeObjectManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractJdbc2Clob(KBConnection conn, int oid) throws SQLException {
        this.oid = oid;
        KBConnection kBConnection = conn;
        synchronized (kBConnection) {
            LargeObjectManager lom;
            this.largeObjectManager = lom = conn.getLargeObjectAPI();
        }
        this.conn = (AbstractJdbc1Connection)conn;
    }

    public long length() throws SQLException {
        this.checkState();
        return this.lo.size();
    }

    public InputStream getAsciiStream() throws SQLException {
        this.checkState();
        this.lo.seek(0);
        return new ClobInputStream(this.lo);
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkState();
        this.lo.seek(0);
        return new ClobReader(this.lo, this.conn.getEncoding().name());
    }

    public String getSubString(long off, int len) throws SQLException {
        this.checkState();
        this.lo.seek((int)off - 1);
        ClobReader reader = new ClobReader(this.lo, this.conn.getEncoding().name());
        CharArrayWriter out = new CharArrayWriter();
        try {
            int i = 0;
            while (i < len) {
                int ch = reader.read();
                if (ch <= 0) break;
                out.write(ch);
                ++i;
            }
            return out.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long position(String pattern, long start) throws SQLException {
        this.checkState();
        long position = -1L;
        if (pattern == null || pattern.length() == 0) {
            return -1L;
        }
        try {
            StringClob clob = new StringClob(pattern);
            CharLargeObject tempLargeObject = this.createTempLargeObject(clob);
            position = this.lo.position(tempLargeObject, start - 1L) + 1L;
            this.deleteTempLargeObject(tempLargeObject);
        }
        catch (Exception e) {
            throw new KSQLException("kingbase.unusual");
        }
        return position;
    }

    public long position(Clob pattern, long start) throws SQLException {
        this.checkState();
        if (pattern instanceof AbstractJdbc2Clob) {
            return this.lo.position(((AbstractJdbc2Clob)((Object)pattern)).lo, start - 1L) + 1L;
        }
        long position = -1L;
        try {
            CharLargeObject tempLargeObject = this.createTempLargeObject(pattern);
            position = this.lo.position(tempLargeObject, start - 1L) + 1L;
            this.deleteTempLargeObject(tempLargeObject);
        }
        catch (Exception e) {
            throw new KSQLException("kingbase.unusual");
        }
        return position;
    }

    public void close() {
        try {
            if (this.lo != null) {
                this.lo.close();
                this.isOpened = false;
                this.lo = null;
            }
        }
        catch (Exception e) {}
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private CharLargeObject createTempLargeObject(Clob clob) throws SQLException {
        CharLargeObject lob = null;
        Reader l_inStream = clob.getCharacterStream();
        long l_length = clob.length();
        LargeObjectManager lom = this.conn.getLargeObjectAPI();
        int oid = lom.create();
        lob = lom.openCharLargeObject(oid);
        ClobWriter los = new ClobWriter(lob, this.conn.getEncoding().name());
        try {
            int c = l_inStream.read();
            int p = 0;
            while (c > -1 && (long)p < l_length) {
                los.write(c);
                c = l_inStream.read();
                ++p;
            }
            los.flush();
        }
        catch (IOException se) {
            throw new SQLException();
        }
        return lob;
    }

    private void deleteTempLargeObject(CharLargeObject lob) throws SQLException {
        try {
            LargeObjectManager lom = this.conn.getLargeObjectAPI();
            lom.delete(lob.getOID());
        }
        catch (Exception e) {
            throw new SQLException("delete temp large object exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() throws SQLException {
        if (!this.isOpened) {
            AbstractJdbc1Connection abstractJdbc1Connection = this.conn;
            synchronized (abstractJdbc1Connection) {
                if (this.conn.getAutoCommit() && !this.conn.getIsBegin()) {
                    this.conn.execSQL("begin;");
                }
                this.lo = this.largeObjectManager.openCharLargeObject(this.oid);
                this.isOpened = true;
            }
        }
    }

    private class StringClob
    implements Clob {
        String str = null;

        public StringClob(String str) {
            this.str = str;
        }

        public long length() throws SQLException {
            return this.str.toCharArray().length;
        }

        public String getSubString(long pos, int length) throws SQLException {
            return this.str.substring((int)pos - 1, (int)pos + length - 1);
        }

        public Reader getCharacterStream() throws SQLException {
            return new CharArrayReader(this.str.toCharArray());
        }

        public InputStream getAsciiStream() throws SQLException {
            return new ByteArrayInputStream(this.str.getBytes());
        }

        public long position(String searchstr, long start) throws SQLException {
            throw new UnsupportedOperationException("Method position() not yet implemented.");
        }

        public long position(Clob searchstr, long start) throws SQLException {
            throw new UnsupportedOperationException("Method position() not yet implemented.");
        }

        public int setString(long pos, String str) throws SQLException {
            throw new UnsupportedOperationException("Method setString() not yet implemented.");
        }

        public int setString(long pos, String str, int offset, int len) throws SQLException {
            throw new UnsupportedOperationException("Method setString() not yet implemented.");
        }

        public OutputStream setAsciiStream(long pos) throws SQLException {
            throw new UnsupportedOperationException("Method setAsciiStream() not yet implemented.");
        }

        public Writer setCharacterStream(long pos) throws SQLException {
            throw new UnsupportedOperationException("Method setCharacterStream() not yet implemented.");
        }

        public void truncate(long len) throws SQLException {
            throw new UnsupportedOperationException("Method truncate() not yet implemented.");
        }
    }
}

