/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.largeobject;

import com.kingbase.fastpath.Fastpath;
import com.kingbase.fastpath.FastpathArg;
import com.kingbase.largeobject.AbstractLargeObject;
import com.kingbase.largeobject.ClobInputStream;
import com.kingbase.largeobject.ClobOutputStream;
import com.kingbase.largeobject.ClobWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

public class CharLargeObject
extends AbstractLargeObject {
    private ClobWriter writer;
    private ClobOutputStream os;

    protected CharLargeObject(Fastpath fp, int oid, int mode) throws SQLException {
        super(fp, oid, mode);
    }

    protected void finalize() throws SQLException, Throwable {
        super.finalize();
    }

    public void close() throws SQLException {
        if (!this.closed && this.fd != -1) {
            if (this.writer != null) {
                try {
                    try {
                        this.writer.flush();
                    }
                    catch (IOException ioe) {
                        throw new SQLException(ioe.getMessage());
                    }
                    Object var3_1 = null;
                    this.writer = null;
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    this.writer = null;
                    throw throwable;
                }
            }
            FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd)};
            this.fp.fastpath("LO_CLOSE", false, args);
            this.closed = true;
            this.fd = -1;
        }
    }

    public byte[] read(int len) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(len)};
        return this.fp.getData("LOREAD_CLOB", args);
    }

    public int read(byte[] buf, int off, int len) throws SQLException {
        byte[] b = this.read(len);
        if (b.length < len) {
            len = b.length;
        }
        System.arraycopy(b, 0, buf, off, len);
        return len;
    }

    public void write(byte[] buf) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(buf)};
        this.fp.fastpath("LOWRITE_CLOB", false, args);
    }

    public void write(byte[] buf, int off, int len) throws SQLException {
        byte[] data = new byte[len];
        System.arraycopy(buf, off, data, 0, len);
        this.write(data);
    }

    public void seek(int pos, int ref) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(pos), new FastpathArg(ref)};
        this.fp.fastpath("LO_LSEEK_CLOB", false, args);
    }

    public void seek(int pos) throws SQLException {
        this.seek(pos, 0);
    }

    public int tell() throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fp.getInteger("LO_TELL_CLOB", args);
    }

    public InputStream getInputStream() throws SQLException {
        return new ClobInputStream(this, 4096);
    }

    public OutputStream getOutputStream() throws SQLException {
        if (this.os == null) {
            this.os = new ClobOutputStream(this, 4096);
        }
        return this.os;
    }

    public long position(byte[] buf, long start) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(buf), new FastpathArg((int)start)};
        return this.fp.getInteger("LO_POSITION_CLOB", args);
    }

    public long position(CharLargeObject pattern, long start) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(pattern.fd), new FastpathArg((int)start)};
        return this.fp.getInteger("LO_POSITIONLOB_CLOB", args);
    }

    public void truncate(long len) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg((int)len)};
        this.fp.fastpath("LO_TRUNCATE_CLOB", false, args);
    }

    public int size() throws SQLException {
        int cp = this.tell();
        this.seek(0, 2);
        int sz = this.tell();
        this.seek(cp, 0);
        return sz;
    }
}

