/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.largeobject;

import com.kingbase.Driver;
import com.kingbase.core.BaseConnection;
import com.kingbase.fastpath.Fastpath;
import com.kingbase.fastpath.FastpathArg;
import com.kingbase.largeobject.CharLargeObject;
import com.kingbase.largeobject.LargeObject;
import java.sql.SQLException;

public class LargeObjectManager {
    private Fastpath fp;
    public static final int WRITE = 131072;
    public static final int READ = 262144;
    public static final int INV_BYTE = 524288;
    public static final int INV_CHAR = 0x100000;
    private BaseConnection conn;
    public static final int READWRITE = 393216;

    private LargeObjectManager() {
    }

    public LargeObjectManager(BaseConnection conn) throws SQLException {
        this.fp = conn.getFastpathAPI();
        this.conn = conn;
        if (Driver.isDebug) {
            Driver.debug("Large Object initialised");
        }
    }

    public CharLargeObject openCharLargeObject(int oid) throws SQLException {
        int dataBaseVersion = this.conn.getDatabaseVersion();
        if (dataBaseVersion < 40100 || dataBaseVersion == 50001 || dataBaseVersion == 50000) {
            return this.openCharLargeObject(oid, 393216);
        }
        return this.openCharLargeObject(oid, 0x160000);
    }

    private CharLargeObject openCharLargeObject(int oid, int mode) throws SQLException {
        return new CharLargeObject(this.fp, oid, mode);
    }

    public LargeObject openLargeObject(int oid) throws SQLException {
        return this.openLargeObject(oid, 393216);
    }

    private LargeObject openLargeObject(int oid, int mode) throws SQLException {
        return new LargeObject(this.fp, oid, mode);
    }

    public int create() throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(393216)};
        return this.fp.getInteger("LO_CREAT", args);
    }

    public int create(int mode) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(mode)};
        return this.fp.getInteger("LO_CREAT", args);
    }

    public void delete(int oid) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(oid)};
        this.fp.fastpath("LO_UNLINK", false, args);
    }

    public void unlink(int oid) throws SQLException {
        this.delete(oid);
    }
}

