/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.tableBuffer;

import com.kingbase.core.BaseConnection;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.largeobject.CharLargeObject;
import com.kingbase.largeobject.ClobWriter;
import com.kingbase.largeobject.LargeObject;
import com.kingbase.largeobject.LargeObjectManager;
import com.kingbase.tableBuffer.CopyIn;
import com.kingbase.tableBuffer.CopyInstruction;
import com.kingbase.tableBuffer.KBCopyException;
import com.kingbase.tableBuffer.RowData;
import com.kingbase.util.KBbytea;
import com.kingbase.util.KSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class CopyInImpl
implements CopyIn {
    private String strTableName = null;
    private String strSchemaPattern = null;
    private char delimiter = (char)9;
    private int bufferSize = 1000;
    private String nullIdentifier = "\\N";
    private RowData[] rows = null;
    private CopyInstruction copyOperate = null;
    private boolean isNewTuples = false;
    private int currentRow = -1;
    private Connection connection = null;
    private boolean isHaveLargeObject = false;
    private static Vector especialChar = new Vector();
    private String[] columnNameArray = null;

    public CopyInImpl(Connection con) throws SQLException {
        if (con == null || con.isClosed()) {
            throw new KBCopyException("The Connection is invalid");
        }
        this.connection = con;
        this.rows = new RowData[this.bufferSize];
        this.copyOperate = new CopyInstruction(this);
    }

    public RowData[] getRowDatas() {
        if (this.currentRow >= 0) {
            return this.rows;
        }
        return null;
    }

    public int getCurrentRowIndex() {
        return this.currentRow;
    }

    private void reset() {
        if (this.rows != null && this.rows.length > 0) {
            int i = 0;
            while (i < this.rows.length) {
                if (this.rows[i] != null) {
                    this.rows[i].reset();
                }
                ++i;
            }
        }
        this.isHaveLargeObject = false;
        this.currentRow = -1;
    }

    public void clear() {
        if (this.rows != null && this.rows.length > 0) {
            int i = 0;
            while (i < this.rows.length) {
                if (this.rows[i] != null) {
                    this.rows[i].clear();
                    this.rows[i] = null;
                }
                ++i;
            }
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this.strTableName == null || this.strSchemaPattern == null || this.strTableName.trim().equals("") || this.strSchemaPattern.trim().equals("")) {
            throw new KBCopyException("Before invoke this function,you must invoke the function setTableName and setSchemaPattern");
        }
        if (++this.currentRow >= this.bufferSize) {
            this.commit();
            this.currentRow = 0;
        }
        this.isNewTuples = true;
        if (this.rows[this.currentRow] == null) {
            this.rows[this.currentRow] = new RowData();
        }
    }

    public void insertRow() {
        this.isNewTuples = false;
    }

    public void cancelCopy(String str) throws SQLException {
        this.copyOperate.CopyFail(str);
    }

    public void commit() throws SQLException {
        try {
            this.copyOperate.CopyData(false);
        }
        catch (SQLException e) {
            this.reset();
            throw e;
        }
        this.reset();
    }

    public void copyComplete() throws SQLException {
        try {
            this.copyOperate.CopyDone();
        }
        catch (SQLException e) {
            this.reset();
            throw e;
        }
        this.reset();
    }

    public void setTableName(String tableName) {
        this.strTableName = tableName;
        this.currentRow = -1;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.strSchemaPattern = schemaPattern;
        this.currentRow = -1;
    }

    public String getTableName() {
        return this.strTableName;
    }

    public String getSchemaPattern() {
        return this.strSchemaPattern;
    }

    public void setBufferSize(int size) throws SQLException {
        if (size == 0) {
            return;
        }
        if (size < 0) {
            throw new KBCopyException("Invalid Buffer Size : " + size);
        }
        this.clear();
        this.bufferSize = size;
        this.rows = new RowData[this.bufferSize];
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setDelimiter(char delimi) {
        this.delimiter = delimi;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setNullIdentifier(String nullIden) {
        this.nullIdentifier = nullIden;
    }

    public String getNullIdentifier() {
        return this.nullIdentifier;
    }

    public void setObject(String columnName, Object obj, int sqlType) throws SQLException {
        if (!this.isNewTuples) {
            throw new KBCopyException("Before invoke this function,you must invoke the function moveToInsertRow");
        }
        switch (sqlType) {
            case 2004: {
                if (obj != null) {
                    this.rows[this.currentRow].setColumnValue(columnName, new Integer(this.createBlob((Blob)obj)));
                    break;
                }
                this.rows[this.currentRow].setColumnValue(columnName, obj);
                break;
            }
            case 2005: {
                if (obj != null) {
                    this.rows[this.currentRow].setColumnValue(columnName, new Integer(this.createClob((Clob)obj)));
                    break;
                }
                this.rows[this.currentRow].setColumnValue(columnName, obj);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (obj != null) {
                    String strValue = obj.toString();
                    if (strValue.indexOf("\\") > -1) {
                        strValue = strValue.replaceAll("\\\\", "\\\\\\\\");
                    }
                    int i = 0;
                    while (i < especialChar.size()) {
                        if (strValue.indexOf(especialChar.get(i).toString()) > -1) {
                            if (especialChar.get(i).toString().equals(new String(new char[]{'\f'}))) {
                                strValue = strValue.replaceAll(especialChar.get(i).toString(), "\\\\f");
                            } else if (especialChar.get(i).equals(new String(new char[]{'\b'}))) {
                                strValue = strValue.replaceAll(especialChar.get(i).toString(), "\\\\b");
                            } else if (especialChar.get(i).equals(new String(new char[]{'\n'}))) {
                                strValue = strValue.replaceAll(especialChar.get(i).toString(), "\\\\n");
                            } else if (especialChar.get(i).equals(new String(new char[]{'\r'}))) {
                                strValue = strValue.replaceAll(especialChar.get(i).toString(), "\\\\r");
                            } else if (especialChar.get(i).equals(new String(new char[]{'\t'}))) {
                                strValue = strValue.replaceAll(especialChar.get(i).toString(), "\\\\t");
                            } else if (especialChar.get(i).equals(new String(new char[]{'\u000b'}))) {
                                strValue = strValue.replaceAll(especialChar.get(i).toString(), "\\\\v");
                            }
                        }
                        ++i;
                    }
                    if (!especialChar.contains(new String(new char[]{this.getDelimiter()})) && strValue.indexOf(new String(new char[]{this.getDelimiter()})) > -1) {
                        strValue = strValue.replaceAll(new String(new char[]{this.getDelimiter()}), "\\\\" + new String(new char[]{this.getDelimiter()}));
                    }
                    obj = strValue;
                }
                this.rows[this.currentRow].setColumnValue(columnName, obj);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] bytea = (byte[])obj;
                if (bytea != null && bytea.length > 0) {
                    obj = KBbytea.toSYSString(bytea, (BaseConnection)((Object)this.connection), -2);
                    obj = ((String)obj).substring(2, ((String)obj).length() - 1);
                } else {
                    obj = null;
                }
                this.rows[this.currentRow].setColumnValue(columnName, obj);
                break;
            }
            case 16: {
                if (obj != null) {
                    obj = (Boolean)obj != false ? "t" : "f";
                }
                this.rows[this.currentRow].setColumnValue(columnName, obj);
                break;
            }
            default: {
                this.rows[this.currentRow].setColumnValue(columnName, obj);
            }
        }
    }

    public boolean isHaveLargeObject() {
        return this.isHaveLargeObject;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String[] getColumnNameArray() throws SQLException {
        if (this.copyOperate.getIsBeginCopy()) {
            if (this.columnNameArray == null || this.columnNameArray.length <= 0) {
                throw new KBCopyException("Invalid Begin Status!");
            }
        } else if (this.rows != null && this.rows.length > 0 && this.rows[0] != null) {
            this.columnNameArray = this.rows[0].getKeys();
        }
        return this.columnNameArray;
    }

    private synchronized int createBlob(Blob x) throws SQLException {
        boolean flag = false;
        this.isHaveLargeObject = true;
        this.checkTransaction();
        InputStream l_inStream = x.getBinaryStream();
        if (!((AbstractJdbc1Connection)((Object)this.connection)).getIsBegin()) {
            ((AbstractJdbc1Connection)((Object)this.connection)).execSQL("begin;");
        }
        LargeObjectManager lom = ((AbstractJdbc1Connection)((Object)this.connection)).getLargeObjectAPI();
        int oid = lom.create();
        LargeObject lob = lom.openLargeObject(oid);
        ((AbstractJdbc1Connection)((Object)this.connection)).produceLargeObject();
        try {
            flag = true;
            OutputStream los = lob.getOutputStream();
            byte[] buf = new byte[4096];
            int bytesRemaining = (int)x.length();
            int numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            while (numRead != -1 && bytesRemaining > 0) {
                bytesRemaining -= numRead;
                if (numRead == buf.length) {
                    los.write(buf);
                } else {
                    los.write(buf, 0, numRead);
                }
                numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            }
            los.close();
            ((AbstractJdbc1Connection)((Object)this.connection)).consumeLargeObject();
            flag = false;
            if (this.connection.getAutoCommit() && ((AbstractJdbc1Connection)((Object)this.connection)).getIsBegin() && !((AbstractJdbc1Connection)((Object)this.connection)).isHaveLargeObjectOpen()) {
                ((AbstractJdbc1Connection)((Object)this.connection)).execSQL("commit;");
            }
            l_inStream.close();
        }
        catch (IOException se) {
            if (flag) {
                ((AbstractJdbc1Connection)((Object)this.connection)).consumeLargeObject();
            }
            if (this.connection.getAutoCommit() && ((AbstractJdbc1Connection)((Object)this.connection)).getIsBegin() && !((AbstractJdbc1Connection)((Object)this.connection)).isHaveLargeObjectOpen()) {
                ((AbstractJdbc1Connection)((Object)this.connection)).execSQL("rollback;");
            }
            throw new KSQLException("kingbase.unusual");
        }
        return oid;
    }

    private synchronized int createClob(Clob x) throws SQLException {
        boolean flag = false;
        this.isHaveLargeObject = true;
        this.checkTransaction();
        Reader l_inStream = x.getCharacterStream();
        if (!((AbstractJdbc1Connection)((Object)this.connection)).getIsBegin()) {
            ((AbstractJdbc1Connection)((Object)this.connection)).execSQL("begin");
        }
        int l_length = (int)x.length();
        LargeObjectManager lom = ((AbstractJdbc1Connection)((Object)this.connection)).getLargeObjectAPI();
        int oid = lom.create();
        CharLargeObject lob = lom.openCharLargeObject(oid);
        ((AbstractJdbc1Connection)((Object)this.connection)).produceLargeObject();
        try {
            flag = true;
            ClobWriter los = new ClobWriter(lob, ((AbstractJdbc1Connection)((Object)this.connection)).getEncoding().name());
            int c = l_inStream.read();
            int p = 0;
            while (c > -1 && p < l_length) {
                los.write(c);
                c = l_inStream.read();
                ++p;
            }
            los.close();
            ((AbstractJdbc1Connection)((Object)this.connection)).consumeLargeObject();
            flag = false;
            if (this.connection.getAutoCommit() && ((AbstractJdbc1Connection)((Object)this.connection)).getIsBegin() && !((AbstractJdbc1Connection)((Object)this.connection)).isHaveLargeObjectOpen()) {
                ((AbstractJdbc1Connection)((Object)this.connection)).execSQL("commit;");
            }
            l_inStream.close();
        }
        catch (IOException se) {
            if (flag) {
                ((AbstractJdbc1Connection)((Object)this.connection)).consumeLargeObject();
            }
            if (this.connection.getAutoCommit() && ((AbstractJdbc1Connection)((Object)this.connection)).getIsBegin() && !((AbstractJdbc1Connection)((Object)this.connection)).isHaveLargeObjectOpen()) {
                ((AbstractJdbc1Connection)((Object)this.connection)).execSQL("rollback;");
            }
            throw new KSQLException("kingbase.unusual");
        }
        return oid;
    }

    public void checkTransaction() {
        try {
            if (!this.connection.getAutoCommit() && !((AbstractJdbc1Connection)((Object)this.connection)).getIsBegin()) {
                ((AbstractJdbc1Connection)((Object)this.connection)).execSQL("begin;");
            }
        }
        catch (Exception e) {}
    }

    static {
        especialChar.add(new String(new char[]{'\b'}));
        especialChar.add(new String(new char[]{'\f'}));
        especialChar.add(new String(new char[]{'\n'}));
        especialChar.add(new String(new char[]{'\r'}));
        especialChar.add(new String(new char[]{'\t'}));
        especialChar.add(new String(new char[]{'\u000b'}));
    }
}

