package com.reconciliation.recfj.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;

import java.util.Date;

/**
 * 对账导出信息
 * @author 史连宁
 */
@Data
@Builder
@EqualsAndHashCode()
@AllArgsConstructor()
@NoArgsConstructor()
public class RecExcel {

    /**
     * 主键标识
     * 表记录主键，执行时间年月日时分秒+6位随时数
     */
    @ExcelProperty("主键标识")
    private String id;

    /**
     * 对账指标唯一编号
     * 获取对账配置表中的列,对账指标编号_目录标识
     */
    @ExcelProperty("对账指标唯一编号")
    private String recId;

    /**
     * 对账指标
     * 获取对账配置表中的列
     * IDX1 数据总量
     * IDX2 创建时间月统计值
     * IDX3 创建时间日统计值（近30天）
     * IDX4 更新时间月统计值
     * IDX5 更新时间日统计值（近30天）
     */
    @ExcelProperty("对账指标")
    private String recItem;

    /**
     * 目录标识
     * 获取对账配置表中的列，汇聚table表名
     */
    @ExcelProperty("目录标识")
    private String thirdTable;

    /**
     * 数据时间
     * 创建时间或者更新时间的所属月份或日期，格式yyyyMM/yyyyMMdd
     * 指标“IDX1数据总量”此列不用填
     */
    @ExcelProperty("数据时间")
    private String dataTimeStr;

    /**
     * 数据区域
     * 暂时为空
     */
    @ExcelProperty("数据区域")
    private String dataArea;

    /**
     * 其他维度
     * 暂时为空
     */
    @ExcelProperty("其他维度")
    private String otherDimension;

    /**
     * 统计值
     * 按指标类型分组统计总量
     */
    @ExcelProperty("统计值")
    private Long value;

    /**
     * 业务系统对账执行时间
     * 执行此条记录的时间
     * 格式：yyyy-MM-dd HH:mm:ss
     */
    @ExcelProperty("业务系统对账执行时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date execDate;

    /**
     * 最新业务更新时间
     * 只在“IDX1数据总量”时填写，取配置时“业务更新时间字段”的最大值，格式：yyyy-MM-dd HH:mm:ss
     */
    @ExcelProperty("最新业务更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date latestUpdateDate;

    /**
     * 备注
     * 按需填写
     */
    @ExcelProperty("备注")
    private String remark = "福建省农业有害生物监控系统";

    /**
     * 临时字段:业务更新年月/年月日
     */
    @ExcelIgnore
    private String tbrq;
}
