package com.reconciliation.recfj.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 返回值
 * @author 史连宁
 */
@Data
@Builder
@AllArgsConstructor()
@NoArgsConstructor()
public class ReturnValue {
    private boolean success;
    private String msg;
    private Object data;

    public static ReturnValue ok() {
        return ReturnValue.builder().success(true).build();
    }
    public static ReturnValue ok(String msg) {
        return ReturnValue.builder().success(true).msg(msg).build();
    }
    public static ReturnValue fail() {
        return ReturnValue.builder().success(false).build();
    }
    public static ReturnValue fail(String msg) {
        return ReturnValue.builder().success(false).msg(msg).build();
    }
}
