package com.reconciliation.recfj.task;

import com.reconciliation.recfj.entity.RecExcel;
import com.reconciliation.recfj.entity.ReturnValue;
import com.reconciliation.recfj.service.RecService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 对账定时任务
 * @author 史连宁
 */
@EnableScheduling
@Component("RecTask")
public class RecTask {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private RecService recService;

    @Scheduled(cron = "${task.rec.default}")
    public void createRecDataToExcel() {
        ReturnValue rtv = recService.createRecDataToExcel(new RecExcel());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (rtv.isSuccess()) {
            logger.info(
                    "[{}]汇聚平台对账数据生成成功",
                    sdf.format(new Date())
            );
        } else {
            logger.warn(
                    "[{}]汇聚平台对账数据生成失败: {}",
                    sdf.format(new Date()),
                    rtv.getMsg()
            );
        }
    }
}
