package com.reconciliation.recfj.util;

import com.reconciliation.recfj.entity.RecXml;

import java.util.List;

/**
 * @author : Fengmao
 * @date : 2024-11-14
 **/
public class XmlBuilderUtils {

    public static String buildXml(List<RecXml> records) {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlBuilder.append("<table>\n");

        for (RecXml record : records) {
            xmlBuilder.append("  <row type=\"").append(record.getType()).append("\">\n");
            xmlBuilder.append("    <primary_key name=\"主键标识\" isattachment=\"false\"><![CDATA[").append(record.getPrimaryKey()).append("]]></primary_key>\n");
            xmlBuilder.append("    <idx_no name=\"对账指标唯一编号\" isattachment=\"false\"><![CDATA[").append(record.getIdxNo()).append("]]></idx_no>\n");
            xmlBuilder.append("    <idx_type name=\"对账指标\" isattachment=\"false\"><![CDATA[").append(record.getIdxType()).append("]]></idx_type>\n");
            xmlBuilder.append("    <table_name name=\"目录标识\" isattachment=\"false\"><![CDATA[").append(record.getTableName()).append("]]></table_name>\n");
            xmlBuilder.append("    <date_time name=\"数据时间\" isattachment=\"false\"><![CDATA[").append(record.getDateTime()).append("]]></date_time>\n");
            xmlBuilder.append("    <data_area name=\"数据区域\" isattachment=\"false\"><![CDATA[").append(record.getDataArea()).append("]]></data_area>\n");
            xmlBuilder.append("    <other_dim name=\"其他维度\" isattachment=\"false\"><![CDATA[").append(record.getOtherDim()).append("]]></other_dim>\n");
            xmlBuilder.append("    <data_count name=\"统计值\" isattachment=\"false\"><![CDATA[").append(record.getDataCount()).append("]]></data_count>\n");
            xmlBuilder.append("    <exec_time name=\"业务系统对账执行时间\" isattachment=\"false\"><![CDATA[").append(record.getExecTime()).append("]]></exec_time>\n");
            xmlBuilder.append("    <max_updatetime name=\"最新业务更新时间\" isattachment=\"false\"><![CDATA[").append(record.getMaxUpdateTime()).append("]]></max_updatetime>\n");
            xmlBuilder.append("    <remark name=\"备注\" isattachment=\"false\"><![CDATA[").append(record.getRemark()).append("]]></remark>\n");
            xmlBuilder.append("  </row>\n");
        }
        xmlBuilder.append("</table>");
        return xmlBuilder.toString();
    }
}
