package com.reconciliation.recfj.test;

import com.reconciliation.recfj.entity.RecExcel;
import com.reconciliation.recfj.entity.RecXml;
import com.reconciliation.recfj.util.DateUtils;
import com.reconciliation.recfj.util.ExcelUtils;
import com.reconciliation.recfj.util.XmlBuilderUtils;
import org.springframework.util.ObjectUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author : Fengmao
 * @date : 2024-11-15
 **/
public class XmlTest {
    public static void main(String[] args) {
        List<RecExcel> list = new ArrayList<>();
        RecExcel recExcel = new RecExcel();
        recExcel.setId("20241662015150");
        recExcel.setRecId("IDX1");
        recExcel.setThirdTable("tet");
        recExcel.setExecDate(new Date());
        recExcel.setRecItem("ee");
        recExcel.setDataTimeStr("");
        recExcel.setLatestUpdateDate(new Date());
        list.add(recExcel);

        String fileName = "RecData" + "_" + DateUtils.ConvertDateToYYYYMMddHHmmss(new Date());
        File file = new File(fileName + ".xlsx");
        ExcelUtils.writeExcel(file, list);

        String type = "add";
        List<RecXml> recXmlList = packRecXmlData(list,type);
        String xmlStr = XmlBuilderUtils.buildXml(recXmlList);
        System.out.printf("xml文件是："+xmlStr);
    }
    /**
     * 将数据封装成XML格式
     * @param list
     * @param type
     * @return
     */
    public static List<RecXml> packRecXmlData(List<RecExcel> list, String type) {
        List<RecXml> recXmlList = new ArrayList<>();
        if (ObjectUtils.isEmpty(list)){
            return null;
        }
        list.forEach(recExcel -> {
            RecXml recXml = new RecXml();
            recXml.setType(type);
            recXml.setPrimaryKey(recExcel.getId());
            recXml.setIdxNo(recExcel.getRecId());
            recXml.setIdxType(recExcel.getRecItem());
            recXml.setTableName(recExcel.getThirdTable());
            recXml.setDateTime(recExcel.getDataTimeStr());
            recXml.setDataArea(recExcel.getDataArea());
            recXml.setOtherDim(recExcel.getOtherDimension());
            recXml.setDataCount(String.valueOf(recExcel.getValue()));
            Date execDate = recExcel.getExecDate();
            String execDateStr = DateUtils.format(execDate, DateUtils.P_YYYY_MM_DD_HH_MM_SS);
            recXml.setExecTime(execDateStr);
            recXml.setMaxUpdateTime(DateUtils.format(recExcel.getLatestUpdateDate(),DateUtils.P_YYYY_MM_DD_HH_MM_SS));
            recXml.setRemark(recExcel.getRemark());
            recXmlList.add(recXml);
        });
        return recXmlList;
    }
}
