/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase;

import com.kingbase.core.KB_Stream;
import com.kingbase.jdbc3.Jdbc3Connection;
import com.kingbase.util.KSQLException;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class Driver
implements java.sql.Driver {
    public static boolean isDebug = false;
    public static PrintWriter logStream = null;
    private Properties props;
    private static String[] protocols;
    private static int m_buildNumber;

    public Connection connect(String url, Properties info) throws SQLException {
        this.props = this.parseURL(url, info);
        if (this.props == null) {
            if (isDebug) {
                Driver.debug("Error in url" + url);
            }
            return null;
        }
        try {
            if (isDebug) {
                Driver.debug("connect " + url);
            }
            Jdbc3Connection con = (Jdbc3Connection)Class.forName("com.kingbase.jdbc3.Jdbc3Connection").newInstance();
            con.openConnection(this.host(), this.port(), this.props, this.database(), url, this);
            return con;
        }
        catch (ClassNotFoundException ex) {
            if (isDebug) {
                Driver.debug("error", ex);
            }
            throw new KSQLException("kingbase.jvm.version", ex);
        }
        catch (KSQLException ex1) {
            throw ex1;
        }
        catch (Exception ex2) {
            if (isDebug) {
                Driver.debug("error", ex2);
            }
            ex2.printStackTrace();
            throw new KSQLException("kingbase.unusual", ex2);
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        this.parseURL(url, info);
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 4;
    }

    public int getMinorVersion() {
        return 1;
    }

    public static String getVersion() {
        return "@VERSION@ (build " + m_buildNumber + ")";
    }

    public boolean jdbcCompliant() {
        return false;
    }

    Properties parseURL(String url, Properties defaults) throws SQLException {
        Properties urlProps = new Properties(defaults);
        if (url == null || url.trim().equals("")) {
            return null;
        }
        String l_urlServer = url;
        String l_urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        String strHost = null;
        if (l_urlServer.indexOf("//") > 0) {
            if (l_urlServer.indexOf(new String(new char[]{'/'}), l_urlServer.indexOf("//") + 2) > 0) {
                strHost = l_urlServer.substring(l_urlServer.indexOf("//") + 2, l_urlServer.indexOf(new String(new char[]{'/'}), l_urlServer.indexOf("//") + 2));
            } else {
                return null;
            }
        }
        int ipv6start = -1;
        int ipv6end = -1;
        if (strHost == null) {
            ipv6end = -1;
            ipv6start = -1;
        } else {
            ipv6start = strHost.indexOf("[");
            ipv6end = strHost.indexOf("]");
        }
        String ipv6address = null;
        if (ipv6start != -1 && ipv6end > ipv6start) {
            ipv6address = l_urlServer.substring(ipv6start + 1, ipv6end);
            l_urlServer = l_urlServer.substring(0, ipv6start) + "ipv6host" + l_urlServer.substring(ipv6end + 1);
        }
        if (l_urlServer.indexOf("jdbc:kingbase:") < 0) {
            return null;
        }
        urlProps.put("Protocol", "kingbase");
        String strIP = strHost;
        String strPort = null;
        String strDBName = null;
        if (strHost != null && strHost.indexOf(":") > 0) {
            strIP = strHost.substring(0, strHost.indexOf(":"));
            strPort = strHost.substring(strHost.indexOf(":") + 1);
        }
        if ((strDBName = strHost != null ? l_urlServer.substring(l_urlServer.indexOf(strHost) + 1 + strHost.length()) : l_urlServer.substring("jdbc:kingbase:".length())) == null) {
            return null;
        }
        urlProps.put("KBDBNAME", strDBName);
        if (strIP != null && !strIP.equals("")) {
            urlProps.put("KBHOST", strIP);
        }
        if (strPort != null && !strPort.equals("")) {
            urlProps.put("KBPORT", strPort);
        }
        if (ipv6address != null) {
            urlProps.put("KBHOST", ipv6address);
        }
        StringTokenizer qst = new StringTokenizer(l_urlArgs, "&");
        int count = 0;
        while (qst.hasMoreTokens()) {
            String token = qst.nextToken();
            int l_pos = token.indexOf(61);
            String argument = null;
            argument = l_pos == -1 ? token : token.substring(0, l_pos);
            if (argument.equalsIgnoreCase("EscapeProcessing") || argument.equalsIgnoreCase("UseServerPrepare") || argument.equalsIgnoreCase("SavePreparedStatement") || argument.equalsIgnoreCase("UseResultSetCache") || argument.equalsIgnoreCase("ClientCursor") || argument.equalsIgnoreCase("logFile") || argument.equalsIgnoreCase("user") || argument.equalsIgnoreCase("password") || argument.equalsIgnoreCase("pwd") || argument.equalsIgnoreCase("ClientEncoding")) {
                if (l_pos == -1) {
                    urlProps.put(token, "");
                } else {
                    urlProps.put(token.substring(0, l_pos), token.substring(l_pos + 1));
                }
            } else {
                throw new KSQLException("kingbase.con.arg", (Object)new String(argument));
            }
            ++count;
        }
        return urlProps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL_Old(String url, Properties defaults) throws SQLException {
        int state = -1;
        Properties urlProps = new Properties(defaults);
        if (url == null || url.trim().equals("")) {
            return null;
        }
        String l_urlServer = url = url.trim();
        String l_urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        String strHost = l_urlServer.substring(l_urlServer.indexOf("//") + 2, l_urlServer.indexOf(new String(new char[]{'/'}), l_urlServer.indexOf("//") + 2));
        int ipv6start = strHost.indexOf("[");
        int ipv6end = strHost.indexOf("]");
        String ipv6address = null;
        if (ipv6start != -1 && ipv6end > ipv6start) {
            ipv6address = l_urlServer.substring(ipv6start + 1, ipv6end);
            l_urlServer = l_urlServer.substring(0, ipv6start) + "ipv6host" + l_urlServer.substring(ipv6end + 1);
        }
        StringTokenizer st = new StringTokenizer(l_urlServer, ":/", true);
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (count <= 3) {
                if (count % 2 != 1 || !token.equals(":")) {
                    if (count % 2 != 0) return null;
                    boolean found = count == 0;
                    int tmp = 0;
                    while (tmp < protocols.length) {
                        if (token.equals(protocols[tmp]) && count == 2 && tmp > 0) {
                            urlProps.put("Protocol", token);
                            found = true;
                        }
                        ++tmp;
                    }
                    if (!found) {
                        return null;
                    }
                }
            } else if (count > 3) {
                if (count == 4 && token.equals("/")) {
                    state = 0;
                } else if (count == 4) {
                    urlProps.put("KBDBNAME", token);
                    state = -2;
                } else if (count == 5 && state == 0 && token.equals("/")) {
                    state = 1;
                } else {
                    if (count == 5 && state == 0) {
                        return null;
                    }
                    if (count == 6 && state == 1) {
                        urlProps.put("KBHOST", token);
                    } else if (count == 7 && token.equals(":")) {
                        state = 2;
                    } else if (count == 8 && state == 2) {
                        try {
                            Integer portNumber = Integer.decode(token);
                            urlProps.put("KBPORT", portNumber.toString());
                        }
                        catch (Exception e) {
                            return null;
                        }
                    } else if (!(count != 7 && count != 9 || state != 1 && state != 2 || !token.equals("/"))) {
                        state = -1;
                    } else if (state == -1) {
                        urlProps.put("KBDBNAME", token);
                        state = -2;
                    }
                }
            }
            ++count;
        }
        if (ipv6address != null) {
            urlProps.put("KBHOST", ipv6address);
        }
        StringTokenizer qst = new StringTokenizer(l_urlArgs, "&");
        int count2 = 0;
        while (qst.hasMoreTokens()) {
            String token = qst.nextToken();
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                urlProps.put(token, "");
            } else {
                urlProps.put(token.substring(0, l_pos), token.substring(l_pos + 1));
            }
            ++count2;
        }
        return urlProps;
    }

    public String host() {
        return this.props.getProperty("KBHOST", "localhost");
    }

    public int port() {
        return Integer.parseInt(this.props.getProperty("KBPORT", "54321"));
    }

    public String database() {
        return this.props.getProperty("KBDBNAME", "");
    }

    public String property(String name) {
        return this.props.getProperty(name);
    }

    public static SQLException notImplemented() {
        return new KSQLException("kingbase.unimplemented");
    }

    public static void debug(String msg, boolean isLine) {
        if (isDebug) {
            if (isLine) {
                Driver.debug(msg);
            } else {
                logStream.print(msg);
            }
        }
    }

    public static void debug(String msg) {
        if (isDebug && logStream != null) {
            logStream.println(msg);
        }
    }

    public static void debug(String msg, Exception ex) {
        if (isDebug) {
            logStream.println(msg);
            if (ex != null) {
                logStream.println(ex.toString());
            }
        }
    }

    public static void makeSSL(KB_Stream p_stream) throws IOException {
    }

    public static boolean sslEnabled() {
        boolean l_return = false;
        return l_return;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            return;
        }
        if (args[0].equalsIgnoreCase("-v")) {
            System.out.println("KingbaseES JDBC @Copyright 2003-2005");
            System.out.println("Version V4.1.2.0040");
            System.out.println("Builded in 2005-12-06");
            System.out.println("The Version add connection argument 'ClientEncoding'!");
        }
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        protocols = new String[]{"jdbc", "kingbase"};
        m_buildNumber = 208;
    }
}

