/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.core;

import com.kingbase.core.Encoding;
import com.kingbase.util.KSQLException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.sql.SQLException;

public class KB_Stream {
    public String host;
    public int port;
    public Socket connection;
    public InputStream sys_input;
    public BufferedOutputStream sys_output;
    private byte[] byte_buf = new byte[8192];

    public KB_Stream(String p_host, int p_port) throws IOException {
        this.host = p_host;
        this.port = p_port;
        this.connection = new Socket(this.host, this.port);
        this.connection.setTcpNoDelay(true);
        this.sys_input = new BufferedInputStream(this.connection.getInputStream(), 8192);
        this.sys_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
    }

    public void SendChar(int val) throws IOException {
        this.sys_output.write((byte)val);
    }

    public void SendInteger(int val, int siz) throws IOException {
        byte[] buf = new byte[siz];
        while (siz-- > 0) {
            buf[siz] = (byte)(val & 0xFF);
            val >>= 8;
        }
        this.Send(buf);
    }

    public void SendIntegerR(int val, int siz) throws IOException {
        byte[] buf = new byte[siz];
        int i = 0;
        while (i < siz) {
            buf[i] = (byte)(val & 0xFF);
            val >>= 8;
            ++i;
        }
        this.Send(buf);
    }

    public void Send(byte[] buf) throws IOException {
        this.sys_output.write(buf);
    }

    public void Send(byte[] buf, int siz) throws IOException {
        this.Send(buf, 0, siz);
    }

    public void Send(byte[] buf, int off, int siz) throws IOException {
        this.sys_output.write(buf, off, buf.length - off < siz ? buf.length - off : siz);
        if (buf.length - off < siz) {
            int i = buf.length - off;
            while (i < siz) {
                this.sys_output.write(0);
                ++i;
            }
        }
    }

    public int ReceiveChar() throws SQLException {
        int c = 0;
        try {
            c = this.sys_input.read();
            if (c < 0) {
                throw new KSQLException("kingbase.stream.eof");
            }
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.stream.ioerror", e);
        }
        return c;
    }

    public int ReceiveInteger(int siz) throws SQLException {
        int n = 0;
        try {
            int i = 0;
            while (i < siz) {
                int b = this.sys_input.read();
                if (b < 0) {
                    throw new KSQLException("kingbase.stream.eof");
                }
                n |= b << 8 * i;
                ++i;
            }
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.stream.ioerror", e);
        }
        return n;
    }

    public int ReceiveIntegerR(int siz) throws SQLException {
        int n = 0;
        try {
            int i = 0;
            while (i < siz) {
                int b = this.sys_input.read();
                if (b < 0) {
                    throw new KSQLException("kingbase.stream.eof");
                }
                n = b | n << 8;
                ++i;
            }
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.stream.ioerror", e);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String ReceiveString(Encoding encoding) throws SQLException {
        int s = 0;
        byte[] rst = this.byte_buf;
        try {
            int buflen = rst.length;
            boolean done = false;
            block2: while (true) {
                if (done) {
                    return encoding.decode(rst, 0, s);
                }
                while (true) {
                    if (s >= buflen) continue block2;
                    int c = this.sys_input.read();
                    if (c < 0) {
                        throw new KSQLException("kingbase.stream.eof");
                    }
                    if (c == 0) {
                        rst[s] = 0;
                        done = true;
                        continue block2;
                    }
                    rst[s++] = (byte)c;
                    if (s < buflen) continue;
                    byte[] newrst = new byte[buflen *= 2];
                    System.arraycopy(rst, 0, newrst, 0, s);
                    rst = newrst;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.stream.ioerror", e);
        }
    }

    public byte[][] ReceiveTuplePV3(int nf, boolean bin) throws SQLException {
        int l_msgSize = this.ReceiveIntegerR(4);
        int l_nf = this.ReceiveIntegerR(2);
        byte[][] answer = new byte[l_nf][0];
        int i = 0;
        while (i < l_nf) {
            int l_size = this.ReceiveIntegerR(4);
            boolean isNull = l_size == -1;
            answer[i] = (byte[])(isNull ? null : this.Receive(l_size));
            ++i;
        }
        return answer;
    }

    public byte[][] ReceiveTuplePV2(int nf, boolean bin) throws SQLException {
        int bim = (nf + 7) / 8;
        byte[] bitmask = this.Receive(bim);
        byte[][] answer = new byte[nf][0];
        int whichbit = 128;
        int whichbyte = 0;
        int i = 0;
        while (i < nf) {
            boolean isNull;
            boolean bl = isNull = (bitmask[whichbyte] & whichbit) == 0;
            if ((whichbit >>= 1) == 0) {
                ++whichbyte;
                whichbit = 128;
            }
            if (isNull) {
                answer[i] = null;
            } else {
                int len = this.ReceiveIntegerR(4);
                if (!bin) {
                    len -= 4;
                }
                if (len < 0) {
                    len = 0;
                }
                answer[i] = this.Receive(len);
            }
            ++i;
        }
        return answer;
    }

    public byte[] Receive(int siz) throws SQLException {
        byte[] answer = new byte[siz];
        this.Receive(answer, 0, siz);
        return answer;
    }

    public void Receive(byte[] b, int off, int siz) throws SQLException {
        int s = 0;
        try {
            while (s < siz) {
                int w = this.sys_input.read(b, off + s, siz - s);
                if (w < 0) {
                    throw new KSQLException("kingbase.stream.eof");
                }
                s += w;
            }
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.stream.ioerror", e);
        }
    }

    public void flush() throws SQLException {
        try {
            this.sys_output.flush();
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.stream.flush", e);
        }
    }

    public void close() throws IOException {
        this.sys_output.close();
        this.sys_input.close();
        this.connection.close();
        this.byte_buf = null;
        this.sys_output = null;
        this.sys_input = null;
        this.connection = null;
    }

    public boolean isAvailbleData() throws IOException {
        return this.sys_input.available() > 0;
    }
}

