/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.core;

import com.kingbase.Driver;
import com.kingbase.core.BaseConnection;
import com.kingbase.core.BaseResultSet;
import com.kingbase.core.BaseStatement;
import com.kingbase.core.Encoding;
import com.kingbase.core.Field;
import com.kingbase.core.KB_Stream;
import com.kingbase.core.Notification;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.jdbc1.AbstractJdbc1ResultSet;
import com.kingbase.jdbc1.AbstractJdbc1Statement;
import com.kingbase.jdbc1.Parameter;
import com.kingbase.jdbc3.Jdbc3PreparedStatement;
import com.kingbase.util.CachedResultSet;
import com.kingbase.util.KBTypeInfo;
import com.kingbase.util.KSQLException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class QueryExecutor {
    private String[] m_sqlFrags;
    private Object[] m_binds;
    private BaseStatement statement;
    private BaseResultSet rs;
    private BaseConnection connection;
    private KB_Stream KB_Stream;
    private Field[] fields = null;
    private Vector tuples = new Vector();
    private boolean binaryCursor = false;
    private String status = null;
    private int update_count = 1;
    private long insert_oid = 0L;
    private int maxRows;
    private int fetchPosition = 0;

    public static BaseResultSet execute(String[] p_sqlFrags, Object[] p_binds, BaseStatement statement) throws SQLException {
        QueryExecutor qe = new QueryExecutor();
        qe.m_sqlFrags = p_sqlFrags;
        qe.m_binds = p_binds;
        qe.statement = statement;
        qe.maxRows = statement != null ? statement.getMaxRows() : 0;
        qe.connection = statement.getKBConnection();
        qe.KB_Stream = qe.connection.getKBStream();
        return qe.execute();
    }

    public static void execute(String[] p_sqlFrags, Object[] p_binds, BaseResultSet rs) throws SQLException {
        QueryExecutor qe = new QueryExecutor();
        qe.m_sqlFrags = p_sqlFrags;
        qe.m_binds = p_binds;
        qe.rs = rs;
        qe.statement = qe.rs.getKBStatement();
        qe.maxRows = qe.statement != null ? qe.statement.getMaxRows() : 0;
        qe.connection = qe.statement.getKBConnection();
        qe.KB_Stream = qe.connection.getKBStream();
        qe.execute();
    }

    private BaseResultSet execute() throws SQLException {
        if (Driver.isDebug) {
            if (this.m_binds != null && this.m_binds.length > 0) {
                Driver.debug("SQL : ", false);
                int i = 0;
                while (i < this.m_binds.length) {
                    Driver.debug(this.m_sqlFrags[i], false);
                    Driver.debug(this.m_binds[i].toString(), false);
                    ++i;
                }
                Driver.debug(this.m_sqlFrags[i], false);
                Driver.debug("");
            } else {
                Driver.debug("SQL : " + this.m_sqlFrags[0]);
            }
        }
        if (((AbstractJdbc1Connection)this.connection).getKBProtocolVersion() >= 30000) {
            if (Driver.isDebug) {
                Driver.debug("Using Protocol Version " + ((AbstractJdbc1Connection)this.connection).getKBProtocolVersionMajor() + "." + ((AbstractJdbc1Connection)this.connection).getKBProtocolVersionMinor() + " to send query");
            }
            return this.executePV3();
        }
        if (Driver.isDebug) {
            Driver.debug("Using Protocol Version " + ((AbstractJdbc1Connection)this.connection).getKBProtocolVersionMajor() + "." + ((AbstractJdbc1Connection)this.connection).getKBProtocolVersionMinor() + " to send query");
        }
        return this.executePV2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private BaseResultSet executePV3() throws SQLException {
        StringBuffer errorMessage = null;
        String sqlState = null;
        if (this.KB_Stream == null) {
            throw new KSQLException("kingbase.con.closed");
        }
        KB_Stream kB_Stream = this.KB_Stream;
        synchronized (kB_Stream) {
            this.sendQueryPV3();
            boolean l_endQuery = false;
            block16: while (!l_endQuery) {
                int c = this.KB_Stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.KB_Stream.ReceiveInteger(4);
                        String msg = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                        this.connection.addNotification(new Notification(msg, pid));
                        break;
                    }
                    case 66: {
                        this.receiveTuplePV3(true);
                        break;
                    }
                    case 67: {
                        this.receiveCommandStatusPV3();
                        break;
                    }
                    case 68: {
                        this.receiveTuplePV3(false);
                        break;
                    }
                    case 69: {
                        int ch;
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        int l_elen = this.KB_Stream.ReceiveIntegerR(4);
                        l_elen -= 4;
                        while ((ch = this.KB_Stream.ReceiveChar()) != 0 && l_elen > 0) {
                            void var9_11;
                            String s = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                            l_elen = s != null && s.length() > 0 ? l_elen - 1 - s.length() : --l_elen;
                            if (var9_11 == 77) {
                                errorMessage.append(s);
                                continue;
                            }
                            if (var9_11 == 67) {
                                sqlState = s;
                                continue;
                            }
                            if (var9_11 != 72) continue;
                            errorMessage.append(". ");
                            errorMessage.append(s);
                        }
                        continue block16;
                    }
                    case 73: {
                        int l_nle = this.KB_Stream.ReceiveIntegerR(4);
                        this.KB_Stream.Receive(l_nle - 4);
                        break;
                    }
                    case 78: {
                        int l_nlen = this.KB_Stream.ReceiveIntegerR(4);
                        this.statement.addWarning(this.connection.getEncoding().decode(this.KB_Stream.Receive(l_nlen - 4)));
                        break;
                    }
                    case 80: {
                        String pname = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                        break;
                    }
                    case 83: {
                        int l_len = this.KB_Stream.ReceiveIntegerR(4);
                        String l_pStatus = this.connection.getEncoding().decode(this.KB_Stream.Receive(l_len - 4));
                        if (!Driver.isDebug) continue block16;
                        Driver.debug("ParameterStatus=" + l_pStatus);
                        break;
                    }
                    case 84: {
                        if (((AbstractJdbc1Connection)this.connection).getKBProtocolVersion() >= 30100) {
                            this.receiveFieldsPV31();
                            break;
                        }
                        this.receiveFieldsPV3();
                        break;
                    }
                    case 90: {
                        if (this.KB_Stream.ReceiveIntegerR(4) != 5) {
                            throw new KSQLException("kingbase.con.setup");
                        }
                        char l_tStatus = (char)this.KB_Stream.ReceiveChar();
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new KSQLException("kingbase.con.type", new Character((char)c));
                    }
                }
            }
            if (errorMessage != null) {
                String message = errorMessage.toString();
                int errCode = 0;
                if (this.connection.getIsBegin() && (((AbstractJdbc1Connection)this.connection).getKBProtocolVersion() == 30100 || !((AbstractJdbc1Connection)this.connection).getEnableSavepoint())) {
                    this.connection.execSQL("rollback");
                }
                throw new SQLException("[KingbaseES Server]" + message, sqlState, errCode);
            }
            if (this.rs != null) {
                this.rs.reInit(this.fields, this.tuples, this.status, this.update_count, this.insert_oid, this.binaryCursor);
            } else {
                this.rs = this.statement.createResultSet(this.fields, this.tuples, this.status, this.update_count, this.insert_oid, this.binaryCursor);
                if (this.connection.getIsSaveResultSet() && this.statement instanceof Jdbc3PreparedStatement && ((AbstractJdbc1ResultSet)this.rs).reallyResultSet()) {
                    CachedResultSet.addResultSetCached((Statement)((Object)this.statement), ((Jdbc3PreparedStatement)this.statement).getPreparedSQL(), this.m_binds, this.fields, this.tuples, this.binaryCursor);
                }
            }
            this.rs.setFetchPosition(this.fetchPosition);
            return this.rs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseResultSet executePV2() throws SQLException {
        StringBuffer errorMessage = null;
        if (this.KB_Stream == null) {
            throw new KSQLException("kingbase.con.closed");
        }
        KB_Stream kB_Stream = this.KB_Stream;
        synchronized (kB_Stream) {
            this.sendQueryPV2();
            boolean l_endQuery = false;
            while (!l_endQuery) {
                int c = this.KB_Stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.KB_Stream.ReceiveInteger(4);
                        String msg = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                        this.connection.addNotification(new Notification(msg, pid));
                        break;
                    }
                    case 66: {
                        this.receiveTuplePV2(true);
                        break;
                    }
                    case 67: {
                        this.receiveCommandStatusPV2();
                        break;
                    }
                    case 68: {
                        this.receiveTuplePV2(false);
                        break;
                    }
                    case 69: {
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        errorMessage.append(this.KB_Stream.ReceiveString(this.connection.getEncoding()));
                        break;
                    }
                    case 73: {
                        int t = this.KB_Stream.ReceiveChar();
                        break;
                    }
                    case 78: {
                        this.statement.addWarning(this.KB_Stream.ReceiveString(this.connection.getEncoding()));
                        break;
                    }
                    case 80: {
                        String pname = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                        break;
                    }
                    case 84: {
                        this.receiveFieldsPV2();
                        break;
                    }
                    case 90: {
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new KSQLException("kingbase.con.type", new Character((char)c));
                    }
                }
            }
            if (errorMessage != null) {
                String message = errorMessage.toString();
                String sqlState = message.substring(0, 5);
                int errCode = 0;
                throw new SQLException("[KingbaseES Server]" + message, sqlState, errCode);
            }
            if (this.rs != null) {
                this.rs.reInit(this.fields, this.tuples, this.status, this.update_count, this.insert_oid, this.binaryCursor);
            } else {
                this.rs = this.statement.createResultSet(this.fields, this.tuples, this.status, this.update_count, this.insert_oid, this.binaryCursor);
            }
            return this.rs;
        }
    }

    private void sendQueryPV3() throws SQLException {
        int i = 0;
        while (i < this.m_binds.length) {
            if (this.m_binds[i] == null) {
                throw new KSQLException("kingbase.prep.param", new Integer(i + 1));
            }
            ++i;
        }
        try {
            byte[][] l_parts = new byte[this.m_binds.length * 2 + 1][];
            int j = 0;
            int l_msgSize = 4;
            Encoding l_encoding = this.connection.getEncoding();
            this.KB_Stream.SendChar(81);
            int i2 = 0;
            while (i2 < this.m_binds.length) {
                l_parts[j] = l_encoding.encode(this.m_sqlFrags[i2]);
                l_msgSize += l_parts[j].length;
                l_parts[++j] = l_encoding.encode(this.m_binds[i2].toString());
                l_msgSize += l_parts[j].length;
                ++j;
                ++i2;
            }
            l_parts[j] = l_encoding.encode(this.m_sqlFrags[this.m_binds.length]);
            l_msgSize += l_parts[j].length;
            if (!(this.connection.getAutoCommit() || this.connection.getIsBegin() || l_parts.length < 1 || this.m_sqlFrags[0].equalsIgnoreCase("begin") || this.m_sqlFrags[0].equalsIgnoreCase("begin;"))) {
                this.sendBeginMessage();
                this.KB_Stream.SendChar(81);
            }
            this.KB_Stream.SendInteger(l_msgSize + 1, 4);
            int k = 0;
            while (k < l_parts.length) {
                this.KB_Stream.Send(l_parts[k]);
                ++k;
            }
            this.KB_Stream.SendChar(0);
            this.KB_Stream.flush();
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.con.ioerror", e);
        }
    }

    private void sendQueryPV2() throws SQLException {
        int i = 0;
        while (i < this.m_binds.length) {
            if (this.m_binds[i] == null) {
                throw new KSQLException("kingbase.prep.param", new Integer(i + 1));
            }
            ++i;
        }
        try {
            this.KB_Stream.SendChar(81);
            int i2 = 0;
            while (i2 < this.m_binds.length) {
                this.KB_Stream.Send(this.connection.getEncoding().encode(this.m_sqlFrags[i2]));
                this.KB_Stream.Send(this.connection.getEncoding().encode(this.m_binds[i2].toString()));
                ++i2;
            }
            if (!(this.connection.getAutoCommit() || this.connection.getIsBegin() || this.m_sqlFrags[0].equalsIgnoreCase("begin") || this.m_sqlFrags[0].equalsIgnoreCase("begin;"))) {
                this.sendBeginMessagePV2();
                this.KB_Stream.SendChar(81);
            }
            this.KB_Stream.Send(this.connection.getEncoding().encode(this.m_sqlFrags[this.m_binds.length]));
            this.KB_Stream.SendChar(0);
            this.KB_Stream.flush();
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.con.ioerror", e);
        }
    }

    private void receiveTuplePV3(boolean isBinary) throws SQLException {
        if (this.fields == null) {
            throw new KSQLException("kingbase.con.tuple");
        }
        byte[][] tuple = this.KB_Stream.ReceiveTuplePV3(this.fields.length, isBinary);
        if (isBinary) {
            this.binaryCursor = true;
        }
        if (this.maxRows == 0 || this.tuples.size() < this.maxRows) {
            this.tuples.addElement(tuple);
        }
    }

    private void receiveTuplePV2(boolean isBinary) throws SQLException {
        if (this.fields == null) {
            throw new KSQLException("kingbase.con.tuple");
        }
        byte[][] tuple = this.KB_Stream.ReceiveTuplePV2(this.fields.length, isBinary);
        if (isBinary) {
            this.binaryCursor = true;
        }
        if (this.maxRows == 0 || this.tuples.size() < this.maxRows) {
            this.tuples.addElement(tuple);
        }
    }

    private void receiveCommandStatusPV3() throws SQLException {
        int l_len = this.KB_Stream.ReceiveIntegerR(4);
        this.status = this.connection.getEncoding().decode(this.KB_Stream.Receive(l_len - 5));
        this.KB_Stream.Receive(1);
        try {
            String[] temp;
            if (this.status.startsWith("INSERT") || this.status.startsWith("UPDATE") || this.status.startsWith("DELETE") || this.status.startsWith("MOVE")) {
                this.update_count = Integer.parseInt(this.status.substring(1 + this.status.lastIndexOf(32)));
            }
            if (this.status.startsWith("EXECUTE INSERT") || this.status.startsWith("EXECUTE UPDATE") || this.status.startsWith("EXECUTE DELETE")) {
                this.update_count = Integer.parseInt(this.status.substring(1 + this.status.lastIndexOf(32)));
                if (this.status.startsWith("EXECUTE INSERT")) {
                    int begin = "EXECUTE INSERT".length() + 1;
                    int end = this.status.lastIndexOf(32);
                    this.insert_oid = Long.parseLong(this.status.substring(begin, end));
                }
            }
            if (this.status.startsWith("INSERT")) {
                this.insert_oid = Long.parseLong(this.status.substring(1 + this.status.indexOf(32), this.status.lastIndexOf(32)));
            }
            if (this.status.startsWith("BEGIN")) {
                this.connection.setIsBegin(true);
            }
            if ((this.status.startsWith("COMMIT") || this.status.startsWith("ROLLBACK")) && !this.status.startsWith("ROLLBACK TO SAVEPOINT")) {
                this.connection.setIsBegin(false);
            }
            if ((this.status.startsWith("FETCH") || this.status.startsWith("MOVE")) && (temp = this.status.split(" ")).length == 3) {
                this.fetchPosition = Integer.parseInt(temp[2]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new KSQLException("kingbase.con.fathom", (Object)this.status);
        }
    }

    private void receiveCommandStatusPV2() throws SQLException {
        this.status = this.KB_Stream.ReceiveString(this.connection.getEncoding());
        try {
            if (this.status.startsWith("INSERT") || this.status.startsWith("UPDATE") || this.status.startsWith("DELETE") || this.status.startsWith("MOVE")) {
                this.update_count = Integer.parseInt(this.status.substring(1 + this.status.lastIndexOf(32)));
            }
            if (this.status.startsWith("EXECUTE INSERT") || this.status.startsWith("EXECUTE UPDATE") || this.status.startsWith("EXECUTE DELETE")) {
                this.update_count = Integer.parseInt(this.status.substring(1 + this.status.lastIndexOf(32)));
            }
            if (this.status.startsWith("INSERT")) {
                this.insert_oid = Long.parseLong(this.status.substring(1 + this.status.indexOf(32), this.status.lastIndexOf(32)));
            }
            if (this.status.startsWith("BEGIN")) {
                this.connection.setIsBegin(true);
            }
            if ((this.status.startsWith("COMMIT") || this.status.startsWith("ROLLBACK")) && !this.status.startsWith("ROLLBACK TO SAVEPOINT")) {
                this.connection.setIsBegin(false);
            }
        }
        catch (NumberFormatException nfe) {
            throw new KSQLException("kingbase.con.fathom", (Object)this.status);
        }
    }

    private void receiveFieldsPV31() throws SQLException {
        this.tuples.clear();
        int l_msgSize = this.KB_Stream.ReceiveIntegerR(4);
        int size = this.KB_Stream.ReceiveIntegerR(2);
        this.fields = new Field[size];
        int i = 0;
        while (i < this.fields.length) {
            String typeName = this.KB_Stream.ReceiveString(this.connection.getEncoding());
            int tableOid = this.KB_Stream.ReceiveIntegerR(4);
            int tablePosition = this.KB_Stream.ReceiveIntegerR(2);
            int typeOid = this.KB_Stream.ReceiveIntegerR(4);
            int typeLength = this.KB_Stream.ReceiveIntegerR(2);
            int typeModifier = this.KB_Stream.ReceiveIntegerR(4);
            int typeNotNull = this.KB_Stream.ReceiveIntegerR(1);
            int formatType = this.KB_Stream.ReceiveIntegerR(2);
            this.fields[i] = new Field(this.connection, typeName, typeOid, typeLength, typeModifier);
            ++i;
        }
    }

    private void receiveFieldsPV3() throws SQLException {
        this.tuples.clear();
        int l_msgSize = this.KB_Stream.ReceiveIntegerR(4);
        int size = this.KB_Stream.ReceiveIntegerR(2);
        this.fields = new Field[size];
        int i = 0;
        while (i < this.fields.length) {
            String typeName = this.KB_Stream.ReceiveString(this.connection.getEncoding());
            int tableOid = this.KB_Stream.ReceiveIntegerR(4);
            int tablePosition = this.KB_Stream.ReceiveIntegerR(2);
            int typeOid = this.KB_Stream.ReceiveIntegerR(4);
            int typeLength = this.KB_Stream.ReceiveIntegerR(2);
            int typeModifier = this.KB_Stream.ReceiveIntegerR(4);
            int formatType = this.KB_Stream.ReceiveIntegerR(2);
            this.fields[i] = new Field(this.connection, typeName, typeOid, typeLength, typeModifier);
            ++i;
        }
    }

    private void receiveFieldsPV2() throws SQLException {
        this.tuples.clear();
        if (this.fields != null) {
            throw new KSQLException("kingbase.con.multres");
        }
        int size = this.KB_Stream.ReceiveIntegerR(2);
        this.fields = new Field[size];
        int i = 0;
        while (i < this.fields.length) {
            String typeName = this.KB_Stream.ReceiveString(this.connection.getEncoding());
            int typeOid = this.KB_Stream.ReceiveIntegerR(4);
            int typeLength = this.KB_Stream.ReceiveIntegerR(2);
            int typeModifier = this.KB_Stream.ReceiveIntegerR(4);
            this.fields[i] = new Field(this.connection, typeName, typeOid, typeLength, typeModifier);
            ++i;
        }
    }

    public static void getParameterMetaData(BaseStatement statement) throws SQLException {
        QueryExecutor qe = new QueryExecutor();
        qe.statement = statement;
        qe.connection = statement.getKBConnection();
        qe.KB_Stream = qe.connection.getKBStream();
        qe.receiveParameterMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveParameterMetaData() throws SQLException {
        KB_Stream kB_Stream = this.KB_Stream;
        synchronized (kB_Stream) {
            try {
                StringBuffer errorMessage = null;
                boolean l_endReceiveMetaData = false;
                Encoding l_encoding = this.connection.getEncoding();
                byte[] bStatementName = l_encoding.encode(this.statement.getStatementName());
                String sqlState = null;
                int parameterNumber = 0;
                Parameter[] parameter = ((AbstractJdbc1Statement)this.statement).getParameter();
                this.KB_Stream.SendChar(68);
                this.KB_Stream.SendInteger(bStatementName.length + 6, 4);
                this.KB_Stream.SendChar(83);
                this.KB_Stream.Send(bStatementName);
                this.KB_Stream.SendChar(0);
                this.KB_Stream.SendChar(83);
                this.KB_Stream.SendInteger(4, 4);
                this.KB_Stream.flush();
                block22: while (!l_endReceiveMetaData) {
                    int c = this.KB_Stream.ReceiveChar();
                    switch (c) {
                        case 110: {
                            int l_size = this.KB_Stream.ReceiveIntegerR(4);
                            break;
                        }
                        case 116: {
                            int typeNotNull;
                            int l_msgSize = this.KB_Stream.ReceiveIntegerR(4);
                            parameterNumber = this.KB_Stream.ReceiveIntegerR(2);
                            int i = 0;
                            while (i < parameterNumber) {
                                int typeOID = this.KB_Stream.ReceiveIntegerR(4);
                                int typeModifier = 0;
                                typeNotNull = 0;
                                if (this.connection.getDatabaseVersion() >= 40100) {
                                    typeModifier = this.KB_Stream.ReceiveIntegerR(4);
                                    typeNotNull = this.KB_Stream.ReceiveIntegerR(1);
                                }
                                parameter[i].parSQLType = typeOID;
                                parameter[i].parPrecision = typeModifier;
                                parameter[i].nullable = typeNotNull;
                                ++i;
                            }
                            continue block22;
                        }
                        case 84: {
                            this.receiveFieldsPV31();
                            break;
                        }
                        case 78: {
                            int l_nlen = this.KB_Stream.ReceiveIntegerR(4);
                            this.statement.addWarning(this.connection.getEncoding().decode(this.KB_Stream.Receive(l_nlen - 4)));
                            break;
                        }
                        case 69: {
                            int ch;
                            int typeNotNull;
                            if (errorMessage == null) {
                                errorMessage = new StringBuffer();
                            }
                            int l_elen = this.KB_Stream.ReceiveIntegerR(4);
                            l_elen -= 4;
                            while ((ch = this.KB_Stream.ReceiveChar()) != 0 && l_elen > 0) {
                                String s = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                                l_elen = s != null && s.length() > 0 ? l_elen - 1 - s.length() : --l_elen;
                                if (typeNotNull == 77) {
                                    errorMessage.append(s);
                                    continue;
                                }
                                if (typeNotNull != 67) continue;
                                sqlState = s;
                            }
                            continue block22;
                        }
                        case 90: {
                            if (this.KB_Stream.ReceiveIntegerR(4) != 5) {
                                throw new KSQLException("kingbase.con.setup");
                            }
                            char l_tStatus = (char)this.KB_Stream.ReceiveChar();
                            l_endReceiveMetaData = true;
                            break;
                        }
                        default: {
                            throw new KSQLException("kingbase.con.type", new Character((char)c));
                        }
                    }
                }
                if (errorMessage != null) {
                    String message = errorMessage.toString();
                    int errCode = 0;
                    throw new SQLException("[KingbaseES Server]" + message, sqlState, errCode);
                }
                if (parameterNumber > 0) {
                    int i = 0;
                    while (i < parameterNumber) {
                        int typeOID = parameter[i].parSQLType;
                        int typeModifier = parameter[i].parPrecision;
                        int typeNotNull = parameter[i].nullable;
                        String pgType = this.connection.getPGType(typeOID);
                        int sqlType = this.connection.getSQLType(typeOID);
                        if ((pgType = KBTypeInfo.getDatabaseTypeName(typeOID, typeModifier, (Connection)((Object)this.connection), pgType)).equalsIgnoreCase("TEXT")) {
                            pgType = "LONGVARCHAR";
                        } else if (pgType.equalsIgnoreCase("BYTEA")) {
                            pgType = "VARBINARY";
                        }
                        parameter[i].parIOType = 1;
                        parameter[i].parSQLType = sqlType;
                        parameter[i].parSYSTypeName = pgType;
                        parameter[i].colName = null;
                        parameter[i].nullable = typeNotNull > 0 ? 0 : 1;
                        parameter[i].parScale = 0;
                        parameter[i].parPrecision = 0;
                        switch (sqlType) {
                            case -6: {
                                parameter[i].parPrecision = 3;
                                parameter[i].parScale = 0;
                                break;
                            }
                            case 2: 
                            case 3: {
                                int attypmod = typeModifier - 4;
                                parameter[i].parPrecision = attypmod >> 16 & 0xFFFF;
                                parameter[i].parScale = attypmod & 0xFFFF;
                                break;
                            }
                            case 5: {
                                parameter[i].parPrecision = 5;
                                parameter[i].parScale = 0;
                                break;
                            }
                            case 4: {
                                parameter[i].parPrecision = 10;
                                parameter[i].parScale = 0;
                                break;
                            }
                            case -5: {
                                parameter[i].parPrecision = 19;
                                parameter[i].parScale = 0;
                                break;
                            }
                            case 7: {
                                parameter[i].parPrecision = 7;
                                parameter[i].parScale = 0;
                                break;
                            }
                            case 8: {
                                parameter[i].parPrecision = 15;
                                parameter[i].parScale = 0;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                throw new KSQLException("kingbase.con.ioerror", e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendBeginMessage() throws SQLException {
        StringBuffer errorMessage = null;
        String sqlState = null;
        try {
            Encoding l_encoding = this.connection.getEncoding();
            this.KB_Stream.SendInteger(11, 4);
            this.KB_Stream.Send(l_encoding.encode("begin;"));
            this.KB_Stream.SendChar(0);
            this.KB_Stream.flush();
            boolean l_endQuery = false;
            block15: while (!l_endQuery) {
                int c = this.KB_Stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.KB_Stream.ReceiveInteger(4);
                        String msg = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                        this.connection.addNotification(new Notification(msg, pid));
                        break;
                    }
                    case 66: {
                        this.receiveTuplePV3(true);
                        break;
                    }
                    case 67: {
                        this.receiveCommandStatusPV3();
                        break;
                    }
                    case 68: {
                        this.receiveTuplePV3(false);
                        break;
                    }
                    case 69: {
                        int ch;
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        int l_elen = this.KB_Stream.ReceiveIntegerR(4);
                        l_elen -= 4;
                        while ((ch = this.KB_Stream.ReceiveChar()) != 0 && l_elen > 0) {
                            void var9_11;
                            String s = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                            l_elen = s != null && s.length() > 0 ? l_elen - 1 - s.length() : --l_elen;
                            if (var9_11 == 77) {
                                errorMessage.append(s);
                                continue;
                            }
                            if (var9_11 != 67) continue;
                            sqlState = s;
                        }
                        continue block15;
                    }
                    case 73: {
                        int t = this.KB_Stream.ReceiveChar();
                        break;
                    }
                    case 78: {
                        int l_nlen = this.KB_Stream.ReceiveIntegerR(4);
                        this.statement.addWarning(this.connection.getEncoding().decode(this.KB_Stream.Receive(l_nlen - 4)));
                        break;
                    }
                    case 80: {
                        String pname = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                        break;
                    }
                    case 83: {
                        int l_len = this.KB_Stream.ReceiveIntegerR(4);
                        String l_pStatus = this.connection.getEncoding().decode(this.KB_Stream.Receive(l_len - 4));
                        if (!Driver.isDebug) continue block15;
                        Driver.debug("ParameterStatus=" + l_pStatus);
                        break;
                    }
                    case 84: {
                        if (((AbstractJdbc1Connection)this.connection).getKBProtocolVersion() >= 30100) {
                            this.receiveFieldsPV31();
                            break;
                        }
                        this.receiveFieldsPV3();
                        break;
                    }
                    case 90: {
                        if (this.KB_Stream.ReceiveIntegerR(4) != 5) {
                            throw new KSQLException("kingbase.con.setup");
                        }
                        char l_tStatus = (char)this.KB_Stream.ReceiveChar();
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new KSQLException("kingbase.con.type", new Character((char)c));
                    }
                }
            }
            if (errorMessage != null) {
                String message = errorMessage.toString();
                int errCode = 0;
                throw new SQLException("[Kingbase Server]" + message, sqlState, errCode);
            }
        }
        catch (Exception e) {
            throw new KSQLException("kingbase.con.ioerror", e);
        }
    }

    private void sendBeginMessagePV2() throws SQLException {
        StringBuffer errorMessage = null;
        String sqlState = null;
        try {
            Encoding l_encoding = this.connection.getEncoding();
            this.KB_Stream.Send(l_encoding.encode("begin;"));
            this.KB_Stream.SendChar(0);
            this.KB_Stream.flush();
            if (Driver.isDebug) {
                Driver.debug("SQL: BEGIN;");
            }
            boolean l_endQuery = false;
            while (!l_endQuery) {
                int c = this.KB_Stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.KB_Stream.ReceiveInteger(4);
                        String msg = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                        this.connection.addNotification(new Notification(msg, pid));
                        break;
                    }
                    case 66: {
                        this.receiveTuplePV2(true);
                        break;
                    }
                    case 67: {
                        this.receiveCommandStatusPV2();
                        break;
                    }
                    case 68: {
                        this.receiveTuplePV2(false);
                        break;
                    }
                    case 69: {
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        errorMessage.append(this.KB_Stream.ReceiveString(this.connection.getEncoding()));
                        break;
                    }
                    case 73: {
                        int t = this.KB_Stream.ReceiveChar();
                        break;
                    }
                    case 78: {
                        this.statement.addWarning(this.KB_Stream.ReceiveString(this.connection.getEncoding()));
                        break;
                    }
                    case 80: {
                        String pname = this.KB_Stream.ReceiveString(this.connection.getEncoding());
                        break;
                    }
                    case 84: {
                        this.receiveFieldsPV2();
                        break;
                    }
                    case 90: {
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new KSQLException("kingbase.con.type", new Character((char)c));
                    }
                }
            }
            if (errorMessage != null) {
                String message = errorMessage.toString();
                int errCode = 0;
                throw new SQLException("[Kingbase Server]" + message, sqlState, errCode);
            }
        }
        catch (Exception e) {
            throw new KSQLException("kingbase.con.ioerror", e);
        }
    }
}

