/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.fastpath;

import com.kingbase.Driver;
import com.kingbase.core.BaseConnection;
import com.kingbase.core.KB_Stream;
import com.kingbase.core.Notification;
import com.kingbase.fastpath.FastpathArg;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.util.KSQLException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;

public class Fastpath {
    protected static Hashtable func = new Hashtable();
    protected BaseConnection conn;
    protected KB_Stream stream;

    public Fastpath(BaseConnection conn, KB_Stream stream) {
        this.conn = conn;
        this.stream = stream;
    }

    public Object fastpath(int fnid, boolean resulttype, FastpathArg[] args) throws SQLException {
        if (((AbstractJdbc1Connection)this.conn).getKBProtocolVersion() >= 30000) {
            return this.fastpathV3(fnid, resulttype, args);
        }
        return this.fastpathV2(fnid, resulttype, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Object fastpathV3(int fnid, boolean resulttype, FastpathArg[] args) throws SQLException {
        KB_Stream kB_Stream = this.stream;
        synchronized (kB_Stream) {
            try {
                int l_msgLen = 0;
                l_msgLen += 16;
                int i = 0;
                while (i < args.length) {
                    l_msgLen += args[i].sendSize();
                    ++i;
                }
                this.stream.SendChar(70);
                this.stream.SendInteger(l_msgLen, 4);
                this.stream.SendInteger(fnid, 4);
                this.stream.SendInteger(1, 2);
                this.stream.SendInteger(1, 2);
                this.stream.SendInteger(args.length, 2);
                int i2 = 0;
                while (i2 < args.length) {
                    args[i2].send(this.stream);
                    ++i2;
                }
                this.stream.SendInteger(1, 2);
                this.stream.flush();
            }
            catch (IOException ioe) {
                throw new KSQLException("kingbase.fp.send", new Integer(fnid), (Object)ioe);
            }
            Object result = null;
            StringBuffer errorMessage = null;
            boolean l_endQuery = false;
            block14: while (!l_endQuery) {
                int c = this.stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.stream.ReceiveInteger(4);
                        String msg = this.stream.ReceiveString(this.conn.getEncoding());
                        this.conn.addNotification(new Notification(msg, pid));
                        break;
                    }
                    case 69: {
                        int ch;
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        int l_elen = this.stream.ReceiveIntegerR(4);
                        l_elen -= 4;
                        while ((ch = this.stream.ReceiveChar()) != 0 && l_elen > 0) {
                            void var12_15;
                            String s = this.stream.ReceiveString(this.conn.getEncoding());
                            l_elen = s != null && s.length() > 0 ? l_elen - 1 - s.length() : --l_elen;
                            if (var12_15 == 77) {
                                errorMessage.append(s);
                                continue;
                            }
                            if (var12_15 != 72) continue;
                            errorMessage.append(". ");
                            errorMessage.append(s);
                        }
                        continue block14;
                    }
                    case 78: {
                        int l_nlen = this.stream.ReceiveIntegerR(4);
                        this.conn.addWarning(this.conn.getEncoding().decode(this.stream.Receive(l_nlen - 4)));
                        break;
                    }
                    case 86: {
                        int l_msgLen = this.stream.ReceiveIntegerR(4);
                        int l_valueLen = this.stream.ReceiveIntegerR(4);
                        if (l_valueLen == -1) continue block14;
                        if (l_valueLen == 0) {
                            result = new byte[]{};
                            break;
                        }
                        if (resulttype) {
                            result = new Integer(this.stream.ReceiveIntegerR(l_valueLen));
                            break;
                        }
                        byte[] buf = new byte[l_valueLen];
                        this.stream.Receive(buf, 0, l_valueLen);
                        result = buf;
                        break;
                    }
                    case 90: {
                        if (this.stream.ReceiveIntegerR(4) != 5) {
                            throw new KSQLException("kingbase.con.setup");
                        }
                        char l_tStatus = (char)this.stream.ReceiveChar();
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new KSQLException("kingbase.fp.protocol", new Character((char)c));
                    }
                }
            }
            if (errorMessage != null) {
                throw new KSQLException("kingbase.fp.error", (Object)errorMessage.toString());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fastpathV2(int fnid, boolean resulttype, FastpathArg[] args) throws SQLException {
        KB_Stream kB_Stream = this.stream;
        synchronized (kB_Stream) {
            try {
                this.stream.SendInteger(70, 1);
                this.stream.SendInteger(0, 1);
                this.stream.SendInteger(fnid, 4);
                this.stream.SendInteger(args.length, 4);
                int i = 0;
                while (i < args.length) {
                    args[i].send(this.stream);
                    ++i;
                }
                this.stream.flush();
            }
            catch (IOException ioe) {
                throw new KSQLException("kingbase.fp.send", new Integer(fnid), (Object)ioe);
            }
            Object result = null;
            StringBuffer errorMessage = null;
            boolean l_endQuery = false;
            block13: while (!l_endQuery) {
                int c = this.stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.stream.ReceiveInteger(4);
                        String msg = this.stream.ReceiveString(this.conn.getEncoding());
                        break;
                    }
                    case 69: {
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        errorMessage.append(this.stream.ReceiveString(this.conn.getEncoding()));
                        break;
                    }
                    case 78: {
                        this.conn.addWarning(this.stream.ReceiveString(this.conn.getEncoding()));
                        break;
                    }
                    case 86: {
                        int l_nextChar = this.stream.ReceiveChar();
                        if (l_nextChar != 71) continue block13;
                        int sz = this.stream.ReceiveIntegerR(4);
                        if (resulttype) {
                            result = new Integer(this.stream.ReceiveIntegerR(sz));
                        } else {
                            byte[] buf = new byte[sz];
                            this.stream.Receive(buf, 0, sz);
                            result = buf;
                        }
                        int l_endChar = this.stream.ReceiveChar();
                        break;
                    }
                    case 90: {
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new KSQLException("kingbase.fp.protocol", new Character((char)c));
                    }
                }
            }
            if (errorMessage != null) {
                throw new KSQLException("kingbase.fp.error", (Object)errorMessage.toString());
            }
            return result;
        }
    }

    public Object fastpath(String name, boolean resulttype, FastpathArg[] args) throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("Fastpath: calling " + name);
        }
        return this.fastpath(this.getID(name), resulttype, args);
    }

    public int getInteger(String name, FastpathArg[] args) throws SQLException {
        Integer i = (Integer)this.fastpath(name, true, args);
        if (i == null) {
            throw new KSQLException("kingbase.fp.expint", (Object)name);
        }
        return i;
    }

    public byte[] getData(String name, FastpathArg[] args) throws SQLException {
        return (byte[])this.fastpath(name, false, args);
    }

    public int getID(String name) throws SQLException {
        Integer id = (Integer)func.get(name);
        if (id == null) {
            throw new KSQLException("kingbase.fp.unknown", (Object)name);
        }
        return id;
    }

    static {
        func.put("LO_OPEN", new Integer(952));
        func.put("LO_CLOSE", new Integer(953));
        func.put("LO_CREAT", new Integer(957));
        func.put("LO_UNLINK", new Integer(964));
        func.put("LO_LSEEK", new Integer(956));
        func.put("LO_TELL", new Integer(958));
        func.put("LOREAD", new Integer(954));
        func.put("LO_POSITION", new Integer(8507));
        func.put("LO_TRUNCATE", new Integer(8506));
        func.put("LOWRITE", new Integer(955));
        func.put("LO_POSITIONLOB", new Integer(8508));
        func.put("LO_LSEEK_CLOB", new Integer(8510));
        func.put("LO_TELL_CLOB", new Integer(8511));
        func.put("LOREAD_CLOB", new Integer(8512));
        func.put("LO_POSITION_CLOB", new Integer(8515));
        func.put("LO_TRUNCATE_CLOB", new Integer(8514));
        func.put("LOWRITE_CLOB", new Integer(8513));
        func.put("LO_POSITIONLOB_CLOB", new Integer(8516));
    }
}

