/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.geometric;

import com.kingbase.geometric.KBpoint;
import com.kingbase.util.KBobject;
import com.kingbase.util.KBtokenizer;
import com.kingbase.util.KSQLException;
import java.io.Serializable;
import java.sql.SQLException;

public class KBbox
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint[] point = new KBpoint[2];

    public KBbox(double x1, double y1, double x2, double y2) {
        this();
        this.point[0] = new KBpoint(x1, y1);
        this.point[1] = new KBpoint(x2, y2);
    }

    public KBbox(KBpoint p1, KBpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public KBbox(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public KBbox() {
        this.setType("box");
    }

    public void setValue(String value) throws SQLException {
        KBtokenizer t = new KBtokenizer(value, ',');
        if (t.getSize() != 2) {
            throw new KSQLException("kingbase.geo.box", (Object)value);
        }
        this.point[0] = new KBpoint(t.getToken(0));
        this.point[1] = new KBpoint(t.getToken(1));
    }

    public boolean equals(Object obj) {
        if (obj instanceof KBbox) {
            KBbox p = (KBbox)obj;
            return p.point[0].equals(this.point[0]) && p.point[1].equals(this.point[1]) || p.point[0].equals(this.point[1]) && p.point[1].equals(this.point[0]);
        }
        return false;
    }

    public Object clone() {
        return new KBbox((KBpoint)this.point[0].clone(), (KBpoint)this.point[1].clone());
    }

    public String getValue() {
        return this.point[0].toString() + "," + this.point[1].toString();
    }
}

