/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.geometric;

import com.kingbase.geometric.KBpoint;
import com.kingbase.util.KBobject;
import com.kingbase.util.KBtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class KBpolygon
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint[] points;

    public KBpolygon(KBpoint[] points) {
        this();
        this.points = points;
    }

    public KBpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public KBpolygon() {
        this.setType("polygon");
    }

    public void setValue(String s) throws SQLException {
        KBtokenizer t = new KBtokenizer(KBtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new KBpoint[npoints];
        int p = 0;
        while (p < npoints) {
            this.points[p] = new KBpoint(t.getToken(p));
            ++p;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof KBpolygon) {
            KBpolygon p = (KBpolygon)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            int i = 0;
            while (i < this.points.length) {
                if (!this.points[i].equals(p.points[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        KBpoint[] ary = new KBpoint[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            ary[i] = (KBpoint)this.points[i].clone();
            ++i;
        }
        return new KBpolygon(ary);
    }

    public String getValue() {
        StringBuffer b = new StringBuffer();
        b.append("(");
        int p = 0;
        while (p < this.points.length) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
            ++p;
        }
        b.append(")");
        return b.toString();
    }
}

