/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc1;

import com.kingbase.Driver;
import com.kingbase.core.BaseStatement;
import com.kingbase.core.Field;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.util.KBTypeInfo;
import com.kingbase.util.KBbytea;
import com.kingbase.util.KSQLException;
import com.kingbase.util.SysTypeNameConverter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AbstractJdbc1DatabaseMetaData {
    private static final String keywords = "abort,acl,add,aggregate,append,archive,arch_store,backward,binary,boolean,change,cluster,copy,database,delimiter,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version";
    protected AbstractJdbc1Connection connection;
    public static final int iVarcharOid = 1043;
    public static final int iBoolOid = 16;
    public static final int iInt2Oid = 21;
    public static final int iInt4Oid = 23;
    public static final int iIntervalOid = 1186;
    public static final int VARHDRSZ = 4;
    public static final int LOB_LENGTH = Integer.MAX_VALUE;
    private int NAMEDATALEN = 0;
    private int INDEX_MAX_KEYS = 0;
    private static Hashtable tableTypeClauses;
    private static final String[] defaultTableTypes;

    protected int getMaxIndexKeys() throws SQLException {
        if (this.INDEX_MAX_KEYS == 0) {
            String from = "sys_catalog.sys_namespace n, sys_catalog.sys_type t1, sys_catalog.sys_type t2 WHERE t1.typnamespace=n.oid AND n.nspname='SYS_CATALOG' AND ";
            String sql = "SELECT t1.typlen/t2.typlen FROM " + from + " t1.typelem=t2.oid AND t1.typname='OIDVECTOR'";
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new KSQLException("kingbase.unexpected");
            }
            this.INDEX_MAX_KEYS = rs.getInt(1);
            rs.close();
            stmt.close();
        }
        return this.INDEX_MAX_KEYS;
    }

    protected int getMaxNameLength() throws SQLException {
        if (this.NAMEDATALEN == 0) {
            String sql = "SELECT t.typlen FROM sys_catalog.sys_type t, sys_catalog.sys_namespace n WHERE t.typnamespace=n.oid AND t.typname='NAME' AND n.nspname='SYS_CATALOG'";
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new KSQLException("kingbase.unexpected");
            }
            this.NAMEDATALEN = rs.getInt("typlen");
            rs.close();
            stmt.close();
        }
        return this.NAMEDATALEN - 1;
    }

    public AbstractJdbc1DatabaseMetaData(AbstractJdbc1Connection conn) {
        tableTypeClauses = new Hashtable();
        this.connection = conn;
        if (this.connection.getDatabaseVersion() >= 40100) {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            tableTypeClauses.put("TABLE", ht);
            ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname NOT LIKE 'SYS\\_%'");
            ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname NOT LIKE 'SYS\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("VIEW", ht);
            ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'SYS_CATALOG'");
            ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname NOT LIKE 'SYS\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("INDEX", ht);
            ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname NOT LIKE 'SYS\\_%'");
            ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname NOT LIKE 'SYS\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SEQUENCE", ht);
            ht.put("SCHEMAS", "c.relkind = 'S'");
            ht.put("NOSCHEMAS", "c.relkind = 'S'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM TABLE", ht);
            ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'SYS_CATALOG'");
            ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'SYS\\_%' AND c.relname NOT LIKE 'SYS\\_TOAST\\_%' AND c.relname NOT LIKE 'SYS\\_TEMP\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM TOAST TABLE", ht);
            ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'SYS_TOAST'");
            ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'SYS\\_TOAST\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM TOAST INDEX", ht);
            ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'SYS_TOAST'");
            ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'SYS\\_TOAST\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM VIEW", ht);
            ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname = 'SYS_CATALOG' ");
            ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'SYS\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM INDEX", ht);
            ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'SYS_CATALOG'");
            ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'SYS\\_%' AND c.relname NOT LIKE 'SYS\\_TOAST\\_%' AND c.relname NOT LIKE 'SYS\\_TEMP\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("TEMPORARY TABLE", ht);
            ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname LIKE '\\_TEMP\\_%' ");
            ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'SYS\\_TEMP\\_%' ");
            ht = new Hashtable();
            tableTypeClauses.put("TEMPORARY INDEX", ht);
            ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname LIKE 'SYS\\_TEMP\\_%' ");
            ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'SYS\\_TEMP\\_%' ");
        } else {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            tableTypeClauses.put("TABLE", ht);
            ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname NOT LIKE 'SYS\\\\_%'");
            ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname NOT LIKE 'SYS\\\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("VIEW", ht);
            ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'SYS_CATALOG'");
            ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname NOT LIKE 'SYS\\\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("INDEX", ht);
            ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname NOT LIKE 'SYS\\\\_%'");
            ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname NOT LIKE 'SYS\\\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SEQUENCE", ht);
            ht.put("SCHEMAS", "c.relkind = 'S'");
            ht.put("NOSCHEMAS", "c.relkind = 'S'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM TABLE", ht);
            ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'SYS_CATALOG'");
            ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'SYS\\\\_%' AND c.relname NOT LIKE 'SYS\\\\_TOAST\\\\_%' AND c.relname NOT LIKE 'SYS\\\\_TEMP\\\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM TOAST TABLE", ht);
            ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'SYS_TOAST'");
            ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'SYS\\\\_TOAST\\\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM TOAST INDEX", ht);
            ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'SYS_TOAST'");
            ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'SYS\\\\_TOAST\\\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM VIEW", ht);
            ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname = 'SYS_CATALOG' ");
            ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'SYS\\\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("SYSTEM INDEX", ht);
            ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'SYS_CATALOG'");
            ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'SYS\\\\_%' AND c.relname NOT LIKE 'SYS\\\\_TOAST\\\\_%' AND c.relname NOT LIKE 'SYS\\\\_TEMP\\\\_%'");
            ht = new Hashtable();
            tableTypeClauses.put("TEMPORARY TABLE", ht);
            ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname LIKE '\\\\_TEMP\\\\_%' ");
            ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'SYS\\\\_TEMP\\\\_%' ");
            ht = new Hashtable();
            tableTypeClauses.put("TEMPORARY INDEX", ht);
            ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname LIKE 'SYS\\\\_TEMP\\\\_%' ");
            ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'SYS\\\\_TEMP\\\\_%' ");
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("allProceduresAreCallable");
        }
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("allTablesAreSelectable");
        }
        return true;
    }

    public String getURL() throws SQLException {
        String url = this.connection.getURL();
        if (Driver.isDebug) {
            Driver.debug("getURL " + url);
        }
        return url;
    }

    public String getUserName() throws SQLException {
        String userName = this.connection.getUserName();
        if (Driver.isDebug) {
            Driver.debug("getUserName " + userName);
        }
        return userName;
    }

    public boolean isReadOnly() throws SQLException {
        boolean isReadOnly = this.connection.isReadOnly();
        if (Driver.isDebug) {
            Driver.debug("isReadOnly " + isReadOnly);
        }
        return isReadOnly;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("nullsAreSortedLow false");
        }
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("nullsAreSortedAtStart false");
        }
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getDatabaseProductName KingbaseES");
        }
        return "KingbaseES";
    }

    public String getDatabaseProductVersion() throws SQLException {
        String versionNumber = new String(this.connection.getDatabaseMajorVersion() + "." + this.connection.getDatabaseMinorVersion());
        if (Driver.isDebug) {
            Driver.debug("getDatabaseProductVersion " + versionNumber);
        }
        return versionNumber;
    }

    public String getDriverName() throws SQLException {
        String driverName = "KingbaseES Native JDBC Driver";
        if (Driver.isDebug) {
            Driver.debug("getDriverName" + driverName);
        }
        return driverName;
    }

    public String getDriverVersion() throws SQLException {
        String driverVersion = Driver.getVersion();
        if (Driver.isDebug) {
            Driver.debug("getDriverVersion " + driverVersion);
        }
        return driverVersion;
    }

    public int getDriverMajorVersion() {
        int majorVersion = this.connection.this_driver.getMajorVersion();
        if (Driver.isDebug) {
            Driver.debug("getMajorVersion " + majorVersion);
        }
        return majorVersion;
    }

    public int getDriverMinorVersion() {
        int minorVersion = this.connection.this_driver.getMinorVersion();
        if (Driver.isDebug) {
            Driver.debug("getMinorVersion " + minorVersion);
        }
        return minorVersion;
    }

    public boolean usesLocalFiles() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("usesLocalFiles false");
        }
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("usesLocalFilePerTable false");
        }
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsMixedCaseIdentifiers false");
        }
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("storesUpperCaseIdentifiers true");
        }
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("storesLowerCaseIdentifiers false");
        }
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("storesMixedCaseIdentifiers false");
        }
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsMixedCaseQuotedIdentifiers true");
        }
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("storesUpperCaseQuotedIdentifiers false");
        }
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("storesLowerCaseQuotedIdentifiers false");
        }
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("storesMixedCaseQuotedIdentifiers false");
        }
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getIdentifierQuoteString \"");
        }
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return keywords;
    }

    public String getNumericFunctions() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getNumericFunctions");
        }
        String fun = "abs,acos,asin,atan,atan2,ceiling,cos,cot,sin,sqrt,tan,truncate,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sign";
        return fun.toUpperCase();
    }

    public String getStringFunctions() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getStringFunctions");
        }
        String fun = "ascii,char,concat,insert,lcase,left,length,locate,ltrim,repeat,replace,right,rtrim,spacesubstring,ucase,soundex,difference,space";
        return fun.toUpperCase();
    }

    public String getSystemFunctions() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getSystemFunctions");
        }
        String fun = "database,ifnull,user";
        return fun.toUpperCase();
    }

    public String getTimeDateFunctions() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getTimeDateFunctions");
        }
        String fun = "curdate,curtime,dayname,dayofmonth,dayofyear,dayofweek,minute,hour,month,monthname,now,quarter,second,week,year,timestampadd,timestampdiff";
        return fun.toUpperCase();
    }

    public String getSearchStringEscape() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getSearchStringEscape");
        }
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getExtraNameCharacters");
        }
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsAlterTableWithAddColumn true");
        }
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsColumnAliasing true");
        }
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("nullPlusNonNullIsNull true");
        }
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (this.connection.getDatabaseVersion() >= 40100) {
            return this.supportsConvertV4(fromType, toType);
        }
        return this.supportsConvertV3(fromType, toType);
    }

    public boolean supportsConvertV3(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -1: 
            case 1: 
            case 12: {
                switch (toType) {
                    case -5: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
            }
            case -5: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                switch (toType) {
                    case -5: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
            }
            case 91: {
                switch (toType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 93: {
                        return true;
                    }
                }
            }
            case 92: {
                switch (toType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 93: {
                        return true;
                    }
                }
            }
            case 93: {
                switch (toType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean supportsConvertV4(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                return false;
            }
        }
        switch (toType) {
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                return false;
            }
        }
        boolean result = false;
        String fromPGTypeName = this.connection.getPGTypeFromSQLType(fromType);
        int fromPGOid = this.connection.getPGType(fromPGTypeName);
        String toPGTypeName = this.connection.getPGTypeFromSQLType(toType);
        int toPGOid = this.connection.getPGType(toPGTypeName);
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("select * from sys_catalog.sys_cast where castsource=" + fromPGOid + " and casttarget=" + toPGOid);
        if (rs.next()) {
            result = true;
        }
        rs.close();
        stmt.close();
        if (Driver.isDebug) {
            Driver.debug("supportsConvert " + result);
        }
        return result;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsTableCorrelationNames true");
        }
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsDifferentTableCorrelationNames false");
        }
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsExpressionsInOrderBy true");
        }
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsGroupBy true");
        }
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsMultipleResultSets false");
        }
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsMultipleTransactions true");
        }
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsNonNullableColumns true");
        }
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsMinimumSQLGrammar TRUE");
        }
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsCoreSQLGrammar FALSE ");
        }
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsExtendedSQLGrammar FALSE");
        }
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsANSI92IntermediateSQL false ");
        }
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsANSI92FullSQL false ");
        }
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsIntegrityEnhancementFacility false ");
        }
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getSchemaTerm schema");
        }
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getProcedureTerm function ");
        }
        return "procedure";
    }

    public String getCatalogTerm() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getCatalogTerm database ");
        }
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("isCatalogAtStart not implemented");
        }
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("getCatalogSeparator not implemented ");
        }
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsCatalogsInDataManipulation false");
        }
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsCatalogsInDataManipulation false");
        }
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsCatalogsInTableDefinitions false");
        }
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsCatalogsInIndexDefinitions false");
        }
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsCatalogsInPrivilegeDefinitions false");
        }
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsPositionedDelete false");
        }
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        if (Driver.isDebug) {
            Driver.debug("supportsPositionedUpdate false");
        }
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.connection.getDatabaseVersion() >= 40100;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.connection.getDatabaseVersion() >= 40100;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    public int getMaxConnections() throws SQLException {
        int maxConNum = 8192;
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("select setting from sys_settings where lower(name) = 'max_connections'");
        maxConNum = rs.next() ? rs.getInt(1) : 8192;
        if (rs != null) {
            rs.close();
        }
        stmt.close();
        return maxConNum;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxRowSize() throws SQLException {
        return 0x40000000;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 1;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8 || level == 2;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    protected static String escapeQuotes(String s) {
        StringBuffer sb = new StringBuffer();
        int length = s.length();
        int prevChar = 32;
        int prevPrevChar = 32;
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            sb.append(c);
            if (c == '\'' || c == '\\') {
                sb.append(c);
            }
            prevPrevChar = prevChar;
            prevChar = c;
            ++i;
        }
        return sb.toString();
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sql = "SELECT NULL AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS, 2 AS PROCEDURE_TYPE  FROM sys_catalog.sys_namespace n, sys_catalog.sys_proc p  LEFT JOIN sys_catalog.sys_description d ON (p.oid=d.objoid)  LEFT JOIN sys_catalog.sys_class c ON (d.classoid=c.oid AND c.relname='SYS_PROC')  LEFT JOIN sys_catalog.sys_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='SYS_CATALOG')  WHERE p.pronamespace=n.oid ";
        if (schemaPattern != null && !"".equals(schemaPattern)) {
            sql = sql + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
        }
        if (procedureNamePattern != null) {
            sql = sql + " AND p.proname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
        }
        sql = sql + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME ";
        return this.connection.createStatement().executeQuery(sql);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (this.connection.getDatabaseVersion() >= 40100) {
            return this.getProcedureColumnsSV5(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        return this.getProcedureColumnsSV4(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    private ResultSet getProcedureColumnsSV4(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        Field[] f = new Field[13];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "PROCEDURE_CAT", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "PROCEDURE_SCHEM", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "PROCEDURE_NAME", 1043, this.getMaxNameLength());
        f[3] = new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "COLUMN_TYPE", 21, 2);
        f[5] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[6] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[7] = new Field(this.connection, "PRECISION", 23, 4);
        f[8] = new Field(this.connection, "LENGTH", 23, 4);
        f[9] = new Field(this.connection, "SCALE", 21, 2);
        f[10] = new Field(this.connection, "RADIX", 21, 2);
        f[11] = new Field(this.connection, "NULLABLE", 21, 2);
        f[12] = new Field(this.connection, "REMARKS", 1043, this.getMaxNameLength());
        String sql = "SELECT n.nspname,p.proname,p.prorettype,p.proargtypes,p.prosrc,t.typtype,t.typrelid  FROM sys_catalog.sys_proc p,sys_catalog.sys_namespace n, sys_catalog.sys_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ";
        if (schemaPattern != null && !"".equals(schemaPattern)) {
            sql = sql + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
        }
        if (procedureNamePattern != null) {
            sql = sql + " AND p.proname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
        }
        sql = sql + " ORDER BY n.nspname, p.proname ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[] schema = rs.getBytes(1);
            byte[] procedureName = rs.getBytes(2);
            int returnType = rs.getInt(3);
            String returnTypeType = rs.getString(6);
            int returnTypeRelid = rs.getInt(7);
            String strArgTypes = rs.getString(4);
            StringTokenizer st = new StringTokenizer(strArgTypes);
            StringTokenizer strArgNames = new StringTokenizer(rs.getString("prosrc").trim(), ";\n \t\r\f");
            Vector<String> argNames = new Vector<String>();
            Vector<Integer> argMode = new Vector<Integer>();
            Vector<Integer> argTypes = new Vector<Integer>();
            while (st.hasMoreTokens()) {
                argTypes.addElement(new Integer(st.nextToken()));
            }
            if (strArgNames.hasMoreTokens()) {
                strArgNames.nextToken();
            }
            int i = 0;
            while (i < argTypes.size()) {
                argNames.addElement(strArgNames.nextToken());
                argMode.addElement(new Integer(strArgNames.nextToken()));
                int j = 0;
                while (j < 3) {
                    strArgNames.nextToken();
                    ++j;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < argTypes.size()) {
                int argOid = (Integer)argTypes.elementAt(i2);
                byte[][] tuple = new byte[13][];
                tuple[0] = null;
                tuple[1] = schema;
                tuple[2] = procedureName;
                tuple[3] = ((String)argNames.elementAt(i2)).getBytes();
                switch ((Integer)argMode.elementAt(i2)) {
                    case 1: {
                        tuple[4] = Integer.toString(1).getBytes();
                        break;
                    }
                    case 2: {
                        tuple[4] = Integer.toString(4).getBytes();
                        break;
                    }
                    case 3: {
                        tuple[4] = Integer.toString(2).getBytes();
                    }
                }
                tuple[5] = Integer.toString(this.connection.getSQLType(argOid)).getBytes();
                String pgType = this.connection.getPGType(argOid);
                tuple[6] = pgType.getBytes();
                tuple[7] = null;
                tuple[8] = null;
                tuple[9] = null;
                tuple[10] = null;
                tuple[11] = Integer.toString(2).getBytes();
                tuple[12] = "".getBytes();
                if (pgType.equals("TINYINT")) {
                    tuple[7] = "3".getBytes();
                    tuple[8] = "1".getBytes();
                    tuple[10] = "10".getBytes();
                } else if (pgType.equals("INT2") || pgType.equals("SMALLINT")) {
                    tuple[7] = "5".getBytes();
                    tuple[8] = "2".getBytes();
                    tuple[10] = "10".getBytes();
                } else if (pgType.equals("INT4") || pgType.equals("INTEGER")) {
                    tuple[7] = "10".getBytes();
                    tuple[8] = "4".getBytes();
                    tuple[10] = "10".getBytes();
                } else if (pgType.equals("INT8") || pgType.equals("BIGINT")) {
                    tuple[7] = "19".getBytes();
                    tuple[8] = "8".getBytes();
                    tuple[10] = "10".getBytes();
                } else if (pgType.equals("FLOAT4") || pgType.equals("REAL")) {
                    tuple[7] = "24".getBytes();
                    tuple[8] = "4".getBytes();
                    tuple[10] = "10".getBytes();
                } else if (pgType.equals("FLOAT8") || pgType.equals("DOUBLE")) {
                    tuple[7] = "53".getBytes();
                    tuple[8] = "8".getBytes();
                    tuple[10] = "10".getBytes();
                } else if (pgType.equals("BOOL") || pgType.equals("BOOLEAN")) {
                    tuple[7] = "1".getBytes();
                    tuple[8] = "1".getBytes();
                } else if (pgType.equals("VARCHAR")) {
                    tuple[7] = "10485760".getBytes();
                    tuple[8] = "-1".getBytes();
                }
                v.addElement(tuple);
                ++i2;
            }
            if (!returnTypeType.equals("c")) continue;
            String columnsql = "SELECT a.attname,a.atttypid FROM sys_catalog.sys_attribute a WHERE a.attrelid = " + returnTypeRelid + " ORDER BY a.attnum ";
            Statement stmt_ = this.connection.createStatement();
            ResultSet columnrs = stmt_.executeQuery(columnsql);
            while (columnrs.next()) {
                int columnTypeOid = columnrs.getInt("atttypid");
                byte[][] tuple = new byte[13][];
                tuple[0] = null;
                tuple[1] = schema;
                tuple[2] = procedureName;
                tuple[3] = columnrs.getString("attname").getBytes();
                tuple[4] = Integer.toString(3).getBytes();
                tuple[5] = Integer.toString(this.connection.getSQLType(columnTypeOid)).getBytes();
                String pgType = this.connection.getPGType(columnTypeOid);
                tuple[6] = pgType.getBytes();
                tuple[7] = null;
                tuple[8] = null;
                tuple[9] = null;
                if (pgType.equals("INT2")) {
                    tuple[7] = "5".getBytes();
                    tuple[8] = "2".getBytes();
                } else if (pgType.equals("INT4")) {
                    tuple[7] = "10".getBytes();
                    tuple[8] = "4".getBytes();
                } else if (pgType.equals("INT8")) {
                    tuple[7] = "19".getBytes();
                    tuple[8] = "8".getBytes();
                } else if (pgType.equals("FLOAT4")) {
                    tuple[7] = "24".getBytes();
                    tuple[8] = "4".getBytes();
                } else if (pgType.equals("FLOAT8")) {
                    tuple[7] = "53".getBytes();
                    tuple[8] = "8".getBytes();
                } else if (pgType.equals("VARCHAR")) {
                    tuple[7] = "10485760".getBytes();
                    tuple[8] = "-1".getBytes();
                }
                tuple[10] = null;
                tuple[11] = Integer.toString(2).getBytes();
                tuple[12] = null;
                v.addElement(tuple);
            }
            if (columnrs != null) {
                columnrs.close();
            }
            stmt_.close();
        }
        rs.close();
        stmt.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    private ResultSet getProcedureColumnsSV5(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        Field[] f = new Field[13];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "PROCEDURE_CAT", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "PROCEDURE_SCHEM", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "PROCEDURE_NAME", 1043, this.getMaxNameLength());
        f[3] = new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "COLUMN_TYPE", 21, 2);
        f[5] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[6] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[7] = new Field(this.connection, "PRECISION", 23, 4);
        f[8] = new Field(this.connection, "LENGTH", 23, 4);
        f[9] = new Field(this.connection, "SCALE", 21, 2);
        f[10] = new Field(this.connection, "RADIX", 21, 2);
        f[11] = new Field(this.connection, "NULLABLE", 21, 2);
        f[12] = new Field(this.connection, "REMARKS", 1043, this.getMaxNameLength());
        String sql = "SELECT a.PARNUM,a.PARNAME,a.PARNDIMS,a.PARMODE,a.PARTYPID,a.PARTYPMOD,a.PARNOTNULL,a.PARISSET,b.PROTYPE,c.NSPNAME,b.PRONAME,e.TYPLEN,b.PRORETTYPE  FROM SYS_CATALOG.SYS_PROCPARAM a,SYS_CATALOG.SYS_PROC b,SYS_CATALOG.SYS_NAMESPACE c,SYS_CATALOG.SYS_TYPE e WHERE b.PRONAMESPACE = c.OID AND a.PARPROID = b.OID AND a.PARTYPID = e.OID";
        if (schemaPattern != null && !"".equals(schemaPattern)) {
            sql = sql + "  AND c.NSPNAME LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "'";
        }
        if (procedureNamePattern != null) {
            sql = sql + " AND b.PRONAME LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
        }
        sql = sql + " ORDER BY c.NSPNAME,b.PRONAME,a.PARNUM";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        boolean isGetReturnInfo = false;
        while (rs.next()) {
            String typeFlag = rs.getString("PROTYPE");
            int paramIndex = rs.getInt("PARNUM");
            String schema = rs.getString("NSPNAME");
            String proName = rs.getString("PRONAME");
            String paramName = rs.getString("PARNAME");
            int arraySize = rs.getInt("PARNDIMS");
            String inOutType = rs.getString("PARMODE");
            int paramTypeOid = rs.getInt("PARTYPID");
            int paramMod = rs.getInt("PARTYPMOD");
            String paramIsNullable = rs.getString("PARNOTNULL");
            String isReturnResultSet = rs.getString("PARISSET");
            int paramLength = rs.getInt("TYPLEN");
            byte[][] tuple = new byte[13][];
            tuple[0] = null;
            tuple[1] = schema.getBytes();
            tuple[2] = proName.getBytes();
            tuple[3] = paramName.getBytes();
            switch (inOutType.charAt(0)) {
                case 'i': {
                    tuple[4] = Integer.toString(1).getBytes();
                    break;
                }
                case 'o': {
                    tuple[4] = Integer.toString(4).getBytes();
                    break;
                }
                case 'b': {
                    tuple[4] = Integer.toString(2).getBytes();
                }
            }
            String pgType = this.connection.getPGType(paramTypeOid);
            int sqlType = this.connection.getSQLType(paramTypeOid);
            tuple[5] = Integer.toString(sqlType).getBytes();
            pgType = KBTypeInfo.getDatabaseTypeName(paramTypeOid, paramMod, (Connection)((Object)this.connection), pgType);
            tuple[6] = pgType.getBytes();
            int precision = 0;
            int length = 0;
            int scale = 0;
            int radix = 10;
            switch (sqlType) {
                case 16: {
                    length = 1;
                    break;
                }
                case 2004: 
                case 2005: {
                    length = Integer.MAX_VALUE;
                    radix = 2;
                    break;
                }
                case -4: 
                case -3: 
                case -1: {
                    length = 65536;
                    radix = 2;
                    break;
                }
                case 1: 
                case 12: {
                    length = paramMod != -1 ? paramMod - 4 : 0;
                    radix = 2;
                    break;
                }
                case -7: {
                    length = paramMod;
                    radix = 2;
                    break;
                }
                case -6: {
                    precision = 3;
                    scale = 0;
                    length = 1;
                    break;
                }
                case 2: 
                case 3: {
                    int attypmod = paramMod - 4;
                    length = 19;
                    precision = attypmod >> 16 & 0xFFFF;
                    scale = attypmod & 0xFFFF;
                    break;
                }
                case 5: {
                    precision = 5;
                    scale = 0;
                    length = 2;
                    break;
                }
                case 4: {
                    precision = 10;
                    scale = 0;
                    length = 4;
                    break;
                }
                case -5: {
                    precision = 19;
                    scale = 0;
                    length = 8;
                    break;
                }
                case 7: {
                    precision = 24;
                    length = 4;
                    scale = 8;
                    break;
                }
                case 8: {
                    precision = 53;
                    length = 8;
                    scale = 8;
                    break;
                }
                default: {
                    length = paramTypeOid == 1186 ? paramLength : (paramMod == -1 ? paramLength : paramMod);
                }
            }
            tuple[7] = Integer.toString(precision).getBytes();
            tuple[8] = (byte[])(length == 0 ? null : Integer.toString(length).getBytes());
            tuple[9] = Integer.toString(scale).getBytes();
            tuple[10] = Integer.toString(radix).getBytes();
            tuple[11] = Integer.toString(paramIsNullable.equals("f") ? 1 : 0).getBytes();
            tuple[12] = "".getBytes();
            if (paramIndex == 1) {
                isGetReturnInfo = false;
            }
            if (typeFlag.equals("f") && !isGetReturnInfo) {
                byte[][] tupleOfReturn = new byte[13][];
                int returnTypeOID = rs.getInt("PRORETTYPE");
                pgType = this.connection.getPGType(returnTypeOID);
                sqlType = this.connection.getSQLType(returnTypeOID);
                tupleOfReturn[5] = Integer.toString(sqlType).getBytes();
                tupleOfReturn[6] = pgType.getBytes();
                precision = 0;
                length = 0;
                scale = 0;
                radix = 10;
                switch (sqlType) {
                    case 16: {
                        length = 1;
                        break;
                    }
                    case 2004: 
                    case 2005: {
                        length = Integer.MAX_VALUE;
                        radix = 2;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -1: {
                        length = 65536;
                        radix = 2;
                        break;
                    }
                    case 1: {
                        length = 8000;
                        radix = 2;
                        break;
                    }
                    case 12: {
                        length = 65536;
                        radix = 2;
                        break;
                    }
                    case -7: {
                        length = 1;
                        radix = 2;
                        break;
                    }
                    case -6: {
                        precision = 3;
                        scale = 0;
                        length = 1;
                        break;
                    }
                    case 2: 
                    case 3: {
                        length = 19;
                        precision = 10;
                        scale = 0;
                        break;
                    }
                    case 5: {
                        precision = 5;
                        scale = 0;
                        length = 2;
                        break;
                    }
                    case 4: {
                        precision = 10;
                        scale = 0;
                        length = 4;
                        break;
                    }
                    case -5: {
                        precision = 19;
                        scale = 0;
                        length = 8;
                        break;
                    }
                    case 7: {
                        precision = 24;
                        length = 4;
                        scale = 8;
                        break;
                    }
                    case 8: {
                        precision = 53;
                        length = 8;
                        scale = 8;
                        break;
                    }
                    default: {
                        paramLength = 10;
                        length = 10;
                    }
                }
                tupleOfReturn[7] = Integer.toString(precision).getBytes();
                tupleOfReturn[8] = (byte[])(length == 0 ? null : Integer.toString(length).getBytes());
                tupleOfReturn[9] = Integer.toString(scale).getBytes();
                tupleOfReturn[10] = Integer.toString(radix).getBytes();
                tupleOfReturn[11] = Integer.toString(1).getBytes();
                tupleOfReturn[12] = "".getBytes();
                tupleOfReturn[0] = null;
                tupleOfReturn[1] = schema.getBytes();
                tupleOfReturn[2] = proName.getBytes();
                tupleOfReturn[3] = "ReturnParaName".getBytes();
                tupleOfReturn[4] = Integer.toString(5).getBytes();
                v.addElement(tupleOfReturn);
                isGetReturnInfo = true;
            }
            v.addElement(tuple);
        }
        rs.close();
        stmt.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String useSchemas = "SCHEMAS";
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME, ";
        select = this.connection.getDatabaseVersion() >= 40100 ? select + " CASE n.nspname LIKE 'SYS\\_%' " : select + " CASE n.nspname LIKE 'SYS\\\\_%' ";
        select = select + " WHEN true THEN CASE n.nspname " + "\tWHEN 'SYS_CATALOG' THEN CASE c.relkind " + "\t\tWHEN 'r' THEN 'SYSTEM TABLE' " + "\t\tWHEN 'v' THEN 'SYSTEM VIEW' " + "\t\tWHEN 'i' THEN 'SYSTEM INDEX' " + "\t\tELSE NULL " + "\t\tEND " + "\tWHEN 'SYS_TOAST' THEN CASE c.relkind " + "\t\tWHEN 'r' THEN 'SYSTEM TOAST TABLE' " + "\t\tWHEN 'i' THEN 'SYSTEM TOAST INDEX' " + "\t\tELSE NULL " + "\t\tEND " + "\tELSE CASE c.relkind " + "\t\tWHEN 'r' THEN 'TEMPORARY TABLE' " + "\t\tWHEN 'i' THEN 'TEMPORARY INDEX' " + "\t\tELSE NULL " + "\t\tEND " + "\tEND " + " WHEN false THEN CASE c.relkind " + "\tWHEN 'r' THEN 'TABLE' " + "\tWHEN 'i' THEN 'INDEX' " + "\tWHEN 'S' THEN 'SEQUENCE' " + "\tWHEN 'v' THEN 'VIEW' " + "\tELSE NULL " + "\tEND " + " ELSE NULL " + " END " + " AS TABLE_TYPE, d.description AS REMARKS,NULL AS TABLE_CAT," + "NULL AS TYPE_SCHEM ,NULL AS TYPE_NAME ,NULL AS SELF_REFERENCING_COL_NAME,NULL AS REF_GENERATION  " + " FROM sys_catalog.sys_namespace n, sys_catalog.sys_class c " + " LEFT JOIN sys_catalog.sys_description d ON (c.oid = d.objoid AND d.objsubid = 0) " + " LEFT JOIN sys_catalog.sys_class dc ON (d.classoid=dc.oid AND dc.relname='SYS_CLASS') " + " LEFT JOIN sys_catalog.sys_namespace dn ON (dn.oid=dc.relnamespace AND dn.nspname='SYS_CATALOG') " + " WHERE c.relnamespace = n.oid ";
        if (schemaPattern != null && !"".equals(schemaPattern)) {
            select = select + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
        }
        String orderby = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        if (types == null) {
            types = defaultTableTypes;
        }
        if (tableNamePattern != null) {
            select = select + " AND c.relname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        String sql = select;
        sql = sql + " AND (false ";
        int i = 0;
        while (i < types.length) {
            Hashtable clauses = (Hashtable)tableTypeClauses.get(types[i]);
            if (clauses != null) {
                String clause = (String)clauses.get(useSchemas);
                sql = sql + " OR ( " + clause + " ) ";
            }
            ++i;
        }
        sql = sql + ") ";
        sql = sql + orderby;
        return this.connection.createStatement().executeQuery(sql);
    }

    public ResultSet getSchemas() throws SQLException {
        String sql = null;
        sql = this.connection.getDatabaseVersion() >= 40100 ? "SELECT nspname AS TABLE_SCHEM FROM sys_catalog.sys_namespace WHERE nspname <> 'SYS_TOAST' AND nspname NOT LIKE 'SYS\\_TEMP\\_%' ORDER BY TABLE_SCHEM" : "SELECT nspname AS TABLE_SCHEM FROM sys_catalog.sys_namespace WHERE nspname <> 'SYS_TOAST' AND nspname NOT LIKE 'SYS\\\\_TEMP\\\\_%' ORDER BY TABLE_SCHEM";
        return this.connection.createStatement().executeQuery(sql);
    }

    public ResultSet getCatalogs() throws SQLException {
        String sql = "SELECT datname AS TABLE_CAT FROM sys_catalog.sys_database ORDER BY TABLE_CAT";
        return this.connection.createStatement().executeQuery(sql);
    }

    public ResultSet getTableTypes() throws SQLException {
        String[] types = new String[tableTypeClauses.size()];
        Enumeration e = tableTypeClauses.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            types[i++] = (String)e.nextElement();
        }
        AbstractJdbc1DatabaseMetaData.sortStringArray(types);
        Field[] f = new Field[1];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, new String("TABLE_TYPE"), 1043, this.getMaxNameLength());
        i = 0;
        while (i < types.length) {
            byte[][] tuple = new byte[][]{types[i].getBytes()};
            v.addElement(tuple);
            ++i;
        }
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Vector<byte[][]> v = new Vector<byte[][]>();
        Field[] f = new Field[]{new Field(this.connection, "TABLE_CAT", 1043, this.getMaxNameLength()), new Field(this.connection, "TABLE_SCHEM", 1043, this.getMaxNameLength()), new Field(this.connection, "TABLE_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "DATA_TYPE", 21, 2), new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "COLUMN_SIZE", 23, 4), new Field(this.connection, "BUFFER_LENGTH", 1043, this.getMaxNameLength()), new Field(this.connection, "DECIMAL_DIGITS", 23, 4), new Field(this.connection, "NUM_PREC_RADIX", 23, 4), new Field(this.connection, "NULLABLE", 23, 4), new Field(this.connection, "REMARKS", 1043, this.getMaxNameLength()), new Field(this.connection, "COLUMN_DEF", 1043, this.getMaxNameLength()), new Field(this.connection, "SQL_DATA_TYPE", 23, 4), new Field(this.connection, "SQL_DATETIME_SUB", 23, 4), new Field(this.connection, "CHAR_OCTET_LENGTH", 1043, this.getMaxNameLength()), new Field(this.connection, "ORDINAL_POSITION", 23, 4), new Field(this.connection, "IS_NULLABLE", 1043, this.getMaxNameLength()), new Field(this.connection, "SCOPE_CATALOG", 1043, this.getMaxNameLength()), new Field(this.connection, "SCOPE_SCHEMA", 1043, this.getMaxNameLength()), new Field(this.connection, "SCOPE_TABLE", 1043, this.getMaxNameLength()), new Field(this.connection, "SCOPE_DATA_TYPE", 1043, this.getMaxNameLength())};
        String sql = "SELECT n.nspname,c.relname,a.attname,a.atttypid,a.attnotnull,a.atttypmod,a.attlen,a.attnum,def.adsrc,dsc.description  FROM sys_catalog.sys_namespace n  JOIN sys_catalog.sys_class c ON (c.relnamespace = n.oid)  JOIN sys_catalog.sys_attribute a ON (a.attrelid=c.oid)  LEFT JOIN sys_catalog.sys_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN sys_catalog.sys_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN sys_catalog.sys_class dc ON (dc.oid=dsc.classoid AND dc.relname='SYS_CLASS')  LEFT JOIN sys_catalog.sys_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='SYS_CATALOG')  WHERE a.attnum > 0 AND NOT a.attisdropped ";
        if (schemaPattern != null && !"".equals(schemaPattern)) {
            sql = sql + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
        }
        if (tableNamePattern != null && !"".equals(tableNamePattern)) {
            sql = sql + " AND c.relname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        if (columnNamePattern != null && !"".equals(columnNamePattern)) {
            sql = sql + " AND a.attname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(columnNamePattern) + "' ";
        }
        sql = sql + " ORDER BY nspname,relname,attnum ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int iOrdinalPosition = 1;
        while (rs.next()) {
            byte[][] tuple = new byte[22][];
            int typeOid = rs.getInt("atttypid");
            int sqlType = this.connection.getSQLType(typeOid);
            String pgType = this.connection.getPGType(typeOid);
            int atttypmod = rs.getInt("atttypmod");
            int columnSize = 0;
            int scale = -1;
            int radix = 10;
            tuple[0] = null;
            tuple[1] = rs.getBytes("nspname");
            tuple[2] = rs.getBytes("relname");
            tuple[3] = rs.getBytes("attname");
            tuple[4] = Integer.toString(sqlType).getBytes();
            pgType = KBTypeInfo.getDatabaseTypeName(typeOid, rs.getInt("atttypmod"), (Connection)((Object)this.connection), pgType);
            tuple[5] = pgType.getBytes();
            switch (sqlType) {
                case 16: {
                    columnSize = 1;
                    break;
                }
                case 2004: 
                case 2005: {
                    columnSize = Integer.MAX_VALUE;
                    radix = 2;
                    break;
                }
                case -4: 
                case -3: 
                case -1: {
                    columnSize = 65536;
                    radix = 2;
                    break;
                }
                case 1: 
                case 12: {
                    columnSize = this.connection.getDatabaseVersion() >= 40100 ? (atttypmod != -1 ? atttypmod - 4 : 8000) : (atttypmod == -1 ? 0xA00000 : atttypmod - 4);
                    radix = 2;
                    break;
                }
                case -7: {
                    columnSize = atttypmod;
                    radix = 2;
                    break;
                }
                case -6: {
                    columnSize = 3;
                    break;
                }
                case 2: 
                case 3: {
                    int attypmod = atttypmod - 4;
                    columnSize = attypmod >> 16 & 0xFFFF;
                    scale = attypmod & 0xFFFF;
                    break;
                }
                case 5: {
                    columnSize = 5;
                    break;
                }
                case 4: {
                    columnSize = 10;
                    break;
                }
                case -5: {
                    columnSize = 19;
                    break;
                }
                case 7: {
                    columnSize = 7;
                    break;
                }
                case 8: {
                    columnSize = 15;
                    break;
                }
                case 91: {
                    columnSize = 10;
                    break;
                }
                case 92: {
                    columnSize = atttypmod > -1 ? 8 + (1 + atttypmod) : 8;
                    scale = atttypmod;
                    break;
                }
                case 93: {
                    columnSize = 26;
                    columnSize = atttypmod > -1 ? 19 + (1 + atttypmod) : 19;
                    scale = atttypmod;
                }
            }
            if (typeOid == 1186) {
                boolean secondType;
                columnSize = (atttypmod & 0xFF00) >> 8;
                boolean bl = secondType = (atttypmod >> 16 & 0x1000) > 0;
                if (secondType) {
                    scale = atttypmod & 0xFF;
                }
            }
            tuple[6] = Integer.toString(columnSize).getBytes();
            tuple[7] = null;
            tuple[8] = Integer.toString(scale).getBytes();
            tuple[9] = Integer.toString(radix).getBytes();
            tuple[10] = Integer.toString(rs.getBoolean("attnotnull") ? 0 : 1).getBytes();
            tuple[11] = rs.getBytes("description");
            String defaultValue = null;
            defaultValue = this.convertColumnDefault(rs.getString("adsrc"), new String(tuple[5]));
            tuple[12] = (byte[])(defaultValue != null && !defaultValue.equalsIgnoreCase("null") ? defaultValue.getBytes() : null);
            tuple[13] = null;
            tuple[14] = null;
            tuple[15] = tuple[6];
            tuple[16] = Integer.toString(iOrdinalPosition).getBytes();
            ++iOrdinalPosition;
            tuple[17] = (rs.getBoolean("attnotnull") ? "NO" : "YES").getBytes();
            tuple[18] = null;
            tuple[19] = null;
            tuple[20] = null;
            tuple[21] = null;
            v.addElement(tuple);
        }
        rs.close();
        stmt.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        Field[] f = new Field[8];
        Vector<byte[][]> v = new Vector<byte[][]>();
        if (table == null) {
            table = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        f[0] = new Field(this.connection, "TABLE_CAT", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "TABLE_SCHEM", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "TABLE_NAME", 1043, this.getMaxNameLength());
        f[3] = new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "GRANTOR", 1043, this.getMaxNameLength());
        f[5] = new Field(this.connection, "GRANTEE", 1043, this.getMaxNameLength());
        f[6] = new Field(this.connection, "PRIVILEGE", 1043, this.getMaxNameLength());
        f[7] = new Field(this.connection, "IS_GRANTABLE", 1043, this.getMaxNameLength());
        String sql = "SELECT n.nspname,c.relname,u.usename,c.relacl,a.attname  FROM sys_catalog.sys_namespace n, sys_catalog.sys_class c, sys_catalog.sys_user u, sys_catalog.sys_attribute a  WHERE c.relnamespace = n.oid  AND u.usesysid = c.relowner  AND c.oid = a.attrelid  AND c.relkind = 'r'  AND a.attnum > 0 AND NOT a.attisdropped ";
        if (schema != null && !"".equals(schema)) {
            sql = sql + " AND n.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schema) + "' ";
        }
        sql = sql + " AND c.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(table) + "' ";
        if (columnNamePattern != null && !"".equals(columnNamePattern)) {
            sql = sql + " AND a.attname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(columnNamePattern) + "' ";
        }
        sql = sql + " ORDER BY attname ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[] schemaName = rs.getBytes("nspname");
            byte[] tableName = rs.getBytes("relname");
            byte[] column = rs.getBytes("attname");
            String owner = rs.getString("usename");
            String acl = rs.getString("relacl");
            Hashtable permissions = this.parseACL(acl, owner);
            String[] permNames = new String[permissions.size()];
            Enumeration e = permissions.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                permNames[i++] = (String)e.nextElement();
            }
            AbstractJdbc1DatabaseMetaData.sortStringArray(permNames);
            i = 0;
            while (i < permNames.length) {
                byte[] privilege = permNames[i].getBytes();
                Vector grantees = (Vector)permissions.get(permNames[i]);
                int j = 0;
                while (j < grantees.size()) {
                    String grantee = (String)grantees.elementAt(j);
                    String grantable = owner.equals(grantee) ? "YES" : "NO";
                    byte[][] tuple = new byte[][]{null, schemaName, tableName, column, owner.getBytes(), grantee.getBytes(), privilege, grantable.getBytes()};
                    v.addElement(tuple);
                    ++j;
                }
                ++i;
            }
        }
        rs.close();
        stmt.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Field[] f = new Field[7];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "TABLE_CAT", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "TABLE_SCHEM", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "TABLE_NAME", 1043, this.getMaxNameLength());
        f[3] = new Field(this.connection, "GRANTOR", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "GRANTEE", 1043, this.getMaxNameLength());
        f[5] = new Field(this.connection, "PRIVILEGE", 1043, this.getMaxNameLength());
        f[6] = new Field(this.connection, "IS_GRANTABLE", 1043, this.getMaxNameLength());
        String sql = "SELECT n.nspname,c.relname,u.usename,c.relacl  FROM sys_catalog.sys_namespace n, sys_catalog.sys_class c, sys_catalog.sys_user u  WHERE c.relnamespace = n.oid  AND u.usesysid = c.relowner  AND c.relkind = 'r' ";
        if (schemaPattern != null && !"".equals(schemaPattern)) {
            sql = sql + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
        }
        if (tableNamePattern != null && !"".equals(tableNamePattern)) {
            sql = sql + " AND c.relname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        sql = sql + " ORDER BY nspname, relname ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[] schema = rs.getBytes("nspname");
            byte[] table = rs.getBytes("relname");
            String owner = rs.getString("usename");
            String acl = rs.getString("relacl");
            Hashtable permissions = this.parseACL(acl, owner);
            String[] permNames = new String[permissions.size()];
            Enumeration e = permissions.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                permNames[i++] = (String)e.nextElement();
            }
            AbstractJdbc1DatabaseMetaData.sortStringArray(permNames);
            i = 0;
            while (i < permNames.length) {
                byte[] privilege = permNames[i].getBytes();
                Vector grantees = (Vector)permissions.get(permNames[i]);
                int j = 0;
                while (j < grantees.size()) {
                    String grantee = (String)grantees.elementAt(j);
                    String grantable = owner.equals(grantee) ? "YES" : "NO";
                    byte[][] tuple = new byte[][]{null, schema, table, owner.getBytes(), grantee.getBytes(), privilege, grantable.getBytes()};
                    v.addElement(tuple);
                    ++j;
                }
                ++i;
            }
        }
        rs.close();
        stmt.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    private static void sortStringArray(String[] s) {
        int i = 0;
        while (i < s.length - 1) {
            int j = i + 1;
            while (j < s.length) {
                if (s[i].compareTo(s[j]) > 0) {
                    String tmp = s[i];
                    s[i] = s[j];
                    s[j] = tmp;
                }
                ++j;
            }
            ++i;
        }
    }

    private static Vector parseACLArray(String aclString) {
        Vector<String> acls = new Vector<String>();
        if (aclString == null || aclString.length() == 0) {
            return acls;
        }
        boolean inQuotes = false;
        int beginIndex = 1;
        int prevChar = 32;
        int i = beginIndex;
        while (i < aclString.length()) {
            char c = aclString.charAt(i);
            if (c == '\"' && prevChar != 92) {
                inQuotes = !inQuotes;
            } else if (c == ',' && !inQuotes) {
                acls.addElement(aclString.substring(beginIndex, i));
                beginIndex = i + 1;
            }
            prevChar = c;
            ++i;
        }
        acls.addElement(aclString.substring(beginIndex, aclString.length() - 1));
        int i2 = 0;
        while (i2 < acls.size()) {
            String acl = (String)acls.elementAt(i2);
            if (acl.startsWith("\"") && acl.endsWith("\"")) {
                acl = acl.substring(1, acl.length() - 1);
                acls.setElementAt(acl, i2);
            }
            ++i2;
        }
        return acls;
    }

    private void addACLPrivileges(String acl, Hashtable privileges) {
        int equalIndex = acl.lastIndexOf("=");
        String name = acl.substring(0, equalIndex);
        if (name.length() == 0) {
            name = "PUBLIC";
        }
        String privs = acl.substring(equalIndex + 1);
        int i = 0;
        while (i < privs.length()) {
            String sqlpriv;
            char c = privs.charAt(i);
            switch (c) {
                case 'a': {
                    sqlpriv = "INSERT";
                    break;
                }
                case 'r': {
                    sqlpriv = "SELECT";
                    break;
                }
                case 'w': {
                    sqlpriv = "UPDATE";
                    break;
                }
                case 'd': {
                    sqlpriv = "DELETE";
                    break;
                }
                case 'R': {
                    sqlpriv = "RULE";
                    break;
                }
                case 'x': {
                    sqlpriv = "REFERENCES";
                    break;
                }
                case 't': {
                    sqlpriv = "TRIGGER";
                    break;
                }
                case 'X': {
                    sqlpriv = "EXECUTE";
                    break;
                }
                case 'U': {
                    sqlpriv = "USAGE";
                    break;
                }
                case 'C': {
                    sqlpriv = "CREATE";
                    break;
                }
                case 'T': {
                    sqlpriv = "CREATE TEMP";
                    break;
                }
                default: {
                    sqlpriv = "UNKNOWN";
                }
            }
            Vector<String> usersWithPermission = (Vector<String>)privileges.get(sqlpriv);
            if (usersWithPermission == null) {
                usersWithPermission = new Vector<String>();
                privileges.put(sqlpriv, usersWithPermission);
            }
            usersWithPermission.addElement(name);
            ++i;
        }
    }

    protected Hashtable parseACL(String aclArray, String owner) {
        if (aclArray == null || aclArray == "") {
            aclArray = "{" + owner + "=arwdRxt}";
        }
        Vector acls = AbstractJdbc1DatabaseMetaData.parseACLArray(aclArray);
        Hashtable privileges = new Hashtable();
        int i = 0;
        while (i < acls.size()) {
            String acl = (String)acls.elementAt(i);
            this.addACLPrivileges(acl, privileges);
            ++i;
        }
        return privileges;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        Field[] f = new Field[8];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "SCOPE", 21, 2);
        f[1] = new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[3] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "COLUMN_SIZE", 23, 4);
        f[5] = new Field(this.connection, "BUFFER_LENGTH", 23, 4);
        f[6] = new Field(this.connection, "DECIMAL_DIGITS", 21, 2);
        f[7] = new Field(this.connection, "PSEUDO_COLUMN", 21, 2);
        String where = "";
        String from = " FROM sys_catalog.sys_namespace n, sys_catalog.sys_class ct, sys_catalog.sys_class ci, sys_catalog.sys_attribute a, sys_catalog.sys_index i ";
        where = " AND ct.relnamespace = n.oid ";
        if (schema != null && !"".equals(schema)) {
            where = where + " AND n.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schema) + "' ";
        }
        String sql = "SELECT a.attname, a.atttypid " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid " + " AND a.attrelid=ci.oid AND i.indisprimary " + " AND ct.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(table) + "' " + where + " ORDER BY a.attnum ";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            byte[][] tuple = new byte[8][];
            int columnTypeOid = rs.getInt("atttypid");
            tuple[0] = Integer.toString(scope).getBytes();
            tuple[1] = rs.getBytes("attname");
            tuple[2] = Integer.toString(this.connection.getSQLType(columnTypeOid)).getBytes();
            tuple[3] = this.connection.getPGType(columnTypeOid).getBytes();
            tuple[4] = null;
            tuple[5] = null;
            tuple[6] = null;
            tuple[7] = Integer.toString(1).getBytes();
            v.addElement(tuple);
        }
        if (rs != null) {
            rs.close();
        }
        stmt.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Field[] f = new Field[8];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "SCOPE", 21, 2);
        f[1] = new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[3] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "COLUMN_SIZE", 23, 4);
        f[5] = new Field(this.connection, "BUFFER_LENGTH", 23, 4);
        f[6] = new Field(this.connection, "DECIMAL_DIGITS", 21, 2);
        f[7] = new Field(this.connection, "PSEUDO_COLUMN", 21, 2);
        byte[][] tuple = new byte[][]{null, "ctid".getBytes(), Integer.toString(this.connection.getSQLType("tid")).getBytes(), "tid".getBytes(), null, null, null, Integer.toString(2).getBytes()};
        v.addElement(tuple);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String where = "";
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
        String from = " FROM sys_catalog.sys_namespace n, sys_catalog.sys_class ct, sys_catalog.sys_class ci, sys_catalog.sys_attribute a, sys_catalog.sys_index i ";
        where = " AND ct.relnamespace = n.oid ";
        if (schema != null && !"".equals(schema)) {
            where = where + " AND n.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schema) + "' ";
        }
        String sql = select + " ct.relname AS TABLE_NAME, " + " a.attname AS COLUMN_NAME, " + " a.attnum AS KEY_SEQ, " + " ci.relname AS PK_NAME " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid " + " AND a.attrelid=ci.oid AND i.indisprimary ";
        if (table != null && !"".equals(table)) {
            sql = sql + " AND ct.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(table) + "' ";
        }
        sql = sql + where + " ORDER BY table_name, pk_name, key_seq";
        return this.connection.createStatement().executeQuery(sql);
    }

    protected ResultSet getImportedExportedKeys(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        Field[] f = new Field[]{new Field(this.connection, "PKTABLE_CAT", 1043, this.getMaxNameLength()), new Field(this.connection, "PKTABLE_SCHEM", 1043, this.getMaxNameLength()), new Field(this.connection, "PKTABLE_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "PKCOLUMN_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "FKTABLE_CAT", 1043, this.getMaxNameLength()), new Field(this.connection, "FKTABLE_SCHEM", 1043, this.getMaxNameLength()), new Field(this.connection, "FKTABLE_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "FKCOLUMN_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "KEY_SEQ", 21, 2), new Field(this.connection, "UPDATE_RULE", 21, 2), new Field(this.connection, "DELETE_RULE", 21, 2), new Field(this.connection, "FK_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "PK_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "DEFERRABILITY", 21, 2)};
        String where = "";
        String select = "SELECT DISTINCT n1.nspname as pnspname,n2.nspname as fnspname, ";
        String from = " FROM sys_catalog.sys_namespace n1  JOIN sys_catalog.sys_class c1 ON (c1.relnamespace = n1.oid)  JOIN sys_catalog.sys_index i ON (c1.oid=i.indrelid)  JOIN sys_catalog.sys_class ic ON (i.indexrelid=ic.oid)  JOIN sys_catalog.sys_attribute a ON (ic.oid=a.attrelid),  sys_catalog.sys_namespace n2  JOIN sys_catalog.sys_class c2 ON (c2.relnamespace=n2.oid),  sys_catalog.sys_trigger t1  JOIN sys_catalog.sys_proc p1 ON (t1.tgfoid=p1.oid),  sys_catalog.sys_trigger t2  JOIN sys_catalog.sys_proc p2 ON (t2.tgfoid=p2.oid) ";
        if (primarySchema != null && !"".equals(primarySchema)) {
            where = where + " AND n1.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(primarySchema) + "' ";
        }
        if (foreignSchema != null && !"".equals(foreignSchema)) {
            where = where + " AND n2.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(foreignSchema) + "' ";
        }
        String sql = select + "c1.relname as prelname, " + "c2.relname as frelname, " + "t1.tgconstrname, " + "a.attnum as keyseq, " + "ic.relname as fkeyname, " + "t1.tgdeferrable, " + "t1.tginitdeferred, " + "t1.tgnargs,t1.tgargs, " + "p1.proname as updaterule, " + "p2.proname as deleterule " + from + "WHERE " + "(t1.tgrelid=c1.oid " + "AND t1.tgisconstraint " + "AND t1.tgconstrrelid=c2.oid ";
        sql = this.connection.getDatabaseVersion() >= 40100 ? sql + "AND p1.proname LIKE 'RI\\_FKEY\\_%\\_UPD') " : sql + "AND p1.proname LIKE 'RI\\\\_FKEY\\\\_%\\\\_UPD') ";
        sql = sql + "AND " + "(t2.tgrelid=c1.oid " + "AND t2.tgisconstraint " + "AND t2.tgconstrrelid=c2.oid ";
        sql = this.connection.getDatabaseVersion() >= 40100 ? sql + "AND p2.proname LIKE 'RI\\_FKEY\\_%\\_DEL') " : sql + "AND p2.proname LIKE 'RI\\\\_FKEY\\\\_%\\\\_DEL') ";
        sql = sql + "AND i.indisprimary " + where;
        if (primaryTable != null) {
            sql = sql + "AND c1.relname='" + AbstractJdbc1DatabaseMetaData.escapeQuotes(primaryTable) + "' ";
        }
        if (foreignTable != null) {
            sql = sql + "AND c2.relname='" + AbstractJdbc1DatabaseMetaData.escapeQuotes(foreignTable) + "' ";
        }
        sql = sql + "ORDER BY ";
        if (primaryTable != null) {
            sql = sql + "fnspname,";
            sql = sql + "frelname";
        } else {
            sql = sql + "pnspname,";
            sql = sql + "prelname";
        }
        sql = sql + ",keyseq";
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        Vector<byte[][]> tuples = new Vector<byte[][]>();
        while (rs.next()) {
            String deleteRule;
            byte[][] tuple = new byte[14][];
            tuple[1] = rs.getBytes(1);
            tuple[5] = rs.getBytes(2);
            tuple[2] = rs.getBytes(3);
            tuple[6] = rs.getBytes(4);
            String fKeyName = rs.getString(5);
            String updateRule = rs.getString(12);
            if (updateRule != null) {
                String rule = updateRule.substring(8, updateRule.length() - 4);
                int action = 3;
                if (rule == null || "NOACTION".equals(rule)) {
                    action = 3;
                }
                if ("CASCADE".equals(rule)) {
                    action = 0;
                } else if ("SETNULL".equals(rule)) {
                    action = 2;
                } else if ("SETDEFAULT".equals(rule)) {
                    action = 4;
                } else if ("RESTRICT".equals(rule)) {
                    action = 1;
                }
                tuple[9] = Integer.toString(action).getBytes();
            }
            if ((deleteRule = rs.getString(13)) != null) {
                String rule = updateRule.substring(8, updateRule.length() - 4);
                int action = 3;
                if ("CASCADE".equals(rule)) {
                    action = 0;
                } else if ("SETNULL".equals(rule)) {
                    action = 2;
                } else if ("SETDEFAULT".equals(rule)) {
                    action = 4;
                }
                tuple[10] = Integer.toString(action).getBytes();
            }
            int keySequence = rs.getInt(6);
            String fkeyColumn = "";
            String pkeyColumn = "";
            String fkName = "";
            String targs = new String(rs.getBytes(11));
            Vector tokens = AbstractJdbc1DatabaseMetaData.tokenize(targs, "\u0000");
            if (tokens.size() > 0) {
                fkName = (String)tokens.elementAt(0);
            }
            if (fkName.startsWith("<unnamed>")) {
                fkName = targs;
            }
            int element = 4 + (keySequence - 1) * 2;
            if (tokens.size() > element) {
                fkeyColumn = (String)tokens.elementAt(element);
            }
            if (tokens.size() > ++element) {
                pkeyColumn = (String)tokens.elementAt(element);
            }
            tuple[3] = pkeyColumn.getBytes();
            tuple[7] = fkeyColumn.getBytes();
            tuple[8] = rs.getBytes(6);
            tuple[11] = fkName.getBytes();
            tuple[12] = rs.getBytes(7);
            int deferrability = 7;
            boolean deferrable = rs.getBoolean(8);
            boolean initiallyDeferred = rs.getBoolean(9);
            if (deferrable) {
                deferrability = initiallyDeferred ? 5 : 6;
            }
            tuple[13] = Integer.toString(deferrability).getBytes();
            tuples.addElement(tuple);
        }
        if (rs != null) {
            rs.close();
        }
        stmt.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, tuples, "OK", 1, 0L, false));
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, catalog, schema, table);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(catalog, schema, table, null, null, null);
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getImportedExportedKeys(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
    }

    public ResultSet getTypeInfo() throws SQLException {
        if (this.connection.getDatabaseVersion() >= 40100) {
            return this.getTypeInfoSV5();
        }
        return this.getTypeInfoSV3();
    }

    private ResultSet getTypeInfoSV5() throws SQLException {
        Field[] f = new Field[18];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[2] = new Field(this.connection, "PRECISION", 23, 4);
        f[3] = new Field(this.connection, "LITERAL_PREFIX", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "LITERAL_SUFFIX", 1043, this.getMaxNameLength());
        f[5] = new Field(this.connection, "CREATE_PARAMS", 1043, this.getMaxNameLength());
        f[6] = new Field(this.connection, "NULLABLE", 21, 2);
        f[7] = new Field(this.connection, "CASE_SENSITIVE", 16, 1);
        f[8] = new Field(this.connection, "SEARCHABLE", 21, 2);
        f[9] = new Field(this.connection, "UNSIGNED_ATTRIBUTE", 16, 1);
        f[10] = new Field(this.connection, "FIXED_PREC_SCALE", 16, 1);
        f[11] = new Field(this.connection, "AUTO_INCREMENT", 16, 1);
        f[12] = new Field(this.connection, "LOCAL_TYPE_NAME", 1043, this.getMaxNameLength());
        f[13] = new Field(this.connection, "MINIMUM_SCALE", 21, 2);
        f[14] = new Field(this.connection, "MAXIMUM_SCALE", 21, 2);
        f[15] = new Field(this.connection, "SQL_DATA_TYPE", 23, 4);
        f[16] = new Field(this.connection, "SQL_DATETIME_SUB", 23, 4);
        f[17] = new Field(this.connection, "NUM_PREC_RADIX", 23, 4);
        KBTypeInfo[] typeInfo = KBTypeInfo.getAllTypeInfo();
        int i = 0;
        while (i < typeInfo.length) {
            byte[][] tuple = new byte[][]{typeInfo[i].getTypeName().getBytes(), Integer.toString(typeInfo[i].getDataType()).getBytes(), Integer.toString(typeInfo[i].getPrecision()).getBytes(), typeInfo[i].getLiteralPrefix() == null ? null : typeInfo[i].getLiteralPrefix().getBytes(), typeInfo[i].getLiteralSuffix() == null ? null : typeInfo[i].getLiteralSuffix().getBytes(), typeInfo[i].getCreateParams() == null ? null : typeInfo[i].getCreateParams().getBytes(), Integer.toString(typeInfo[i].getNullable()).getBytes(), (typeInfo[i].getCaseSensitive() ? "t" : "f").getBytes(), new Integer(typeInfo[i].getSearchable()).toString().getBytes(), (typeInfo[i].getUnsignedAttribute() ? "t" : "f").getBytes(), (typeInfo[i].getFixedPrecScale() ? "t" : "f").getBytes(), (typeInfo[i].getAutoIncrement() ? "t" : "f").getBytes(), typeInfo[i].getLocalTypeName().getBytes(), Integer.toString(typeInfo[i].getMinimumScale()).getBytes(), Integer.toString(typeInfo[i].getMaximumScale()).getBytes(), Integer.toString(typeInfo[i].getSqlDataType()).getBytes(), Integer.toString(typeInfo[i].getSqlDatatimeSub()).getBytes(), Integer.toString(typeInfo[i].getNumPrecRadix()).getBytes()};
            v.addElement(tuple);
            ++i;
        }
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    private ResultSet getTypeInfoSV4() throws SQLException {
        Field[] f = new Field[18];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[2] = new Field(this.connection, "PRECISION", 23, 4);
        f[3] = new Field(this.connection, "LITERAL_PREFIX", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "LITERAL_SUFFIX", 1043, this.getMaxNameLength());
        f[5] = new Field(this.connection, "CREATE_PARAMS", 1043, this.getMaxNameLength());
        f[6] = new Field(this.connection, "NULLABLE", 21, 2);
        f[7] = new Field(this.connection, "CASE_SENSITIVE", 16, 1);
        f[8] = new Field(this.connection, "SEARCHABLE", 21, 2);
        f[9] = new Field(this.connection, "UNSIGNED_ATTRIBUTE", 16, 1);
        f[10] = new Field(this.connection, "FIXED_PREC_SCALE", 16, 1);
        f[11] = new Field(this.connection, "AUTO_INCREMENT", 16, 1);
        f[12] = new Field(this.connection, "LOCAL_TYPE_NAME", 1043, this.getMaxNameLength());
        f[13] = new Field(this.connection, "MINIMUM_SCALE", 21, 2);
        f[14] = new Field(this.connection, "MAXIMUM_SCALE", 21, 2);
        f[15] = new Field(this.connection, "SQL_DATA_TYPE", 23, 4);
        f[16] = new Field(this.connection, "SQL_DATETIME_SUB", 23, 4);
        f[17] = new Field(this.connection, "NUM_PREC_RADIX", 23, 4);
        byte[][] tuple = new byte[18][];
        tuple[0] = "SMALLINT".getBytes();
        tuple[1] = new Integer(5).toString().getBytes();
        tuple[2] = new Integer(5).toString().getBytes();
        tuple[5] = null;
        tuple[4] = null;
        tuple[3] = null;
        tuple[6] = new Integer(1).toString().getBytes();
        tuple[7] = "f".getBytes();
        tuple[8] = new Integer(2).toString().getBytes();
        tuple[10] = tuple[11] = "f".getBytes();
        tuple[9] = tuple[11];
        tuple[16] = null;
        tuple[15] = null;
        tuple[12] = null;
        tuple[13] = tuple[14] = new Integer(0).toString().getBytes();
        tuple[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple);
        byte[][] tuple1 = new byte[18][];
        tuple1[0] = "INTEGER".getBytes();
        tuple1[1] = new Integer(4).toString().getBytes();
        tuple1[2] = new Integer(10).toString().getBytes();
        tuple1[5] = null;
        tuple1[4] = null;
        tuple1[3] = null;
        tuple1[6] = new Integer(1).toString().getBytes();
        tuple1[7] = "f".getBytes();
        tuple1[8] = new Integer(2).toString().getBytes();
        tuple1[10] = tuple1[11] = "f".getBytes();
        tuple1[9] = tuple1[11];
        tuple1[16] = null;
        tuple1[15] = null;
        tuple1[12] = null;
        tuple1[13] = tuple1[14] = new Integer(0).toString().getBytes();
        tuple1[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple1);
        byte[][] tuple2 = new byte[18][];
        tuple2[0] = "BIGINT".getBytes();
        tuple2[1] = new Integer(-5).toString().getBytes();
        tuple2[2] = new Integer(19).toString().getBytes();
        tuple2[5] = null;
        tuple2[4] = null;
        tuple2[3] = null;
        tuple2[6] = new Integer(1).toString().getBytes();
        tuple2[7] = "f".getBytes();
        tuple2[8] = new Integer(2).toString().getBytes();
        tuple2[10] = tuple2[11] = "f".getBytes();
        tuple2[9] = tuple2[11];
        tuple2[16] = null;
        tuple2[15] = null;
        tuple2[12] = null;
        tuple2[13] = tuple2[14] = new Integer(0).toString().getBytes();
        tuple2[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple2);
        byte[][] tuple3 = new byte[18][];
        tuple3[0] = "REAL".getBytes();
        tuple3[1] = new Integer(7).toString().getBytes();
        tuple3[2] = new Integer(24).toString().getBytes();
        tuple3[5] = null;
        tuple3[4] = null;
        tuple3[3] = null;
        tuple3[6] = new Integer(1).toString().getBytes();
        tuple3[7] = "f".getBytes();
        tuple3[8] = new Integer(2).toString().getBytes();
        tuple3[10] = tuple3[11] = "f".getBytes();
        tuple3[9] = tuple3[11];
        tuple3[16] = null;
        tuple3[15] = null;
        tuple3[12] = null;
        tuple3[13] = "0".getBytes();
        tuple3[14] = "8".getBytes();
        tuple3[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple3);
        byte[][] tuple4 = new byte[18][];
        tuple4[0] = "DOUBLE".getBytes();
        tuple4[1] = new Integer(8).toString().getBytes();
        tuple4[2] = new Integer(53).toString().getBytes();
        tuple4[5] = null;
        tuple4[4] = null;
        tuple4[3] = null;
        tuple4[6] = new Integer(1).toString().getBytes();
        tuple4[7] = "f".getBytes();
        tuple4[8] = new Integer(2).toString().getBytes();
        tuple4[10] = tuple4[11] = "f".getBytes();
        tuple4[9] = tuple4[11];
        tuple4[16] = null;
        tuple4[15] = null;
        tuple4[12] = null;
        tuple4[13] = "0".getBytes();
        tuple4[14] = "8".getBytes();
        tuple4[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple4);
        byte[][] tuple5 = new byte[18][];
        tuple5[0] = "NUMERIC".getBytes();
        tuple5[1] = new Integer(2).toString().getBytes();
        tuple5[2] = new Integer(1000).toString().getBytes();
        tuple5[4] = null;
        tuple5[3] = null;
        tuple5[5] = "precision,scale".getBytes();
        tuple5[6] = new Integer(1).toString().getBytes();
        tuple5[7] = "f".getBytes();
        tuple5[8] = new Integer(2).toString().getBytes();
        tuple5[10] = tuple5[11] = "f".getBytes();
        tuple5[9] = tuple5[11];
        tuple5[16] = null;
        tuple5[15] = null;
        tuple5[12] = null;
        tuple5[13] = new Integer(0).toString().getBytes();
        tuple5[14] = new Integer(1000).toString().getBytes();
        tuple5[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple5);
        byte[][] tuple6 = new byte[18][];
        tuple6[0] = "BLOB".getBytes();
        tuple6[1] = new Integer(2004).toString().getBytes();
        tuple6[2] = new Integer(Integer.MAX_VALUE).toString().getBytes();
        tuple6[4] = null;
        tuple6[3] = null;
        tuple6[5] = null;
        tuple6[6] = new Integer(1).toString().getBytes();
        tuple6[7] = "f".getBytes();
        tuple6[8] = new Integer(0).toString().getBytes();
        tuple6[9] = null;
        tuple6[10] = "f".getBytes();
        tuple6[11] = null;
        tuple6[17] = null;
        tuple6[16] = null;
        tuple6[15] = null;
        tuple6[14] = null;
        tuple6[13] = null;
        tuple6[12] = null;
        v.addElement(tuple6);
        byte[][] tuple7 = new byte[18][];
        tuple7[0] = "CHAR".getBytes();
        tuple7[1] = new Integer(1).toString().getBytes();
        tuple7[2] = new Integer(8000).toString().getBytes();
        tuple7[3] = tuple7[4] = "'".getBytes();
        tuple7[5] = "length".getBytes();
        tuple7[6] = new Integer(1).toString().getBytes();
        tuple7[7] = "t".getBytes();
        tuple7[8] = new Integer(1).toString().getBytes();
        tuple7[9] = null;
        tuple7[10] = "f".getBytes();
        tuple7[11] = null;
        tuple7[17] = null;
        tuple7[16] = null;
        tuple7[15] = null;
        tuple7[14] = null;
        tuple7[13] = null;
        tuple7[12] = null;
        v.addElement(tuple7);
        byte[][] tuple8 = new byte[18][];
        tuple8[0] = "VARCHAR".getBytes();
        tuple8[1] = new Integer(12).toString().getBytes();
        tuple8[2] = new Integer(8000).toString().getBytes();
        tuple8[3] = tuple8[4] = "'".getBytes();
        tuple8[5] = "max length".getBytes();
        tuple8[6] = new Integer(1).toString().getBytes();
        tuple8[7] = "t".getBytes();
        tuple8[8] = new Integer(1).toString().getBytes();
        tuple8[9] = null;
        tuple8[10] = "f".getBytes();
        tuple8[11] = null;
        tuple8[17] = null;
        tuple8[16] = null;
        tuple8[15] = null;
        tuple8[14] = null;
        tuple8[13] = null;
        tuple8[12] = null;
        v.addElement(tuple8);
        byte[][] tuple9 = new byte[18][];
        tuple9[0] = "TEXT".getBytes();
        tuple9[1] = new Integer(-1).toString().getBytes();
        tuple9[2] = new Integer(65536).toString().getBytes();
        tuple9[3] = tuple9[4] = "'".getBytes();
        tuple9[5] = null;
        tuple9[6] = new Integer(1).toString().getBytes();
        tuple9[7] = "t".getBytes();
        tuple9[8] = new Integer(0).toString().getBytes();
        tuple9[9] = null;
        tuple9[10] = "f".getBytes();
        tuple9[11] = null;
        tuple9[17] = null;
        tuple9[16] = null;
        tuple9[15] = null;
        tuple9[14] = null;
        tuple9[13] = null;
        tuple9[12] = null;
        v.addElement(tuple9);
        byte[][] tuple10 = new byte[18][];
        tuple10[0] = "BYTEA".getBytes();
        tuple10[1] = new Integer(-4).toString().getBytes();
        tuple10[2] = new Integer(65536).toString().getBytes();
        tuple10[3] = tuple10[4] = "'".getBytes();
        tuple10[5] = null;
        tuple10[6] = new Integer(1).toString().getBytes();
        tuple10[7] = "t".getBytes();
        tuple10[8] = new Integer(0).toString().getBytes();
        tuple10[9] = null;
        tuple10[10] = "f".getBytes();
        tuple10[11] = null;
        tuple10[17] = null;
        tuple10[16] = null;
        tuple10[15] = null;
        tuple10[14] = null;
        tuple10[13] = null;
        tuple10[12] = null;
        v.addElement(tuple10);
        byte[][] tuple11 = new byte[18][];
        tuple11[0] = "DATE".getBytes();
        tuple11[1] = new Integer(91).toString().getBytes();
        tuple11[2] = new Integer(10).toString().getBytes();
        tuple11[3] = tuple11[4] = "'".getBytes();
        tuple11[5] = null;
        tuple11[6] = new Integer(1).toString().getBytes();
        tuple11[7] = "f".getBytes();
        tuple11[8] = new Integer(2).toString().getBytes();
        tuple11[9] = null;
        tuple11[10] = "f".getBytes();
        tuple11[11] = null;
        tuple11[17] = null;
        tuple11[16] = null;
        tuple11[15] = null;
        tuple11[14] = null;
        tuple11[13] = null;
        tuple11[12] = null;
        v.addElement(tuple11);
        byte[][] tuple12 = new byte[18][];
        tuple12[0] = "TIME".getBytes();
        tuple12[1] = new Integer(92).toString().getBytes();
        tuple12[2] = new Integer(15).toString().getBytes();
        tuple12[3] = tuple12[4] = "'".getBytes();
        tuple12[5] = null;
        tuple12[6] = new Integer(1).toString().getBytes();
        tuple12[7] = "f".getBytes();
        tuple12[8] = new Integer(2).toString().getBytes();
        tuple12[9] = null;
        tuple12[10] = "f".getBytes();
        tuple12[11] = null;
        tuple12[17] = null;
        tuple12[16] = null;
        tuple12[15] = null;
        tuple12[14] = null;
        tuple12[13] = null;
        tuple12[12] = null;
        tuple12[13] = "0".getBytes();
        tuple12[14] = "6".getBytes();
        v.addElement(tuple12);
        byte[][] tuple13 = new byte[18][];
        tuple13[0] = "TIMESTAMP".getBytes();
        tuple13[1] = new Integer(93).toString().getBytes();
        tuple13[2] = new Integer(26).toString().getBytes();
        tuple13[3] = tuple13[4] = "'".getBytes();
        tuple13[5] = null;
        tuple13[6] = new Integer(1).toString().getBytes();
        tuple13[7] = "f".getBytes();
        tuple13[8] = new Integer(2).toString().getBytes();
        tuple13[9] = null;
        tuple13[10] = "f".getBytes();
        tuple13[11] = null;
        tuple13[17] = null;
        tuple13[16] = null;
        tuple13[15] = null;
        tuple13[12] = null;
        tuple13[13] = tuple13[14] = new Integer(3).toString().getBytes();
        tuple12[13] = "0".getBytes();
        tuple12[14] = "6".getBytes();
        v.addElement(tuple13);
        byte[][] tuple14 = new byte[18][];
        tuple14[0] = "TIMESTAMP WITH TIME ZONE".getBytes();
        tuple14[1] = new Integer(93).toString().getBytes();
        tuple14[2] = new Integer(29).toString().getBytes();
        tuple14[3] = tuple14[4] = "'".getBytes();
        tuple14[5] = null;
        tuple14[6] = new Integer(1).toString().getBytes();
        tuple14[7] = "f".getBytes();
        tuple14[8] = new Integer(2).toString().getBytes();
        tuple14[9] = null;
        tuple14[10] = "f".getBytes();
        tuple14[11] = null;
        tuple14[17] = null;
        tuple14[16] = null;
        tuple14[15] = null;
        tuple14[12] = null;
        tuple14[13] = tuple14[14] = new Integer(3).toString().getBytes();
        tuple12[13] = "0".getBytes();
        tuple12[14] = "6".getBytes();
        v.addElement(tuple14);
        byte[][] tuple15 = new byte[18][];
        tuple15[0] = "BOOLEAN".getBytes();
        tuple15[1] = new Integer(16).toString().getBytes();
        tuple15[2] = new Integer(1).toString().getBytes();
        tuple15[5] = null;
        tuple15[4] = null;
        tuple15[3] = null;
        tuple15[6] = new Integer(1).toString().getBytes();
        tuple15[7] = "f".getBytes();
        tuple15[8] = new Integer(2).toString().getBytes();
        tuple15[9] = null;
        tuple15[10] = "f".getBytes();
        tuple15[13] = null;
        tuple15[12] = null;
        tuple15[11] = null;
        tuple15[17] = null;
        tuple15[16] = null;
        tuple15[15] = null;
        tuple15[14] = null;
        v.addElement(tuple15);
        byte[][] tuple16 = new byte[18][];
        tuple16[0] = "TIME WITH TIME ZONE".getBytes();
        tuple16[1] = new Integer(92).toString().getBytes();
        tuple16[2] = new Integer(18).toString().getBytes();
        tuple16[3] = tuple16[4] = "'".getBytes();
        tuple16[5] = null;
        tuple16[6] = new Integer(1).toString().getBytes();
        tuple16[7] = "f".getBytes();
        tuple16[8] = new Integer(2).toString().getBytes();
        tuple16[9] = null;
        tuple16[10] = "f".getBytes();
        tuple16[13] = null;
        tuple16[12] = null;
        tuple16[11] = null;
        tuple16[17] = null;
        tuple16[16] = null;
        tuple16[15] = null;
        tuple16[14] = null;
        tuple12[13] = "0".getBytes();
        tuple12[14] = "6".getBytes();
        v.addElement(tuple16);
        byte[][] tuple17 = new byte[18][];
        tuple17[0] = "TINYINT".getBytes();
        tuple17[1] = new Integer(4).toString().getBytes();
        tuple17[2] = new Integer(3).toString().getBytes();
        tuple17[5] = null;
        tuple17[4] = null;
        tuple17[3] = null;
        tuple17[6] = new Integer(1).toString().getBytes();
        tuple17[7] = "f".getBytes();
        tuple17[8] = new Integer(2).toString().getBytes();
        tuple17[10] = tuple17[11] = "f".getBytes();
        tuple17[9] = tuple17[11];
        tuple17[16] = null;
        tuple17[15] = null;
        tuple17[12] = null;
        tuple17[13] = tuple17[14] = new Integer(0).toString().getBytes();
        tuple17[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple17);
        byte[][] tuple18 = new byte[18][];
        tuple18[0] = "CLOB".getBytes();
        tuple18[1] = new Integer(2005).toString().getBytes();
        tuple18[2] = new Integer(Integer.MAX_VALUE).toString().getBytes();
        tuple18[4] = null;
        tuple18[3] = null;
        tuple18[5] = null;
        tuple18[6] = new Integer(1).toString().getBytes();
        tuple18[7] = "f".getBytes();
        tuple18[8] = new Integer(0).toString().getBytes();
        tuple18[9] = null;
        tuple18[10] = "f".getBytes();
        tuple18[11] = null;
        tuple18[17] = null;
        tuple18[16] = null;
        tuple18[15] = null;
        tuple18[14] = null;
        tuple18[13] = null;
        tuple18[12] = null;
        v.addElement(tuple18);
        byte[][] tuple19 = new byte[18][];
        tuple19[0] = "DECIMAL".getBytes();
        tuple19[1] = new Integer(3).toString().getBytes();
        tuple19[2] = new Integer(28).toString().getBytes();
        tuple19[4] = null;
        tuple19[3] = null;
        tuple19[5] = "precision,scale".getBytes();
        tuple19[6] = new Integer(1).toString().getBytes();
        tuple19[7] = "f".getBytes();
        tuple19[8] = new Integer(2).toString().getBytes();
        tuple19[10] = tuple19[11] = "f".getBytes();
        tuple19[9] = tuple19[11];
        tuple19[16] = null;
        tuple19[15] = null;
        tuple19[12] = null;
        tuple19[13] = new Integer(0).toString().getBytes();
        tuple19[14] = new Integer(28).toString().getBytes();
        tuple19[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple19);
        byte[][] tuple21 = new byte[18][];
        tuple21[0] = "BIT".getBytes();
        tuple21[1] = new Integer(-7).toString().getBytes();
        tuple21[2] = new Integer(64000).toString().getBytes();
        tuple21[4] = null;
        tuple21[3] = null;
        tuple21[5] = "length".getBytes();
        tuple21[6] = new Integer(1).toString().getBytes();
        tuple21[7] = "f".getBytes();
        tuple21[8] = new Integer(2).toString().getBytes();
        tuple21[10] = tuple21[11] = "f".getBytes();
        tuple21[9] = tuple21[11];
        tuple21[16] = null;
        tuple21[15] = null;
        tuple21[12] = null;
        tuple21[13] = new Integer(0).toString().getBytes();
        tuple21[14] = new Integer(0).toString().getBytes();
        tuple21[17] = new Integer(2).toString().getBytes();
        v.addElement(tuple21);
        byte[][] tuple22 = new byte[18][];
        tuple22[0] = "BIT VARYING".getBytes();
        tuple22[1] = new Integer(-7).toString().getBytes();
        tuple22[2] = new Integer(64000).toString().getBytes();
        tuple22[4] = null;
        tuple22[3] = null;
        tuple22[5] = "length".getBytes();
        tuple22[6] = new Integer(1).toString().getBytes();
        tuple22[7] = "f".getBytes();
        tuple22[8] = new Integer(2).toString().getBytes();
        tuple22[10] = tuple22[11] = "f".getBytes();
        tuple22[9] = tuple22[11];
        tuple22[16] = null;
        tuple22[15] = null;
        tuple22[12] = null;
        tuple22[13] = new Integer(0).toString().getBytes();
        tuple22[14] = new Integer(0).toString().getBytes();
        tuple22[17] = new Integer(2).toString().getBytes();
        v.addElement(tuple22);
        byte[][] tuple20 = new byte[18][];
        tuple20[0] = "INTERVAL YEAR".getBytes();
        tuple20[1] = new Integer(1111).toString().getBytes();
        tuple20[2] = new Integer(9).toString().getBytes();
        tuple20[3] = tuple20[4] = "'".getBytes();
        tuple20[5] = null;
        tuple20[6] = new Integer(1).toString().getBytes();
        tuple20[7] = "f".getBytes();
        tuple20[8] = new Integer(2).toString().getBytes();
        tuple20[10] = tuple20[11] = "f".getBytes();
        tuple20[9] = tuple20[11];
        tuple20[16] = null;
        tuple20[15] = null;
        tuple20[12] = null;
        tuple20[13] = new Integer(6).toString().getBytes();
        tuple20[14] = new Integer(0).toString().getBytes();
        tuple20[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple20);
        byte[][] tuple23 = new byte[18][];
        tuple23[0] = "INTERVAL MONTH".getBytes();
        tuple23[1] = new Integer(1111).toString().getBytes();
        tuple23[2] = new Integer(9).toString().getBytes();
        tuple23[3] = tuple23[4] = "'".getBytes();
        tuple23[5] = null;
        tuple23[6] = new Integer(1).toString().getBytes();
        tuple23[7] = "f".getBytes();
        tuple23[8] = new Integer(2).toString().getBytes();
        tuple23[10] = tuple23[11] = "f".getBytes();
        tuple23[9] = tuple23[11];
        tuple23[16] = null;
        tuple23[15] = null;
        tuple23[12] = null;
        tuple23[13] = new Integer(6).toString().getBytes();
        tuple23[14] = new Integer(0).toString().getBytes();
        tuple23[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple23);
        byte[][] tuple24 = new byte[18][];
        tuple24[0] = "INTERVAL DAY".getBytes();
        tuple24[1] = new Integer(1111).toString().getBytes();
        tuple24[2] = new Integer(9).toString().getBytes();
        tuple24[3] = tuple24[4] = "'".getBytes();
        tuple24[5] = null;
        tuple24[6] = new Integer(1).toString().getBytes();
        tuple24[7] = "f".getBytes();
        tuple24[8] = new Integer(2).toString().getBytes();
        tuple24[10] = tuple24[11] = "f".getBytes();
        tuple24[9] = tuple24[11];
        tuple24[16] = null;
        tuple24[15] = null;
        tuple24[12] = null;
        tuple24[13] = new Integer(6).toString().getBytes();
        tuple24[14] = new Integer(0).toString().getBytes();
        tuple24[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple24);
        byte[][] tuple25 = new byte[18][];
        tuple25[0] = "INTERVAL HOUR".getBytes();
        tuple25[1] = new Integer(1111).toString().getBytes();
        tuple25[2] = new Integer(9).toString().getBytes();
        tuple25[3] = tuple25[4] = "'".getBytes();
        tuple25[5] = null;
        tuple25[6] = new Integer(1).toString().getBytes();
        tuple25[7] = "f".getBytes();
        tuple25[8] = new Integer(2).toString().getBytes();
        tuple25[10] = tuple25[11] = "f".getBytes();
        tuple25[9] = tuple25[11];
        tuple25[16] = null;
        tuple25[15] = null;
        tuple25[12] = null;
        tuple25[13] = new Integer(6).toString().getBytes();
        tuple25[14] = new Integer(0).toString().getBytes();
        tuple25[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple25);
        byte[][] tuple26 = new byte[18][];
        tuple26[0] = "INTERVAL MINUTE".getBytes();
        tuple26[1] = new Integer(1111).toString().getBytes();
        tuple26[2] = new Integer(9).toString().getBytes();
        tuple26[3] = tuple26[4] = "'".getBytes();
        tuple26[5] = null;
        tuple26[6] = new Integer(1).toString().getBytes();
        tuple26[7] = "f".getBytes();
        tuple26[8] = new Integer(2).toString().getBytes();
        tuple26[10] = tuple26[11] = "f".getBytes();
        tuple26[9] = tuple26[11];
        tuple26[16] = null;
        tuple26[15] = null;
        tuple26[12] = null;
        tuple26[13] = new Integer(6).toString().getBytes();
        tuple26[14] = new Integer(0).toString().getBytes();
        tuple26[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple26);
        byte[][] tuple27 = new byte[18][];
        tuple27[0] = "INTERVAL SECOND".getBytes();
        tuple27[1] = new Integer(1111).toString().getBytes();
        tuple27[2] = new Integer(9).toString().getBytes();
        tuple27[3] = tuple27[4] = "'".getBytes();
        tuple27[5] = null;
        tuple27[6] = new Integer(1).toString().getBytes();
        tuple27[7] = "f".getBytes();
        tuple27[8] = new Integer(2).toString().getBytes();
        tuple27[10] = tuple27[11] = "f".getBytes();
        tuple27[9] = tuple27[11];
        tuple27[16] = null;
        tuple27[15] = null;
        tuple27[12] = null;
        tuple27[13] = new Integer(6).toString().getBytes();
        tuple27[14] = new Integer(0).toString().getBytes();
        tuple27[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple27);
        byte[][] tuple28 = new byte[18][];
        tuple28[0] = "INTERVAL YEAR TO MONTH".getBytes();
        tuple28[1] = new Integer(1111).toString().getBytes();
        tuple28[2] = new Integer(9).toString().getBytes();
        tuple28[3] = tuple28[4] = "'".getBytes();
        tuple28[5] = null;
        tuple28[6] = new Integer(1).toString().getBytes();
        tuple28[7] = "f".getBytes();
        tuple28[8] = new Integer(2).toString().getBytes();
        tuple28[10] = tuple28[11] = "f".getBytes();
        tuple28[9] = tuple28[11];
        tuple28[16] = null;
        tuple28[15] = null;
        tuple28[12] = null;
        tuple28[13] = new Integer(6).toString().getBytes();
        tuple28[14] = new Integer(0).toString().getBytes();
        tuple28[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple28);
        byte[][] tuple29 = new byte[18][];
        tuple29[0] = "INTERVAL DAY TO SECOND".getBytes();
        tuple29[1] = new Integer(1111).toString().getBytes();
        tuple29[2] = new Integer(9).toString().getBytes();
        tuple29[3] = tuple29[4] = "'".getBytes();
        tuple29[5] = null;
        tuple29[6] = new Integer(1).toString().getBytes();
        tuple29[7] = "f".getBytes();
        tuple29[8] = new Integer(2).toString().getBytes();
        tuple29[10] = tuple29[11] = "f".getBytes();
        tuple29[9] = tuple29[11];
        tuple29[16] = null;
        tuple29[15] = null;
        tuple29[12] = null;
        tuple29[13] = new Integer(6).toString().getBytes();
        tuple29[14] = new Integer(0).toString().getBytes();
        tuple29[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple29);
        byte[][] tuple31 = new byte[18][];
        tuple31[0] = "FLOAT".getBytes();
        tuple31[1] = new Integer(6).toString().getBytes();
        tuple31[2] = new Integer(53).toString().getBytes();
        tuple31[5] = null;
        tuple31[4] = null;
        tuple31[3] = null;
        tuple31[5] = "length".getBytes();
        tuple31[6] = new Integer(1).toString().getBytes();
        tuple31[7] = "f".getBytes();
        tuple31[8] = new Integer(2).toString().getBytes();
        tuple31[10] = tuple31[11] = "f".getBytes();
        tuple31[9] = tuple31[11];
        tuple31[16] = null;
        tuple31[15] = null;
        tuple31[12] = null;
        tuple31[13] = "0".getBytes();
        tuple31[14] = "8".getBytes();
        tuple31[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple31);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    private ResultSet getTypeInfoSV3() throws SQLException {
        Field[] f = new Field[18];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[2] = new Field(this.connection, "PRECISION", 23, 4);
        f[3] = new Field(this.connection, "LITERAL_PREFIX", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "LITERAL_SUFFIX", 1043, this.getMaxNameLength());
        f[5] = new Field(this.connection, "CREATE_PARAMS", 1043, this.getMaxNameLength());
        f[6] = new Field(this.connection, "NULLABLE", 21, 2);
        f[7] = new Field(this.connection, "CASE_SENSITIVE", 16, 1);
        f[8] = new Field(this.connection, "SEARCHABLE", 21, 2);
        f[9] = new Field(this.connection, "UNSIGNED_ATTRIBUTE", 16, 1);
        f[10] = new Field(this.connection, "FIXED_PREC_SCALE", 16, 1);
        f[11] = new Field(this.connection, "AUTO_INCREMENT", 16, 1);
        f[12] = new Field(this.connection, "LOCAL_TYPE_NAME", 1043, this.getMaxNameLength());
        f[13] = new Field(this.connection, "MINIMUM_SCALE", 21, 2);
        f[14] = new Field(this.connection, "MAXIMUM_SCALE", 21, 2);
        f[15] = new Field(this.connection, "SQL_DATA_TYPE", 23, 4);
        f[16] = new Field(this.connection, "SQL_DATETIME_SUB", 23, 4);
        f[17] = new Field(this.connection, "NUM_PREC_RADIX", 23, 4);
        byte[][] tuple = new byte[18][];
        tuple[0] = "int2".getBytes();
        tuple[1] = new Integer(5).toString().getBytes();
        tuple[2] = new Integer(5).toString().getBytes();
        tuple[5] = null;
        tuple[4] = null;
        tuple[3] = null;
        tuple[6] = new Integer(1).toString().getBytes();
        tuple[7] = "f".getBytes();
        tuple[8] = new Integer(2).toString().getBytes();
        tuple[10] = tuple[11] = "f".getBytes();
        tuple[9] = tuple[11];
        tuple[16] = null;
        tuple[15] = null;
        tuple[12] = null;
        tuple[13] = tuple[14] = new Integer(0).toString().getBytes();
        tuple[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple);
        byte[][] tuple1 = new byte[18][];
        tuple1[0] = "int4".getBytes();
        tuple1[1] = new Integer(4).toString().getBytes();
        tuple1[2] = new Integer(10).toString().getBytes();
        tuple1[5] = null;
        tuple1[4] = null;
        tuple1[3] = null;
        tuple1[6] = new Integer(1).toString().getBytes();
        tuple1[7] = "f".getBytes();
        tuple1[8] = new Integer(2).toString().getBytes();
        tuple1[10] = tuple1[11] = "f".getBytes();
        tuple1[9] = tuple1[11];
        tuple1[16] = null;
        tuple1[15] = null;
        tuple1[12] = null;
        tuple1[13] = tuple1[14] = new Integer(0).toString().getBytes();
        tuple1[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple1);
        byte[][] tuple2 = new byte[18][];
        tuple2[0] = "int8".getBytes();
        tuple2[1] = new Integer(-5).toString().getBytes();
        tuple2[2] = new Integer(19).toString().getBytes();
        tuple2[5] = null;
        tuple2[4] = null;
        tuple2[3] = null;
        tuple2[6] = new Integer(1).toString().getBytes();
        tuple2[7] = "f".getBytes();
        tuple2[8] = new Integer(2).toString().getBytes();
        tuple2[10] = tuple2[11] = "f".getBytes();
        tuple2[9] = tuple2[11];
        tuple2[16] = null;
        tuple2[15] = null;
        tuple2[12] = null;
        tuple2[13] = tuple2[14] = new Integer(0).toString().getBytes();
        tuple2[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple2);
        byte[][] tuple3 = new byte[18][];
        tuple3[0] = "float4".getBytes();
        tuple3[1] = new Integer(7).toString().getBytes();
        tuple3[2] = new Integer(24).toString().getBytes();
        tuple3[5] = null;
        tuple3[4] = null;
        tuple3[3] = null;
        tuple3[6] = new Integer(1).toString().getBytes();
        tuple3[7] = "f".getBytes();
        tuple3[8] = new Integer(2).toString().getBytes();
        tuple3[10] = tuple3[11] = "f".getBytes();
        tuple3[9] = tuple3[11];
        tuple3[16] = null;
        tuple3[15] = null;
        tuple3[12] = null;
        tuple3[13] = "0".getBytes();
        tuple3[14] = "8".getBytes();
        tuple3[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple3);
        byte[][] tuple4 = new byte[18][];
        tuple4[0] = "float8".getBytes();
        tuple4[1] = new Integer(6).toString().getBytes();
        tuple4[2] = new Integer(53).toString().getBytes();
        tuple4[5] = null;
        tuple4[4] = null;
        tuple4[3] = null;
        tuple4[6] = new Integer(1).toString().getBytes();
        tuple4[7] = "f".getBytes();
        tuple4[8] = new Integer(2).toString().getBytes();
        tuple4[10] = tuple4[11] = "f".getBytes();
        tuple4[9] = tuple4[11];
        tuple4[16] = null;
        tuple4[15] = null;
        tuple4[12] = null;
        tuple4[13] = "0".getBytes();
        tuple4[14] = "14".getBytes();
        tuple4[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple4);
        byte[][] tuple5 = new byte[18][];
        tuple5[0] = "numeric".getBytes();
        tuple5[1] = new Integer(2).toString().getBytes();
        tuple5[2] = new Integer(38).toString().getBytes();
        tuple5[4] = null;
        tuple5[3] = null;
        tuple5[5] = "precision,scale".getBytes();
        tuple5[6] = new Integer(1).toString().getBytes();
        tuple5[7] = "f".getBytes();
        tuple5[8] = new Integer(2).toString().getBytes();
        tuple5[10] = tuple5[11] = "f".getBytes();
        tuple5[9] = tuple5[11];
        tuple5[16] = null;
        tuple5[15] = null;
        tuple5[12] = null;
        tuple5[13] = new Integer(28).toString().getBytes();
        tuple5[14] = new Integer(0).toString().getBytes();
        tuple5[17] = new Integer(10).toString().getBytes();
        v.addElement(tuple5);
        byte[][] tuple6 = new byte[18][];
        tuple6[0] = "blob".getBytes();
        tuple6[1] = new Integer(2004).toString().getBytes();
        tuple6[2] = null;
        tuple6[4] = null;
        tuple6[3] = null;
        tuple6[5] = null;
        tuple6[6] = new Integer(1).toString().getBytes();
        tuple6[7] = "f".getBytes();
        tuple6[8] = new Integer(0).toString().getBytes();
        tuple6[9] = null;
        tuple6[10] = "f".getBytes();
        tuple6[11] = null;
        tuple6[17] = null;
        tuple6[16] = null;
        tuple6[15] = null;
        tuple6[14] = null;
        tuple6[13] = null;
        tuple6[12] = null;
        v.addElement(tuple6);
        byte[][] tuple7 = new byte[18][];
        tuple7[0] = "char".getBytes();
        tuple7[1] = new Integer(1).toString().getBytes();
        tuple7[2] = new Integer(0xA00000).toString().getBytes();
        tuple7[3] = tuple7[4] = "'".getBytes();
        tuple7[5] = "length".getBytes();
        tuple7[6] = new Integer(1).toString().getBytes();
        tuple7[7] = "t".getBytes();
        tuple7[8] = new Integer(1).toString().getBytes();
        tuple7[9] = null;
        tuple7[10] = "f".getBytes();
        tuple7[11] = null;
        tuple7[17] = null;
        tuple7[16] = null;
        tuple7[15] = null;
        tuple7[14] = null;
        tuple7[13] = null;
        tuple7[12] = null;
        v.addElement(tuple7);
        byte[][] tuple8 = new byte[18][];
        tuple8[0] = "varchar".getBytes();
        tuple8[1] = new Integer(12).toString().getBytes();
        tuple8[2] = new Integer(0xA00000).toString().getBytes();
        tuple8[3] = tuple8[4] = "'".getBytes();
        tuple8[5] = "max length".getBytes();
        tuple8[6] = new Integer(1).toString().getBytes();
        tuple8[7] = "t".getBytes();
        tuple8[8] = new Integer(1).toString().getBytes();
        tuple8[9] = null;
        tuple8[10] = "f".getBytes();
        tuple8[11] = null;
        tuple8[17] = null;
        tuple8[16] = null;
        tuple8[15] = null;
        tuple8[14] = null;
        tuple8[13] = null;
        tuple8[12] = null;
        v.addElement(tuple8);
        byte[][] tuple9 = new byte[18][];
        tuple9[0] = "text".getBytes();
        tuple9[1] = new Integer(-1).toString().getBytes();
        tuple9[2] = new Integer(0xA00000).toString().getBytes();
        tuple9[3] = tuple9[4] = "'".getBytes();
        tuple9[5] = null;
        tuple9[6] = new Integer(1).toString().getBytes();
        tuple9[7] = "t".getBytes();
        tuple9[8] = new Integer(0).toString().getBytes();
        tuple9[9] = null;
        tuple9[10] = "f".getBytes();
        tuple9[11] = null;
        tuple9[17] = null;
        tuple9[16] = null;
        tuple9[15] = null;
        tuple9[14] = null;
        tuple9[13] = null;
        tuple9[12] = null;
        v.addElement(tuple9);
        byte[][] tuple10 = new byte[18][];
        tuple10[0] = "bytea".getBytes();
        tuple10[1] = new Integer(-4).toString().getBytes();
        tuple10[2] = new Integer(0xA00000).toString().getBytes();
        tuple10[3] = "X'".getBytes();
        tuple10[4] = "'".getBytes();
        tuple10[5] = null;
        tuple10[6] = new Integer(1).toString().getBytes();
        tuple10[7] = "t".getBytes();
        tuple10[8] = new Integer(0).toString().getBytes();
        tuple10[9] = null;
        tuple10[10] = "f".getBytes();
        tuple10[11] = null;
        tuple10[17] = null;
        tuple10[16] = null;
        tuple10[15] = null;
        tuple10[14] = null;
        tuple10[13] = null;
        tuple10[12] = null;
        v.addElement(tuple10);
        byte[][] tuple11 = new byte[18][];
        tuple11[0] = "date".getBytes();
        tuple11[1] = new Integer(91).toString().getBytes();
        tuple11[2] = new Integer(10).toString().getBytes();
        tuple11[3] = tuple11[4] = "'".getBytes();
        tuple11[5] = null;
        tuple11[6] = new Integer(1).toString().getBytes();
        tuple11[7] = "f".getBytes();
        tuple11[8] = new Integer(2).toString().getBytes();
        tuple11[9] = null;
        tuple11[10] = "f".getBytes();
        tuple11[11] = null;
        tuple11[17] = null;
        tuple11[16] = null;
        tuple11[15] = null;
        tuple11[14] = null;
        tuple11[13] = null;
        tuple11[12] = null;
        v.addElement(tuple11);
        byte[][] tuple12 = new byte[18][];
        tuple12[0] = "time".getBytes();
        tuple12[1] = new Integer(92).toString().getBytes();
        tuple12[2] = new Integer(15).toString().getBytes();
        tuple12[3] = tuple12[4] = "'".getBytes();
        tuple12[5] = null;
        tuple12[6] = new Integer(1).toString().getBytes();
        tuple12[7] = "f".getBytes();
        tuple12[8] = new Integer(2).toString().getBytes();
        tuple12[9] = null;
        tuple12[10] = "f".getBytes();
        tuple12[11] = null;
        tuple12[17] = null;
        tuple12[16] = null;
        tuple12[15] = null;
        tuple12[14] = null;
        tuple12[13] = null;
        tuple12[12] = null;
        v.addElement(tuple12);
        byte[][] tuple13 = new byte[18][];
        tuple13[0] = "timestamp".getBytes();
        tuple13[1] = new Integer(93).toString().getBytes();
        tuple13[2] = new Integer(26).toString().getBytes();
        tuple13[3] = tuple13[4] = "'".getBytes();
        tuple13[5] = null;
        tuple13[6] = new Integer(1).toString().getBytes();
        tuple13[7] = "f".getBytes();
        tuple13[8] = new Integer(2).toString().getBytes();
        tuple13[9] = null;
        tuple13[10] = "f".getBytes();
        tuple13[11] = null;
        tuple13[17] = null;
        tuple13[16] = null;
        tuple13[15] = null;
        tuple13[12] = null;
        tuple13[13] = tuple13[14] = new Integer(3).toString().getBytes();
        v.addElement(tuple13);
        byte[][] tuple14 = new byte[18][];
        tuple14[0] = "timestamptz".getBytes();
        tuple14[1] = new Integer(93).toString().getBytes();
        tuple14[2] = new Integer(29).toString().getBytes();
        tuple14[3] = tuple14[4] = "'".getBytes();
        tuple14[5] = null;
        tuple14[6] = new Integer(1).toString().getBytes();
        tuple14[7] = "f".getBytes();
        tuple14[8] = new Integer(2).toString().getBytes();
        tuple14[9] = null;
        tuple14[10] = "f".getBytes();
        tuple14[11] = null;
        tuple14[17] = null;
        tuple14[16] = null;
        tuple14[15] = null;
        tuple14[12] = null;
        tuple14[13] = tuple14[14] = new Integer(3).toString().getBytes();
        v.addElement(tuple14);
        byte[][] tuple15 = new byte[18][];
        tuple15[0] = "bool".getBytes();
        tuple15[1] = new Integer(-7).toString().getBytes();
        tuple15[2] = new Integer(1).toString().getBytes();
        tuple15[5] = null;
        tuple15[4] = null;
        tuple15[3] = null;
        tuple15[6] = new Integer(1).toString().getBytes();
        tuple15[7] = "f".getBytes();
        tuple15[8] = new Integer(2).toString().getBytes();
        tuple15[9] = null;
        tuple15[10] = "f".getBytes();
        tuple15[13] = null;
        tuple15[12] = null;
        tuple15[11] = null;
        tuple15[17] = null;
        tuple15[16] = null;
        tuple15[15] = null;
        tuple15[14] = null;
        v.addElement(tuple15);
        byte[][] tuple16 = new byte[18][];
        tuple16[0] = "timetz".getBytes();
        tuple16[1] = new Integer(92).toString().getBytes();
        tuple16[2] = new Integer(18).toString().getBytes();
        tuple16[3] = tuple16[4] = "'".getBytes();
        tuple16[5] = null;
        tuple16[6] = new Integer(1).toString().getBytes();
        tuple16[7] = "f".getBytes();
        tuple16[8] = new Integer(2).toString().getBytes();
        tuple16[9] = null;
        tuple16[10] = "f".getBytes();
        tuple16[13] = null;
        tuple16[12] = null;
        tuple16[11] = null;
        tuple16[17] = null;
        tuple16[16] = null;
        tuple16[15] = null;
        tuple16[14] = null;
        v.addElement(tuple16);
        byte[][] tuple17 = new byte[18][];
        tuple17[0] = "oid".getBytes();
        tuple17[1] = new Integer(2004).toString().getBytes();
        tuple17[2] = null;
        tuple6[4] = null;
        tuple17[3] = null;
        tuple17[5] = null;
        tuple17[6] = new Integer(1).toString().getBytes();
        tuple17[7] = "f".getBytes();
        tuple17[8] = new Integer(0).toString().getBytes();
        tuple17[9] = null;
        tuple17[10] = "f".getBytes();
        tuple17[14] = null;
        tuple17[13] = null;
        tuple17[12] = null;
        tuple17[11] = null;
        tuple17[17] = null;
        tuple17[16] = null;
        tuple17[15] = null;
        v.addElement(tuple17);
        byte[][] tuple18 = new byte[18][];
        tuple18[0] = "array".getBytes();
        tuple18[1] = new Integer(2003).toString().getBytes();
        tuple18[2] = null;
        tuple18[3] = tuple16[4] = "'".getBytes();
        tuple18[5] = null;
        tuple18[6] = new Integer(1).toString().getBytes();
        tuple18[7] = "f".getBytes();
        tuple18[8] = new Integer(0).toString().getBytes();
        tuple18[9] = null;
        tuple18[10] = "f".getBytes();
        tuple18[14] = null;
        tuple18[13] = null;
        tuple18[12] = null;
        tuple18[11] = null;
        tuple18[17] = null;
        tuple18[16] = null;
        tuple18[15] = null;
        v.addElement(tuple18);
        byte[][] tuple19 = new byte[18][];
        tuple19[0] = "BIT".getBytes();
        tuple19[1] = new Integer(-7).toString().getBytes();
        tuple19[2] = new Integer(0x5000000).toString().getBytes();
        tuple19[3] = "B'".getBytes();
        tuple19[4] = "'".getBytes();
        tuple19[5] = "length".getBytes();
        tuple19[6] = new Integer(1).toString().getBytes();
        tuple19[7] = "f".getBytes();
        tuple19[8] = new Integer(2).toString().getBytes();
        tuple19[10] = tuple19[11] = "f".getBytes();
        tuple19[9] = tuple19[11];
        tuple19[16] = null;
        tuple19[15] = null;
        tuple19[12] = null;
        tuple19[13] = new Integer(0).toString().getBytes();
        tuple19[14] = new Integer(0).toString().getBytes();
        tuple19[17] = new Integer(2).toString().getBytes();
        v.addElement(tuple19);
        byte[][] tuple20 = new byte[18][];
        tuple20[0] = "BIT VARYING".getBytes();
        tuple20[1] = new Integer(-7).toString().getBytes();
        tuple20[2] = new Integer(0x5000000).toString().getBytes();
        tuple20[3] = "B'".getBytes();
        tuple20[4] = "'".getBytes();
        tuple20[5] = "length".getBytes();
        tuple20[6] = new Integer(1).toString().getBytes();
        tuple20[7] = "f".getBytes();
        tuple20[8] = new Integer(2).toString().getBytes();
        tuple20[10] = tuple20[11] = "f".getBytes();
        tuple20[9] = tuple20[11];
        tuple20[16] = null;
        tuple20[15] = null;
        tuple20[12] = null;
        tuple20[13] = new Integer(0).toString().getBytes();
        tuple20[14] = new Integer(0).toString().getBytes();
        tuple20[17] = new Integer(2).toString().getBytes();
        v.addElement(tuple20);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        String where = "";
        String select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
        String from = " FROM sys_catalog.sys_namespace n, sys_catalog.sys_class ct, sys_catalog.sys_class ci, sys_catalog.sys_index i, sys_catalog.sys_attribute a, sys_catalog.sys_am am ";
        where = " AND n.oid = ct.relnamespace ";
        if (schema != null && !"".equals(schema)) {
            where = where + " AND n.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schema) + "' ";
        }
        String sql = select + " ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME, " + " CASE i.indisclustered " + " WHEN true THEN " + 1 + " ELSE CASE am.amname " + "\tWHEN 'HASH' THEN " + 2 + "\tELSE " + 3 + "\tEND " + " END AS TYPE, " + " a.attnum AS ORDINAL_POSITION, " + " a.attname AS COLUMN_NAME, " + " NULL AS ASC_OR_DESC, " + " ci.reltuples AS CARDINALITY, " + " ci.relpages AS PAGES, " + " NULL AS FILTER_CONDITION " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid AND a.attrelid=ci.oid AND ci.relam=am.oid " + where + " AND ct.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(tableName) + "' ";
        if (unique) {
            sql = sql + " AND i.indisunique ";
        }
        sql = sql + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ";
        return this.connection.createStatement().executeQuery(sql);
    }

    private static Vector tokenize(String input, String delimiter) {
        Vector<String> result = new Vector<String>();
        int start = 0;
        int end = input.length();
        int delimiterSize = delimiter.length();
        while (start < end) {
            int delimiterIndex = input.indexOf(delimiter, start);
            if (delimiterIndex < 0) {
                result.addElement(input.substring(start));
                break;
            }
            String token = input.substring(start, delimiterIndex);
            result.addElement(token);
            start = delimiterIndex + delimiterSize;
        }
        return result;
    }

    protected String convertColumnDefault(String defaultValue, String type) throws SQLException {
        if (defaultValue == null) {
            return null;
        }
        String def = "";
        if (defaultValue.indexOf(40) >= 0 && (defaultValue.indexOf(39) < 0 || defaultValue.indexOf(39) > defaultValue.indexOf(40))) {
            def = defaultValue;
            return def;
        }
        Statement stmt_ = ((Connection)((Object)this.connection)).createStatement();
        ResultSet rs_ = stmt_.executeQuery("SELECT " + defaultValue);
        rs_.next();
        if (rs_.getMetaData().getColumnTypeName(1).equalsIgnoreCase("bytea")) {
            String strBytea = rs_.getString(1);
            defaultValue = this.connection.getDatabaseVersion() >= 40100 ? ((defaultValue = strBytea != null ? KBbytea.toSYSStringV4(strBytea.getBytes(), -2) : null) != null && !defaultValue.equals("X''") && defaultValue.length() > "X''".length() ? defaultValue.substring(2, defaultValue.length() - 1) : (defaultValue != null && defaultValue.equals("X''") ? "" : null)) : (strBytea != null ? KBbytea.toSYSStringV3(strBytea.getBytes()) : null);
        } else {
            defaultValue = rs_.getString(1);
        }
        rs_.close();
        stmt_.close();
        DatabaseMetaData DM = this.connection.getMetaData();
        rs_ = DM.getTypeInfo();
        while (rs_ != null && rs_.next()) {
            String databaseTypeName = this.connection.getDatabaseVersion() < 40100 ? SysTypeNameConverter.sysTypeRename(rs_.getString(1)) : rs_.getString(1);
            if (!databaseTypeName.equalsIgnoreCase(type)) continue;
            if (rs_.getString(4) != null) {
                def = rs_.getString(4);
            }
            def = def + defaultValue;
            if (rs_.getString(5) != null) {
                def = def + rs_.getString(5);
            }
            rs_.close();
            break;
        }
        return def;
    }

    static {
        defaultTableTypes = new String[]{"TABLE", "VIEW", "INDEX", "SEQUENCE", "TEMPORARY TABLE", "SYSTEM INDEX", "SYSTEM TABLE", "SYSTEM TOAST INDEX", "SYSTEM TOAST TABLE", "SYSTEM VIEW", "TEMPORARY INDEX"};
    }
}

