/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc2;

import com.kingbase.Driver;
import com.kingbase.core.Field;
import com.kingbase.jdbc1.AbstractJdbc1ResultSet;
import com.kingbase.jdbc1.AbstractJdbc1Statement;
import com.kingbase.jdbc2.AbstractJdbc2Connection;
import com.kingbase.jdbc2.KBatchUpdateException;
import com.kingbase.largeobject.CharLargeObject;
import com.kingbase.largeobject.ClobWriter;
import com.kingbase.largeobject.LargeObject;
import com.kingbase.largeobject.LargeObjectManager;
import com.kingbase.util.KSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AbstractJdbc2Statement
extends AbstractJdbc1Statement {
    protected Vector batch = null;

    public AbstractJdbc2Statement(AbstractJdbc2Connection c) {
        super(c);
        this.resultsettype = 1004;
        this.concurrency = 1007;
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection connection, String sql) throws SQLException {
        super(connection, sql);
    }

    public boolean execute() throws SQLException {
        throw Driver.notImplemented();
    }

    public void addBatch(String p_sql) throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        Object[] l_statement = new Object[]{new String[]{p_sql}, new Object[0], new String[0]};
        this.batch.addElement(l_statement);
    }

    public void clearBatch() throws SQLException {
        this.batch = null;
    }

    public int[] executeBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        int size = this.batch.size();
        int[] result = new int[size];
        int i = 0;
        try {
            try {
                String[] l_origSqlFragments = this.m_sqlFragments;
                Object[] l_origBinds = this.m_binds;
                String[] l_origBindTypes = this.m_bindTypes;
                i = 0;
                while (i < size) {
                    Object[] l_statement = (Object[])this.batch.elementAt(i);
                    this.m_sqlFragments = (String[])l_statement[0];
                    this.m_binds = (Object[])l_statement[1];
                    this.m_bindTypes = (String[])l_statement[2];
                    result[i] = this.executeUpdate();
                    ++i;
                }
                this.m_sqlFragments = l_origSqlFragments;
                this.m_binds = l_origBinds;
                this.m_bindTypes = l_origBindTypes;
            }
            catch (SQLException e) {
                int[] resultSucceeded = new int[i];
                System.arraycopy(result, 0, resultSucceeded, 0, i);
                KBatchUpdateException updex = new KBatchUpdateException("kingbase.stat.batch.error", new Integer(i), e.getMessage(), resultSucceeded);
                updex.setNextException(e);
                throw updex;
            }
            Object var9_11 = null;
            this.batch.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.batch.removeAllElements();
            throw throwable;
        }
        return result;
    }

    public void cancel() throws SQLException {
        this.connection.cancelQuery();
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.concurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultsettype;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new KSQLException("kingbase.stat.Illegalconstant");
        }
        this.fetchDirection = 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("fetchSize munst be more then zero");
        }
        this.fetchSize = rows;
    }

    public void setResultSetConcurrency(int value) throws SQLException {
        if (value != 1007 && value != 1008) {
            throw new KSQLException("kingbase.stat.Illegalconstant");
        }
        this.concurrency = value;
    }

    public void setResultSetType(int value) throws SQLException {
        if (value == 1003 || value == 1004) {
            this.resultsettype = value;
        } else if (value == 1005) {
            this.resultsettype = 1004;
        } else {
            throw new KSQLException("kingbase.stat.Illegalconstant");
        }
    }

    public void addBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        String[] l_newSqlFragments = null;
        if (this.m_sqlFragments != null) {
            l_newSqlFragments = new String[this.m_sqlFragments.length];
            System.arraycopy(this.m_sqlFragments, 0, l_newSqlFragments, 0, this.m_sqlFragments.length);
        }
        Object[] l_newBinds = new Object[this.m_binds.length];
        System.arraycopy(this.m_binds, 0, l_newBinds, 0, this.m_binds.length);
        String[] l_newBindTypes = new String[this.m_bindTypes.length];
        System.arraycopy(this.m_bindTypes, 0, l_newBindTypes, 0, this.m_bindTypes.length);
        Object[] l_statement = new Object[]{l_newSqlFragments, l_newBinds, l_newBindTypes};
        this.batch.addElement(l_statement);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        String querySql = this.m_sqlFragments[0].trim();
        if ((querySql = querySql.substring(querySql.indexOf("AS") + 3, querySql.length())).startsWith("select") || querySql.startsWith("SELECT")) {
            Field[] fds;
            int frmPos = querySql.indexOf("FROM");
            if (frmPos <= 0) {
                frmPos = querySql.indexOf("from");
            }
            if (frmPos <= 0) {
                return null;
            }
            String tableName = null;
            StringTokenizer ts = new StringTokenizer(querySql);
            while (ts.hasMoreTokens()) {
                if (!ts.nextToken().equalsIgnoreCase("from") || (tableName = ts.nextToken()).startsWith("'")) continue;
                tableName = tableName.toUpperCase();
                break;
            }
            String[] cols = querySql.substring(6, frmPos).split(",");
            ResultSet colrs = null;
            DatabaseMetaData dma = this.connection.getMetaData();
            if (cols.length == 1 && cols[0].trim().equals("*")) {
                colrs = dma.getColumns(null, null, tableName, "%");
                int len = ((AbstractJdbc1ResultSet)((Object)colrs)).getTupleCount();
                fds = new Field[len];
                int i = 0;
                while (colrs.next()) {
                    fds[i] = new Field(this.connection, colrs.getString(4), colrs.getInt(5), colrs.getInt(7));
                    ++i;
                }
            } else {
                fds = new Field[cols.length];
                int i = 0;
                while (i < cols.length) {
                    cols[i] = cols[i].trim();
                    if (!cols[i].startsWith("'")) {
                        cols[i] = cols[i].toUpperCase();
                    }
                    colrs = dma.getColumns(null, null, tableName, cols[i]);
                    boolean datatype = false;
                    boolean len = false;
                    if (colrs.next()) {
                        fds[i] = new Field(this.connection, cols[i], colrs.getInt(5), colrs.getInt(7));
                    }
                    ++i;
                }
            }
            Vector v = new Vector();
            rs = (ResultSet)((Object)this.createResultSet(fds, v, "OK", 1, 0L, false));
            return rs.getMetaData();
        }
        return null;
    }

    public void setArray(int i, Array x) throws SQLException {
        this.setString(i, x.toString());
    }

    public synchronized void setBlob(int i, Blob x) throws SQLException {
        boolean flag = false;
        InputStream l_inStream = x.getBinaryStream();
        if (!this.connection.getIsBegin()) {
            this.connection.execSQL("begin;");
        }
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        LargeObject lob = lom.openLargeObject(oid);
        this.connection.produceLargeObject();
        try {
            flag = true;
            OutputStream los = lob.getOutputStream();
            byte[] buf = new byte[4096];
            int bytesRemaining = (int)x.length();
            int numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            while (numRead != -1 && bytesRemaining > 0) {
                bytesRemaining -= numRead;
                if (numRead == buf.length) {
                    los.write(buf);
                } else {
                    los.write(buf, 0, numRead);
                }
                numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            }
            los.close();
            this.connection.consumeLargeObject();
            flag = false;
            if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                this.connection.execSQL("commit;");
            }
            l_inStream.close();
        }
        catch (IOException se) {
            if (flag) {
                this.connection.consumeLargeObject();
            }
            if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                this.connection.execSQL("rollback;");
            }
            throw new KSQLException("kingbase.unusual");
        }
        this.setInt(i, oid);
        this.UpdatedOrInsertedLargeObjOID = oid;
    }

    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        boolean flag = false;
        if (!this.connection.getIsBegin()) {
            this.connection.execSQL("begin");
        }
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        CharLargeObject lob = lom.openCharLargeObject(oid);
        this.connection.produceLargeObject();
        try {
            flag = true;
            ClobWriter writer = new ClobWriter(lob, this.connection.getEncoding().name());
            int c = x.read();
            int p = 0;
            while (c > -1 && p < length) {
                writer.write(c);
                c = x.read();
                ++p;
            }
            writer.close();
            this.connection.consumeLargeObject();
            flag = false;
            this.UpdatedOrInsertedLargeObjOID = oid;
            this.setInt(i, oid);
            if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                this.connection.execSQL("commit;");
            }
        }
        catch (Exception se) {
            if (flag) {
                this.connection.consumeLargeObject();
            }
            if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                this.connection.execSQL("rollback;");
            }
            throw new SQLException(se.getMessage());
        }
    }

    public synchronized void setClob(int i, Clob x) throws SQLException {
        boolean flag = false;
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        Reader l_inStream = x.getCharacterStream();
        if (!this.connection.getIsBegin()) {
            this.connection.execSQL("begin");
        }
        int l_length = (int)x.length();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        CharLargeObject lob = lom.openCharLargeObject(oid);
        this.connection.produceLargeObject();
        try {
            flag = true;
            ClobWriter los = new ClobWriter(lob, this.connection.getEncoding().name());
            int c = l_inStream.read();
            int p = 0;
            while (c > -1 && p < l_length) {
                los.write(c);
                c = l_inStream.read();
                ++p;
            }
            los.close();
            this.connection.consumeLargeObject();
            flag = false;
            if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                this.connection.execSQL("commit;");
            }
        }
        catch (IOException se) {
            if (flag) {
                this.connection.consumeLargeObject();
            }
            if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                this.connection.execSQL("rollback;");
            }
            throw new KSQLException("kingbase.unusual");
        }
        this.setInt(i, oid);
        this.UpdatedOrInsertedLargeObjOID = oid;
    }

    public void setNull(int i, int t, String s) throws SQLException {
        this.setNull(i, t);
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setDate(i, d);
        } else {
            cal.setTime(d);
            this.setDate(i, new Date(cal.getTime().getTime()));
        }
    }

    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setTime(i, t);
        } else {
            cal.setTime(t);
            this.setTime(i, new Time(cal.getTime().getTime()));
        }
    }

    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setTimestamp(i, t);
        } else {
            cal.setTime(t);
            StringBuffer sbuf = new StringBuffer();
            sbuf.setLength(0);
            sbuf.ensureCapacity(32);
            sbuf.append("'");
            int l_year = cal.get(1);
            sbuf.append(l_year);
            sbuf.append('-');
            int l_month = cal.get(2) + 1;
            if (l_month < 10) {
                sbuf.append('0');
            }
            sbuf.append(l_month);
            sbuf.append('-');
            int l_day = cal.get(5);
            if (l_day < 10) {
                sbuf.append('0');
            }
            sbuf.append(l_day);
            sbuf.append(' ');
            int l_hours = cal.get(11);
            if (l_hours < 10) {
                sbuf.append('0');
            }
            sbuf.append(l_hours);
            sbuf.append(':');
            int l_minutes = cal.get(12);
            if (l_minutes < 10) {
                sbuf.append('0');
            }
            sbuf.append(l_minutes);
            sbuf.append(':');
            int l_seconds = cal.get(13);
            if (l_seconds < 10) {
                sbuf.append('0');
            }
            sbuf.append(l_seconds);
            char[] l_decimal = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
            char[] l_nanos = Integer.toString(t.getNanos()).toCharArray();
            System.arraycopy(l_nanos, 0, l_decimal, l_decimal.length - l_nanos.length, l_nanos.length);
            sbuf.append('.');
            sbuf.append(l_decimal, 0, 6);
            int l_offset = cal.get(15);
            int l_houros = l_offset / 3600000;
            if (l_houros >= 0) {
                sbuf.append('+');
            } else {
                sbuf.append('-');
            }
            if (l_houros > -10 && l_houros < 10) {
                sbuf.append('0');
            }
            if (l_houros >= 0) {
                sbuf.append(l_houros);
            } else {
                sbuf.append(-l_houros);
            }
            int l_minos = (l_offset - l_houros * 3600000) / 60000;
            if (l_minos < 0) {
                l_minos = -l_minos;
            }
            if (l_minos != 0) {
                sbuf.append(":");
                if (l_minos < 10) {
                    sbuf.append('0');
                }
                sbuf.append(l_minos);
            }
            sbuf.append("'");
            this.bind(i, sbuf.toString(), "timestamptz");
        }
    }

    public Array getArray(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Blob getBlob(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Clob getClob(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Date getDate(int i, Calendar cal) throws SQLException {
        int in = this.checkIndex(i);
        if (this.parameters[in].parValue == null) {
            return null;
        }
        Date date = this.getDate(i);
        cal.setTime(date);
        StringBuffer sbuf = new StringBuffer();
        sbuf.setLength(0);
        sbuf.ensureCapacity(10);
        int l_year = cal.get(1);
        sbuf.append(l_year);
        sbuf.append('-');
        int l_month = cal.get(2) + 1;
        if (l_month < 10) {
            sbuf.append('0');
        }
        sbuf.append(l_month);
        sbuf.append('-');
        int l_day = cal.get(5);
        if (l_day < 10) {
            sbuf.append('0');
        }
        sbuf.append(l_day);
        return Date.valueOf(sbuf.toString());
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        int in = this.checkIndex(i);
        if (this.parameters[in].parValue == null) {
            return null;
        }
        Time date = this.getTime(i);
        cal.setTime(date);
        StringBuffer sbuf = new StringBuffer(8);
        int l_hours = cal.get(11);
        if (l_hours < 10) {
            sbuf.append('0');
        }
        sbuf.append(l_hours);
        sbuf.append(':');
        int l_minutes = cal.get(12);
        if (l_minutes < 10) {
            sbuf.append('0');
        }
        sbuf.append(l_minutes);
        sbuf.append(':');
        int l_seconds = cal.get(13);
        if (l_seconds < 10) {
            sbuf.append('0');
        }
        sbuf.append(l_seconds);
        return Time.valueOf(sbuf.toString());
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        int in = this.checkIndex(i);
        if (this.parameters[in].parValue == null) {
            return null;
        }
        return this.getTimestamp(i);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented();
    }

    protected String[] getSqlFragments() {
        return this.m_sqlFragments;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (!this.isFunction && !this.isProcedure) {
            throw new KSQLException("kingbase.call.procasfunc");
        }
        if (this.isFunction) {
            if (!this.isEscape) {
                throw new KSQLException("kingbase.call.noinout");
            }
            if (parameterIndex == 1) {
                this.functionReturnType = sqlType;
                this.testReturn = sqlType;
                if (this.functionReturnType == 1 || this.functionReturnType == -1) {
                    this.testReturn = 12;
                } else if (this.functionReturnType == 6) {
                    this.testReturn = 7;
                }
                this.returnTypeSet = true;
            }
        }
        int in = this.checkIndex(parameterIndex);
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                if (this.pmd.getParameterTypeName(parameterIndex).startsWith("CHAR") || this.pmd.getParameterTypeName(parameterIndex).startsWith("TEXT") || this.pmd.getParameterTypeName(parameterIndex).startsWith("BPCHAR") || this.pmd.getParameterTypeName(parameterIndex).startsWith("VARCHAR")) break;
                throw new KSQLException("kingbase.call.typeerror");
            }
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.pmd.getParameterTypeName(parameterIndex).startsWith("INT") || this.pmd.getParameterTypeName(parameterIndex).startsWith("BIGINT") || this.pmd.getParameterTypeName(parameterIndex).startsWith("SMALLINT") || this.pmd.getParameterTypeName(parameterIndex).startsWith("TINYINT") || this.pmd.getParameterTypeName(parameterIndex).startsWith("REAL") || this.pmd.getParameterTypeName(parameterIndex).startsWith("DOUBLE") || this.pmd.getParameterTypeName(parameterIndex).startsWith("FLOAT") || this.pmd.getParameterTypeName(parameterIndex).startsWith("NUMERIC") || this.pmd.getParameterTypeName(parameterIndex).startsWith("DECIMAL")) break;
                throw new KSQLException("kingbase.call.typeerror");
            }
            case -7: {
                break;
            }
            case 91: {
                if (this.pmd.getParameterTypeName(parameterIndex).startsWith("DATE")) break;
                throw new KSQLException("kingbase.call.typeerror");
            }
            case 92: {
                if (this.pmd.getParameterTypeName(parameterIndex).startsWith("TIME")) break;
                throw new KSQLException("kingbase.call.typeerror");
            }
            case 93: {
                if (this.pmd.getParameterTypeName(parameterIndex).startsWith("TIMESTAMP")) break;
                throw new KSQLException("kingbase.call.typeerror");
            }
        }
        this.parameters[in].isregist = true;
    }

    public int getUpdatedOrInsertedLargeObjOID() {
        return this.UpdatedOrInsertedLargeObjOID;
    }
}

