/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc3;

import com.kingbase.Driver;
import com.kingbase.jdbc1.AbstractJdbc1Statement;
import com.kingbase.jdbc2.AbstractJdbc2Blob;
import com.kingbase.jdbc2.AbstractJdbc2Clob;
import com.kingbase.jdbc2.AbstractJdbc2Connection;
import com.kingbase.jdbc3.AbstractJdbc3Statement;
import com.kingbase.jdbc3.Jdbc3Blob;
import com.kingbase.jdbc3.Jdbc3Clob;
import com.kingbase.jdbc3.Jdbc3Savepoint;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractJdbc3Connection
extends AbstractJdbc2Connection {
    protected int holdability = 2;
    private int savepointCounter;
    private static final String[] jdbc3Types = new String[]{"tinyint", "int2", "smallint", "int4", "oid", "integer", "int8", "bigint", "cash", "money", "numeric", "float4", "real", "float8", "double", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bytea", "bool", "boolean", "bit", "bit varying", "varbit", "date", "time", "abstime", "timestamp", "timestamptz", "timestamp with timezone", "timestamp without timezone", "_bool", "_char", "_int2", "_int4", "_text", "_oid", "_varchar", "_int8", "_float4", "_float8", "_abstime", "_date", "_time", "_timestamp", "_numeric", "_bytea", "timetz", "blob", "clob"};
    private static final int[] jdbc3Typei = new int[]{-6, 5, 5, 4, 4, 4, -5, -5, 8, 8, 2, 7, 7, 8, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -3, 16, 16, -7, -7, -7, 91, 92, 93, 93, 93, 93, 93, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 92, 2004, 2005};
    HashMap savaPointHashMap = new HashMap();
    protected int largetObjectNumber = 0;
    protected Hashtable loList = new Hashtable();
    protected int m_preparedCount = 0;
    protected int m_cursorCount = 0;

    public void setHoldability(int holdability) throws SQLException {
        if (holdability == 2 || holdability == 1) {
            this.holdability = holdability;
        }
    }

    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        return this.setSavepoint("JDBC_SAVEPOINT" + (this.savepointCounter + 1));
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        if (!this.getIsBegin() && this.getAutoCommit()) {
            throw new SQLException("[KingbaseES JDBC Driver]you must operate in a transaction using setSavepoint");
        }
        this.createStatement().execute("SAVEPOINT " + name);
        Jdbc3Savepoint savepoint = new Jdbc3Savepoint(++this.savepointCounter, name);
        this.savaPointHashMap.put(name, savepoint);
        return savepoint;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        if (!this.savaPointHashMap.containsKey(savepoint.getSavepointName())) {
            throw new SQLException("[KingbaseES JDBC Driver]the Savepoint has been released");
        }
        this.createStatement().execute("ROLLBACK TO SAVEPOINT  " + savepoint.getSavepointName());
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        this.createStatement().execute("RELEASE SAVEPOINT " + savepoint.getSavepointName());
        this.savaPointHashMap.remove(savepoint.getSavepointName());
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw Driver.notImplemented();
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw Driver.notImplemented();
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw Driver.notImplemented();
    }

    public void commit() throws SQLException {
        int i = 0;
        while (i < this.stmts.size()) {
            if (((AbstractJdbc3Statement)this.stmts.elementAt(i)).getResultSetHoldability() == 2 && ((AbstractJdbc3Statement)this.stmts.elementAt(i)).getResultSetType() == 1003 && ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result != null) {
                ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result.close();
            }
            ++i;
        }
        if (this.autoCommit) {
            return;
        }
        this.clearLoList();
        if (this.getIsBegin()) {
            this.execSQL("commit;");
        }
    }

    public int getSQLType(String sysTypeName) {
        int sqlType = 1111;
        int i = 0;
        while (i < jdbc3Types.length) {
            if (sysTypeName.equalsIgnoreCase(jdbc3Types[i])) {
                sqlType = jdbc3Typei[i];
                break;
            }
            ++i;
        }
        return sqlType;
    }

    private void releaseSavepoints() {
        try {
            if (this.savaPointHashMap != null) {
                Set savepointSet = this.savaPointHashMap.entrySet();
                Iterator it = savepointSet.iterator();
                while (it.hasNext()) {
                    Savepoint obj = (Savepoint)((Object)it.next());
                    try {
                        this.createStatement().execute("RELEASE SAVEPOINT " + obj.getSavepointName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.savaPointHashMap.clear();
            }
        }
        catch (Exception e) {}
    }

    public void close() throws SQLException {
        this.isSavePrepared = false;
        this.releaseSavepoints();
        this.clearLoList();
        super.close();
    }

    protected boolean isMultipleDeclaredCursors() {
        boolean result = false;
        if (this.stmts != null) {
            int i = 0;
            while (i < this.stmts.size()) {
                if (((AbstractJdbc3Statement)this.stmts.elementAt((int)i)).isDelare) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public synchronized void clearLoList() throws SQLException {
        if (this.loList.isEmpty()) {
            return;
        }
        Enumeration enumerator = this.loList.keys();
        while (enumerator.hasMoreElements()) {
            Object obj = enumerator.nextElement();
            if (obj instanceof Blob) {
                ((AbstractJdbc2Blob)obj).close();
            } else if (obj instanceof Clob) {
                ((AbstractJdbc2Clob)obj).close();
            }
            this.consumeLargeObject(obj);
        }
        if (this.getAutoCommit() && this.getIsBegin() && !this.isHaveLargeObjectOpen()) {
            this.execSQL("commit;");
        }
    }

    public synchronized void produceLargeObject(Object obj) {
        if (obj instanceof Jdbc3Blob || obj instanceof Jdbc3Clob) {
            if (this.largetObjectNumber < 0) {
                this.largetObjectNumber = 0;
            }
            ++this.largetObjectNumber;
            if (this.loList.containsKey(obj)) {
                Integer n = (Integer)this.loList.get(obj);
                this.loList.put(obj, new Integer(n + 1));
            } else {
                this.loList.put(obj, new Integer(1));
            }
        }
    }

    public synchronized void consumeLargeObject(Object obj) {
        if (this.largetObjectNumber > 0) {
            --this.largetObjectNumber;
        }
        if (this.loList.containsKey(obj)) {
            Integer n = (Integer)this.loList.get(obj);
            if (n == 1) {
                this.loList.remove(obj);
            } else {
                this.loList.put(obj, new Integer(n - 1));
            }
        }
    }

    public synchronized void produceLargeObject() {
        if (this.largetObjectNumber < 0) {
            this.largetObjectNumber = 0;
        }
        ++this.largetObjectNumber;
    }

    public synchronized void consumeLargeObject() {
        if (this.largetObjectNumber > 0) {
            --this.largetObjectNumber;
        }
    }

    public synchronized boolean isHaveLargeObjectOpen() {
        return this.largetObjectNumber > 0;
    }

    public int getPreparedCounter() {
        if (this.m_preparedCount == Integer.MAX_VALUE) {
            this.m_preparedCount = 0;
        }
        return this.m_preparedCount++;
    }

    public int getCursorCounter() {
        if (this.m_cursorCount == Integer.MAX_VALUE) {
            this.m_cursorCount = 0;
        }
        return this.m_cursorCount++;
    }

    public boolean getIsSaveResultSet() {
        return this.isSaveResultSet;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.getDatabaseMajorVersion() >= 4) {
            this.setAutoCommitV4(autoCommit);
        } else {
            this.setAutoCommitV3(autoCommit);
        }
    }

    public void setAutoCommitV4(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (this.getIsBegin()) {
            this.clearLoList();
            if (this.getIsBegin()) {
                Boolean b = new Boolean(autoCommit);
                String s = Boolean.toString(autoCommit);
                this.execSQL("commit;");
            }
        }
        this.autoCommit = autoCommit;
    }

    public void setAutoCommitV3(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        int i = 0;
        while (i < this.stmts.size()) {
            if (((AbstractJdbc3Statement)this.stmts.elementAt(i)).getResultSetHoldability() == 2 && ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result != null) {
                ((AbstractJdbc1Statement)this.stmts.elementAt((int)i)).result.close();
            }
            ++i;
        }
        if (autoCommit) {
            this.execSQL("select 1; commit; set autocommit = on;");
        } else {
            this.execSQL("set autocommit = off; " + this.getIsolationLevelSQL());
        }
        this.autoCommit = autoCommit;
    }
}

