/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc3;

import com.kingbase.Driver;
import com.kingbase.core.BaseResultSet;
import com.kingbase.core.BaseStatement;
import com.kingbase.core.QueryExecutor;
import com.kingbase.jdbc1.AbstractJdbc1ResultSet;
import com.kingbase.jdbc1.AbstractJdbc1Statement;
import com.kingbase.jdbc2.AbstractJdbc2Statement;
import com.kingbase.jdbc3.AbstractJdbc3Connection;
import com.kingbase.jdbc3.AbstractJdbc3ResultSet;
import com.kingbase.jdbc3.Jdbc3ParameterMetaData;
import com.kingbase.jdbc3.Jdbc3PreparedStatement;
import com.kingbase.largeobject.CharLargeObject;
import com.kingbase.largeobject.ClobWriter;
import com.kingbase.largeobject.LargeObject;
import com.kingbase.largeobject.LargeObjectManager;
import com.kingbase.util.CachedResultSet;
import com.kingbase.util.KSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class AbstractJdbc3Statement
extends AbstractJdbc2Statement {
    protected int holdability = 2;
    protected AbstractJdbc3ResultSet generatedKeysResult;
    protected int autoGeneratedKeys;
    protected String[] keyColumnNames;
    protected int[] keyColumnIndexes;
    protected int maxOidBeforeInsert;
    public boolean isNeedCommit = false;
    public boolean isDelare = false;
    private boolean isGetParameterMetaData = false;

    public AbstractJdbc3Statement(AbstractJdbc3Connection c) {
        super(c);
    }

    public AbstractJdbc3Statement(AbstractJdbc3Connection connection, String sql) throws SQLException {
        super(connection, sql);
        connection.clearLoList();
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (this.connection.getDatabaseVersion() >= 40100) {
            return false;
        }
        throw Driver.notImplemented();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        if (!this.isGeneratedKeys()) {
            throw new KSQLException("kingbase.stat.notreturngeneratedkeys");
        }
        String fields = "";
        String tableName = this.insertTableName;
        tableName = tableName.startsWith("\"") ? tableName.substring(1, tableName.length() - 1) : tableName.toUpperCase();
        String schemaName = null;
        if (this.insertSchemaName != null) {
            schemaName = this.insertSchemaName.toUpperCase();
        }
        if (this.autoGeneratedKeys == 1) {
            fields = "oid";
        } else if (this.keyColumnNames != null) {
            int i = 0;
            while (i < this.keyColumnNames.length) {
                fields = fields + this.keyColumnNames[i] + ",";
                ++i;
            }
            fields = fields.substring(0, fields.length() - 1);
        } else if (this.keyColumnIndexes != null) {
            ResultSet rs = this.connection.getMetaData().getColumns(null, schemaName, tableName, "%");
            int count = 1;
            while (rs.next()) {
                int i = 0;
                while (i < this.keyColumnIndexes.length) {
                    if (count == this.keyColumnIndexes[i]) {
                        fields = fields + rs.getString(4) + ",";
                    }
                    ++i;
                }
            }
            fields = fields.equals("") ? "oid" : fields.substring(0, fields.length() - 1);
        }
        tableName = this.insertSchemaName != null ? this.insertSchemaName + "." + this.insertTableName : this.insertTableName;
        return this.connection.createStatement().executeQuery("select " + fields + " from " + tableName + " where oid>" + this.maxOidBeforeInsert);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.keyColumnIndexes = null;
        this.keyColumnNames = null;
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        this.keyColumnIndexes = columnIndexes;
        this.keyColumnNames = null;
        this.autoGeneratedKeys = 2;
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        this.keyColumnNames = columnNames;
        this.autoGeneratedKeys = 2;
        this.keyColumnIndexes = null;
        return this.executeUpdate(sql);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.keyColumnIndexes = null;
        this.keyColumnNames = null;
        return this.execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        this.keyColumnIndexes = columnIndexes;
        this.autoGeneratedKeys = 2;
        this.keyColumnNames = null;
        return this.execute(sql);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        this.keyColumnNames = columnNames;
        this.autoGeneratedKeys = 2;
        this.keyColumnIndexes = null;
        return this.execute(sql);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType, scale);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.nameToIndex(parameterName), x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.nameToIndex(parameterName), x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.nameToIndex(parameterName), x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.nameToIndex(parameterName), x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.nameToIndex(parameterName), x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.nameToIndex(parameterName), x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.nameToIndex(parameterName), x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.nameToIndex(parameterName), x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.nameToIndex(parameterName), x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.nameToIndex(parameterName), x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), x, length);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x, targetSqlType, scale);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x, targetSqlType);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader, length);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), x, cal);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType, typeName);
    }

    public String getString(String parameterName) throws SQLException {
        return this.getString(this.nameToIndex(parameterName));
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.nameToIndex(parameterName));
    }

    public byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.nameToIndex(parameterName));
    }

    public short getShort(String parameterName) throws SQLException {
        return this.getShort(this.nameToIndex(parameterName));
    }

    public int getInt(String parameterName) throws SQLException {
        return this.getInt(this.nameToIndex(parameterName));
    }

    public long getLong(String parameterName) throws SQLException {
        return this.getLong(this.nameToIndex(parameterName));
    }

    public float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.nameToIndex(parameterName));
    }

    public double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.nameToIndex(parameterName));
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.nameToIndex(parameterName));
    }

    public Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.nameToIndex(parameterName));
    }

    public Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.nameToIndex(parameterName));
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.nameToIndex(parameterName));
    }

    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.nameToIndex(parameterName));
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.nameToIndex(parameterName));
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.nameToIndex(parameterName));
    }

    public Clob getClob(String parameterName) throws SQLException {
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        return this.getClob(this.nameToIndex(parameterName));
    }

    public Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.nameToIndex(parameterName));
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.nameToIndex(parameterName), cal);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.nameToIndex(parameterName), cal);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.nameToIndex(parameterName), cal);
    }

    public URL getURL(String parameterName) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setResultSetHoldability(int hold) throws SQLException {
        if (hold != 2 && hold != 1) {
            throw new KSQLException("kingbase.stat.Illegalconstant");
        }
        this.holdability = hold;
    }

    public int getResultSetHoldability() {
        return this.holdability;
    }

    private boolean isUpdateable(String sql) {
        String subSql1 = null;
        subSql1 = sql.endsWith(";") ? sql.substring(0, sql.length() - 1) : sql.substring(0, sql.length());
        String testSql = "select oid from(" + subSql1 + ") foo";
        try {
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(testSql);
            if (rs != null) {
                return true;
            }
            rs.close();
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private String precompileSV4(String sql1) throws SQLException {
        String sql = sql1.toLowerCase().trim();
        boolean updatesql = false;
        StringBuffer sqlbuf = new StringBuffer();
        boolean updatei = sql.endsWith("update");
        boolean selecti = sql.startsWith("select");
        int from = sql.indexOf("from");
        if (selecti && from > -1) {
            if (!this.connection.getIsClientCursor() || this.resultsettype == 1003) {
                updatesql = true;
                if (this.m_cursorName == null) {
                    this.m_cursorName = "JDBC_CURS_" + this.connection.getCursorCounter();
                }
                if (!this.connection.getAutoCommit() && this.holdability == 2) {
                    if (this.resultsettype == 1003) {
                        sqlbuf.append("  declare " + this.m_cursorName + " cursor for " + sql1.substring(0, from > 0 ? from : sql1.length()));
                    } else {
                        sqlbuf.append("  declare " + this.m_cursorName + " scroll  cursor for " + sql1.substring(0, from > 0 ? from : sql1.length()));
                    }
                } else if (this.resultsettype == 1003) {
                    sqlbuf.append("  declare " + this.m_cursorName + " cursor with hold for " + sql1.substring(0, from > 0 ? from : sql1.length()));
                } else {
                    sqlbuf.append("  declare " + this.m_cursorName + " scroll cursor with hold  for " + sql1.substring(0, from > 0 ? from : sql1.length()));
                }
                if (updatei || this.concurrency == 1008) {
                    if (this.isUpdateable(sql1)) {
                        this.addoid = true;
                        sqlbuf.append(", oid ");
                    }
                    int end = sql1.length();
                    if (updatei) {
                        end = sql.lastIndexOf("for");
                    }
                    sqlbuf.append(sql1.substring(from, end));
                } else {
                    sqlbuf.append(sql1.substring(from, sql1.length()));
                }
                if (this.maxrows > 0) {
                    sqlbuf.append(" limit " + this.maxrows);
                }
                if (this.resultsettype == 1003) {
                    sqlbuf.append("; fetch " + this.fetchSize + " from " + this.m_cursorName + ";");
                } else {
                    sqlbuf.append("; fetch 0 from " + this.m_cursorName + ";");
                }
            } else if (updatei || this.concurrency == 1008) {
                updatesql = true;
                sqlbuf.append(sql1.substring(0, from));
                if (this.isUpdateable(sql1)) {
                    this.addoid = true;
                    sqlbuf.append(", oid ");
                }
                sqlbuf.append(sql1.substring(from));
                if (this.maxrows > 0) {
                    sqlbuf.append(" limit " + this.maxrows);
                }
            }
        } else if (sql.lastIndexOf("where current of") > -1) {
            updatesql = true;
            StringTokenizer stt = new StringTokenizer(sql);
            String currens = new String();
            String curname = new String();
            stt.nextToken();
            while (stt.hasMoreTokens()) {
                curname = stt.nextToken();
            }
            Iterator it = this.connection.stmts.iterator();
            ResultSet curres = null;
            boolean hascur = false;
            AbstractJdbc1Statement st = null;
            while (it.hasNext()) {
                st = (AbstractJdbc1Statement)it.next();
                String cur_name = st.getCursorName();
                if (cur_name == null || !cur_name.equals(curname)) continue;
                curres = st.getResultSet();
                hascur = true;
                break;
            }
            if (curres != null) {
                AbstractJdbc1ResultSet rs1 = null;
                rs1 = (AbstractJdbc1ResultSet)((Object)curres);
                int oidi = rs1.getOID("oid");
                int where = sql.lastIndexOf("where") + 6;
                sqlbuf.append(sql1.substring(0, where));
                sqlbuf.append(" oid=" + oidi);
            } else {
                throw new KSQLException("kingbase.stat.cur");
            }
        }
        if (updatesql) {
            sql1 = sqlbuf.toString();
        }
        return sql1;
    }

    public boolean execute() throws SQLException {
        if (this instanceof Jdbc3PreparedStatement && this.connection.getIsSaveResultSet() && ((Jdbc3PreparedStatement)this).getPreparedSQL() != null && ((Jdbc3PreparedStatement)this).getPreparedSQL().toUpperCase().indexOf("SELECT ") >= 0) {
            this.result = (BaseResultSet)((Object)CachedResultSet.getResultSet(((Jdbc3PreparedStatement)this).getPreparedSQL(), this.m_binds, (Statement)((Object)this)));
            if (this.result != null) {
                return true;
            }
        }
        if (this.connection.getDatabaseVersion() >= 40100) {
            return this.executeSV5();
        }
        return this.executeSV3();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSV5() throws SQLException {
        ResultSet rs;
        if (this.connection.isStatementClosed(this)) {
            throw new SQLException("this statement has been closed");
        }
        if (this.connection == null) {
            throw new KSQLException("kingbase.stmt.noconnection");
        }
        if (this.isFunction && this.isEscape && !this.returnTypeSet) {
            throw new KSQLException("kingbase.call.noreturntype");
        }
        if (this.isFunction && this.isEscape) {
            this.m_binds[0] = "";
            this.m_bindTypes[0] = "text";
        }
        if (this.result != null && (rs = this.getResultSet()) != null) {
            rs.close();
        }
        if (this.m_useServerPrepare) {
            if (this.connection.getIsUseServerPrepare()) {
                this.addOid();
                if (this.m_statementName == null) {
                    this.m_statementName = "JDBC_STATEMENT_" + this.connection.getPreparedCounter();
                    this.m_origSqlFragments = new String[this.m_sqlFragments.length];
                    this.m_executeSqlFragments = new String[this.m_sqlFragments.length];
                    System.arraycopy(this.m_sqlFragments, 0, this.m_origSqlFragments, 0, this.m_sqlFragments.length);
                    this.m_executeSqlFragments[0] = "EXECUTE " + this.m_statementName;
                    if (this.m_binds == null || this.m_binds.length == 0) {
                        this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "()";
                    }
                    if (this.m_sqlFragments.length > 1) {
                        this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "(";
                        int i = 1;
                        while (i < this.m_bindTypes.length) {
                            this.m_executeSqlFragments[i] = ", ";
                            ++i;
                        }
                        this.m_executeSqlFragments[this.m_bindTypes.length] = ")";
                    }
                    StringBuffer i = this.sbuf;
                    synchronized (i) {
                        this.sbuf.setLength(0);
                        this.sbuf.append("PREPARE ");
                        this.sbuf.append(this.m_statementName);
                        this.sbuf.append(" AS ");
                        this.sbuf.append(this.m_origSqlFragments[0]);
                        int i2 = 1;
                        while (i2 < this.m_origSqlFragments.length) {
                            this.sbuf.append(" $");
                            this.sbuf.append(i2);
                            this.sbuf.append(" ");
                            this.sbuf.append(this.m_origSqlFragments[i2]);
                            ++i2;
                        }
                        this.sbuf.append("; ");
                        this.sbuf.append(this.m_executeSqlFragments[0]);
                        this.m_sqlFragments[0] = this.sbuf.toString();
                        System.arraycopy(this.m_executeSqlFragments, 1, this.m_sqlFragments, 1, this.m_sqlFragments.length - 1);
                    }
                } else {
                    this.m_sqlFragments = this.m_executeSqlFragments;
                }
            }
        } else {
            if (!this.isFunction && !this.isProcedure) {
                this.m_sqlFragments[0] = this.precompileSV4(this.m_sqlFragments[0]);
            }
            if (this.isProcedure || this.isFunction) {
                int ic = this.pmd.getParameterCount();
                int j = 0;
                while (j < ic) {
                    int acti = this.checkIndex1(j + 1);
                    if (this.parameters[acti].parIOType != 1 && !this.parameters[acti].isregist) {
                        throw new KSQLException("kingbase.call.outpnoreg");
                    }
                    String stp = this.pmd.getTypeName(j + 1);
                    if (this.parameters[acti].parIOType != 1 && this.parameters[acti].parIOType != 2) {
                        this.m_binds[j] = "null";
                        if (this.isFunction) {
                            this.m_binds[0] = "";
                        }
                    }
                    if (this.m_binds[j] == null) {
                        this.m_binds[j] = "null";
                    }
                    if (stp.equalsIgnoreCase("numeric") && !this.m_binds[j].equals("null")) {
                        this.m_binds[j] = " '" + this.m_binds[j] + "'";
                    } else if (stp.equalsIgnoreCase("bool")) {
                        this.m_binds[j] = this.m_binds[j].equals("null") || this.m_binds[j].equals("'f'") ? "false" : "true";
                    }
                    ++j;
                }
            }
        }
        if (this.isGeneratedKeys()) {
            this.maxOidBeforeInsert = this.getMaxOid();
        }
        this.result = QueryExecutor.execute(this.m_sqlFragments, this.m_binds, this);
        if (this.addoid) {
            this.result.setIsOidAdded(true);
            this.addoid = false;
        }
        if (this.isFunction || this.isProcedure) {
            if (!((AbstractJdbc1ResultSet)this.result).reallyResultSet()) {
                throw new KSQLException("kingbase.call.noreturnval");
            }
            if (!this.result.next()) {
                throw new KSQLException("kingbase.call.noreturnval");
            }
            if (this.isFunction) {
                this.callResult = this.result;
                int columnType = this.result.getMetaData().getColumnType(1);
                if (columnType != this.functionReturnType && this.isEscape) {
                    throw new KSQLException("kingbase.call.wrongrtntype", new Object[]{"java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType});
                }
            } else {
                int column = this.parameters.length;
                int ii = 0;
                while (ii < column) {
                    this.parameters[ii].parValue = this.result.getObject(ii + 2);
                    ++ii;
                }
            }
            if (((ResultSet)((Object)this.result)).getStatement() != null && ((BaseStatement)((Object)((ResultSet)((Object)this.result)).getStatement())).getCursorName() != null) {
                try {
                    this.connection.execSQL("CLOSE " + ((BaseStatement)((Object)((ResultSet)((Object)this.result)).getStatement())).getCursorName());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return true;
        }
        return this.result != null && ((AbstractJdbc1ResultSet)this.result).reallyResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSV3() throws SQLException {
        ResultSet rs;
        if (this.connection == null) {
            throw new KSQLException("kingbase.stmt.noconnection");
        }
        if (this.connection.isStatementClosed(this)) {
            throw new SQLException("this statement has been closed");
        }
        if (this.isFunction && !this.returnTypeSet) {
            throw new KSQLException("kingbase.call.noreturntype");
        }
        if (this.isFunction && this.isEscape) {
            this.m_binds[0] = "";
            this.m_bindTypes[0] = "text";
        }
        if (this.result != null && (rs = this.getResultSet()) != null) {
            rs.close();
        }
        if (this.m_useServerPrepare) {
            if (this.m_statementName == null) {
                this.m_statementName = "JDBC_STATEMENT_" + this.connection.getPreparedCounter();
                this.m_origSqlFragments = new String[this.m_sqlFragments.length];
                this.m_executeSqlFragments = new String[this.m_sqlFragments.length];
                System.arraycopy(this.m_sqlFragments, 0, this.m_origSqlFragments, 0, this.m_sqlFragments.length);
                this.m_executeSqlFragments[0] = "EXECUTE " + this.m_statementName;
                if (this.m_sqlFragments.length > 1) {
                    this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "(";
                    int i = 1;
                    while (i < this.m_bindTypes.length) {
                        this.m_executeSqlFragments[i] = ", ";
                        ++i;
                    }
                    this.m_executeSqlFragments[this.m_bindTypes.length] = ")";
                }
                StringBuffer i = this.sbuf;
                synchronized (i) {
                    int i2;
                    this.sbuf.setLength(0);
                    this.sbuf.append("PREPARE ");
                    this.sbuf.append(this.m_statementName);
                    if (this.m_origSqlFragments.length > 1) {
                        this.sbuf.append("(");
                        i2 = 0;
                        while (i2 < this.m_bindTypes.length - 1) {
                            this.sbuf.append(this.m_bindTypes[i2]);
                            this.sbuf.append(", ");
                            ++i2;
                        }
                        this.sbuf.append(this.m_bindTypes[this.m_bindTypes.length - 1]);
                        this.sbuf.append(")");
                    }
                    this.sbuf.append(" AS ");
                    this.sbuf.append(this.m_origSqlFragments[0]);
                    i2 = 1;
                    while (i2 < this.m_origSqlFragments.length) {
                        this.sbuf.append(" $");
                        this.sbuf.append(i2);
                        this.sbuf.append(" ");
                        this.sbuf.append(this.m_origSqlFragments[i2]);
                        ++i2;
                    }
                    this.sbuf.append("; ");
                    this.sbuf.append(this.m_executeSqlFragments[0]);
                    this.m_sqlFragments[0] = this.sbuf.toString();
                    System.arraycopy(this.m_executeSqlFragments, 1, this.m_sqlFragments, 1, this.m_sqlFragments.length - 1);
                }
            } else {
                this.m_sqlFragments = this.m_executeSqlFragments;
            }
        } else {
            if (!this.isFunction && !this.isProcedure) {
                this.m_sqlFragments[0] = this.precompileSV3(this.m_sqlFragments[0]);
            }
            if (this.isProcedure || this.isFunction) {
                int ic = this.pmd.getParameterCount();
                int j = 0;
                while (j < ic) {
                    int acti = this.checkIndex1(j + 1);
                    if (this.parameters[acti].parIOType != 1 && !this.parameters[acti].isregist) {
                        throw new KSQLException("kingbase.call.outpnoreg");
                    }
                    String stp = this.pmd.getTypeName(j + 1);
                    if (this.parameters[acti].parIOType != 1) {
                        this.m_binds[j] = "null";
                        if (this.isFunction) {
                            this.m_binds[0] = "";
                        }
                    }
                    if (this.m_binds[j] == null) {
                        this.m_binds[j] = "null";
                    }
                    this.m_binds[j] = stp.equalsIgnoreCase("numeric") && !this.m_binds[j].equals("null") ? stp + " '" + this.m_binds[j] + "'" : (stp.equalsIgnoreCase("bool") ? (this.m_binds[j].equals("null") || this.m_binds[j].equals("'f'") ? "bool false" : "bool true") : stp + " " + this.m_binds[j]);
                    ++j;
                }
            }
        }
        try {
            this.result = QueryExecutor.execute(this.m_sqlFragments, this.m_binds, this);
        }
        catch (SQLException e) {
            if (this.isNeedCommit && !this.connection.isClosed()) {
                this.connection.execSQL("rollback");
                this.isNeedCommit = false;
            }
            this.isDelare = false;
            throw e;
        }
        if (this.isFunction || this.isProcedure) {
            if (!((AbstractJdbc1ResultSet)this.result).reallyResultSet()) {
                throw new KSQLException("kingbase.call.noreturnval");
            }
            if (!this.result.next()) {
                throw new KSQLException("kingbase.call.noreturnval");
            }
            if (this.isFunction) {
                this.callResult = this.result;
                int columnType = this.result.getMetaData().getColumnType(1);
                if (columnType != this.functionReturnType) {
                    throw new KSQLException("kingbase.call.wrongrtntype", new Object[]{"java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType});
                }
            } else {
                int column = this.result.getMetaData().getColumnCount();
                int ii = 0;
                while (ii < column) {
                    this.parameters[ii].parValue = this.result.getObject(ii + 1);
                    ++ii;
                }
            }
            this.result.close();
            return true;
        }
        return this.result != null && ((AbstractJdbc1ResultSet)this.result).reallyResultSet();
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        super.registerOutParameter(parameterIndex, sqlType);
        int in = this.checkIndex(parameterIndex);
        if (this.isProcedure && !this.parameters[in].isregist) {
            switch (sqlType) {
                case 16: {
                    if (this.pmd.getParameterTypeName(parameterIndex).startsWith("BOOLEAN")) break;
                    throw new KSQLException("kingbase.call.typeerror");
                }
            }
            this.parameters[in].isregist = true;
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.connection.getKBProtocolVersion() >= 30100) {
            return this.getParameterMetaDataPV31();
        }
        return this.getParameterMetaDataPV2();
    }

    private ParameterMetaData getParameterMetaDataPV2() throws SQLException {
        return new Jdbc3ParameterMetaData(this.pmd.parcount, this.pmd.parameters, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParameterMetaData getParameterMetaDataPV31() throws SQLException {
        block12: {
            if (this.isGetParameterMetaData) {
                return new Jdbc3ParameterMetaData(this.pmd.parcount, this.pmd.parameters, this);
            }
            if (!this.connection.getIsUseServerPrepare()) {
                throw new SQLException("No parameter metadata derived.");
            }
            try {
                if (this.isProcedure || this.isFunction) break block12;
                if (this.m_statementName == null) {
                    this.m_statementName = "JDBC_STATEMENT_" + this.connection.getPreparedCounter();
                    this.m_origSqlFragments = new String[this.m_sqlFragments.length];
                    this.m_executeSqlFragments = new String[this.m_sqlFragments.length];
                    System.arraycopy(this.m_sqlFragments, 0, this.m_origSqlFragments, 0, this.m_sqlFragments.length);
                    this.m_executeSqlFragments[0] = "EXECUTE " + this.m_statementName;
                    if (this.m_binds == null || this.m_binds.length == 0) {
                        this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "()";
                    }
                    if (this.m_sqlFragments.length > 1) {
                        this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "(";
                        int i = 1;
                        while (i < this.m_bindTypes.length) {
                            this.m_executeSqlFragments[i] = ", ";
                            ++i;
                        }
                        this.m_executeSqlFragments[this.m_bindTypes.length] = ")";
                    }
                    StringBuffer i = this.sbuf;
                    synchronized (i) {
                        this.sbuf.setLength(0);
                        this.sbuf.append("PREPARE ");
                        this.sbuf.append(this.m_statementName);
                        this.sbuf.append(" AS ");
                        this.sbuf.append(this.m_origSqlFragments[0]);
                        int i2 = 1;
                        while (i2 < this.m_origSqlFragments.length) {
                            this.sbuf.append(" $");
                            this.sbuf.append(i2);
                            this.sbuf.append(" ");
                            this.sbuf.append(this.m_origSqlFragments[i2]);
                            ++i2;
                        }
                        this.sbuf.append("; ");
                        this.m_sqlFragments[0] = this.sbuf.toString();
                        QueryExecutor.execute(this.m_sqlFragments, new Object[0], this);
                    }
                }
                QueryExecutor.getParameterMetaData(this);
            }
            catch (Exception e) {
                throw new SQLException("get ParameterMetaData Error:" + e);
            }
        }
        this.isGetParameterMetaData = true;
        return new Jdbc3ParameterMetaData(this.pmd.parcount, this.pmd.parameters, this);
    }

    private boolean isGeneratedKeys() {
        return (this.autoGeneratedKeys == 1 || this.keyColumnNames != null || this.keyColumnIndexes != null) && this.insertTableName != null;
    }

    private int getMaxOid() throws SQLException {
        BaseResultSet rs;
        int maxOid = 0;
        String tableName = this.insertTableName;
        if (this.insertSchemaName != null) {
            tableName = this.insertSchemaName + "." + tableName;
        }
        if ((rs = this.connection.execSQL("select max(oid) from " + tableName)).next()) {
            maxOid = rs.getOID(1);
        }
        return maxOid;
    }

    private void addOid() throws SQLException {
        int pos;
        String sql1 = this.m_sqlFragments[0];
        if ((sql1 = sql1.toLowerCase().trim()).startsWith("select") && this.concurrency == 1008 && this.isUpdateable(sql1) && (pos = sql1.indexOf(" from ")) > 0) {
            String part1 = this.m_sqlFragments[0].substring(0, pos);
            String part2 = this.m_sqlFragments[0].substring(pos, this.m_sqlFragments[0].length());
            this.m_sqlFragments[0] = part1 + " ,oid " + part2;
            this.addoid = true;
        }
    }

    private String precompileSV3(String sql1) throws SQLException {
        String sql = sql1.toLowerCase();
        boolean updatesql = false;
        StringBuffer sqlbuf = new StringBuffer();
        boolean updatei = sql.endsWith("update");
        boolean selecti = sql.startsWith("select");
        int from = sql.indexOf("from");
        if (selecti && from > -1) {
            if (sql.toLowerCase().indexOf(" join ") >= 1 && this.concurrency == 1008) {
                throw new SQLException("The ResultSet Concurrency can't set CONCUR_UPDATABLE");
            }
            if (this.resultsettype == 1003 && this.holdability == 2) {
                updatesql = true;
                if (this.connection.getAutoCommit()) {
                    sqlbuf.append(" begin; ");
                    this.isNeedCommit = true;
                }
                this.isDelare = true;
                if (this.m_cursorName == null) {
                    this.m_cursorName = "JDBC_CURS_" + this.connection.getCursorCounter();
                }
                sqlbuf.append("  declare " + this.m_cursorName + " cursor for " + sql1.substring(0, from > 0 ? from : sql1.length()));
                if (updatei || this.concurrency == 1008) {
                    if (!this.existsAggFun(sql1) && this.isUpdateable(sql1)) {
                        this.addoid = true;
                        sqlbuf.append(", oid ");
                    }
                    int end = sql1.length();
                    if (updatei) {
                        end = sql.lastIndexOf("for");
                    }
                    sqlbuf.append(sql1.substring(from, end));
                } else {
                    sqlbuf.append(sql1.substring(from, sql1.length()));
                }
                if (this.maxrows > 0) {
                    sqlbuf.append(" limit " + this.maxrows);
                }
                sqlbuf.append("; fetch " + this.fetchSize + " from " + this.m_cursorName + ";");
            } else if (updatei || this.concurrency == 1008) {
                updatesql = true;
                sqlbuf.append(sql1.substring(0, from));
                if (!this.existsAggFun(sql1) && this.isUpdateable(sql1)) {
                    this.addoid = true;
                    sqlbuf.append(", oid ");
                }
                sqlbuf.append(sql1.substring(from));
                if (this.maxrows > 0) {
                    sqlbuf.append(" limit " + this.maxrows);
                }
            }
        } else if (sql.lastIndexOf("where current of") > -1) {
            StringTokenizer stt = new StringTokenizer(sql);
            String currens = new String();
            String curname = new String();
            stt.nextToken();
            while (stt.hasMoreTokens()) {
                curname = stt.nextToken();
            }
            Iterator it = this.connection.stmts.iterator();
            ResultSet curres = null;
            boolean hascur = false;
            AbstractJdbc1Statement st = null;
            while (it.hasNext()) {
                st = (AbstractJdbc1Statement)it.next();
                if (!st.getCursorName().equals(curname)) continue;
                curres = st.getResultSet();
                hascur = true;
                break;
            }
            if (curres != null) {
                updatesql = true;
                curres.next();
                AbstractJdbc1ResultSet rs1 = null;
                rs1 = (AbstractJdbc1ResultSet)((Object)curres);
                int oidi = rs1.getOID("oid");
                int where = sql.lastIndexOf("where") + 6;
                sqlbuf.append(sql1.substring(0, where));
                sqlbuf.append(" oid=" + oidi);
            } else {
                throw new KSQLException("kingbase.stat.cur");
            }
        }
        if (updatesql) {
            sql1 = sqlbuf.toString();
        }
        if (!sql1.endsWith(";")) {
            sql1 = sql1 + ";";
        }
        return sql1;
    }

    private boolean existsAggFun(String sql) {
        if (sql.indexOf("count(") >= 0) {
            return true;
        }
        if (sql.indexOf("avg(") >= 0) {
            return true;
        }
        if (sql.indexOf("sum(") >= 0) {
            return true;
        }
        if (sql.indexOf("max(") >= 0) {
            return true;
        }
        if (sql.indexOf("min(") >= 0) {
            return true;
        }
        if (sql.indexOf("sdtdev(") >= 0) {
            return true;
        }
        return sql.indexOf("variance(") >= 0;
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        if (this.connection.getDatabaseVersion() < 40100) {
            throw Driver.notImplemented();
        }
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 2005, "Clob");
            if (this.callResult == null) {
                return null;
            }
            return (Clob)((Object)this.callResult);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue instanceof Clob) {
            if (this.parameters[in].parValue == null) {
                return null;
            }
            return (Clob)this.parameters[in].parValue;
        }
        return null;
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            this.checkIndex(parameterIndex, 2004, "Blob");
            if (this.callResult == null) {
                return null;
            }
            return (Blob)((Object)this.callResult);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue instanceof Blob) {
            if (this.parameters[in].parValue == null) {
                return null;
            }
            return (Blob)this.parameters[in].parValue;
        }
        return null;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        if (this.isFunction) {
            if (this.testReturn == 2004) {
                return this.getBlob(parameterIndex);
            }
            if (this.testReturn == 2005) {
                return this.getClob(parameterIndex);
            }
            return super.getObject(parameterIndex);
        }
        int in = this.checkIndex(parameterIndex);
        if (this.parameters[in].parValue instanceof Blob) {
            return this.getBlob(parameterIndex);
        }
        if (this.parameters[in].parValue instanceof Clob) {
            return this.getClob(parameterIndex);
        }
        return super.getObject(parameterIndex);
    }

    public void close() throws SQLException {
        this.callResult = null;
        if (this.connection.getIsSavePrepareStatement()) {
            return;
        }
        super.close();
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        boolean flag = false;
        if (x == null) {
            this.setNull(parameterIndex, 1111);
            return;
        }
        if (this.parameters != null && this.parameters[parameterIndex - 1] != null && (this.parameters[parameterIndex - 1].parSQLType == 2005 || this.parameters[parameterIndex - 1].parSQLType == 2004)) {
            if (!this.connection.getIsBegin()) {
                this.connection.execSQL("begin");
            }
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            LargeObject lob = lom.openLargeObject(oid);
            this.connection.produceLargeObject();
            try {
                flag = true;
                OutputStream los = lob.getOutputStream();
                int c = x.read();
                int p = 0;
                while (c > -1 && p < length) {
                    los.write(c);
                    c = x.read();
                    ++p;
                }
                los.close();
                this.connection.consumeLargeObject();
                flag = false;
                if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                    this.connection.execSQL("commit");
                }
                this.setInt(parameterIndex, oid);
                this.UpdatedOrInsertedLargeObjOID = oid;
            }
            catch (IOException se) {
                if (flag) {
                    this.connection.consumeLargeObject();
                }
                if (this.connection.getAutoCommit() && this.connection.getIsBegin() && !this.connection.isHaveLargeObjectOpen()) {
                    this.connection.execSQL("rollback");
                }
                throw new KSQLException("kingbase.unusual");
            }
        }
        try {
            byte[] result = null;
            byte[] buf = new byte[1024];
            int realLength = -1;
            while ((realLength = x.read(buf, 0, buf.length)) != -1) {
                byte[] bufTemp = null;
                if (result != null) {
                    bufTemp = new byte[result.length];
                    System.arraycopy(result, 0, bufTemp, 0, result.length);
                    result = new byte[bufTemp.length + realLength];
                    System.arraycopy(bufTemp, 0, result, 0, bufTemp.length);
                    System.arraycopy(buf, 0, result, bufTemp.length, realLength);
                    continue;
                }
                result = new byte[realLength];
                System.arraycopy(buf, 0, result, 0, realLength);
            }
            this.setObject(parameterIndex, result);
        }
        catch (IOException e) {
            throw new KSQLException("kingbase.unusual");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        boolean flag = false;
        if (x == null) {
            this.setNull(parameterIndex, 1111);
            return;
        }
        if (this.parameters != null && this.parameters[parameterIndex - 1] != null && (this.parameters[parameterIndex - 1].parSQLType == 2005 || this.parameters[parameterIndex - 1].parSQLType == 2004)) {
            if (!this.connection.getIsBegin()) {
                this.connection.execSQL("begin");
            }
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            CharLargeObject lob = lom.openCharLargeObject(oid);
            this.connection.produceLargeObject();
            try {
                flag = true;
                ClobWriter writer = new ClobWriter(lob, this.connection.getEncoding().name());
                int c = x.read();
                int p = 0;
                while (c > -1 && p < length) {
                    writer.write(c);
                    c = x.read();
                    ++p;
                }
                writer.close();
                this.connection.consumeLargeObject();
                flag = false;
                this.UpdatedOrInsertedLargeObjOID = oid;
                this.setInt(parameterIndex, oid);
                if (!this.connection.getAutoCommit() || !this.connection.getIsBegin() || this.connection.isHaveLargeObjectOpen()) return;
                this.connection.execSQL("commit;");
                return;
            }
            catch (Exception se) {
                if (flag) {
                    this.connection.consumeLargeObject();
                }
                if (!this.connection.getAutoCommit() || !this.connection.getIsBegin() || this.connection.isHaveLargeObjectOpen()) throw new SQLException(se.getMessage());
                this.connection.execSQL("rollback;");
                throw new SQLException(se.getMessage());
            }
        }
        try {
            char[] result = null;
            char[] buf = new char[1024];
            int realLength = -1;
            while ((realLength = x.read(buf, 0, buf.length)) != -1) {
                char[] bufTemp = null;
                if (result != null) {
                    bufTemp = new char[result.length];
                    System.arraycopy(result, 0, bufTemp, 0, result.length);
                    result = new char[bufTemp.length + realLength];
                    System.arraycopy(bufTemp, 0, result, 0, bufTemp.length);
                    System.arraycopy(buf, 0, result, bufTemp.length, realLength);
                    continue;
                }
                result = new char[realLength];
                System.arraycopy(buf, 0, result, 0, realLength);
            }
            this.setObject(parameterIndex, result);
            return;
        }
        catch (IOException l_ioe) {
            throw new KSQLException("kingbase.unusual");
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(x), length);
    }

    public boolean isMultipleConDeclaredCurs() {
        return ((AbstractJdbc3Connection)this.connection).isMultipleDeclaredCursors();
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (this.parameters != null && this.parameters[parameterIndex - 1] != null && (this.parameters[parameterIndex - 1].parSQLType == -2 || this.parameters[parameterIndex - 1].parSQLType == -3)) {
            byte[] buf = x.getBytes();
            this.setBytes(parameterIndex, buf);
        } else {
            super.setString(parameterIndex, x);
        }
    }
}

