/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.jdbc3;

import com.kingbase.core.BaseStatement;
import com.kingbase.jdbc3.AbstractJdbc3Connection;
import com.kingbase.jdbc3.Jdbc3CallableStatement;
import com.kingbase.jdbc3.Jdbc3DatabaseMetaData;
import com.kingbase.jdbc3.Jdbc3PreparedStatement;
import com.kingbase.jdbc3.Jdbc3Statement;
import com.kingbase.util.KSQLException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Jdbc3Connection
extends AbstractJdbc3Connection
implements Connection {
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.holdability);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConcurrencyAndHoldability(resultSetConcurrency, resultSetHoldability);
        Jdbc3Statement s = new Jdbc3Statement(this);
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(resultSetHoldability);
        this.stmts.add(s);
        return s;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.getIsSavePrepareStatement() && this.stmts != null && this.stmts.size() > 0) {
            Iterator it = this.stmts.iterator();
            while (it.hasNext()) {
                Object stmtObj = it.next();
                if (!(stmtObj instanceof Jdbc3PreparedStatement) || !((Jdbc3PreparedStatement)stmtObj).IsSameSQLStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability)) continue;
                return (Jdbc3PreparedStatement)stmtObj;
            }
        }
        this.checkConcurrencyAndHoldability(resultSetConcurrency, resultSetHoldability);
        Jdbc3PreparedStatement s = new Jdbc3PreparedStatement(this, sql);
        StringTokenizer strToken = new StringTokenizer(sql);
        String str = strToken.nextToken();
        if (str.equalsIgnoreCase("insert") || str.equalsIgnoreCase("delete") || str.equalsIgnoreCase("update") || str.equalsIgnoreCase("select")) {
            s.setUseServerPrepare(true);
        } else {
            s.setUseServerPrepare(false);
        }
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(resultSetHoldability);
        this.stmts.add(s);
        s.getParameterMetaData();
        return s;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.holdability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConcurrencyAndHoldability(resultSetConcurrency, resultSetHoldability);
        Jdbc3CallableStatement s = new Jdbc3CallableStatement(this, sql);
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(resultSetHoldability);
        this.stmts.add(s);
        s.getParameterMetaData();
        return s;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.holdability);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new Jdbc3DatabaseMetaData(this);
        }
        return this.metadata;
    }

    private void checkConcurrencyAndHoldability(int concurrency, int holdability) throws SQLException {
        if (this.isClosed()) {
            throw new KSQLException("kingbase.con.closed");
        }
        if (concurrency == 1008 && this.readOnly) {
            throw new KSQLException("kingbase.con.readOnly");
        }
    }

    public String getKBType(int col) throws SQLException {
        return null;
    }

    public int getKBType(String colName) throws SQLException {
        return 0;
    }

    public BaseStatement createBaseStatement() throws SQLException {
        return new Jdbc3Statement(this);
    }
}

