/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.largeobject;

import com.kingbase.largeobject.CharLargeObject;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class ClobInputStream
extends InputStream {
    private CharLargeObject lo;
    private byte[] buffer;
    private int bpos;
    private int bsize;
    private int mpos = 0;

    public ClobInputStream(CharLargeObject lo) {
        this(lo, 1024);
    }

    public ClobInputStream(CharLargeObject lo, int bsize) {
        this.lo = lo;
        this.buffer = null;
        this.bpos = 0;
        this.bsize = bsize;
    }

    public int read() throws IOException {
        try {
            if (this.buffer == null || this.bpos >= this.buffer.length) {
                if (this.lo == null || this.lo.closed) {
                    throw new IOException("The InputStream has been closed");
                }
                this.buffer = this.lo.read(this.bsize);
                this.bpos = 0;
            }
            if (this.bpos >= this.buffer.length) {
                return -1;
            }
            int ret = this.buffer[this.bpos] & 0x7F;
            if ((this.buffer[this.bpos] & 0x80) == 128) {
                ret |= 0x80;
            }
            ++this.bpos;
            return ret;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void close() throws IOException {
        try {
            this.lo.close();
            this.lo = null;
            this.buffer = null;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public synchronized void mark(int readlimit) {
        try {
            if (this.lo == null || this.lo.closed) {
                return;
            }
            this.mpos = this.lo.tell();
        }
        catch (SQLException se) {}
    }

    public synchronized void reset() throws IOException {
        try {
            if (this.lo == null || this.lo.closed) {
                throw new IOException("The InputStream has been closed");
            }
            this.lo.seek(this.mpos);
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public boolean markSupported() {
        return true;
    }
}

