/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.largeobject;

import com.kingbase.largeobject.CharLargeObject;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class ClobWriter
extends Writer {
    private CharLargeObject lo;
    private char[] cbuffer;
    private int csize;
    private int cpos;
    private String encoding;

    public ClobWriter(CharLargeObject lo, String encoding) {
        this(lo, 4096, encoding);
    }

    public ClobWriter(CharLargeObject lo, int csize, String encoding) {
        this.lo = lo;
        this.csize = csize;
        this.encoding = encoding;
        this.cbuffer = new char[csize];
        this.cpos = 0;
    }

    public void write(int c) throws IOException {
        try {
            if (this.cpos >= this.csize) {
                if (this.lo == null || this.lo.closed) {
                    throw new IOException("The Writer has been closed");
                }
                this.lo.write(new String(this.cbuffer).getBytes(this.encoding));
                this.cpos = 0;
            }
            this.cbuffer[this.cpos++] = (char)c;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            if (this.cpos > 0) {
                this.flush();
            }
            if (cbuf == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len + off > cbuf.length || len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            String instr = null;
            instr = off == 0 && len == cbuf.length ? new String(cbuf) : new String(cbuf, off, len);
            if (this.lo == null || this.lo.closed) {
                throw new IOException("The Writer has been closed");
            }
            this.lo.write(instr.getBytes(this.encoding));
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void flush() throws IOException {
        try {
            if (this.cpos > 0) {
                if (this.lo == null || this.lo.closed) {
                    throw new IOException("The Writer has been closed");
                }
                this.lo.write(new String(this.cbuffer, 0, this.cpos).getBytes(this.encoding));
            }
            this.cpos = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
            this.lo.close();
            this.lo = null;
            this.cbuffer = null;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }
}

