/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.util;

import com.kingbase.core.BaseConnection;
import com.kingbase.jdbc1.AbstractJdbc1Connection;
import com.kingbase.util.KBTypeInfo;
import java.sql.SQLException;

public class KBbytea {
    public static byte[] toBytes(byte[] p_buf, BaseConnection connection) throws SQLException {
        if (((AbstractJdbc1Connection)connection).getDatabaseVersion() >= 40100) {
            return KBbytea.toBytesV4(p_buf);
        }
        return KBbytea.toBytesV3(p_buf);
    }

    public static String toSYSString(byte[] p_buf, BaseConnection connection, int parameterType) throws SQLException {
        if (((AbstractJdbc1Connection)connection).getDatabaseVersion() >= 40100) {
            return KBbytea.toSYSStringV4(p_buf, parameterType);
        }
        return KBbytea.toSYSStringV3(p_buf);
    }

    public static byte[] toBytesV3(byte[] s) throws SQLException {
        if (s == null) {
            return null;
        }
        int slength = s.length;
        byte[] buf = new byte[slength];
        int bufpos = 0;
        int i = 0;
        while (i < slength) {
            byte nextbyte = s[i];
            if (nextbyte == 92) {
                byte secondbyte;
                if ((secondbyte = s[++i]) == 92) {
                    buf[bufpos++] = 92;
                } else {
                    int thebyte;
                    if ((thebyte = (secondbyte - 48) * 64 + (s[++i] - 48) * 8 + (s[++i] - 48)) > 127) {
                        thebyte -= 256;
                    }
                    buf[bufpos++] = (byte)thebyte;
                }
            } else {
                buf[bufpos++] = nextbyte;
            }
            ++i;
        }
        byte[] l_return = new byte[bufpos];
        System.arraycopy(buf, 0, l_return, 0, bufpos);
        return l_return;
    }

    public static String toSYSStringV3(byte[] p_buf) throws SQLException {
        if (p_buf == null) {
            return null;
        }
        StringBuffer l_strbuf = new StringBuffer();
        int i = 0;
        while (i < p_buf.length) {
            int l_int = p_buf[i];
            if (l_int < 0) {
                l_int = 256 + l_int;
            }
            if (l_int < 32 || l_int > 126) {
                l_strbuf.append("\\");
                l_strbuf.append((char)((l_int >> 6 & 3) + 48));
                l_strbuf.append((char)((l_int >> 3 & 7) + 48));
                l_strbuf.append((char)((l_int & 7) + 48));
            } else if (p_buf[i] == 92) {
                l_strbuf.append("\\\\");
            } else {
                l_strbuf.append((char)p_buf[i]);
            }
            ++i;
        }
        return l_strbuf.toString();
    }

    public static String toSYSStringV4(byte[] p_buf, int parameterType) throws SQLException {
        if (p_buf == null || p_buf.length == 0) {
            return null;
        }
        StringBuffer l_strbuf = new StringBuffer();
        if (parameterType == 2004) {
            l_strbuf.append(KBTypeInfo.getAllTypeInfo()[6].getLiteralPrefix());
        } else {
            l_strbuf.append(KBTypeInfo.getAllTypeInfo()[1].getLiteralPrefix());
        }
        int i = 0;
        while (i < p_buf.length) {
            int l_int = p_buf[i] & 0xFF;
            if ((l_int >> 4 & 0xF) + 48 > 57) {
                l_strbuf.append((char)((l_int >> 4 & 0xF) + 55));
            } else {
                l_strbuf.append((char)((l_int >> 4 & 0xF) + 48));
            }
            if ((l_int & 0xF) + 48 > 57) {
                l_strbuf.append((char)((l_int & 0xF) + 55));
            } else {
                l_strbuf.append((char)((l_int & 0xF) + 48));
            }
            ++i;
        }
        l_strbuf.append("'");
        return l_strbuf.toString();
    }

    public static byte[] toBytesV4(byte[] p_buf) throws SQLException {
        if (p_buf == null || p_buf.length == 0) {
            return null;
        }
        int slength = p_buf.length;
        byte[] buf = new byte[slength / 2];
        if (p_buf.length != buf.length * 2) {
            throw new SQLException("byte[].length in database is invalid:" + slength);
        }
        int bufpos = 0;
        int i = 0;
        while (i < slength) {
            buf[bufpos] = 0;
            buf[bufpos] = p_buf[i] - 48 > 9 ? (byte)(p_buf[i] - 55) : (byte)(p_buf[i] - 48);
            buf[bufpos] = (byte)(buf[bufpos] << 4);
            buf[bufpos] = p_buf[++i] - 48 > 9 ? (byte)(buf[bufpos] + (p_buf[i] - 55)) : (byte)(buf[bufpos] + (p_buf[i] - 48));
            ++bufpos;
            ++i;
        }
        byte[] l_return = new byte[bufpos];
        System.arraycopy(buf, 0, l_return, 0, bufpos);
        return l_return;
    }
}

