/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase.util;

import java.util.Vector;

public class KBtokenizer {
    protected Vector tokens;

    public KBtokenizer(String string, char delim) {
        this.tokenize(string, delim);
    }

    public int tokenize(String string, char delim) {
        this.tokens = new Vector();
        int nest = 0;
        int p = 0;
        int s = 0;
        while (p < string.length()) {
            char c = string.charAt(p);
            if (c == '(' || c == '[' || c == '<') {
                ++nest;
            }
            if (c == ')' || c == ']' || c == '>') {
                --nest;
            }
            if (nest == 0 && c == delim) {
                this.tokens.addElement(string.substring(s, p));
                s = p + 1;
            }
            ++p;
        }
        if (s < string.length()) {
            this.tokens.addElement(string.substring(s));
        }
        return this.tokens.size();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String getToken(int n) {
        return (String)this.tokens.elementAt(n);
    }

    public KBtokenizer tokenizeToken(int n, char delim) {
        return new KBtokenizer(this.getToken(n), delim);
    }

    public static String remove(String s, String l, String t) {
        if (s.startsWith(l)) {
            s = s.substring(l.length());
        }
        if (s.endsWith(t)) {
            s = s.substring(0, s.length() - t.length());
        }
        return s;
    }

    public void remove(String l, String t) {
        int i = 0;
        while (i < this.tokens.size()) {
            this.tokens.setElementAt(KBtokenizer.remove((String)this.tokens.elementAt(i), l, t), i);
            ++i;
        }
    }

    public static String removePara(String s) {
        return KBtokenizer.remove(s, "(", ")");
    }

    public void removePara() {
        this.remove("(", ")");
    }

    public static String removeBox(String s) {
        return KBtokenizer.remove(s, "[", "]");
    }

    public void removeBox() {
        this.remove("[", "]");
    }

    public static String removeAngle(String s) {
        return KBtokenizer.remove(s, "<", ">");
    }

    public void removeAngle() {
        this.remove("<", ">");
    }
}

