package com.reconciliation.recfj.Controller;

import com.reconciliation.recfj.entity.RecExcel;
import com.reconciliation.recfj.entity.ReturnValue;
import com.reconciliation.recfj.service.RecService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import javax.annotation.Resource;

/**
 * @author 史连宁
 */
@Controller
@RequestMapping("rec")
public class RecController {

    @Resource
    private RecService recService;

    @RequestMapping("/create_rec_data_to_excel")
    @ResponseBody
    public ReturnValue createRecDataToExcel(RecExcel rec) {
        if (rec == null) {
            rec = new RecExcel();
        }
        return recService.createRecDataToExcel(rec);
    }

    @RequestMapping("/test_add_xml")
    @ResponseBody
    public ReturnValue testAddXmlToWebService() {
        return recService.testAddXmlToWebService();
    }

    @RequestMapping("/test_delete_xml")
    @ResponseBody
    public ReturnValue testDelXmlToWebService() {
        return recService.testDelXmlToWebService();
    }
}
