package com.reconciliation.recfj.enums;

/**
 * 对账指标
 * @author 史连宁
 */
public enum RecItem {
    IDX1("IDX1", "IDX1数据总量", "getRecAll"),
    IDX2("IDX2", "IDX2创建时间月统计值", "getRecMon"),
    IDX3("IDX3", "IDX3创建时间日统计值（近30天）", "getRecDay"),
    IDX4("IDX4", "IDX4更新时间月统计值", "getRecMon"),
    IDX5("IDX5", "IDX5更新时间日统计值（近30天）", "getRecDay");

    private final String id;
    private final String name;
    private final String func;

    /**
     * 对账指标枚举类
     * @param id 编码
     * @param name 名称
     */
    RecItem(String id, String name, String func) {
      this.id = id;
      this.name = name;
      this.func = func;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getFunc() {
        return func;
    }

    public static RecItem parse(String str) throws EnumConstantNotPresentException {
        for (RecItem rec : RecItem.values()) {
            if (rec.id.equals(str)) {
                return rec;
            }
        }
        throw new EnumConstantNotPresentException(RecItem.class, str);
    }
}
